/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Action;
import com.sun.jade.policy.ActionNotExecutedException;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.policy.Filter;
import com.sun.jade.policy.Policy;
import com.sun.jade.policy.UnitTestHelper;
import com.sun.jade.services.event.AbstractEventSubscriber;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.Propertizable;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class PolicyRule
extends Policy
implements Propertizable {
    private static final String sccs_id = "@(#)PolicyRule.java\t1.19 09/19/02 SMI";
    private Condition condition;
    private Action action;
    private Set topics;
    private Filter filter;
    private String ruleUsage;
    private int sequencedAction;
    private static final String POLICY = "Policy";
    private static final int DEFAULT_PRIORITY = 0;
    private static final String DEFAULT_ACTION_SEQUENCE = "Serial";
    private Map policyDataMap;

    public String getRuleUsage() {
        return this.ruleUsage;
    }

    public void setRuleUsage(String string) {
        this.ruleUsage = string;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public int getSequencesAction() {
        return this.sequencedAction;
    }

    public void setSequencedAction(int n) {
        this.sequencedAction = n;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean evaluate(NSMEvent nSMEvent) {
        boolean bl = false;
        if (this.condition == null) {
            return false;
        }
        try {
            Report.trace.log(POLICY, (Object)("Inside Policy Evaluation & the Condition is " + this.condition));
            Context context = new Context();
            bl = this.condition.evaluate(nSMEvent, context);
            if (bl) {
                this.action.doAction(nSMEvent, context);
            }
        }
        catch (ActionNotExecutedException actionNotExecutedException) {
            Throwable throwable = actionNotExecutedException.getNestedException();
            if (throwable != null) {
                Report.error.log((Exception)throwable, (Object)("Unable to perform action for policy " + this.getCommonName()));
            } else {
                Report.error.log(actionNotExecutedException, (Object)("Unable to perform action for policy " + this.getCommonName()));
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)("Caught exception while trying to evaluate condition for " + this.getCommonName()));
        }
        return bl;
    }

    public boolean evaluate(Collection collection) {
        boolean bl = false;
        if (this.condition == null) {
            return false;
        }
        try {
            Report.trace.log(POLICY, (Object)("I am inside Policy Evaluation & the Condition is " + this.condition));
            Context context = new Context();
            bl = this.condition.evaluate(collection, context);
            if (bl) {
                Report.trace.log(POLICY, (Object)("Doing the Action :" + this.action));
                this.action.doAction(collection, context);
            }
        }
        catch (ActionNotExecutedException actionNotExecutedException) {
            Throwable throwable = actionNotExecutedException.getNestedException();
            if (throwable != null) {
                Report.error.log((Exception)throwable, (Object)("Unable to perform action for policy " + this.getCommonName()));
            } else {
                Report.error.log(actionNotExecutedException, (Object)("Unable to perform action for policy " + this.getCommonName()));
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)("Caught exception while trying to evaluate condition for " + this.getCommonName()));
        }
        return bl;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Collection getTopics() {
        return this.topics;
    }

    public void addTopic(String string) {
        if (this.topics == null) {
            this.topics = new HashSet();
        }
        this.topics.add(string);
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        String string;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.condition.toProperties());
        properties.putAll((Map<?, ?>)this.action.toProperties());
        String string2 = this.getCommonName();
        String string3 = "Policy." + string2 + ".";
        properties.setProperty("Policy.Name", string2);
        properties.setProperty(string3 + "Condition", this.condition.getConditionName());
        properties.setProperty(string3 + "Action", this.action.getActionName());
        properties.setProperty(string3 + "Roles", this.getPolicyRoles().toString());
        properties.setProperty(string3 + "Topic", this.topics.toString());
        properties.setProperty(string3 + "Filter", this.filter.toString());
        properties.setProperty(string3 + "Priority", Integer.toString(this.getPriority()));
        if (this.filter != null && (string = this.filter.getFilterAction()) != null) {
            properties.setProperty(string3 + "FilterAction", string);
        }
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        Object object;
        String string = properties.getProperty("Policy.Name");
        String string2 = properties.getProperty("Policy." + string + ".Condition");
        String string3 = properties.getProperty("Policy." + string + ".Action");
        String string4 = properties.getProperty("Policy." + string + ".Roles");
        String string5 = properties.getProperty("Policy." + string + ".Topic");
        String string6 = properties.getProperty("Policy." + string + ".Filter");
        String string7 = properties.getProperty("Policy." + string + ".Priority");
        String string8 = properties.getProperty("Policy." + string + ".FilterAction");
        if (string4 == null || string == null) {
            throw new PropertiesPersistenceException("Properties are missing from the " + string + " policy.", this, null);
        }
        this.setCommonName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken().trim());
        }
        this.setPolicyRoles(hashSet);
        if (string2 != null) {
            object = Condition.newInstance(string2, properties);
            this.setCondition((Condition)object);
        }
        if (string3 != null) {
            object = Action.newInstance(string3, properties);
            this.setAction((Action)object);
        }
        if (string7 != null) {
            this.setPriority(Integer.parseInt(string7));
        } else {
            this.setPriority(0);
        }
        if (string6 != null) {
            if (string5 == null) {
                throw new PropertiesPersistenceException(string + " requires that a topic be set for the specified filter", this, null);
            }
            object = new Filter(string6, string5);
            ((Filter)object).setFilterAction(string8);
            this.setFilter((Filter)object);
        }
        if (string5 != null) {
            this.addTopic(string5);
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testPolicyRule();
        test.testPolicyContext();
    }

    public static class Test
    extends UnitTest {
        public void testPolicyRule() {
            Properties properties = new Properties();
            properties.setProperty("Policy.Name", "TestPolicy");
            properties.setProperty("Policy.TestPolicy.Roles", "Role");
            properties.setProperty("Policy.TestPolicy.Topic", ".testtopic");
            properties.setProperty("Policy.TestPolicy.Filter", "filter");
            properties.setProperty("Policy.TestPolicy.Priority", "1");
            PolicyRule policyRule = new PolicyRule();
            try {
                policyRule.fromProperties(properties);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                propertiesPersistenceException.printStackTrace();
                this.assertCondition(propertiesPersistenceException.getMessage(), false);
            }
            properties = new Properties();
            properties.setProperty("Policy.Name", "TestPolicy");
            properties.setProperty("Policy.TestPolicy.Roles", "Role");
            properties.setProperty("Policy.TestPolicy.Topic", ".testtopic");
            properties.setProperty("Policy.TestPolicy.Priority", "1");
            try {
                policyRule = new PolicyRule();
                policyRule.fromProperties(properties);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                propertiesPersistenceException.printStackTrace();
                this.assertCondition(propertiesPersistenceException.getMessage(), false);
            }
            properties = new Properties();
            properties.setProperty("Policy.Name", "TestPolicy");
            properties.setProperty("Policy.TestPolicy.Roles", "Role");
            properties.setProperty("Policy.TestPolicy.Filter", "filter");
            properties.setProperty("Policy.TestPolicy.Priority", "1");
            try {
                policyRule = new PolicyRule();
                policyRule.fromProperties(properties);
                this.assertCondition("Invalid Policy Specification, Filter without topic", false);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                this.assertNotNull(propertiesPersistenceException);
            }
            properties = new Properties();
            properties.setProperty("Policy.Name", "TestPolicy");
            properties.setProperty("Policy.TestPolicy.Roles", "Role");
            properties.setProperty("Policy.TestPolicy.Priority", "1");
            try {
                policyRule = new PolicyRule();
                policyRule.fromProperties(properties);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                propertiesPersistenceException.printStackTrace();
                this.assertCondition(propertiesPersistenceException.getMessage(), false);
            }
        }

        public void testPolicyContext() {
            NSMEvent nSMEvent = UnitTestHelper.createNSMEvent("30", "70");
            this.assertNotNull(nSMEvent);
            PolicyRule policyRule = UnitTestHelper.createPolicyRule();
            policyRule.setCondition(UnitTestHelper.createCondition());
            policyRule.setAction(UnitTestHelper.createAction());
            AbstractEventSubscriber abstractEventSubscriber = new AbstractEventSubscriber(this){
                private final /* synthetic */ Test this$0;
                {
                    this.this$0 = test;
                }

                public void notify(AbstractEvent abstractEvent) {
                    ModificationEventData modificationEventData = new ModificationEventData(abstractEvent);
                    String string = modificationEventData.getDescription().toString();
                    string = string.substring(0, string.indexOf(".", 70));
                    this.this$0.assertEquals("Change in the Port Statistics (CRCErrors) on port Dev1 of switch Test. The counter incremented from 30 to 70 in {4} seconds", string);
                }
            };
            String string = ".state.test";
            BaseServiceFinder.getEventService2().subscribe(abstractEventSubscriber, string);
            try {
                policyRule.evaluate(nSMEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

