/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Action;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.policy.Filter;
import com.sun.jade.policy.Policy;
import com.sun.jade.policy.PolicyEventListener;
import com.sun.jade.policy.PolicyRule;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class PolicyGroup
extends Policy {
    private Vector policies;
    private boolean activationStatus = false;
    private PolicyEventListener listener;
    private String domain = "default";

    public PolicyGroup() {
        Report.trace.log("Policy", (Object)"Creating Policy Group");
        this.policies = new Vector();
    }

    public PolicyGroup(String string) {
        Report.trace.log("Policy", (Object)("Creating Policy Group: " + string));
        this.setCommonName(string);
        this.policies = new Vector();
    }

    public void addPolicy(Policy policy) {
        if (policy != null) {
            int n = policy.getPriority();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.policies.size() && !bl) {
                Policy policy2 = (Policy)this.policies.get(n2);
                int n3 = policy2.getPriority();
                if (n <= n3) {
                    this.policies.add(n2, policy);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.policies.add(policy);
            }
        }
    }

    public Collection getPolicies() {
        return this.policies;
    }

    public boolean evaluate(NSMEvent nSMEvent) {
        boolean bl = true;
        Iterator iterator = this.policies.iterator();
        try {
            while (iterator.hasNext()) {
                Policy policy = (Policy)iterator.next();
                boolean bl2 = bl = policy.evaluate(nSMEvent) && bl;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in evaluating Policies in Policy Group");
            bl = false;
        }
        return bl;
    }

    public boolean evaluate(Collection collection) {
        boolean bl = true;
        Iterator iterator = this.policies.iterator();
        try {
            while (iterator.hasNext()) {
                Policy policy = (Policy)iterator.next();
                boolean bl2 = policy.evaluate(collection);
                Report.trace.log("Policy", (Object)("Eval Policy " + bl2));
                boolean bl3 = bl = bl && bl2;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in evaluating Policies in Policy Group");
            bl = false;
        }
        return bl;
    }

    public boolean activate() {
        Report.trace.log("Policy", (Object)("PolicyGroup activate() for: " + this.getCommonName()));
        this.listener = new PolicyEventListener(this.domain);
        Iterator iterator = this.policies.iterator();
        if (!this.activationStatus) {
            while (iterator.hasNext()) {
                PolicyGroup policyGroup;
                Policy policy = (Policy)iterator.next();
                this.listener.addToListener(policy);
                if (!(policy instanceof PolicyGroup) || !(policyGroup = (PolicyGroup)policy).activate()) continue;
                Report.error.log("Unable to Activate policyGroup:", (Object)policyGroup.getCommonName());
            }
            this.activationStatus = true;
            return this.activationStatus;
        }
        return false;
    }

    public Vector getGroupFilters() {
        Iterator iterator = this.policies.iterator();
        Vector<Filter> vector = new Vector<Filter>();
        while (iterator.hasNext()) {
            Policy policy;
            Policy policy2 = (Policy)iterator.next();
            if (policy2 instanceof PolicyRule) {
                policy = (PolicyRule)policy2;
                if (((PolicyRule)policy).getFilter() == null) continue;
                vector.add(((PolicyRule)policy).getFilter());
                continue;
            }
            if (!(policy2 instanceof PolicyGroup)) continue;
            policy = (PolicyGroup)policy2;
            vector.addAll(((PolicyGroup)policy).getGroupFilters());
        }
        return vector;
    }

    public Collection getTopics() {
        HashSet<Collection> hashSet = new HashSet<Collection>();
        Iterator iterator = this.policies.iterator();
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            if (policy.getTopics() == null) continue;
            hashSet.add(policy.getTopics());
        }
        return hashSet;
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testPolicyGroup();
    }

    public static class Test
    extends UnitTest {
        public void testPolicyGroup() {
            Object object;
            PolicyGroup policyGroup = new PolicyGroup();
            PolicyRule policyRule = new PolicyRule();
            policyRule.setCommonName("p1");
            policyRule.setPriority(1);
            policyGroup.addPolicy(policyRule);
            PolicyRule policyRule2 = new PolicyRule();
            policyRule2.setCommonName("p2");
            policyRule2.setPriority(3);
            policyGroup.addPolicy(policyRule2);
            PolicyRule policyRule3 = new PolicyRule();
            policyRule3.setCommonName("p3");
            policyRule3.setPriority(2);
            policyGroup.addPolicy(policyRule3);
            PolicyRule policyRule4 = new PolicyRule();
            policyRule4.setCommonName("p4");
            policyRule4.setPriority(0);
            policyGroup.addPolicy(policyRule4);
            PolicyRule policyRule5 = new PolicyRule();
            policyRule5.setCommonName("p5");
            policyRule5.setPriority(0);
            policyGroup.addPolicy(policyRule5);
            PolicyRule policyRule6 = new PolicyRule();
            policyRule6.setCommonName("p6");
            policyRule6.setPriority(1);
            policyGroup.addPolicy(policyRule6);
            Iterator iterator = policyGroup.policies.iterator();
            String[] stringArray = new String[]{"p5", "p4", "p6", "p1", "p3", "p2"};
            int n = 0;
            while (iterator.hasNext()) {
                object = (Policy)iterator.next();
                this.assertEquals(((Policy)object).getCommonName(), stringArray[n++]);
            }
            policyGroup = new PolicyGroup();
            object = new Condition(this, "Test Condition"){
                private final /* synthetic */ Test this$0;
                {
                    this.this$0 = test;
                }

                public boolean evaluate(NSMEvent nSMEvent, Context context) {
                    return true;
                }

                public boolean evaluate(Collection collection, Context context) {
                    return true;
                }

                public void fromProperties(Properties properties) {
                }
            };
            Condition condition = new Condition(this, "Test Condition"){
                private final /* synthetic */ Test this$0;
                {
                    this.this$0 = test;
                }

                public boolean evaluate(NSMEvent nSMEvent, Context context) {
                    return false;
                }

                public boolean evaluate(Collection collection, Context context) {
                    return false;
                }

                public void fromProperties(Properties properties) {
                }
            };
            Action action = new Action(this, "Test Action"){
                private final /* synthetic */ Test this$0;
                {
                    this.this$0 = test;
                }

                public void doAction(NSMEvent nSMEvent, Context context) {
                }

                public void doAction(Collection collection, Context context) {
                }

                public void fromProperties(Properties properties) {
                }
            };
            PolicyRule policyRule7 = new PolicyRule();
            policyRule7.setCommonName("PolicyOne");
            policyRule7.setPriority(1);
            policyRule7.setCondition((Condition)object);
            policyRule7.setAction(action);
            PolicyRule policyRule8 = new PolicyRule();
            policyRule8.setCommonName("PolicyTwo");
            policyRule8.setPriority(2);
            policyRule8.setCondition(condition);
            policyRule8.setAction(action);
            policyGroup.addPolicy(policyRule7);
            policyGroup.addPolicy(policyRule8);
            boolean bl = policyGroup.evaluate((NSMEvent)null);
            this.assertEquals(new Boolean(bl), Boolean.FALSE);
            bl = policyGroup.evaluate((Collection)null);
            this.assertEquals(new Boolean(bl), Boolean.FALSE);
            policyGroup = new PolicyGroup();
            policyRule8 = new PolicyRule();
            policyRule8.setCommonName("PolicyTwo");
            policyRule8.setPriority(2);
            policyRule8.setCondition((Condition)object);
            policyRule8.setAction(action);
            policyGroup.addPolicy(policyRule7);
            policyGroup.addPolicy(policyRule8);
            bl = policyGroup.evaluate((NSMEvent)null);
            this.assertEquals(new Boolean(bl), Boolean.TRUE);
            bl = policyGroup.evaluate((Collection)null);
            this.assertEquals(new Boolean(bl), Boolean.TRUE);
            policyGroup = new PolicyGroup();
            this.assertNotNull(policyGroup);
            policyGroup = new PolicyGroup("TestGroup");
            this.assertNotNull(policyGroup);
            policyRule7.addTopic("testtopic");
            policyRule8.addTopic("testtopic");
            policyGroup.addPolicy(policyRule7);
            policyGroup.addPolicy(policyRule8);
            this.assertEquals(new Boolean(policyGroup.activate()), Boolean.TRUE);
            this.assertEquals(new Boolean(policyGroup.evaluate((Collection)null)), Boolean.TRUE);
            this.assertEquals(new Boolean(policyGroup.evaluate((NSMEvent)null)), Boolean.TRUE);
            Vector vector = policyGroup.getGroupFilters();
            this.assertNotNull(vector);
            Collection collection = policyGroup.getPolicies();
            this.assertNotNull(collection);
            this.assertEquals(new Integer(collection.size()), new Integer(2));
            policyGroup.getTopics();
        }
    }
}

