/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Context;
import com.sun.jade.policy.DelegateCondition;
import com.sun.jade.policy.EventHelper;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class PatternMatchCondition
extends DelegateCondition {
    public static final String TARGET_CLASS = ".TargetClass";
    public static final String TARGET_ATTR = ".TargetAttr";
    public static final String PATTERN = ".Pattern";
    public static final String[] propertyNames = new String[]{".TargetClass", ".TargetAttr", ".Pattern"};
    private Map propertyValues;
    private String targetClass;
    private String targetAttr;
    private String targetPattern;
    private static final String sccs_id = "@(#) 1.0 @(#)PatternMatchCondition.java\t1.23 10/07/02 SMI";
    static /* synthetic */ Class class$java$lang$String;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public PatternMatchCondition(String string) {
        super(string);
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) {
        Report.trace.log("Policy", (Object)("Evaluating " + nSMEvent.getSubject()));
        if (this.propertyValues == null) {
            Report.error.log(this.getConditionName() + " PatternMatchCondition properties have not been initialized." + " Check to make sure that fromProperties has been called.");
            return false;
        }
        CIMBean cIMBean = null;
        Method method = null;
        if (nSMEvent instanceof NSMEvent) {
            Object object;
            Object object2;
            Object object3;
            if (EventHelper.isDefinitionEvent(nSMEvent)) {
                object3 = new DefinitionEventData(nSMEvent);
                object2 = ((DefinitionEventData)object3).getDefinedObjects();
                if (object2 == null) {
                    return false;
                }
                cIMBean = object2[0];
                if (cIMBean == null || ((CIMBean[])object2).length == 0) {
                    return false;
                }
            } else if (EventHelper.isDeletionEvent(nSMEvent)) {
                object3 = new DeletionEventData(nSMEvent);
                object2 = ((DeletionEventData)object3).getDeletedObjects();
                if (object2 == null) {
                    return false;
                }
                cIMBean = object2[0];
                if (cIMBean == null || ((CIMBean[])object2).length == 0) {
                    return false;
                }
            } else {
                Report.error.log("Unhandled eventType");
                return false;
            }
            object3 = cIMBean.getClass();
            try {
                object2 = Class.forName(this.targetClass);
                if (!((Class)object2).isAssignableFrom(cIMBean.getClass())) {
                    return false;
                }
                Report.trace.log("Policy", (Object)("MATCHED CLASS: " + cIMBean.getClass().getName()));
                object = "get" + this.targetAttr.substring(0, 1).toUpperCase() + this.targetAttr.substring(1);
                method = ((Class)object3).getMethod((String)object, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Report.error.log(noSuchMethodException);
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Report.error.log("No class found with name " + this.targetClass);
                return false;
            }
            object2 = method.getReturnType();
            if (!object2.equals(class$java$lang$String == null ? (class$java$lang$String = PatternMatchCondition.class$("java.lang.String")) : class$java$lang$String)) {
                Report.debug.log("The target attribute in PatternMatch must be of type string");
                return false;
            }
            try {
                object = method.invoke((Object)cIMBean, null);
                String string = (String)object;
                Pattern pattern = Pattern.compile(this.targetPattern);
                if (pattern.matcher(string).find()) {
                    return true;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Report.error.log(illegalAccessException);
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Report.error.log(illegalArgumentException);
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                Report.error.log(invocationTargetException);
                return false;
            }
        }
        return false;
    }

    public boolean evaluate(Collection collection, Context context) {
        return false;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        this.targetClass = (String)this.propertyValues.get(TARGET_CLASS);
        this.targetAttr = (String)this.propertyValues.get(TARGET_ATTR);
        this.targetPattern = (String)this.propertyValues.get(PATTERN);
        if (this.targetClass == null || this.targetAttr == null || this.targetPattern == null) {
            throw new PropertiesPersistenceException(this.getConditionName() + " PatternMatchCondition is missing " + TARGET_CLASS + ", " + TARGET_ATTR + ", or " + PATTERN);
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testPatternMatchCondition();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test
    extends UnitTest {
        public void testPatternMatchCondition() {
            PatternMatchCondition patternMatchCondition = new PatternMatchCondition("TestCondition");
        }
    }
}

