/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.policy.StatisticEvaluator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;

public class IntegerStatisticEvaluator
implements StatisticEvaluator {
    private long initialValue = 0L;
    private long accumValue = 0L;
    private boolean restarted = true;
    private static final String sccs_id = "@(#)IntegerStatisticEvaluator.java 1.6 02/09/30 SMI";

    public String getPreviousValue() {
        return Long.toString(this.initialValue);
    }

    public String getCurrentValue() {
        return Long.toString(this.accumValue);
    }

    public String getDelta() {
        return Long.toString(this.accumValue - this.initialValue);
    }

    public void init() {
        this.restarted = true;
    }

    public void add(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (this.restarted) {
            this.initialValue = Long.parseLong(string);
            this.accumValue = Long.parseLong(string2);
            this.restarted = false;
        } else {
            long l = Long.parseLong(string);
            if (l > this.accumValue) {
                Report.debug.log("Policy", (Object)"Policy missed an event");
            }
            this.accumValue = Long.parseLong(string2);
        }
    }

    public boolean evaluate(String string) {
        long l = this.accumValue - this.initialValue;
        long l2 = Long.parseLong(string);
        return l >= l2;
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testIntegerStatisticEvaluator();
    }

    public static class Test
    extends UnitTest {
        public void testIntegerStatisticEvaluator() {
            IntegerStatisticEvaluator integerStatisticEvaluator = new IntegerStatisticEvaluator();
            try {
                integerStatisticEvaluator.add("300", Long.toString(Long.MAX_VALUE));
                this.assertCondition(integerStatisticEvaluator.evaluate(Long.toString(0x3FFFFFFFFFFFFFFFL)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.fail();
            }
            try {
                integerStatisticEvaluator.init();
                integerStatisticEvaluator.add(Long.toString(Long.MIN_VALUE), Long.toString(Long.MAX_VALUE));
                integerStatisticEvaluator.evaluate("2000000");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.assertNotNull(exception);
            }
        }
    }
}

