/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.ConditionEvaluator;
import com.sun.jade.policy.Context;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.unittest.UnitTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class DelegateCondition
extends Condition {
    private ConditionEvaluator delegateClass;
    private Method eventEvalMethod;
    private Method collectionEvalMethod;
    public static final String DELEGATE_CLASS = ".DelegateClass";
    private static final String[] propertyNames = new String[]{".DelegateClass"};
    private Map propertyValues;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public DelegateCondition(String string) {
        super(string);
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) {
        return this.delegateClass.evaluate(nSMEvent);
    }

    public boolean evaluate(Collection collection, Context context) {
        return this.delegateClass.evaluate(collection);
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        String string = this.getConditionName();
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string2 = properties.getProperty("Condition." + string.trim() + DELEGATE_CLASS);
        if (string2 == null) {
            throw new PropertiesPersistenceException(string + " Condition must define a DelegateClass");
        }
        try {
            Class<?> clazz = Class.forName(string2);
            this.delegateClass = (ConditionEvaluator)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new PropertiesPersistenceException("Delegate Condition Class: Class " + string2 + " does not implement ConditionEvaluator Interface", classCastException);
        }
        catch (InstantiationException instantiationException) {
            throw new PropertiesPersistenceException("Delegate Condition Class: " + string2 + " is abstract or an interface", instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PropertiesPersistenceException("Delegate Condition Class: " + string2 + " unable to load class", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertiesPersistenceException("Delegate Condition Class: " + string2 + " cannot access class", illegalAccessException);
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testValueCondition();
    }

    public static class TestDelegate2
    implements ConditionEvaluator {
        public boolean evaluate(NSMEvent nSMEvent) {
            return false;
        }

        public boolean evaluate(Collection collection) {
            return false;
        }
    }

    public static class TestDelegate1
    implements ConditionEvaluator {
        public boolean evaluate(NSMEvent nSMEvent) {
            return true;
        }

        public boolean evaluate(Collection collection) {
            return true;
        }
    }

    public static class Test
    extends UnitTest {
        public void testValueCondition() {
            try {
                DelegateCondition delegateCondition = new DelegateCondition("TestCondition");
                Properties properties = new Properties();
                properties.setProperty("Condition.TestCondition.DelegateClass", "com.sun.jade.policy.DelegateCondition$TestDelegate1");
                delegateCondition.fromProperties(properties);
                NSMEvent nSMEvent = new NSMEvent("", "", "");
                this.assertCondition(delegateCondition.evaluate(nSMEvent, null));
                ArrayList arrayList = new ArrayList();
                this.assertCondition(delegateCondition.evaluate(arrayList, null));
                properties.setProperty("Condition.TestCondition.DelegateClass", "com.sun.jade.policy.DelegateCondition$TestDelegate2");
                delegateCondition.fromProperties(properties);
                this.assertCondition(!delegateCondition.evaluate(nSMEvent, null));
                this.assertCondition(!delegateCondition.evaluate(arrayList, null));
                try {
                    properties.setProperty("Condition.TestCondition.DelegateClass", "kjfg");
                    delegateCondition.fromProperties(properties);
                    this.fail("Accepting Bad Properties");
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                this.fail(exception.toString());
            }
        }
    }
}

