/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Context {
    private Map sourceMap = new HashMap();
    public static final String CREATION_CLASS_NAME = "CreationClassName";
    public static final String CURRENTVALUE = "currentValue";
    public static final String PREVIOUSVALUE = "previousValue";
    public static final String DELTA = "delta";
    public static final String INTERVAL_SEC = "interval_sec";
    public static final String INTERVAL_MIN = "interval_min";
    public static final String INTERVAL_HRS = "interval_hrs";
    public static final String INTERVAL_DAY = "interval_day";

    public String getAttr(String string, String string2) {
        Properties properties = (Properties)this.sourceMap.get(string);
        if (properties != null) {
            return properties.getProperty(string2);
        }
        return null;
    }

    public void saveAttr(String string, String string2, String string3) {
        Properties properties = (Properties)this.sourceMap.get(string);
        if (properties == null) {
            properties = new Properties();
            properties.setProperty(CREATION_CLASS_NAME, string);
            this.sourceMap.put(string, properties);
        }
        properties.setProperty(string2, string3);
    }

    public Collection getCollection() {
        ArrayList<PolicyBean> arrayList = new ArrayList<PolicyBean>();
        Set set = this.sourceMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Properties properties = (Properties)this.sourceMap.get(iterator.next());
            PolicyBean policyBean = new PolicyBean(properties);
            arrayList.add(policyBean);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testContext();
    }

    public static class Test
    extends UnitTest {
        public void testContext() {
            Context context = new Context();
            this.testUninitializedContext(context);
            context = new Context();
            this.testIntervalContext(context);
            context = new Context();
            this.testStatusContext(context);
        }

        public void testIntervalContext(Context context) {
            String string = "10";
            String string2 = "159";
            String string3 = "10";
            String string4 = "ChangeCondition";
            String string5 = "A";
            String string6 = "B";
            String string7 = "C";
            String string8 = "TestCondition";
            context.saveAttr(string4, Context.PREVIOUSVALUE, string);
            context.saveAttr(string4, Context.CURRENTVALUE, string2);
            context.saveAttr(string4, Context.INTERVAL_SEC, string3);
            context.saveAttr(string8, Context.PREVIOUSVALUE, string5);
            context.saveAttr(string8, Context.CURRENTVALUE, string6);
            context.saveAttr(string8, Context.INTERVAL_SEC, string7);
            this.assertEquals(string, context.getAttr(string4, Context.PREVIOUSVALUE));
            this.assertEquals(string2, context.getAttr(string4, Context.CURRENTVALUE));
            this.assertEquals(string3, context.getAttr(string4, Context.INTERVAL_SEC));
            this.assertEquals(string5, context.getAttr(string8, Context.PREVIOUSVALUE));
            this.assertEquals(string6, context.getAttr(string8, Context.CURRENTVALUE));
            this.assertEquals(string7, context.getAttr(string8, Context.INTERVAL_SEC));
            Collection collection = context.getCollection();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                System.out.println("Iterating...");
                CIMBeanBase cIMBeanBase = (CIMBeanBase)iterator.next();
                Properties properties = cIMBeanBase.toProperties();
                if (string4.equals(properties.getProperty(Context.CREATION_CLASS_NAME))) {
                    this.assertEquals(string, properties.getProperty(Context.PREVIOUSVALUE));
                    this.assertEquals(string2, properties.getProperty(Context.CURRENTVALUE));
                    this.assertEquals(string3, properties.getProperty(Context.INTERVAL_SEC));
                    continue;
                }
                if (string8.equals(properties.getProperty(Context.CREATION_CLASS_NAME))) {
                    this.assertEquals(string5, properties.getProperty(Context.PREVIOUSVALUE));
                    this.assertEquals(string6, properties.getProperty(Context.CURRENTVALUE));
                    this.assertEquals(string7, properties.getProperty(Context.INTERVAL_SEC));
                    continue;
                }
                this.fail();
            }
        }

        public void testStatusContext(Context context) {
            String string = "bad";
            String string2 = "good";
            context.saveAttr("Test", Context.PREVIOUSVALUE, string);
            context.saveAttr("Test", Context.CURRENTVALUE, string2);
            this.assertEquals(string, context.getAttr("Test", Context.PREVIOUSVALUE));
            this.assertEquals(string2, context.getAttr("Test", Context.CURRENTVALUE));
            this.assertNull(context.getAttr("Test", Context.INTERVAL_SEC));
        }

        public void testUninitializedContext(Context context) {
            this.assertNull(context.getAttr("Junk", Context.PREVIOUSVALUE));
            this.assertNull(context.getAttr("Junk", Context.CURRENTVALUE));
            this.assertNull(context.getAttr("Junk", Context.INTERVAL_SEC));
        }
    }

    public class PolicyBean
    extends CIMBeanBase {
        private Properties properties;

        public PolicyBean(Properties properties) {
            this.properties = new Properties(properties);
        }

        public void readCIMInstance(CIMInstance cIMInstance) throws CIMException {
        }

        public void writeCIMInstance(CIMInstance cIMInstance) throws CIMException {
        }

        public void writeCIMInstance(CIMInstance cIMInstance, boolean bl) throws CIMException {
        }

        public Properties toProperties() {
            return this.properties;
        }

        public void readPropertyValues(Map map) {
        }

        public void readPropertyNames(Set set) {
        }
    }
}

