/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.cim.bean.NWS_InstModification;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.unittest.UnitTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class AggregateCondition
extends Condition {
    private Vector conditionList = null;
    private String conditionListType = null;
    private static final String DNF = "DNF";
    private static final String CNF = "CNF";
    public static final String CONDITION_LIST = ".ConditionList";
    public static final String CONDITION_LIST_TYPE = ".ConditionListType";
    private static final String[] propertyNames = new String[]{".ConditionList", ".ConditionListType"};
    private Map propertyValues;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public AggregateCondition(String string) {
        super(string);
    }

    public Vector getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(Vector vector) {
        this.conditionList = vector;
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) throws Exception {
        return this.doevaluate(nSMEvent, context);
    }

    public boolean evaluate(Collection collection, Context context) throws Exception {
        return this.doevaluate(collection, context);
    }

    private boolean doevaluate(Object object, Context context) throws Exception {
        boolean bl = false;
        Iterator iterator = this.conditionList.iterator();
        if (this.conditionListType.equalsIgnoreCase(DNF)) {
            bl = true;
        } else if (this.conditionListType.equalsIgnoreCase(CNF)) {
            bl = false;
        }
        while (iterator.hasNext()) {
            Object object2;
            Condition condition = (Condition)iterator.next();
            if (this.conditionListType.equalsIgnoreCase(DNF)) {
                if (object instanceof NSMEvent) {
                    object2 = (NSMEvent)object;
                    bl &= condition.evaluate((NSMEvent)object2, context);
                } else {
                    object2 = (Collection)object;
                    bl &= condition.evaluate((Collection)object2, context);
                }
                if (bl) continue;
                break;
            }
            if (!this.conditionListType.equalsIgnoreCase(CNF)) continue;
            if (object instanceof NSMEvent) {
                object2 = (NSMEvent)object;
                bl |= condition.evaluate((NSMEvent)object2, context);
            } else {
                object2 = (Collection)object;
                bl |= condition.evaluate((Collection)object2, context);
            }
            if (bl) break;
        }
        return bl;
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        Iterator iterator = this.conditionList.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            stringBuffer.append(condition.getConditionName());
            if (iterator.hasNext()) {
                stringBuffer.append(",");
            }
            properties.putAll((Map<?, ?>)condition.toProperties());
        }
        this.propertyValues.put(CONDITION_LIST_TYPE, this.conditionListType);
        this.propertyValues.put(CONDITION_LIST, stringBuffer);
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = (String)this.propertyValues.get(CONDITION_LIST);
        this.conditionListType = (String)this.propertyValues.get(CONDITION_LIST_TYPE);
        String string2 = this.getConditionName();
        if (string == null) {
            throw new PropertiesPersistenceException(string2 + " Aggregate Condition " + " must define " + CONDITION_LIST + " property.");
        }
        if (this.conditionListType == null) {
            throw new PropertiesPersistenceException(string2 + " Aggregate Condition " + " must define " + CONDITION_LIST_TYPE + " property.");
        }
        if (!this.conditionListType.equals(DNF) && !this.conditionListType.equals(CNF)) {
            throw new PropertiesPersistenceException(string2 + " Aggregate Condition " + " ConditionListType must be either " + CNF + " or " + DNF);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.conditionList = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            Condition condition = Condition.newInstance(string3, properties);
            this.conditionList.add(condition);
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testAggregateCondition();
    }

    public static class Test
    extends UnitTest {
        public void testAggregateCondition() {
            try {
                Condition condition = new Condition(this, "Test1"){
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                    }

                    public boolean evaluate(NSMEvent nSMEvent, Context context) {
                        return true;
                    }

                    public boolean evaluate(Collection collection, Context context) {
                        return true;
                    }

                    public void fromProperties(Properties properties) {
                    }
                };
                Condition condition2 = new Condition(this, "Test2"){
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                    }

                    public boolean evaluate(NSMEvent nSMEvent, Context context) {
                        return true;
                    }

                    public boolean evaluate(Collection collection, Context context) {
                        return true;
                    }

                    public void fromProperties(Properties properties) {
                    }
                };
                ReferenceForMSE referenceForMSE = new ReferenceForMSE("com.sun.jade.cim.bean.StorEdgeT3_DiskDrive", "DeviceID", "T3", "purple12");
                NWS_InstModification nWS_InstModification = new NWS_InstModification();
                nWS_InstModification.setSourceInstance("Instance of CIM_Configuration{ Caption = \"1\" ; }");
                nWS_InstModification.setPreviousInstance("Instance of CIM_Configuration { Caption = \"6\" ; }");
                NSMEvent nSMEvent = new NSMEvent("testSubject", "testSource", ".testopic");
                Vector<NWS_InstModification> vector = new Vector<NWS_InstModification>();
                vector.add(nWS_InstModification);
                nSMEvent.setPayload(vector);
                AggregateCondition aggregateCondition = new AggregateCondition("AggregateTest");
                Properties properties = new Properties();
                properties.setProperty("Condition.Test1.Type", "com.sun.jade.policy.EventCondition");
                properties.setProperty("Condition.Test1.EventCondType", "EventSubject");
                properties.setProperty("Condition.Test1.EventCondComparator", "testSubject");
                properties.setProperty("Condition.Test1.EvaluateCollection", "true");
                properties.setProperty("Condition.Test2.Type", "com.sun.jade.policy.EventCondition");
                properties.setProperty("Condition.Test2.EventCondType", "EventSubject");
                properties.setProperty("Condition.Test2.EventCondComparator", "testSubject");
                properties.setProperty("Condition.Test2.EvaluateCollection", "true");
                properties.setProperty("Condition.AggregateTest.ConditionList", "Test1, Test2");
                properties.setProperty("Condition.AggregateTest.ConditionListType", AggregateCondition.CNF);
                aggregateCondition.fromProperties(properties);
                this.assertCondition(aggregateCondition.evaluate(nSMEvent, new Context()));
                properties.setProperty("Condition.Test1.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test1.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test1.Operator", "==");
                properties.setProperty("Condition.Test1.Constant", "1");
                properties.setProperty("Condition.Test2.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test2.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test2.Operator", "==");
                properties.setProperty("Condition.Test2.Constant", "1");
                properties.setProperty("Condition.AggregateTest.ConditionList", "Test1, Test2");
                properties.setProperty("Condition.AggregateTest.ConditionListType", AggregateCondition.DNF);
                aggregateCondition.fromProperties(properties);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(new Object(this){
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                    }

                    public int getTestAttr() {
                        return 1;
                    }
                });
                this.assertCondition(aggregateCondition.evaluate(arrayList, new Context()));
                properties.setProperty("Condition.Test1.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test1.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test1.Operator", "==");
                properties.setProperty("Condition.Test1.Constant", "1");
                properties.setProperty("Condition.Test2.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test2.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test2.Operator", "==");
                properties.setProperty("Condition.Test2.Constant", "2");
                properties.setProperty("Condition.AggregateTest.ConditionList", "Test1, Test2");
                properties.setProperty("Condition.AggregateTest.ConditionListType", AggregateCondition.DNF);
                aggregateCondition.fromProperties(properties);
                arrayList = new ArrayList();
                arrayList.add(new Object(this){
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                    }

                    public int getTestAttr() {
                        return 2;
                    }
                });
                this.assertCondition(!aggregateCondition.evaluate(arrayList, new Context()));
                properties.setProperty("Condition.Test1.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test1.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test1.Operator", "==");
                properties.setProperty("Condition.Test1.Constant", "1");
                properties.setProperty("Condition.Test2.Type", "com.sun.jade.policy.ValueCondition");
                properties.setProperty("Condition.Test2.TargetAttr", "testAttr");
                properties.setProperty("Condition.Test2.Operator", "==");
                properties.setProperty("Condition.Test2.Constant", "2");
                properties.setProperty("Condition.AggregateTest.ConditionList", "Test1, Test2");
                properties.setProperty("Condition.AggregateTest.ConditionListType", AggregateCondition.CNF);
                aggregateCondition.fromProperties(properties);
                arrayList = new ArrayList();
                arrayList.add(new Object(this){
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                    }

                    public int getTestAttr() {
                        return 2;
                    }
                });
                this.assertCondition(aggregateCondition.evaluate(arrayList, new Context()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.fail(exception.toString());
            }
        }
    }
}

