/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Action;
import com.sun.jade.policy.ActionNotExecutedException;
import com.sun.jade.policy.Context;
import com.sun.jade.util.PropertiesPersistenceException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ActionGroup
extends Action {
    private Vector actionList = null;
    private String actionExecutionStrategy = "Serial";
    public static final String PARALLEL = "Parallel";
    public static final String SERIAL = "Serial";
    public static final String DEFAULT_ACTION_STRATEGY = "Serial";
    public static final String ACTION = ".Action";
    public static final String ACTION_EXECUTION_SEQUENCE = ".ActionExecutionSequence";
    private static final String[] propertyNames = new String[]{".Action", ".ActionExecutionSequence"};
    private Map propertyValues;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public ActionGroup(String string) {
        super(string);
    }

    public ActionGroup(String string, Vector vector, String string2) {
        super(string);
        vector = new Vector();
    }

    public void doAction(NSMEvent nSMEvent, Context context) throws ActionNotExecutedException {
        int n = 0;
        while (n < this.actionList.size()) {
            if (this.actionExecutionStrategy.equalsIgnoreCase("Serial")) {
                Action action = (Action)this.actionList.get(n);
                action.doAction(nSMEvent, context);
            } else if (this.actionExecutionStrategy.equalsIgnoreCase(PARALLEL)) {
                // empty if block
            }
            ++n;
        }
    }

    public void doAction(Collection collection, Context context) throws ActionNotExecutedException {
        int n = 0;
        while (n < this.actionList.size()) {
            if (this.actionExecutionStrategy.equalsIgnoreCase("Serial")) {
                Action action = (Action)this.actionList.get(n);
                action.doAction(collection, context);
            } else if (this.actionExecutionStrategy.equalsIgnoreCase(PARALLEL)) {
                // empty if block
            }
            ++n;
        }
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        String string = this.getActionName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.actionList.size()) {
            Action action = (Action)this.actionList.get(n);
            stringBuffer.append(action.getActionName());
            if (n != this.actionList.size() - 1) {
                stringBuffer.append(",");
            }
            properties.putAll((Map<?, ?>)action.toProperties());
            properties.setProperty(".Action." + action.getActionName() + ".ActionOrder", Integer.toString(n));
            ++n;
        }
        properties.setProperty(".Action." + string + ACTION, stringBuffer.toString());
        properties.setProperty(".Action." + string + ACTION_EXECUTION_SEQUENCE, this.actionExecutionStrategy);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = (String)this.propertyValues.get(ACTION);
        this.actionExecutionStrategy = (String)this.propertyValues.get(ACTION_EXECUTION_SEQUENCE);
        if (this.actionExecutionStrategy == null) {
            this.actionExecutionStrategy = "Serial";
        } else if (!this.actionExecutionStrategy.equals(PARALLEL) && !this.actionExecutionStrategy.equals("Serial")) {
            throw new PropertiesPersistenceException("Action Execution Sequence must be either Parallel or Serial");
        }
        if (string == null) {
            throw new PropertiesPersistenceException("Action Group does not specify any subgroups");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.actionList = new Vector();
        this.actionList.setSize(stringTokenizer.countTokens());
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            Action action = Action.newInstance(string2, properties);
            String string3 = properties.getProperty(".Action." + string2 + ".ActionOrder");
            Action action2 = null;
            if (string3 == null) {
                try {
                    action2 = this.actionList.set(n, action);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new PropertiesPersistenceException("Cannot parse actionGroup: " + this.getActionName(), indexOutOfBoundsException);
                }
            }
            int n2 = Integer.parseInt(string3);
            try {
                action2 = this.actionList.set(n2 - 1, action);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new PropertiesPersistenceException("Cannot parse actionGroup: " + this.getActionName(), indexOutOfBoundsException);
            }
            if (action2 != null) {
                throw new PropertiesPersistenceException("ActionOrder cannot be resolved:" + string2);
            }
            ++n;
        }
    }
}

