/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.device.util.ReportSearcher;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.StateChangeData;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.mediator.DeviceManager;
import com.sun.jade.mediator.Filter;
import com.sun.jade.mediator.FilterEvaluationException;
import com.sun.jade.mediator.Predicate;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class FilterChecker {
    private DeviceManager deviceManager;
    private ArrayList currentBeans;
    private ArrayList priorBeans;
    private String prefixName;
    private String packageName;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int EQUAL_TO = 3;
    public static final int NOT_EQUAL_TO = 4;
    public static final int GREATER_THAN_OR_EQUAL = 5;
    public static final int LESS_THAN_OR_EQUAL = 6;
    public static final int DELTA = 7;

    FilterChecker(DeviceManager deviceManager) throws StorAdeException {
        if (deviceManager == null) {
            throw new StorAdeException("resource.error", 5);
        }
        this.deviceManager = deviceManager;
        this.currentBeans = deviceManager.getGraph().getBeans();
        this.priorBeans = deviceManager.getPriorGraph().getBeans();
        String string = this.deviceManager.getSystemData();
        DeviceReport deviceReport = new DeviceReport(string);
        this.prefixName = deviceReport.getPrefixName();
        this.packageName = deviceReport.getPackageName();
    }

    public void evaluate(Filter filter) {
        Object var2_2 = null;
        Object object = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList = ReportSearcher.enumerateBeans(filter.getClassName(), this.currentBeans);
        arrayList2 = ReportSearcher.enumerateBeans(filter.getClassName(), this.priorBeans);
        if (arrayList == null || arrayList2 == null) {
            MessageCode messageCode = new MessageCode("app.sade3.resource.error", 6);
            Object[] objectArray = new Object[]{filter.getClassName(), this.deviceManager.getName()};
            Report.error.log(messageCode.toString(objectArray));
            return;
        }
        Vector vector = filter.getPredicates();
        int n = 0;
        while (n < arrayList.size()) {
            Object object2;
            Object object3;
            boolean bl = true;
            boolean bl2 = true;
            var2_2 = arrayList.get(n);
            try {
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object[] objectArray;
                    object3 = (Predicate)vector.get(n2);
                    object2 = "get" + ((Predicate)object3).getAttributeName();
                    Object object4 = this.getAttributeValue(var2_2, (String)object2);
                    object = this.findMatch(var2_2, this.priorBeans);
                    if (((Predicate)object3).getOperator() == 7) {
                        objectArray = this.getAttributeValue(object, (String)object2);
                        bl2 = this.deltaComparison(object4, objectArray);
                    } else {
                        if (object4 == null) {
                            objectArray = new Object[]{((Predicate)object3).getClassName(), ((Predicate)object3).getAttributeName()};
                            throw new FilterEvaluationException("resource.information", 3, objectArray);
                        }
                        bl2 = FilterChecker.makeComparison(object4, ((Predicate)object3).getOperator(), ((Predicate)object3).getTargetValue());
                    }
                    bl = n2 == 0 ? bl2 : (((Predicate)object3).getLogicalOperator() == 1 ? (bl &= bl2) : (bl |= bl2));
                    ++n2;
                }
            }
            catch (FilterEvaluationException filterEvaluationException) {
                object3 = new MessageCode("app.sade3.resource.warning", 3);
                object2 = new Object[]{filterEvaluationException.getLocalizedMessage()};
                Report.warning.log(((MessageCode)object3).toString((Object[])object2));
                bl = false;
            }
            this.postIfRequired(filter, var2_2, (CIMBeanBase)object, bl);
            ++n;
        }
    }

    private Object findMatch(Object object, ArrayList arrayList) throws FilterEvaluationException {
        int n = 0;
        while (n < arrayList.size()) {
            try {
                if (object.equals(arrayList.get(n))) {
                    return arrayList.get(n);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n;
        }
        throw new FilterEvaluationException("resource.warning", 4);
    }

    private Object getAttributeValue(Object object, String string) throws FilterEvaluationException {
        Object object2 = null;
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, null);
            object2 = method.invoke(object, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object[] objectArray = new Object[]{string};
            throw new FilterEvaluationException("resource.warning", 5, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FilterEvaluationException("resource.warning", 6);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FilterEvaluationException("resource.warning", 7);
        }
        return object2;
    }

    public static boolean makeComparison(Object object, int n, Object object2) throws FilterEvaluationException {
        boolean bl;
        block10: {
            bl = false;
            try {
                Class<?> clazz = object.getClass();
                if (clazz.getName().indexOf("UnsignedInt8") != -1) {
                    int n2 = ((UnsignedInt8)object).intValue();
                    bl = FilterChecker.compare(new Integer(n2), n, (Integer)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("UnsignedInt16") != -1) {
                    int n3 = ((UnsignedInt16)object).intValue();
                    bl = FilterChecker.compare(new Integer(n3), n, (Integer)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("UnsignedInt32") != -1) {
                    int n4 = ((UnsignedInt32)object).intValue();
                    bl = FilterChecker.compare(new Integer(n4), n, (Integer)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("UnsignedInt64") != -1) {
                    int n5 = ((UnsignedInt64)object).intValue();
                    bl = FilterChecker.compare(new Integer(n5), n, (Integer)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("Integer") != -1) {
                    bl = FilterChecker.compare((Integer)object, n, (Integer)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("Float") != -1) {
                    Float f = (Float)object;
                    bl = FilterChecker.compare(f, n, (Float)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("String") != -1) {
                    String string = (String)object;
                    bl = FilterChecker.compare(string, n, (String)object2);
                    break block10;
                }
                if (clazz.getName().indexOf("Boolean") != -1) {
                    Boolean bl2 = (Boolean)object;
                    bl = FilterChecker.compare(bl2, n, (Boolean)object2);
                    break block10;
                }
                Object[] objectArray = new Object[]{clazz.getName()};
                throw new FilterEvaluationException("resource.warning", 8, objectArray);
            }
            catch (NullPointerException nullPointerException) {
                throw new FilterEvaluationException("resource.information", 4);
            }
        }
        return bl;
    }

    private boolean deltaComparison(Object object, Object object2) throws FilterEvaluationException {
        boolean bl = false;
        if (object == null && object2 != null || object != null && object2 == null) {
            bl = true;
        } else if (object == null && object2 == null) {
            bl = false;
        } else {
            try {
                if (!object.equals(object2)) {
                    bl = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new FilterEvaluationException("resource.information", 4);
            }
        }
        return bl;
    }

    public void postIfRequired(Filter filter, CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, boolean bl) {
        if (filter.usesDelta() && bl) {
            this.createEvent(cIMBeanBase, cIMBeanBase2, filter);
        } else {
            CIMObjectPath cIMObjectPath = cIMBeanBase.getCIMObjectPath();
            if (bl) {
                if (!filter.postedForElement(cIMObjectPath)) {
                    filter.addCOP(cIMObjectPath);
                    this.createEvent(cIMBeanBase, cIMBeanBase2, filter);
                }
            } else if (filter.postedForElement(cIMObjectPath)) {
                filter.removeCOP(cIMObjectPath);
                this.createEvent(cIMBeanBase, cIMBeanBase2, filter);
            }
        }
    }

    private int searchHitList(Vector vector, String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (string.equals((String)vector.get(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void createEvent(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, Filter filter) {
        Properties properties = DevInfo.getDeviceProperties(this.deviceManager.getType().toLowerCase());
        String string = properties.getProperty("MF.class");
        int n = 3;
        try {
            StateChangeData stateChangeData = new StateChangeData(cIMBeanBase, cIMBeanBase2);
            ArrayList<StateChangeData> arrayList = new ArrayList<StateChangeData>();
            arrayList.add(stateChangeData);
            CIMObjectPath cIMObjectPath = cIMBeanBase.getCIMObjectPath();
            EventData eventData = new EventData(this.deviceManager.getName(), "StateChange", filter.getTopic(), cIMObjectPath, n, string, this.deviceManager.getName(), arrayList);
            EventGenerator.generateEvent(eventData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.error.log(illegalArgumentException.getLocalizedMessage());
        }
    }

    public static boolean compare(Integer n, int n2, Integer n3) {
        boolean bl = false;
        switch (n2) {
            case 1: {
                if (n.compareTo(n3) <= 0) break;
                bl = true;
                break;
            }
            case 2: {
                if (n.compareTo(n3) >= 0) break;
                bl = true;
                break;
            }
            case 3: {
                if (n.compareTo(n3) != 0) break;
                bl = true;
                break;
            }
            case 4: {
                if (n.compareTo(n3) == 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean compare(Float f, int n, Float f2) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (f.compareTo(f2) <= 0) break;
                bl = true;
                break;
            }
            case 2: {
                if (f.compareTo(f2) >= 0) break;
                bl = true;
                break;
            }
            case 3: {
                if (!f.equals(f2)) break;
                bl = true;
                break;
            }
            case 4: {
                if (f.equals(f2)) break;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean compare(Boolean bl, int n, Boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 3: {
                if (!bl.equals(bl2)) break;
                bl3 = true;
                break;
            }
            case 4: {
                if (bl.equals(bl2)) break;
                bl3 = true;
            }
        }
        return bl3;
    }

    public static boolean compare(String string, int n, String string2) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (string.compareTo(string2) <= 0) break;
                bl = true;
                break;
            }
            case 2: {
                if (string.compareTo(string2) >= 0) break;
                bl = true;
                break;
            }
            case 3: {
                if (!string.equals(string2)) break;
                bl = true;
                break;
            }
            case 4: {
                if (string.equals(string2)) break;
                bl = true;
            }
        }
        return bl;
    }
}

