/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.mediator.DeviceHelper;
import com.sun.jade.mediator.DeviceManager;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.log.Report;
import java.util.Timer;
import java.util.TimerTask;

class DeviceHolder {
    private DeviceManager dm;
    private int pollInterval;
    private long pollCount;
    private long totalTime;
    private long lastAudit;
    private long auditInterval;
    private Timer timer;
    private static final long MILLIS_IN_WEEK = 604800000L;

    DeviceHolder(DeviceManager deviceManager, int n) {
        this.dm = deviceManager;
        this.pollInterval = n * 1000;
        this.pollCount = 0L;
        this.totalTime = 0L;
        this.lastAudit = System.currentTimeMillis();
        this.auditInterval = 604800000L;
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new PollingTask(), 0L, (long)this.pollInterval);
    }

    DeviceManager getDevice() {
        return this.dm;
    }

    boolean matchName(String string) {
        boolean bl = false;
        if (this.dm.getName().equals(string)) {
            bl = true;
        }
        return bl;
    }

    void stopPolling() {
        this.timer.cancel();
        this.timer = null;
    }

    void startPolling() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new PollingTask(), 0L, (long)this.pollInterval);
        }
    }

    void updatePollingInterval(int n) {
        if (this.timer == null) {
            this.pollInterval = n;
        } else {
            this.stopPolling();
            this.pollInterval = n;
            this.startPolling();
        }
    }

    boolean isPolling() {
        return this.timer != null;
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            DeviceHolder.this.dm.updateData();
            long l2 = System.currentTimeMillis();
            DeviceHolder.this.pollCount++;
            DeviceHolder.this.totalTime += l2 - l;
            MessageCode messageCode = new MessageCode("app.sade3.resource.information", 2);
            Object[] objectArray = new Object[]{DeviceHolder.this.dm.getType(), DeviceHolder.this.dm.getName(), new Long(DeviceHolder.this.totalTime / DeviceHolder.this.pollCount / 1000L), new Long((l2 - l) / 1000L)};
            Report.info.log("PollingStats", (Object)messageCode.toString(objectArray));
            if (l2 - DeviceHolder.this.auditInterval >= DeviceHolder.this.lastAudit) {
                DeviceHelper.sendAuditEvent(DeviceHolder.this.dm);
                DeviceHolder.this.lastAudit = l2;
            }
        }
    }
}

