/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.wbem;

import com.sun.jade.apps.diags.lib.DiagnosableHelperImpl;
import com.sun.jade.cim.bean.CIM_IndicationFilter;
import com.sun.jade.cim.bean.CIM_IndicationSubscription;
import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanImpl;
import com.sun.jade.cim.util.CIMReference;
import com.sun.jade.logic.mf.MFAdmin;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.mf.ServiceException;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.logic.wbem.CIMClientMF;
import com.sun.jade.logic.wbem.CIMClientUser;
import com.sun.jade.logic.wbem.CIMTopologyHelper;
import com.sun.jade.logic.wbem.IndicationEvent;
import com.sun.jade.logic.wbem.IndicationListener;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.unittest.ClassTest;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.client.CIMEvent;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CIMClientMFImpl
implements CIMClientMF {
    protected static boolean localHelpers;
    private CIMObjectPath system;
    private CIMClient cc;
    private CIM_System systemInfo;
    private CIMNameSpace cns;
    private Principal principal;
    private Object credential;
    private Listener listener;
    private TopicListener topicListener;
    private Properties properties;
    private static int eventNum;
    private Vector installedHelpers = new Vector();
    boolean localOnly = false;
    boolean deepInheritance = true;
    boolean includeQualifiers = false;
    boolean includeClassOrigin = false;
    String[] propertyList = null;
    private MFStatus status = MFStatus.STOPPED;
    private boolean started;
    private static final String sccs_id = "@(#)CIMClientMFImpl.java\t1.11 05/02/02 SMI";
    static /* synthetic */ Class class$com$sun$jade$logic$wbem$CIMClientMFImpl;

    protected CIMClientMFImpl() {
    }

    public CIMClientMFImpl(Properties properties) {
        this.properties = properties;
        String string = (String)properties.get("ip");
        this.system = new CIMObjectPath("CIM_UnitaryComputerSystem");
        this.system.addKey("Name", new CIMValue((Object)string));
        this.cns = new CIMNameSpace(string);
        String string2 = (String)properties.get("user");
        if (string2 == null) {
            string2 = "guest";
        }
        String string3 = (String)properties.get("password");
        this.principal = new UserPrincipal(string2);
        this.credential = new PasswordCredential(string3);
    }

    public CIMClientMFImpl(CIMObjectPath cIMObjectPath, String string, String string2, String string3) throws RemoteException {
        this.system = cIMObjectPath;
        this.cns = new CIMNameSpace(string);
        this.principal = new UserPrincipal(string2);
        this.credential = new PasswordCredential(string3);
    }

    public CIMClientMFImpl(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws RemoteException {
        this.system = cIMObjectPath;
        this.cns = new CIMNameSpace(string, string2);
        this.principal = new UserPrincipal(string3);
        this.credential = new PasswordCredential(string4);
    }

    private void createServices() {
        DiagnosableHelperImpl diagnosableHelperImpl = null;
        CIMTopologyHelper cIMTopologyHelper = null;
        CIMClientUserImpl cIMClientUserImpl = new CIMClientUserImpl();
        try {
            diagnosableHelperImpl = new DiagnosableHelperImpl(this, cIMClientUserImpl);
            cIMTopologyHelper = new CIMTopologyHelper(this, cIMClientUserImpl);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.installedHelpers.add(diagnosableHelperImpl);
        this.installedHelpers.add(cIMTopologyHelper);
    }

    private void removeServices() {
        this.installedHelpers = new Vector();
        Object var1_1 = null;
        Object var2_2 = null;
    }

    public String getClassName() throws RemoteException {
        return this.system.getObjectName();
    }

    public String getName() throws RemoteException {
        Vector vector = this.system.getKeys();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(n);
            if (cIMProperty.getName().equalsIgnoreCase("Name")) {
                return (String)cIMProperty.getValue().getValue();
            }
            ++n;
        }
        return "";
    }

    public LocalizedMessage getDescription() throws RemoteException {
        return new LocalizedString(class$com$sun$jade$logic$wbem$CIMClientMFImpl == null ? (class$com$sun$jade$logic$wbem$CIMClientMFImpl = CIMClientMFImpl.class$("com.sun.jade.logic.wbem.CIMClientMFImpl")) : class$com$sun$jade$logic$wbem$CIMClientMFImpl, "description", "CIM Client Management Facade");
    }

    public LocalizedMessage getCaption() throws RemoteException {
        String string = this.getName();
        return new LocalizedString(class$com$sun$jade$logic$wbem$CIMClientMFImpl == null ? (class$com$sun$jade$logic$wbem$CIMClientMFImpl = CIMClientMFImpl.class$("com.sun.jade.logic.wbem.CIMClientMFImpl")) : class$com$sun$jade$logic$wbem$CIMClientMFImpl, "caption", string);
    }

    public Properties getProperties() throws RemoteException {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ServiceHelper[] getServiceHelpers() throws RemoteException {
        ServiceHelper[] serviceHelperArray = new ServiceHelper[this.installedHelpers.size()];
        this.installedHelpers.toArray(serviceHelperArray);
        return serviceHelperArray;
    }

    public ServiceHelper getServiceHelper(String string) throws RemoteException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        int n = 0;
        while (n < this.installedHelpers.size()) {
            if (clazz.isInstance(this.installedHelpers.get(n))) {
                return (ServiceHelper)this.installedHelpers.get(n);
            }
            ++n;
        }
        return null;
    }

    public CIMReference getManagedSystem() {
        return new CIMReference(this.system);
    }

    public String getManagerName() {
        return this.cns.getHost();
    }

    public MFAdmin getAdmin() {
        return this;
    }

    public MFStatus getStatus() {
        return new MFStatus(this.status.getValue());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stopService() throws ServiceException {
        try {
            this.cc.close();
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        this.cc = null;
        this.started = false;
        this.removeServices();
        this.status = MFStatus.STOPPED;
    }

    public void startService() throws ServiceException {
        try {
            this.cc = new CIMClient(this.cns, this.principal, this.credential, 1);
        }
        catch (Exception exception) {
            try {
                System.out.println("XML connection to CIMOM");
                this.cc = new CIMClient(this.cns, this.principal, this.credential, 0);
            }
            catch (Exception exception2) {
                this.status = MFStatus.LOST_COMM;
                throw new ServiceException("Service failed to start.", exception2);
            }
        }
        this.createServices();
        this.status = MFStatus.OK;
        this.started = true;
    }

    public CIMBean[] enumerateBeans(CIMObjectPath cIMObjectPath) throws RemoteException {
        CIMBean[] cIMBeanArray;
        this.checkStarted();
        ArrayList<CIMBeanImpl> arrayList = new ArrayList<CIMBeanImpl>();
        try {
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, this.localOnly, this.deepInheritance, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
            while (enumeration.hasMoreElements()) {
                cIMBeanArray = (CIMBean[])enumeration.nextElement();
                arrayList.add(new CIMBeanImpl((CIMInstance)cIMBeanArray));
            }
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        cIMBeanArray = new CIMBean[arrayList.size()];
        arrayList.toArray(cIMBeanArray);
        return cIMBeanArray;
    }

    public CIMReference[] enumerateBeanNames(CIMObjectPath cIMObjectPath) throws RemoteException {
        return this.enumerateInstanceNames(cIMObjectPath);
    }

    public CIMBean getBean(CIMObjectPath cIMObjectPath) throws RemoteException {
        this.checkStarted();
        try {
            CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, this.localOnly, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
            return new CIMBeanImpl(cIMInstance);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public CIMBean getBean(String string, Vector vector) throws RemoteException {
        CIMObjectPath cIMObjectPath = null;
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        try {
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.get(n);
                String string3 = (String)vector.get(n + 1);
                vector2.add(new CIMProperty(string2, new CIMValue((Object)string3)));
                n += 2;
            }
            cIMObjectPath = new CIMObjectPath(string, vector2);
        }
        catch (Exception exception) {
            throw new ServiceException("CIM Client Error", exception);
        }
        return this.getBean(cIMObjectPath);
    }

    public void setAccess(Principal principal, Object object) throws RemoteException {
        this.principal = principal;
        this.credential = object;
    }

    public CIMReference[] associatorNames(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws RemoteException {
        CIMObjectPath cIMObjectPath2;
        Enumeration enumeration;
        this.checkStarted();
        try {
            enumeration = this.cc.associatorNames(cIMObjectPath, string, string2, string3, string4);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        ArrayList<CIMReference> arrayList = new ArrayList<CIMReference>();
        while (enumeration.hasMoreElements()) {
            cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
            arrayList.add(new CIMReference(cIMObjectPath2));
        }
        cIMObjectPath2 = new CIMReference[arrayList.size()];
        arrayList.toArray((T[])cIMObjectPath2);
        return cIMObjectPath2;
    }

    public ArrayList associators(CIMObjectPath cIMObjectPath, String string, String string2, String string3, String string4) throws RemoteException {
        Enumeration enumeration;
        this.checkStarted();
        try {
            enumeration = this.cc.associators(cIMObjectPath, string, string2, string3, string4, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public CIMReference[] enumerateClassNames(CIMObjectPath cIMObjectPath, boolean bl) throws RemoteException {
        this.checkStarted();
        try {
            ArrayList<CIMReference> arrayList = new ArrayList<CIMReference>();
            Enumeration enumeration = this.cc.enumerateClassNames(cIMObjectPath, bl);
            while (enumeration.hasMoreElements()) {
                arrayList.add(new CIMReference((CIMObjectPath)enumeration.nextElement()));
            }
            CIMReference[] cIMReferenceArray = new CIMReference[arrayList.size()];
            arrayList.toArray(cIMReferenceArray);
            return cIMReferenceArray;
        }
        catch (Exception exception) {
            throw new ServiceException("CIM Client Error", exception);
        }
    }

    public CIMReference[] enumerateInstanceNames(CIMObjectPath cIMObjectPath) throws RemoteException {
        CIMObjectPath cIMObjectPath2;
        Enumeration enumeration;
        this.checkStarted();
        try {
            enumeration = this.cc.enumerateInstanceNames(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        ArrayList<CIMReference> arrayList = new ArrayList<CIMReference>();
        while (enumeration.hasMoreElements()) {
            cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
            arrayList.add(new CIMReference(cIMObjectPath2));
        }
        cIMObjectPath2 = new CIMReference[arrayList.size()];
        arrayList.toArray((T[])cIMObjectPath2);
        return cIMObjectPath2;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath) throws RemoteException {
        CIMInstance[] cIMInstanceArray;
        this.checkStarted();
        ArrayList<CIMInstance[]> arrayList = new ArrayList<CIMInstance[]>();
        try {
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, this.localOnly, this.deepInheritance, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
            while (enumeration.hasMoreElements()) {
                cIMInstanceArray = (CIMInstance[])enumeration.nextElement();
                arrayList.add(cIMInstanceArray);
            }
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        cIMInstanceArray = new CIMInstance[arrayList.size()];
        arrayList.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string) throws RemoteException {
        CIMInstance[] cIMInstanceArray;
        this.checkStarted();
        ArrayList<CIMInstance[]> arrayList = new ArrayList<CIMInstance[]>();
        try {
            Enumeration enumeration = this.cc.execQuery(cIMObjectPath, string, 0);
            while (enumeration.hasMoreElements()) {
                cIMInstanceArray = (CIMInstance[])enumeration.nextElement();
                arrayList.add(cIMInstanceArray);
            }
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        cIMInstanceArray = new CIMInstance[arrayList.size()];
        arrayList.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMClass getClass(CIMObjectPath cIMObjectPath) throws RemoteException {
        this.checkStarted();
        try {
            return this.cc.getClass(cIMObjectPath, this.localOnly, true, true, null);
        }
        catch (Exception exception) {
            throw new ServiceException("CIM Client Error", exception);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath) throws RemoteException {
        this.checkStarted();
        try {
            CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, this.localOnly, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
            return cIMInstance;
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws RemoteException {
        this.checkStarted();
        try {
            this.cc.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public CIMReference createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws RemoteException {
        this.checkStarted();
        try {
            CIMObjectPath cIMObjectPath2 = this.cc.createInstance(cIMObjectPath, cIMInstance);
            return new CIMReference(cIMObjectPath2);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public CIMValue getProperty(CIMObjectPath cIMObjectPath, String string) throws RemoteException {
        this.checkStarted();
        CIMValue cIMValue = null;
        try {
            cIMValue = this.cc.getProperty(cIMObjectPath, string);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        return cIMValue;
    }

    public void setProperty(CIMObjectPath cIMObjectPath, String string, CIMValue cIMValue) throws RemoteException {
        this.checkStarted();
        try {
            this.cc.setProperty(cIMObjectPath, string, cIMValue);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws RemoteException {
        this.checkStarted();
        CIMValue cIMValue = null;
        try {
            this.cc.invokeMethod(cIMObjectPath, string, vector, vector2);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
        return cIMValue;
    }

    public CIMReference[] referenceNames(CIMObjectPath cIMObjectPath, String string, String string2) throws RemoteException {
        this.checkStarted();
        return new CIMReference[0];
    }

    public ArrayList references(CIMObjectPath cIMObjectPath, String string, String string2) throws RemoteException {
        this.checkStarted();
        try {
            Enumeration enumeration = this.cc.references(cIMObjectPath, string, string2, this.includeQualifiers, this.includeClassOrigin, this.propertyList);
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            return arrayList;
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Client Error", cIMException);
        }
    }

    public String subscribeForIndication(String string, String string2, IndicationListener indicationListener) throws RemoteException {
        this.checkStarted();
        this.initListener();
        return this.listener.subscribe(string2, string, indicationListener);
    }

    public String subscribeForIndication(String string, String string2) throws RemoteException {
        this.checkStarted();
        this.initListener();
        return this.listener.subscribe(string, string2, this.topicListener);
    }

    public void unsubscribeIndication(String string) throws RemoteException {
    }

    private void initListener() throws RemoteException {
        if (this.listener != null) {
            return;
        }
        this.listener = new Listener(this.cc);
        this.topicListener = new TopicListener();
        try {
            this.cc.addCIMListener((CIMListener)this.listener);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Listener Init Failed", cIMException);
        }
    }

    private void stopListener() throws RemoteException {
        if (this.listener == null) {
            return;
        }
        try {
            this.cc.removeCIMListener((CIMListener)this.listener);
        }
        catch (CIMException cIMException) {
            throw new ServiceException("CIM Listener Stop Failed", cIMException);
        }
        this.listener.clean();
        this.listener = null;
    }

    private void checkStarted() throws ServiceException {
        if (!this.started) {
            throw new ServiceException("Bad state. Operation requires MF to be Running");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        eventNum = 0;
    }

    public static class Test
    extends ClassTest {
        String systemClass = "TEST_System";
        CIMObjectPath system;

        protected void init() {
            this.system = new CIMObjectPath(this.systemClass);
            this.system.addKey("Name", new CIMValue((Object)"localhost"));
        }

        public void test() throws Exception {
            CIMClientMFImpl cIMClientMFImpl = new CIMClientMFImpl(this.system, "cimhost", "user", "pass");
            cIMClientMFImpl.getManagedSystem();
            this.assertEquals(this.systemClass, cIMClientMFImpl.getClassName());
            this.assertEquals("localhost", cIMClientMFImpl.getName());
            this.assertEquals("cimhost", cIMClientMFImpl.getManagerName());
            this.assertNotNull(cIMClientMFImpl.getAdmin());
            LocalizedMessage localizedMessage = cIMClientMFImpl.getDescription();
        }

        protected void cleanup() {
            this.system = null;
        }
    }

    class CIMClientUserImpl
    implements CIMClientUser {
        CIMClientUserImpl() {
        }

        public CIMClient getCIMClient() {
            if (!CIMClientMFImpl.this.started) {
                return null;
            }
            return CIMClientMFImpl.this.cc;
        }

        public void finished(CIMClient cIMClient) {
        }
    }

    private class Listener
    implements CIMListener {
        Vector listenList = new Vector();
        CIMObjectPath handler;
        CIMClient cimClient;
        CIMClass cimFilter;
        CIMClass cimClientFilterDelivery;
        CIMClass rmidelivery;

        Listener(CIMClient cIMClient) {
            this.cimClient = cIMClient;
            try {
                this.cimFilter = CIMClientMFImpl.this.cc.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
                this.cimClientFilterDelivery = CIMClientMFImpl.this.cc.getClass(new CIMObjectPath("CIM_IndicationSubscription"), true, true, true, null);
                this.rmidelivery = cIMClient.getClass(new CIMObjectPath("Solaris_RMIDelivery"), false, true, true, null);
                CIMInstance cIMInstance = this.rmidelivery.newInstance();
                cIMInstance.setProperty("name", new CIMValue((Object)"MF_Event_Handler"));
                CIMObjectPath cIMObjectPath = cIMClient.createInstance(new CIMObjectPath(), cIMInstance);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }

        void clean() {
        }

        private String getName() {
            return "Event_" + eventNum;
        }

        String subscribe(String string, String string2, IndicationListener indicationListener) {
            CIMObjectPath cIMObjectPath = null;
            String string3 = null;
            try {
                CIM_IndicationFilter cIM_IndicationFilter = new CIM_IndicationFilter();
                cIM_IndicationFilter.setCreationClassName("CIM_IndicationFilter");
                cIM_IndicationFilter.setName(this.getName());
                cIM_IndicationFilter.setQuery(string);
                cIM_IndicationFilter.setQueryLanguage("WQL");
                cIM_IndicationFilter.setSourceNamespace(null);
                cIM_IndicationFilter.setSystemCreationClassName(CIMClientMFImpl.this.systemInfo.getCreationClassName());
                cIM_IndicationFilter.setSystemName(CIMClientMFImpl.this.systemInfo.getName());
                CIMInstance cIMInstance = this.cimFilter.newInstance();
                cIM_IndicationFilter.writeCIMInstance(cIMInstance);
                cIMObjectPath = CIMClientMFImpl.this.cc.createInstance(new CIMObjectPath(), cIMInstance);
                CIM_IndicationSubscription cIM_IndicationSubscription = new CIM_IndicationSubscription();
                cIM_IndicationSubscription.setFilter(cIMObjectPath);
                cIM_IndicationSubscription.setHandler(this.handler);
                cIM_IndicationSubscription.writeCIMInstance(cIMInstance);
                CIMObjectPath cIMObjectPath2 = CIMClientMFImpl.this.cc.createInstance(new CIMObjectPath(), cIMInstance);
                if (cIMObjectPath2 == null) {
                    cIMObjectPath2 = new CIMObjectPath();
                    cIMObjectPath2.setNameSpace("");
                    cIMObjectPath2.setObjectName(cIMInstance.getClassName());
                    cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
            return string3;
        }

        public void indicationOccured(CIMEvent cIMEvent) {
            CIMInstance cIMInstance = cIMEvent.getIndication();
            String string = cIMEvent.getSubscriptionAlias();
            System.out.println("Got event " + cIMEvent.getIndication());
        }
    }

    private class TopicListener
    implements IndicationListener {
        private TopicListener() {
        }

        public void notify(IndicationEvent indicationEvent) throws RemoteException {
            CIMEvent cIMEvent = indicationEvent.getCIMEvent();
            CIMInstance cIMInstance = cIMEvent.getIndication();
            String string = cIMEvent.getSubscriptionAlias();
        }
    }
}

