/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.mf;

import com.sun.jade.apps.command.DebugCommand;
import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.discovery.BaseServiceFinder;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.topology.lib.Connection;
import com.sun.jade.apps.topology.lib.TopologyHelper;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.view.ViewHelper;
import com.sun.jade.logic.view.ViewItem;
import com.sun.jade.ui.topology.tree.TreeNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Properties;

public class DebugCommands
implements DebugCommand {
    private InstallerService is;
    private String domain;
    private static final String sccs_id = "@(#)DebugCommands.java\t1.22 10/25/02 SMI";

    public String getHelp() {
        return "Print device information.  Argument name=deviceName for verbose output.";
    }

    public int execute(Properties properties, PrintWriter printWriter) throws IOException {
        try {
            this.init();
            String string = InstallerServiceFinder.getCurrentDomain();
            InstallerService installerService = InstallerServiceFinder.getInstallerService(string);
            MF[] mFArray = installerService.getInstalledSystems();
            String string2 = properties.getProperty("name");
            if (string2 != null) {
                int n = 0;
                while (n < mFArray.length) {
                    if (string2.equals(mFArray[n].getName())) {
                        this.info(mFArray[n], printWriter);
                    }
                    ++n;
                }
            } else {
                printWriter.println("Number of Installed devices = " + mFArray.length);
                printWriter.println("<UL>");
                int n = 0;
                while (n < mFArray.length) {
                    String string3 = mFArray[n].getName();
                    String string4 = mFArray[n].getClassName();
                    printWriter.print("<LI><A HREF=\"/jade/debug/device?name=");
                    printWriter.print(string3);
                    printWriter.print("\">");
                    printWriter.println(string4 + "." + string3);
                    ++n;
                }
                printWriter.println("</UL>");
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            return 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void info(MF var1_1, PrintWriter var2_2) throws Exception {
        var3_3 = (TopologyHelper)var1_1.getServiceHelper("com.sun.jade.apps.topology.lib.TopologyHelper");
        var4_4 = (ViewHelper)var1_1.getServiceHelper("com.sun.jade.logic.view.ViewHelper");
        var5_5 = (DiagnosableHelper)var1_1.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
        var6_6 = null;
        if (var5_5 != null) {
            var6_6 = var5_5.getDiagnosticTests();
        }
        var2_2.println("Device " + var1_1.getClassName() + "." + var1_1.getName() + "<UL>");
        var7_7 = var1_1.getCaption();
        if (var7_7 != null) {
            var2_2.println("<LI>Caption=" + var7_7.getLocalizedMessage() + "\n");
        }
        if ((var7_7 = var1_1.getDescription()) != null) {
            var2_2.println("<LI>Description=" + var7_7.getLocalizedMessage() + "\n");
        }
        var8_8 = new ReferenceForMSE(var1_1.getClassName(), var1_1.getName());
        if (var3_3 == null) {
            var2_2.println("<LI>No topology found.");
            var2_2.println("</UL>");
            return;
        }
        this.assetView(var4_4, var8_8, var2_2);
        this.healthView(var4_4, var8_8, var2_2);
        if (var5_5 != null) {
            var2_2.println("<LI>Diagnostic (" + var6_6.length + " Tests)\n");
            this.printTestInfo(var6_6, var8_8, var2_2);
        }
        if ((var9_9 = var3_3.getConnections()) != null) {
            var2_2.println("<LI>External Topology <UL>");
            while (var9_9.hasNext()) {
                var10_10 = (Connection)var9_9.next();
                var2_2.print("<LI>");
                var2_2.print(var10_10.getMSE().toString());
                var2_2.print(" ");
                var2_2.print(var10_10.getType());
                var2_2.print(" ");
                var2_2.print(var10_10.getInId());
                var2_2.print(" -> ");
                var2_2.println(var10_10.getOutId());
            }
            var2_2.println("</UL>");
        }
        if ((var10_10 = var3_3.getTree()) == null) {
            var2_2.println("</UL>");
            return;
        }
        var11_11 = var10_10.getRoots();
        if (var11_11 != null) ** GOTO lbl63
        var2_2.println("</UL>");
        return;
lbl-1000:
        // 1 sources

        {
            var12_12 = (TreeNode)var11_11.next();
            if (var12_12 == null) continue;
            var13_13 = (ReferenceForMSE)var12_12.getUserObject();
            var2_2.println("<LI>" + var13_13.toString() + "<UL>");
            this.assetView(var4_4, var13_13, var2_2);
            this.healthView(var4_4, var13_13, var2_2);
            this.printTestInfo(var6_6, var13_13, var2_2);
            var2_2.println("</UL>");
            var14_14 = var12_12.getChildren();
            if (var14_14 == null) continue;
            while (var14_14.hasNext()) {
                var15_15 = (TreeNode)var14_14.next();
                var16_16 = (ReferenceForMSE)var15_15.getUserObject();
                var2_2.println("<LI>" + var16_16.toString() + "<UL>");
                this.assetView(var4_4, var16_16, var2_2);
                this.healthView(var4_4, var16_16, var2_2);
                this.printTestInfo(var6_6, var16_16, var2_2);
                var2_2.println("</UL>");
            }
lbl63:
            // 4 sources

            ** while (var11_11.hasNext())
        }
lbl64:
        // 1 sources

        var2_2.println("</UL>");
    }

    private void printTestInfo(DiagnosticTestInfo[] diagnosticTestInfoArray, ReferenceForMSE referenceForMSE, PrintWriter printWriter) {
        if (diagnosticTestInfoArray == null) {
            return;
        }
        int n = 0;
        while (n < diagnosticTestInfoArray.length) {
            ReferenceForMSE referenceForMSE2 = new ReferenceForMSE(diagnosticTestInfoArray[n].getMSE());
            String string = referenceForMSE2.getCreationClassName();
            String string2 = referenceForMSE2.getKeyValue();
            if (referenceForMSE.getCreationClassName().equalsIgnoreCase(string) && referenceForMSE.getKeyValue().equals(string2)) {
                printWriter.println("<LI>Diagnostic Test = " + diagnosticTestInfoArray[n].getTestName() + "<UL>");
                printWriter.println("<LI>System = " + referenceForMSE2.getSystemName());
                printWriter.println("<LI>MSE = " + referenceForMSE2.getKeyValue());
                printWriter.println("</UL>");
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testService(StringBuffer var1_1) throws Exception {
        this.init();
        var2_2 = InstallerServiceFinder.getCurrentDomain();
        var3_3 = InstallerServiceFinder.getInstallerService(var2_2);
        var4_4 = var3_3.getInstalledSystems();
        var5_5 = BaseServiceFinder.getDiagnosticTestService();
        if (var5_5 == null) {
            var1_1.append("No test service installed.");
            return;
        }
        var1_1.append("getServiceName=" + var5_5.getServiceName() + "\n");
        var6_6 = 0;
        while (var6_6 < var4_4.length) {
            block8: {
                block7: {
                    var7_7 = var4_4[var6_6];
                    var1_1.append("Class=" + var7_7.getClassName() + "\n");
                    var1_1.append("Name=" + var7_7.getName() + "\n");
                    var8_8 = (TopologyHelper)var7_7.getServiceHelper("com.sun.jade.apps.topology.lib.TopologyHelper");
                    var9_9 = var5_5.getTestsForMF(var7_7);
                    if (var9_9 != null && var9_9.length > 0) {
                        var10_10 = 0;
                        while (var10_10 < var9_9.length) {
                            var1_1.append("\tDiagnostic Test = " + var9_9[var10_10].getTestName());
                            var11_12 = new ReferenceForMSE(var9_9[var10_10].getMSE());
                            var1_1.append("\n\t           System=" + var11_12.getSystemName() + " MSE=" + var11_12.getKeyValue() + "\n");
                            ++var10_10;
                        }
                    } else {
                        var1_1.append("No device tests");
                    }
                    if (var8_8 == null) break block7;
                    var10_11 = var8_8.getTree();
                    if (var10_11 != null && (var11_12 = var10_11.getRoots()) != null) ** GOTO lbl51
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        var12_13 = (TreeNode)var11_12.next();
                        if (var12_13 == null || (var9_9 = var5_5.getMseTestsForMF(var7_7, var13_14 = (ReferenceForMSE)var12_13.getUserObject())) == null || var9_9.length <= 0) continue;
                        var1_1.append(var13_14.toString() + "\n");
                        var14_15 = 0;
                        while (var14_15 < var9_9.length) {
                            var1_1.append("\tDiagnostic Test = " + var9_9[var14_15].getTestName());
                            var15_16 = new ReferenceForMSE(var9_9[var14_15].getMSE());
                            var1_1.append("\n\t           System=" + var15_16.getSystemName() + " MSE=" + var15_16.getKeyValue() + "\n");
                            ++var14_15;
                        }
lbl51:
                        // 3 sources

                        ** while (var11_12.hasNext())
                    }
                }
                var1_1.append("\n");
            }
            ++var6_6;
        }
    }

    private void assetView(ViewHelper viewHelper, ReferenceForMSE referenceForMSE, PrintWriter printWriter) throws Exception {
        ViewItem[] viewItemArray = viewHelper.getAssetView(Locale.getDefault(), referenceForMSE);
        if (viewItemArray != null && viewItemArray.length > 0) {
            printWriter.println("<LI>Asset View <UL>");
            int n = 0;
            while (n < viewItemArray.length) {
                printWriter.println("<LI>" + viewItemArray[n].getName() + " = " + viewItemArray[n].getValue());
                ++n;
            }
            printWriter.println("</UL>");
        }
    }

    private void healthView(ViewHelper viewHelper, ReferenceForMSE referenceForMSE, PrintWriter printWriter) throws Exception {
        ViewItem[] viewItemArray = viewHelper.getHealthView(Locale.getDefault(), referenceForMSE);
        if (viewItemArray != null && viewItemArray.length > 0) {
            printWriter.println("<LI>Health View <UL>");
            int n = 0;
            while (n < viewItemArray.length) {
                printWriter.println("<LI>" + viewItemArray[n].getName() + " = " + viewItemArray[n].getValue());
                ++n;
            }
            printWriter.println("</UL>");
        }
    }

    private void init() {
        if (this.domain == null) {
            this.domain = InstallerServiceFinder.getCurrentDomain();
        }
        if (this.is == null) {
            this.is = InstallerServiceFinder.getInstallerService(this.domain);
        }
    }
}

