/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.health;

import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.cim.bean.CIM_FRU;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.device.util.BeanHandler;
import com.sun.jade.device.util.DeviceStore;
import com.sun.jade.logic.health.HealthEvent;
import com.sun.jade.logic.health.HealthMonitor;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class HealthHandler
implements BeanHandler {
    private CIMBeanPersistence persistence;
    private HealthMonitor monitor;
    private DeviceStore store;
    private boolean indb;
    private boolean baseline = true;
    private MF device;
    private LinkedList fruAdditionList;
    public static final String sccs_id = "@(#)HealthHandler.java\t1.10 01/30/03 SMI";

    public HealthHandler(HealthMonitor healthMonitor) {
        this.monitor = healthMonitor;
        this.device = this.monitor.getDevice();
        this.persistence = this.monitor.initPersistence();
        try {
            String string = this.device.getClassName();
            String string2 = this.device.getName();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            cIMObjectPath.addKey("Name", new CIMValue((Object)string2));
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)string));
            CIMBean cIMBean = CIMBeanUtil.createBean(cIMObjectPath);
            try {
                CIMBean cIMBean2 = this.persistence.retrieveBean(cIMBean);
                if (cIMBean2 != null) {
                    this.baseline = false;
                }
            }
            catch (ConnectionException connectionException) {
                Report.error.log(connectionException, (Object)"Persistence connection error.");
            }
            catch (NoDataFoundException noDataFoundException) {}
        }
        catch (RemoteException remoteException) {
            Report.error.log(remoteException, (Object)"RMI error.");
        }
    }

    public void start() {
        this.persistence = this.monitor.initPersistence();
        if (this.device instanceof AbstractMF) {
            this.store = ((AbstractMF)this.device).getDeviceStore();
        }
    }

    public void handleBean(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
        if (this.persistence == null) {
            return;
        }
        if (cIMBeanBase2 == null) {
            return;
        }
        if (StoradeEnvironment.getState() == 2) {
            return;
        }
        try {
            CIMBean cIMBean = null;
            if (this.indb && this.store != null && this.store.isParsed()) {
                cIMBean = this.store.find(cIMBeanBase2);
            }
            if (cIMBean == null) {
                try {
                    cIMBean = this.persistence.retrieveBean(cIMBeanBase2);
                }
                catch (Exception exception) {
                    cIMBean = null;
                }
            }
            if (cIMBean == null) {
                if (!this.baseline) {
                    new HealthEvent(this.device, cIMBeanBase2).generateDefinitionEvent();
                    if (cIMBeanBase2 instanceof CIM_FRU) {
                        this.addFRU((CIM_FRU)cIMBeanBase2);
                    }
                }
                this.monitor.evalFilters(cIMBean, cIMBeanBase2);
                this.persistence.storeCIMBean(cIMBeanBase2);
                if (cIMBeanBase3 != null) {
                    this.persistence.storeCIMBean(cIMBeanBase3);
                }
            } else if (!CIMBeanUtil.deepEquals(cIMBean, cIMBeanBase2)) {
                this.monitor.evalFilters(cIMBean, cIMBeanBase2);
                this.persistence.storeCIMBean(cIMBeanBase2);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)this.healthError(cIMBeanBase2, "Persistence Error"));
        }
        catch (Throwable throwable) {
            Report.error.log(throwable, (Object)this.healthError(cIMBeanBase2, "Error Persisting CIMBean."));
        }
    }

    public void end() {
        if (this.indb && !this.baseline) {
            this.deleteOldBeans();
            this.handleAddedFrus();
        }
        this.baseline = false;
        this.indb = true;
    }

    private String healthError(CIMBean cIMBean, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Health Handler:");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append("Device ");
            stringBuffer.append(this.device.getClassName());
            stringBuffer.append(":");
            stringBuffer.append(this.device.getName());
            stringBuffer.append("Bean:\n");
            stringBuffer.append(cIMBean.toBeanXML());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private void addFRU(CIM_FRU cIM_FRU) {
        if (this.fruAdditionList == null) {
            this.fruAdditionList = new LinkedList();
        }
        this.fruAdditionList.add(cIM_FRU);
    }

    private void handleAddedFrus() {
        if (this.fruAdditionList == null) {
            return;
        }
        Iterator iterator = this.fruAdditionList.iterator();
        while (iterator.hasNext()) {
            CIM_FRU cIM_FRU = (CIM_FRU)iterator.next();
            new HealthEvent(this.device, (CIMBean)cIM_FRU).generateFRUAdditionEvent(cIM_FRU);
        }
        this.fruAdditionList = null;
    }

    private void deleteOldBeans() {
        CIMBean cIMBean;
        if (this.store == null) {
            return;
        }
        if (!this.store.isParsed()) {
            return;
        }
        Collection collection = this.store.getUnusedBeans();
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            cIMBean = (CIMBean)iterator.next();
            if (!(cIMBean instanceof CIM_FRU)) continue;
            try {
                new HealthEvent(this.device, cIMBean).generateFRURemovalEvent((CIM_FRU)cIMBean);
            }
            catch (Throwable throwable) {
                Report.error.log(throwable, (Object)"Generate FRU removal event.");
            }
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            cIMBean = (CIMBean)iterator.next();
            try {
                new HealthEvent(this.device, cIMBean).generateDeletionEvent();
                this.persistence.removeBean(cIMBean);
                Report.debug.log("Remove bean:" + cIMBean);
            }
            catch (ConnectionException connectionException) {
                Report.error.log(connectionException, (Object)this.healthError(cIMBean, "Persistence Error."));
            }
            catch (NoDataFoundException noDataFoundException) {
                Report.debug.log(this.healthError(cIMBean, "Old bean not in database, can't delete."));
            }
        }
    }
}

