/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.health;

import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.CIM_FRU;
import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.bean.CIM_PhysicalElement;
import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.logic.health.HealthMonitor;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.message.MessageCode;
import com.sun.jade.message.MessageSeverity;
import com.sun.jade.util.ValueMap;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMObjectPath;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

final class HealthEvent {
    private MF mf;
    private CIMBean obean;
    private CIMBean cbean;
    private ArrayList list = new ArrayList();
    private static String TAG = "HealthEvent";
    public static final String sccs_id = "@(#)HealthEvent.java\t1.13 01/30/03 SMI";

    HealthEvent(MF mF, CIMBean cIMBean, CIMBean cIMBean2) {
        this.mf = mF;
        this.obean = cIMBean;
        this.cbean = cIMBean2;
    }

    HealthEvent(MF mF, CIMBean cIMBean) {
        this.mf = mF;
        this.cbean = cIMBean;
        this.obean = cIMBean;
    }

    void createMsgCodeEvent(Properties properties) {
        String string;
        Object object;
        Serializable serializable;
        Object object2;
        String string2;
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("createMsgCodeEvent");
        }
        String string3 = "";
        String string4 = "";
        try {
            string4 = this.mf.getName();
            string3 = this.mf.getClassName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String string5 = properties.getProperty(HealthMonitor.MSG_CODE_KEY);
        String string6 = properties.getProperty(HealthMonitor.MSG_CODE_ARGS);
        CIMObjectPath cIMObjectPath = this.cbean.getCIMObjectPath();
        Object[] objectArray = null;
        int n = 0;
        String string7 = "UNKNOWN";
        String string8 = properties.getProperty("type");
        String string9 = properties.getProperty("topic");
        String string10 = cIMObjectPath.toString();
        if (string9 == null) {
            Report.error.log("Topic is undefined for code " + string5);
            return;
        }
        if (string8 == null) {
            string8 = "StateChange";
        }
        if ((string2 = properties.getProperty("severity")) != null) {
            try {
                object2 = new MessageSeverity(string2);
                n = ((ValueMap)object2).getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Report.error.log(illegalArgumentException, (Object)("Illegal severity " + string2));
            }
        }
        object2 = EventConstants.SOURCE_PREFIX + string4 + "/" + string3;
        MessageCode messageCode = new MessageCode(string5);
        if (string6 != null) {
            serializable = new ArrayList();
            object = new StringTokenizer(string6, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string11;
                string = string11 = ((StringTokenizer)object).nextToken();
                int n2 = string11.indexOf(".");
                if (n2 > 0) {
                    string = string11.substring(n2 + 1);
                }
                ((ArrayList)serializable).add(CIMBeanUtil.getAttributeValue(this.cbean, string));
            }
            objectArray = new Object[((ArrayList)serializable).size()];
            int n3 = 0;
            while (n3 < ((ArrayList)serializable).size()) {
                objectArray[n3] = ((ArrayList)serializable).get(n3);
                ++n3;
            }
        }
        Serializable serializable2 = serializable = objectArray == null ? messageCode.getLocalizedStringMessage() : messageCode.getLocalizedStringMessage(objectArray);
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log(((LocalizedString)serializable).getLocalizedMessage());
        }
        if (string8.endsWith("Alert")) {
            LocalizedString[] localizedStringArray;
            LocalizedString[] localizedStringArray2;
            object = messageCode.getLocalizedStringProperty("probableCause");
            LocalizedString localizedString = messageCode.getLocalizedStringProperty("recommendedAction");
            string = properties.getProperty("url");
            if (object == null) {
                localizedStringArray2 = null;
            } else {
                LocalizedString[] localizedStringArray3 = new LocalizedString[1];
                localizedStringArray2 = localizedStringArray3;
                localizedStringArray3[0] = object;
            }
            LocalizedString[] localizedStringArray4 = localizedStringArray2;
            if (localizedString == null) {
                localizedStringArray = null;
            } else {
                LocalizedString[] localizedStringArray5 = new LocalizedString[1];
                localizedStringArray = localizedStringArray5;
                localizedStringArray5[0] = localizedString;
            }
            LocalizedString[] localizedStringArray6 = localizedStringArray;
            AlertEventData.CauseInformation[] causeInformationArray = new AlertEventData.CauseInformation[]{new AlertEventData.CauseInformation(localizedStringArray4, localizedStringArray6, string)};
            AlertEventData alertEventData = new AlertEventData(n, (String)object2, string10, string9, string8, null, (LocalizedString)serializable, "other", causeInformationArray);
            alertEventData.setEventCode(string5);
            String string12 = EventGenerator.createEventID();
            alertEventData.setEventID(string12);
            this.setEnclosureIP(alertEventData);
            this.list.add(alertEventData);
            if (Report.debug.isEnabled(TAG)) {
                Report.debug.log("Generating alert event " + alertEventData.getType() + " on topic " + alertEventData.getTopic());
            }
        } else {
            object = new ModificationEventData(n, (String)object2, string10, string9, string8, null, (LocalizedString)serializable, "device", this.obean, this.cbean);
            this.setEnclosureIP((EventData)object);
            ((EventData)object).setEventCode(string5);
            String string13 = EventGenerator.createEventID();
            ((EventData)object).setEventID(string13);
            this.list.add(object);
            if (Report.debug.isEnabled(TAG)) {
                Report.debug.log("Generating modification event " + ((EventData)object).getType() + " on topic " + ((EventData)object).getTopic());
            }
        }
    }

    void generateEvents() {
        Object object;
        EventData eventData;
        if (this.list.size() == 0) {
            return;
        }
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("Generating " + this.list.size() + " number of events.");
        }
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Object object2;
            eventData = (EventData)iterator.next();
            if (!(eventData instanceof AlertEventData)) continue;
            object = new ArrayList();
            Iterator iterator2 = this.list.iterator();
            while (iterator2.hasNext()) {
                object2 = (EventData)iterator2.next();
                if (object2 instanceof AlertEventData) continue;
                ((ArrayList)object).add(((EventData)object2).getEventID());
            }
            object2 = new String[((ArrayList)object).size()];
            ((ArrayList)object).toArray((T[])object2);
            eventData.setCorrelatedEvents((String[])object2);
        }
        iterator = this.list.iterator();
        while (iterator.hasNext()) {
            eventData = (EventData)iterator.next();
            if (!(eventData instanceof AlertEventData)) continue;
            object = (AlertEventData)eventData;
            this.clearAlert((AlertEventData)object);
        }
        iterator = this.list.iterator();
        while (iterator.hasNext()) {
            eventData = (EventData)iterator.next();
            EventGenerator.generateEvent(eventData);
        }
    }

    private void clearAlert(AlertEventData alertEventData) {
        String string = alertEventData.getTopic();
        String string2 = alertEventData.getType();
        String[] stringArray = alertEventData.getCorrelatedEvents();
        if (string.startsWith("alert.clear", 1)) {
            Object object;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (this.cbean instanceof CIM_LogicalDevice) {
                object = (CIM_LogicalDevice)this.cbean;
                string3 = object.getSystemCreationClassName();
                string4 = object.getSystemName();
                string5 = object.getDeviceID();
            } else if (this.cbean instanceof CIM_System) {
                object = (CIM_System)this.cbean;
                string3 = object.getCreationClassName();
                string4 = object.getName();
            }
            if (Report.debug.isEnabled(TAG)) {
                Report.debug.log("Clear alarm for " + string3 + ":" + string4 + ":" + string5);
            }
            try {
                object = PersistenceService.getService();
                GenericPersistence genericPersistence = ((PersistenceService)object).getGenericPersistence();
                Object object2 = string5 != null ? genericPersistence.retrieveLastEventBySystemDevice(string3, string4, string5, -1, 2, 3) : genericPersistence.retrieveLastEventBySystemName(string3, string4, -1, 2, 3);
                if (Report.debug.isEnabled(TAG)) {
                    Report.debug.log("Got last alarm=" + object2);
                }
                if (object2 instanceof Alarm) {
                    NSMEvent nSMEvent;
                    Alarm alarm = (Alarm)object2;
                    alarm.setIsCleared(true);
                    alarm.setClearTime(System.currentTimeMillis());
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            alarm.addCorrelatedEvent(stringArray[n]);
                            ++n;
                        }
                    }
                    if ((nSMEvent = alarm.getEvent()) != null) {
                        alertEventData.addCorrelatedEvent(nSMEvent.getEventID());
                    }
                    genericPersistence.updateAlarm(alarm);
                }
            }
            catch (ConnectionException connectionException) {
                Report.error.log(connectionException, (Object)"Unable to clear the alarm");
            }
        }
    }

    void generateDefinitionEvent() {
        String string = "";
        String string2 = "";
        try {
            string2 = this.mf.getName();
            string = this.mf.getClassName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int n = 0;
        String string3 = EventConstants.SOURCE_PREFIX + string + "/" + string2;
        CIMObjectPath cIMObjectPath = this.cbean.getCIMObjectPath();
        String string4 = cIMObjectPath.toString();
        String string5 = ".private.indication.create." + this.getTypeModel();
        DefinitionEventData definitionEventData = new DefinitionEventData(n, string3, string4, string5, "definition", "device", new CIMBean[]{this.cbean});
        this.setEnclosureIP(definitionEventData);
        definitionEventData.setDescription(new LocalizedString("internal intrinsic event."));
        EventGenerator.generateEvent(definitionEventData);
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("Create Definition Event: topic=" + string5 + " source=" + string3 + " bean=" + this.cbean.toBeanXML());
        }
    }

    void generateDeletionEvent() {
        String string = "CIM_System";
        String string2 = "null";
        try {
            string2 = this.mf.getName();
            string = this.mf.getClassName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int n = 0;
        String string3 = EventConstants.SOURCE_PREFIX + string + "/" + string2;
        CIMObjectPath cIMObjectPath = this.obean.getCIMObjectPath();
        String string4 = cIMObjectPath.toString();
        String string5 = ".private.indication.delete." + this.getTypeModel();
        DeletionEventData deletionEventData = new DeletionEventData(n, string3, string4, string5, "definition", "device", new CIMBean[]{this.obean});
        this.setEnclosureIP(deletionEventData);
        deletionEventData.setDescription(new LocalizedString("internal intrinsic event."));
        EventGenerator.generateEvent(deletionEventData);
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("Create Deletion Event: topic=" + string5 + " source=" + string3 + " bean=" + this.obean.toBeanXML());
        }
    }

    private String getTypeModel() {
        String string = "";
        String string2 = "";
        String string3 = "generic";
        String string4 = "generic";
        try {
            string2 = this.mf.getName();
            string = this.mf.getClassName();
            Properties properties = this.mf.getProperties();
            String string5 = properties.getProperty("type");
            Properties properties2 = DevInfo.getDeviceProperties(string5);
            string3 = properties2.getProperty("RESOURCE_TYPE");
            string4 = properties2.getProperty("RESOURCE_MODEL");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return string3 + "." + string4;
    }

    private void setEnclosureIP(EventData eventData) {
        try {
            Properties properties = this.mf.getProperties();
            eventData.setSubjectEnclosureIP(properties.getProperty("ipno"));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private String getFRUTopic(CIM_FRU cIM_FRU, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".");
        stringBuffer.append("definition");
        stringBuffer.append(".");
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append("fru");
        stringBuffer.append(".");
        stringBuffer.append(this.getTypeModel());
        return stringBuffer.toString();
    }

    public void generateFRURemovalEvent(CIM_FRU cIM_FRU) {
        int n = 2;
        String string = this.getSource();
        String string2 = this.getFRUTopic(cIM_FRU, "delete");
        String string3 = "FruRemoval";
        String string4 = null;
        CIMBean[] cIMBeanArray = this.getFRUBeans(cIM_FRU);
        String string5 = this.getSubjectFromArray(cIMBeanArray);
        if (string5 == null) {
            string5 = cIM_FRU.getCIMObjectPath().toString();
        }
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("Create FRU Removal Event: topic=" + string2 + " source=" + string + " bean=" + cIMBeanArray[0].toBeanXML());
        }
        DefinitionEventData definitionEventData = new DefinitionEventData(n, string, string5, string2, string3, string4, cIMBeanArray);
        this.setEnclosureIP(definitionEventData);
        MessageCode messageCode = new MessageCode("app.sade3.health.event", 2);
        definitionEventData.setDescription(messageCode.getLocalizedStringMessage());
        EventGenerator.generateEvent(definitionEventData);
    }

    public void generateFRUAdditionEvent(CIM_FRU cIM_FRU) {
        int n = 2;
        String string = this.getSource();
        String string2 = this.getFRUTopic(cIM_FRU, "create");
        String string3 = "FruAddition";
        String string4 = null;
        CIMBean[] cIMBeanArray = this.getFRUBeans(cIM_FRU);
        String string5 = this.getSubjectFromArray(cIMBeanArray);
        if (string5 == null) {
            string5 = cIM_FRU.getCIMObjectPath().toString();
        }
        if (Report.debug.isEnabled(TAG)) {
            Report.debug.log("Create FRU Addition Event: topic=" + string2 + " source=" + string + " bean=" + cIMBeanArray[0].toBeanXML());
        }
        DefinitionEventData definitionEventData = new DefinitionEventData(n, string, string5, string2, string3, string4, cIMBeanArray);
        this.setEnclosureIP(definitionEventData);
        MessageCode messageCode = new MessageCode("app.sade3.health.event", 1);
        definitionEventData.setDescription(messageCode.getLocalizedStringMessage());
        EventGenerator.generateEvent(definitionEventData);
    }

    private CIMBean[] getFRUBeans(CIM_FRU cIM_FRU) {
        try {
            CIMBean[] cIMBeanArray;
            CIMBeanPersistence cIMBeanPersistence = PersistenceService.getService().getCIMBeanPersistence();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            Collection collection = cIMBeanPersistence.retrieveBeans((CIMBean)cIM_FRU);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                cIMBeanArray = (CIMBean[])iterator.next();
                if (cIMBeanArray instanceof CIM_PhysicalElement) {
                    Collection collection2 = cIMBeanPersistence.retrieveBeans((CIMBean)cIMBeanArray);
                    Iterator iterator2 = collection2.iterator();
                    while (iterator2.hasNext()) {
                        CIMBean cIMBean = (CIMBean)iterator2.next();
                        if (cIMBean instanceof CIM_LogicalDevice) {
                            linkedList.addFirst(cIMBean);
                            Collection collection3 = cIMBeanPersistence.retrieveBeans(cIMBean);
                            Iterator iterator3 = collection2.iterator();
                            while (iterator3.hasNext()) {
                                linkedList.add(iterator3.next());
                            }
                            continue;
                        }
                        linkedList.add(cIMBean);
                    }
                    continue;
                }
                linkedList.add(cIMBeanArray);
            }
            if (linkedList.size() > 0) {
                cIMBeanArray = new CIMBean[linkedList.size()];
                iterator = linkedList.iterator();
                int n = 0;
                while (n < linkedList.size()) {
                    cIMBeanArray[n] = (CIMBean)iterator.next();
                    ++n;
                }
                return cIMBeanArray;
            }
            Report.debug.log("No associated beans found for FRU:" + cIM_FRU.toBeanXML());
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Getting beans for FRU");
        }
        return new CIMBean[]{cIM_FRU};
    }

    private String getSource() {
        return EventConstants.SOURCE_PREFIX + "Health";
    }

    private String getSubjectFromArray(CIMBean[] cIMBeanArray) {
        String string = null;
        if (cIMBeanArray != null) {
            int n = 0;
            while (n < cIMBeanArray.length) {
                if (cIMBeanArray[n] instanceof CIM_LogicalDevice) {
                    string = cIMBeanArray[n].getCIMObjectPath().toString();
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    public static class Test
    extends UnitTest {
        public void test() {
            MessageCode messageCode = new MessageCode("app.sade3.general.test", 1);
            Object[] objectArray = new Object[]{new Integer(8), new Integer(99)};
            LocalizedString localizedString = messageCode.getLocalizedStringMessage(objectArray);
            System.out.println(localizedString.toString());
            System.out.println(localizedString.getLocalizedMessage());
        }
    }
}

