/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event.generator;

import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.util.ItemImpl;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.topology.TopologyBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

class GeneratorHelper {
    static final String resource = "com.sun.jade.ui.resources.Internal";
    private static final String TOPIC = "Topic";
    private static final String DATE = "Date";
    private static final String SEVERITY = "Severity";
    private static final String DESCRIPTION = "Description";
    private static final String DEVICE = "Device";
    private static final String DEVICE_TYPE = "Device Type";
    private static final String FRU = "FRU";
    private static final String FRU_TYPE = "FRU Type";
    private static final String DEVICE_2 = "Device 2";
    private static final String DEVICE_TYPE_2 = "Device Type 2";
    private static final String FRU_2 = "FRU 2";
    private static final String FRU_TYPE_2 = "FRU Type 2";
    static HashMap deviceTypes = new HashMap();
    static HashMap fruTypes = new HashMap();

    GeneratorHelper() {
    }

    static String getTopicTitle(Localizer localizer) {
        return localizer.getString("topic", TOPIC);
    }

    static String getDateTitle(Localizer localizer) {
        return localizer.getString("date", DATE);
    }

    static String getSeverityTitle(Localizer localizer) {
        return localizer.getString("severity", SEVERITY);
    }

    static String getDescriptionTitle(Localizer localizer) {
        return localizer.getString("description", DESCRIPTION);
    }

    static String getDeviceTitle(Localizer localizer) {
        return localizer.getString("device", DEVICE);
    }

    static String getDeviceTypeTitle(Localizer localizer) {
        return localizer.getString("deviceType", DEVICE_TYPE);
    }

    static String getFruTitle(Localizer localizer) {
        return localizer.getString("fru", FRU);
    }

    static String getFruTypeTitle(Localizer localizer) {
        return localizer.getString("fruType", FRU_TYPE);
    }

    static String getDevice2Title(Localizer localizer) {
        return localizer.getString("device2", DEVICE_2);
    }

    static String getDeviceType2Title(Localizer localizer) {
        return localizer.getString("deviceType2", DEVICE_2);
    }

    static String getFru2Title(Localizer localizer) {
        return localizer.getString("fru2", FRU_2);
    }

    static String getFruType2Title(Localizer localizer) {
        return localizer.getString("fruType2", FRU_TYPE_2);
    }

    static final String getLocalizedDeviceType(String string) {
        String string2 = string;
        String string3 = (String)deviceTypes.get(string);
        if (string3 != null) {
            string2 = string3;
        } else if (string != null) {
            try {
                Properties properties = DevInfo.getDevicePropertiesByClassName(string);
                String string4 = properties.getProperty("CAPTION");
                if (string4 != null) {
                    string2 = string4;
                }
                deviceTypes.put(string, string2);
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Cannot access property file for device");
            }
        }
        return string2;
    }

    static final String getFRUType(String string) {
        String string2 = string;
        String string3 = (String)fruTypes.get(string);
        if (string3 != null) {
            string2 = string3;
        } else {
            String string4 = ReferenceForMSE.getLocalizedCreationClassName(string);
            if (string4 != null && !"".equals(string4)) {
                string2 = string4;
            }
            fruTypes.put(string, string2);
        }
        return string2;
    }

    static final String getElement(String string, String string2) {
        String string3 = null;
        String string4 = "." + string2;
        String string5 = "," + string2;
        int n = string.indexOf(string4);
        int n2 = string4.length();
        if (n == -1) {
            n = string.indexOf(string5);
            n2 = string5.length();
        }
        if (n != -1) {
            String string6 = string.substring(n + n2);
            if (string6.startsWith("\\\\\\\"")) {
                string6 = string6.substring(4);
            } else if (string6.startsWith("\\\"")) {
                string6 = string6.substring(2);
            } else if (string6.startsWith("\"")) {
                string6 = string6.substring(1);
            }
            int n3 = string6.indexOf(34);
            if (n3 != -1) {
                string3 = string6.substring(0, n3);
                int n4 = string3.indexOf("\\");
                if (n4 != -1) {
                    string3 = string3.substring(0, n4);
                }
                if (string3.endsWith("\\")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            }
        }
        return string3;
    }

    static final String getDevice(String string, Locale locale) {
        Object var2_2 = null;
        String string2 = null;
        String string3 = com.sun.jade.ui.util.Properties.getDomain();
        TopologyBean topologyBean = TopologyBean.get(string3, locale);
        TopologyNode topologyNode = topologyBean.getNodeByDeviceName(string, null);
        try {
            if (topologyNode != null && topologyNode.getOID() != null && topologyNode.getMF() != null) {
                string2 = topologyNode.getMF().getCaption().getLocalizedMessage(locale);
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot generate logicalName");
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    static final String[] getDeviceLink(String string, Locale locale) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = com.sun.jade.ui.util.Properties.getDomain();
        TopologyBean topologyBean = TopologyBean.get(string5, locale);
        TopologyNode topologyNode = topologyBean.getNodeByDeviceName(string, null);
        try {
            if (topologyNode != null && topologyNode.getOID() != null && topologyNode.getMF() != null) {
                string2 = topologyNode.getOID().toString();
                string3 = topologyNode.getMF().getCaption().getLocalizedMessage(locale);
                string4 = "<a href=\"asset.jsp?mode=Device&OID=" + string2 + "\">" + string3 + "</a>";
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot generate logicalName");
        }
        String[] stringArray = new String[2];
        if (string4 != null) {
            stringArray[0] = string2;
            stringArray[1] = string4;
        } else {
            stringArray[0] = string2;
            stringArray[1] = string;
        }
        return stringArray;
    }

    static String getProperty(ArrayList arrayList, String string) {
        int n = 0;
        while (n < arrayList.size()) {
            ItemImpl itemImpl = (ItemImpl)arrayList.get(n);
            if (string.equals(itemImpl.getName())) {
                return itemImpl.getValue().toString();
            }
            ++n;
        }
        return null;
    }
}

