/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event.generator;

import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.EventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.event.generator.PropertiesGenerator;
import com.sun.jade.util.ItemImpl;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class EventHelper {
    private static final String appResource = "com.sun.jade.ui.resources.ApplicationResources";
    private static final String variableResource = "com.sun.jade.ui.resources.Internal";
    private static final String generatorResource = "com.sun.jade.event.resources.PropertiesGenerators";
    private static final String topicResource = "com.sun.jade.event.resources.Topics";
    private static final String CORRELATED_ALARM_KEY = "correlatedAlarm";
    private static final String CORRELATED_EVENT_KEY = "correlatedEvent";
    private static final String DESCRIPTION_KEY = "description";
    private static final String PROBABLE_CAUSE_KEY = "probableCause";
    private static final String RECOMMENDED_ACTION_KEY = "recommendedAction";
    private static final String CORRELATED_ALARM = "Correlated Alarm";
    private static final String CORRELATED_EVENT = "Correlated Event";
    private static final String DESCRIPTION = "Description";
    private static final String PROBABLE_CAUSE = "Probable Cause";
    private static final String RECOMMENDED_ACTION = "Recommended Action";
    private static HashMap generators = new HashMap();
    private static HashMap correlatedAlarmNames = new HashMap(1);
    private static HashMap correlatedEventNames = new HashMap(1);

    private EventHelper() {
    }

    private static String getGeneratorClass(String string) {
        Object var1_1 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(generatorResource);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string5 = enumeration.nextElement();
                String string6 = resourceBundle.getString(string5);
                if (".".equals(string5)) {
                    string2 = string3;
                }
                if (!EventHelper.doTopicMatch(string, string5)) continue;
                if (string3 == null) {
                    string3 = string6;
                    string4 = string5;
                    continue;
                }
                if (new StringTokenizer(string5, ".").countTokens() <= new StringTokenizer(string4, ".").countTokens()) continue;
                string3 = string6;
                string4 = string5;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot access Generator property file");
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static PropertiesGenerator getGenerator(String string) {
        PropertiesGenerator propertiesGenerator = (PropertiesGenerator)generators.get(string);
        if (propertiesGenerator == null) {
            String string2 = EventHelper.getGeneratorClass(string);
            if (string2 != null) {
                try {
                    propertiesGenerator = (PropertiesGenerator)Class.forName(string2).newInstance();
                    generators.put(string, propertiesGenerator);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Report.error.log(classNotFoundException, (Object)"Could not instantiate a generator");
                }
                catch (InstantiationException instantiationException) {
                    Report.error.log(instantiationException, (Object)"Could not instantiate a generator");
                }
                catch (IllegalAccessException illegalAccessException) {
                    Report.error.log(illegalAccessException, (Object)"Could not instantiate a generator");
                }
            } else {
                Report.error.log("Could not find a properties generator for topic: " + string);
                return null;
            }
        }
        return propertiesGenerator;
    }

    public static String getDescription(Locale locale, NSMEvent nSMEvent) {
        EventData eventData = new EventData(nSMEvent);
        String string = null;
        LocalizedString localizedString = eventData.getDescription();
        if (localizedString != null) {
            string = localizedString.getString(locale);
        }
        if (string == null) {
            string = "description...";
        }
        return EventHelper.getHTMLString(string);
    }

    public static String getShortDescription(Locale locale, NSMEvent nSMEvent) {
        String string;
        EventData eventData = new EventData(nSMEvent);
        String string2 = null;
        LocalizedString localizedString = eventData.getDescription();
        if (localizedString != null && (string = localizedString.getString(locale)) != null) {
            string2 = EventHelper.shortenDescription(string);
        }
        if (string2 == null) {
            string2 = "description...";
        }
        return string2;
    }

    private static String shortenDescription(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf(": ");
        if (n != -1) {
            string2 = string.substring(n + 2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(string3);
            if (++n2 == 5) {
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append(" ");
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public static String getTopic(String string) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(topicResource);
            try {
                string2 = resourceBundle.getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                int n;
                String string3 = string;
                while ((n = string3.lastIndexOf(46)) != -1) {
                    string3 = string3.substring(0, n);
                    try {
                        string2 = resourceBundle.getString(string3);
                        return string2;
                    }
                    catch (MissingResourceException missingResourceException2) {
                    }
                }
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot access Topics property file");
        }
        return string;
    }

    public static String getTopic(Locale locale, String string) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(topicResource, locale);
            try {
                string2 = resourceBundle.getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                int n;
                String string3 = string;
                while ((n = string3.lastIndexOf(46)) != -1) {
                    string3 = string3.substring(0, n);
                    try {
                        string2 = resourceBundle.getString(string3);
                        return string2;
                    }
                    catch (MissingResourceException missingResourceException2) {
                    }
                }
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot access Topics property file");
        }
        return string;
    }

    public static String getSeverityValue(int n) {
        return EventHelper.getSeverityValue(n, Locale.getDefault());
    }

    public static String getSeverityValue(int n, Locale locale) {
        Localizer localizer = new Localizer(appResource);
        localizer.setLocale(locale);
        String string = null;
        switch (n) {
            case 0: {
                string = localizer.getString("minor", "Minor");
                break;
            }
            case 1: {
                string = localizer.getString("minor", "Minor");
                break;
            }
            case 2: {
                string = localizer.getString("minor", "Minor");
                break;
            }
            case 3: {
                string = localizer.getString("minor", "Minor");
                break;
            }
            case 4: {
                string = localizer.getString("major", "Major");
                break;
            }
            case 5: {
                string = localizer.getString("critical", "Critical");
                break;
            }
            case 6: {
                string = localizer.getString("down", "Down");
            }
        }
        return string;
    }

    public static String getSeverityCode(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "minor";
                break;
            }
            case 1: {
                string = "minor";
                break;
            }
            case 2: {
                string = "minor";
                break;
            }
            case 3: {
                string = "minor";
                break;
            }
            case 4: {
                string = "major";
                break;
            }
            case 5: {
                string = "critical";
                break;
            }
            case 6: {
                string = "down";
            }
        }
        return string;
    }

    public static String getSeverityIcon(int n, String string) {
        String string2 = "&nbsp;";
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            string2 = "<img src=\"../images/minor_14.gif\" border=\"0\" align=\"absmiddle\" title=\"" + string + "\" alt=\"" + string + "\" >";
        } else if (n == 4) {
            string2 = "<img src=\"../images/major_14.gif\" border=\"0\" align=\"absmiddle\" title=\"" + string + "\" alt=\"" + string + "\" >";
        } else if (n == 5) {
            string2 = "<img src=\"../images/critical_14.gif\" border=\"0\" align=\"absmiddle\" title=\"" + string + "\" alt=\"" + string + "\" >";
        } else if (n == 6) {
            string2 = "<img src=\"../images/down_14.gif\" border=\"0\" align=\"absmiddle\" title=\"" + string + "\" alt=\"" + string + "\" >";
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean doTopicMatch(String var0, String var1_1) {
        if (var0 == null && var1_1 == null) {
            return true;
        }
        if (var0 == null && var1_1 != null) {
            return false;
        }
        if (var0 != null && var1_1 == null) {
            return false;
        }
        if (var1_1.equals(".")) {
            return true;
        }
        var2_2 = var0;
        if (!var0.equals(var1_1)) ** GOTO lbl14
        return true;
lbl-1000:
        // 1 sources

        {
            if (!(var2_2 = var2_2.substring(0, var2_2.lastIndexOf("."))).equals(var1_1)) continue;
            return true;
lbl14:
            // 2 sources

            ** while (var2_2.indexOf((String)".") != -1)
        }
lbl15:
        // 1 sources

        return false;
    }

    public static void createCorrelatedEvents(Locale locale, NSMEvent nSMEvent, ArrayList arrayList, ArrayList arrayList2) {
        if (nSMEvent.getCorrelatedEvents() != null) {
            String[] stringArray = nSMEvent.getCorrelatedEvents();
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                Object object2;
                String string = stringArray[n];
                NSMEvent nSMEvent2 = null;
                try {
                    object2 = PersistenceService.getService();
                    object = object2.getGenericPersistence();
                    try {
                        nSMEvent2 = object.retrieveEventByID(string);
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        Report.info.log("Non existing event");
                    }
                    catch (Exception exception) {
                        Report.error.log(exception, (Object)"Error in database operation");
                    }
                    try {
                        if (nSMEvent2 == null) {
                            nSMEvent2 = object.retrieveAlarmByID(string).getEvent();
                        }
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        Report.info.log("Non existing event");
                    }
                    catch (Exception exception) {
                        Report.error.log(exception, (Object)"Error in database operation");
                    }
                }
                catch (Exception exception) {
                    Report.error.log(exception, (Object)"Error in database operation");
                }
                if (nSMEvent2 == null) {
                    Report.info.log("cannot find the event/alarm for id " + string);
                } else {
                    Localizer localizer;
                    String string2;
                    object2 = EventHelper.getDescription(locale, nSMEvent2);
                    object = null;
                    if (nSMEvent2.getTopic().startsWith(".alert")) {
                        object = "<a href=alarmDetails.jsp?id=" + URLEncoder.encode(string) + ">" + (String)object2 + "</a>";
                        string2 = (String)correlatedAlarmNames.get(locale);
                        if (string2 == null) {
                            localizer = new Localizer(variableResource);
                            localizer.setLocale(locale);
                            string2 = localizer.getString(CORRELATED_ALARM_KEY, CORRELATED_ALARM);
                            correlatedAlarmNames.put(locale, string2);
                        }
                        arrayList.add(new ItemImpl(string2, object));
                        arrayList2.add(new ItemImpl(string2, object2));
                    } else {
                        object = "<a href=eventDetails.jsp?id=" + URLEncoder.encode(string) + ">" + (String)object2 + "</a>";
                        string2 = (String)correlatedEventNames.get(locale);
                        if (string2 == null) {
                            localizer = new Localizer(variableResource);
                            localizer.setLocale(locale);
                            string2 = localizer.getString(CORRELATED_EVENT_KEY, CORRELATED_EVENT);
                            correlatedEventNames.put(locale, string2);
                        }
                        arrayList.add(new ItemImpl(string2, object));
                        arrayList2.add(new ItemImpl(string2, object2));
                    }
                }
                ++n;
            }
        }
    }

    public static void createMessageInfo(Locale locale, NSMEvent nSMEvent, ArrayList arrayList, ArrayList arrayList2) {
        AlertEventData.CauseInformation[] causeInformationArray;
        Object object;
        Localizer localizer = new Localizer(variableResource);
        localizer.setLocale(locale);
        EventData eventData = nSMEvent.getTopic().startsWith(".alert") ? new AlertEventData(nSMEvent) : new EventData(nSMEvent);
        String string = null;
        String string2 = null;
        LocalizedString localizedString = eventData.getDescription();
        if (localizedString != null && (object = localizedString.getString(locale)) != null) {
            string = object;
            string2 = EventHelper.getHTMLString((String)object);
        }
        if (string != null) {
            object = localizer.getString(DESCRIPTION_KEY, DESCRIPTION);
            arrayList.add(new ItemImpl((String)object, string2));
            arrayList2.add(new ItemImpl((String)object, string));
        }
        if (nSMEvent.getTopic().startsWith(".alert") && (causeInformationArray = ((AlertEventData)(object = (AlertEventData)eventData)).getCauseInformation()) != null) {
            int n = 0;
            while (n < causeInformationArray.length) {
                LocalizedString[] localizedStringArray;
                String string3 = causeInformationArray[n].getURL();
                LocalizedString[] localizedStringArray2 = causeInformationArray[n].getProbableCauses();
                if (localizedStringArray2 != null) {
                    localizedStringArray = localizer.getString(PROBABLE_CAUSE_KEY, PROBABLE_CAUSE);
                    int n2 = 0;
                    while (n2 < localizedStringArray2.length) {
                        arrayList.add(new ItemImpl((String)localizedStringArray, EventHelper.getHTMLString(localizedStringArray2[n2].getString(locale))));
                        arrayList2.add(new ItemImpl((String)localizedStringArray, localizedStringArray2[n2].getString(locale)));
                        ++n2;
                    }
                }
                if ((localizedStringArray = causeInformationArray[n].getRecommendedActions()) != null) {
                    String string4 = localizer.getString(RECOMMENDED_ACTION_KEY, RECOMMENDED_ACTION);
                    int n3 = 0;
                    while (n3 < localizedStringArray.length) {
                        if (string3 == null) {
                            arrayList.add(new ItemImpl(string4, EventHelper.getHTMLString(localizedStringArray[n3].getString(locale))));
                        } else {
                            String string5 = "../jhelp/web/help.jsp?helpset=jade/jhelp/web/" + string3;
                            String string6 = "\"javascript:openNewWindow('" + string5 + "', 'helpWindow', 'resizable');\"";
                            String string7 = "<a href=" + string3 + "\">" + EventHelper.getHTMLString(localizedStringArray[n3].getString(locale)) + "</a>";
                            arrayList.add(new ItemImpl(string4, string7));
                        }
                        arrayList2.add(new ItemImpl(string4, localizedStringArray[n3].getString(locale)));
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    private static String getHTMLString(String string) {
        String string2;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string3 = string3 != null ? string3 + "<br>" + string2 : string2;
        }
        string2 = null;
        stringTokenizer = new StringTokenizer(string3, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string2 = string2 != null ? string2 + "&nbsp;&nbsp;" + string4 : string4;
        }
        return string2;
    }
}

