/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event;

import com.sun.jade.apps.command.DebugCommand;
import com.sun.jade.apps.discovery.AgentInstallEvent;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.event.EventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.xml.XmlEncoder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;

public class EventDebug
implements DebugCommand {
    public static String ROOT = "/jade/debug/event";
    public static final String sccs_id = "@(#)EventDebug.java\t1.4 11/19/02 SMI";

    public String getHelp() {
        return "Print events.";
    }

    public int execute(Properties properties, PrintWriter printWriter) throws IOException {
        try {
            String string = properties.getProperty("CMD");
            if (string == null || "".equals(string)) {
                this.printOptions(printWriter);
                return 0;
            }
            if ("PRINT".equals(string)) {
                String string2 = properties.getProperty("id");
                if (string2 == null || "".equals(string2)) {
                    printWriter.println("Unknown id=" + string2);
                } else {
                    this.printEvent(string2, printWriter);
                }
            } else if ("AUDIT".equals(string)) {
                AgentInstallEvent.postAuditEvent();
                printWriter.print("Audit event posted.");
            } else if ("HEARTBEAT".equals(string)) {
                AgentInstallEvent.postHeartbeatEvent();
                printWriter.print("Heartbeat event posted.");
            } else if ("LIST".equals(string)) {
                this.printEventLinks(printWriter);
            } else {
                this.printOptions(printWriter);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            return 1;
        }
        return 0;
    }

    private void printOptions(PrintWriter printWriter) {
        printWriter.println("Event commands:<ul>");
        printWriter.print("<li>Generate <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?CMD=AUDIT\">Audit</A> Event");
        printWriter.print("<li>Generate <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?CMD=HEARTBEAT\">Heartbeat</A> Event");
        printWriter.print("<li>List All <A HREF=\"");
        printWriter.print(ROOT);
        printWriter.println("?CMD=LIST\">Events</A>");
        printWriter.println("<li>");
        this.printForm(printWriter);
        printWriter.println("</ul>");
    }

    private void printForm(PrintWriter printWriter) {
        printWriter.println("Print event.");
        printWriter.println("<FORM METHOD=GET ACTION=\"" + ROOT + "\">");
        printWriter.println("Event Id:");
        printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"CMD\" VALUE=\"PRINT\">");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"id\" VALUE=\"\" SIZE=\"16\">");
        printWriter.println("<INPUT TYPE=\"submit\" VALUE=\"Submit\">");
        printWriter.println("<INPUT TYPE=\"reset\">");
        printWriter.println("</FORM>");
    }

    private void printEventGenForm(PrintWriter printWriter) {
        printWriter.println("Generate event.");
        printWriter.println("<FORM METHOD=GET ACTION=\"" + ROOT + "\">");
        printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"CMD\" VALUE=\"GEN\">");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"severity\" VALUE=\"\">");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"source\" VALUE=\"debug\">");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"subject\" VALUE=\"\" >");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"topic\" VALUE=\"\" >");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"type\" VALUE=\"\" >");
        printWriter.println("<INPUT TYPE=\"text\" NAME=\"deftype\" VALUE=\"\" >");
        printWriter.println("</FORM>");
    }

    private void printEvent(String string, PrintWriter printWriter) throws Exception {
        PersistenceService persistenceService = PersistenceService.getService();
        GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
        NSMEvent nSMEvent = genericPersistence.retrieveEventByID(string);
        printWriter.println("<pre>");
        printWriter.println(XmlEncoder.encode(nSMEvent.toXML()));
        printWriter.println("</pre>");
    }

    private void printEventLinks(PrintWriter printWriter) throws Exception {
        PersistenceService persistenceService = PersistenceService.getService();
        GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
        Iterator iterator = genericPersistence.retrieveEvents(-1);
        if (iterator == null) {
            printWriter.println("Unable to get all events.");
            return;
        }
        printWriter.println("Events <UL>");
        while (iterator.hasNext()) {
            NSMEvent nSMEvent = (NSMEvent)iterator.next();
            EventData eventData = new EventData(nSMEvent);
            printWriter.print("<LI><A HREF=\"/jade/debug/event?CMD=PRINT&id=");
            printWriter.print(nSMEvent.getEventID() + "\">");
            printWriter.print(nSMEvent.getEventID() + "</A>");
            LocalizedString localizedString = eventData.getDescription();
            if (localizedString != null) {
                printWriter.print(localizedString.getString());
            }
            printWriter.println("");
        }
        printWriter.println("</UL>");
    }
}

