/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.cim.util.CIMAssociationBean;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.device.util.AssocAdder;
import com.sun.jade.device.util.BeanHandler;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ReportParser {
    private String returnCode;
    private String exceptionReason;
    private String exception;
    private String report;
    private InputStream reportStream;
    public static final String sccs_id = "@(#)ReportParser.java\t1.10 12/06/02 SMI";
    static /* synthetic */ Class class$com$sun$wbem$cim$CIMObjectPath;

    public String getReport() {
        return this.report;
    }

    public void setReport(String string) {
        this.report = string;
    }

    public void setReportStream(InputStream inputStream) {
        this.reportStream = inputStream;
        this.report = null;
    }

    public void writeBeans() {
        this.parseReport(new PrintBeanHandler());
    }

    public void writeBeans(int n) {
        this.parseReport(new PrintBeanHandler(n));
    }

    public void parseReport(BeanHandler[] beanHandlerArray) {
        this.parseReport(new MultiBeanHandler(beanHandlerArray));
    }

    public void parseReport(BeanHandler beanHandler) {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new ReportHandler(beanHandler));
            xMLReader.setErrorHandler(new DRErrorHandler());
            if (this.reportStream == null) {
                xMLReader.parse(new InputSource(new StringReader(this.report)));
            } else {
                xMLReader.parse(new InputSource(this.reportStream));
                this.reportStream = null;
            }
        }
        catch (Exception exception) {
            this.returnCode = "FAILURE";
            this.exception = exception.toString();
            this.exceptionReason = MFStatus.ERROR.getMappedValue();
        }
    }

    private Properties getProperties(Attributes attributes) {
        Properties properties = new Properties();
        int n = 0;
        while (n < attributes.getLength()) {
            properties.setProperty(attributes.getQName(n), attributes.getValue(n));
            ++n;
        }
        return properties;
    }

    private CIMBean getBean(String string, Attributes attributes) {
        Properties properties = this.getProperties(attributes);
        properties.remove("REF");
        CIMBean cIMBean = CIMBeanUtil.createBean("CIM_" + string, properties);
        return cIMBean;
    }

    private void setBeanCOP(CIMBean cIMBean, String string, CIMObjectPath cIMObjectPath) {
        Class<?> clazz = cIMBean.getClass();
        try {
            Method method = clazz.getMethod("set" + string, class$com$sun$wbem$cim$CIMObjectPath == null ? (class$com$sun$wbem$cim$CIMObjectPath = ReportParser.class$("com.sun.wbem.cim.CIMObjectPath")) : class$com$sun$wbem$cim$CIMObjectPath);
            method.invoke((Object)cIMBean, cIMObjectPath);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Report.error.log(noSuchMethodException, (Object)("Error setting " + string));
        }
        catch (IllegalAccessException illegalAccessException) {
            Report.error.log(illegalAccessException, (Object)("Error setting " + string));
        }
        catch (InvocationTargetException invocationTargetException) {
            Report.error.log(invocationTargetException, (Object)("Error setting " + string));
        }
    }

    private static void usage() {
        System.out.println("Usage: ReportParser [options] <xml Report>");
        System.out.println("\t-v Turn on verbose output.");
        System.out.println("\t-b Print beans");
        System.out.println("\t-m Print memory usage.");
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                if (!string.startsWith("-") || string.equals("-")) break;
                if (string.equals("-v")) {
                    bl = true;
                } else if (string.equals("-b")) {
                    bl2 = true;
                } else if (string.equals("-t")) {
                    bl3 = true;
                } else if (string.equals("-m")) {
                    bl4 = true;
                } else if (string.equals("-i")) {
                    n = Integer.parseInt(stringArray[++n2]);
                }
                ++n2;
            }
            if (n2 >= stringArray.length) {
                ReportParser.usage();
                System.exit(-1);
            }
            int n3 = n2;
            while (n3 < stringArray.length) {
                Object object;
                int n4;
                StringBuffer stringBuffer = new StringBuffer();
                FileReader fileReader = null;
                File file = new File(stringArray[n3]);
                fileReader = new FileReader(file);
                char[] cArray = new char[1024];
                while ((n4 = fileReader.read(cArray)) != -1) {
                    object = new String(cArray, 0, n4);
                    stringBuffer.append((String)object);
                }
                object = new ReportParser();
                ((ReportParser)object).setReport(stringBuffer.toString());
                if (bl2) {
                    ((ReportParser)object).writeBeans();
                }
                if (bl4) {
                    ((ReportParser)object).writeBeans(3);
                }
                if (bl3) {
                    PrintBeanHandler printBeanHandler = new PrintBeanHandler();
                    printBeanHandler.setFormat(0);
                    long l = 0L;
                    int n5 = n;
                    ((ReportParser)object).parseReport(printBeanHandler);
                    int n6 = 0;
                    while (n6 < n5) {
                        Date date = new Date();
                        ((ReportParser)object).parseReport(printBeanHandler);
                        Date date2 = new Date();
                        l += date2.getTime() - date.getTime();
                        ++n6;
                    }
                    int n7 = (int)l / n5 / 1000;
                    int n8 = (int)l / n5 % 1000;
                    System.out.println("Parsing took " + n7 + "." + n8 + " seconds.");
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MultiBeanHandler
    implements BeanHandler {
        private BeanHandler[] handlers;

        public MultiBeanHandler(BeanHandler[] beanHandlerArray) {
            this.handlers = beanHandlerArray;
        }

        public void start() {
            int n = 0;
            while (n < this.handlers.length) {
                this.handlers[n].start();
                ++n;
            }
        }

        public void handleBean(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
            int n = 0;
            while (n < this.handlers.length) {
                this.handlers[n].handleBean(cIMBeanBase, cIMBeanBase2, cIMBeanBase3);
                ++n;
            }
        }

        public void end() {
            int n = 0;
            while (n < this.handlers.length) {
                this.handlers[n].end();
                ++n;
            }
        }
    }

    public static class PrintBeanHandler
    implements BeanHandler {
        public static final int NO_OP = 0;
        public static final int CIM_XML = 1;
        public static final int BEAN_XML = 2;
        public static final int MOF = 3;
        private int format;

        public PrintBeanHandler() {
            this.format = 2;
        }

        public PrintBeanHandler(int n) {
            this.format = n;
        }

        public void setFormat(int n) {
            this.format = n;
        }

        public void start() {
        }

        public void handleBean(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
            if (this.format == 0) {
                return;
            }
            try {
                if (this.format == 2) {
                    if (cIMBeanBase2 != null) {
                        System.out.println(cIMBeanBase2.toBeanXML());
                    }
                    if (cIMBeanBase3 != null) {
                        System.out.println(cIMBeanBase3.toBeanXML());
                    }
                } else if (this.format == 1) {
                    CIMInstance cIMInstance;
                    if (cIMBeanBase2 != null) {
                        cIMInstance = cIMBeanBase2.toCIMInstance();
                        System.out.println(cIMInstance.toXml());
                    }
                    if (cIMBeanBase3 != null) {
                        cIMInstance = cIMBeanBase3.toCIMInstance();
                        System.out.println(cIMInstance.toXml());
                    }
                } else if (this.format == 3) {
                    CIMInstance cIMInstance;
                    if (cIMBeanBase2 != null) {
                        cIMInstance = cIMBeanBase2.toCIMInstance();
                        System.out.println(cIMInstance.toMOF());
                    }
                    if (cIMBeanBase3 != null) {
                        cIMInstance = cIMBeanBase3.toCIMInstance();
                        System.out.println(cIMInstance.toMOF());
                    }
                }
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Error writing bean");
            }
        }

        public void end() {
        }
    }

    private class ReportHandler
    implements ContentHandler {
        String currentElement;
        String assocTag;
        String assocVar;
        String assocClass;
        CIMAssociationBean assocBean;
        CIMObjectPath assocCOP;
        Attributes assocAtts;
        boolean aggregateAssoc = false;
        boolean handlerStarted;
        AssocAdder adder = new AssocAdder();
        BeanHandler beanHandler;
        HashMap refMap = new HashMap();
        private static final String REF = "REF";

        public ReportHandler(BeanHandler beanHandler) {
            this.beanHandler = beanHandler;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if ("exception".equals(this.currentElement)) {
                ReportParser.this.exception = new String(cArray, n, n2);
            }
            if (this.assocAtts != null) {
                String string = new String(cArray, n, n2);
            }
        }

        public void endDocument() throws SAXException {
            if (this.handlerStarted) {
                this.beanHandler.end();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!"report".equals(string2) || "OK".equals(ReportParser.this.returnCode)) {
                // empty if block
            }
            if (this.assocTag != null) {
                if (this.assocTag.equals(string3)) {
                    if (!this.aggregateAssoc) {
                        this.beanHandler.handleBean(null, (CIMBeanBase)((Object)this.assocBean), null);
                    }
                    this.assocTag = null;
                    this.assocBean = null;
                    this.aggregateAssoc = false;
                } else if (this.assocAtts != null) {
                    String string4 = this.assocBean.associatedClassName(this.assocVar);
                    this.assocCOP = this.getCOP(string4, this.assocAtts);
                    if (this.assocClass != null) {
                        this.assocCOP.setObjectName(this.assocClass);
                    }
                    ReportParser.this.setBeanCOP(this.assocBean, this.assocVar, this.assocCOP);
                    this.aggregateAssoc = this.adder.checkAggregation(this.assocBean, this.assocVar);
                    if (this.aggregateAssoc) {
                        this.beanHandler.handleBean(null, (CIMBeanBase)((Object)this.assocBean), null);
                    }
                    this.assocVar = null;
                    this.assocAtts = null;
                    this.assocClass = null;
                }
            } else {
                this.adder.pop(string3);
            }
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) {
        }

        public void startDocument() throws SAXException {
            this.beanHandler.start();
            this.handlerStarted = true;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block11: {
                block12: {
                    block10: {
                        this.currentElement = string3;
                        if (!"report".equals(string3)) break block10;
                        int n = 0;
                        while (n < attributes.getLength()) {
                            if ("ReturnCode".equals(attributes.getQName(n))) {
                                ReportParser.this.returnCode = attributes.getValue(n);
                            }
                            ++n;
                        }
                        break block11;
                    }
                    if (!"exception".equals(string3)) break block12;
                    int n = 0;
                    while (n < attributes.getLength()) {
                        if ("Reason".equals(attributes.getQName(n))) {
                            ReportParser.this.exceptionReason = attributes.getValue(n);
                        }
                        ++n;
                    }
                    break block11;
                }
                if ("model".equals(string3) || "SystemView".equals(string3) || "Associations".equals(string3)) break block11;
                if (this.assocTag != null) {
                    this.assocAtts = attributes;
                    this.assocVar = string3;
                    return;
                }
                try {
                    CIMBean cIMBean = this.adder.getLast();
                    CIMBean cIMBean2 = null;
                    CIMBean cIMBean3 = ReportParser.this.getBean(string3, attributes);
                    String string4 = attributes.getValue(REF);
                    if (cIMBean3 != null) {
                        if (string4 != null) {
                            this.refMap.put(string4, cIMBean3.getCIMObjectPath());
                        }
                        if (cIMBean3 instanceof CIMAssociationBean) {
                            this.assocTag = string3;
                            this.assocBean = (CIMAssociationBean)cIMBean3;
                            return;
                        }
                        cIMBean2 = this.adder.push(string3, cIMBean3);
                    }
                    this.beanHandler.handleBean((CIMBeanBase)cIMBean, (CIMBeanBase)cIMBean3, (CIMBeanBase)cIMBean2);
                }
                catch (Exception exception) {
                    Report.error.log(exception, (Object)("Unable to load bean " + string3));
                }
            }
        }

        public void startPrefixMapping(String string, String string2) {
        }

        private CIMObjectPath getCOP(String string, Attributes attributes) {
            String string2 = attributes.getValue(REF);
            if (string2 != null) {
                return (CIMObjectPath)this.refMap.get(string2);
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            int n = 0;
            while (n < attributes.getLength()) {
                String string3 = attributes.getQName(n);
                String string4 = attributes.getValue(n);
                if ("CreationClassName".equals(string3)) {
                    cIMObjectPath.setObjectName(string4);
                }
                CIMValue cIMValue = new CIMValue((Object)string4);
                cIMObjectPath.addKey(string3, cIMValue);
                ++n;
            }
            return cIMObjectPath;
        }
    }

    private static class DRErrorHandler
    implements ErrorHandler {
        private DRErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            Report.error.log(sAXParseException, (Object)("Parse Error" + this.locate(sAXParseException)));
        }

        public void warning(SAXParseException sAXParseException) {
            Report.warning.log(sAXParseException, (Object)("Parse warning " + this.locate(sAXParseException)));
        }

        public void fatalError(SAXParseException sAXParseException) {
            Report.error.log(sAXParseException, (Object)("Parse fatal Error " + this.locate(sAXParseException)));
        }

        private String locate(SAXParseException sAXParseException) {
            return "(Line " + sAXParseException.getLineNumber() + " Char " + sAXParseException.getColumnNumber() + ")";
        }
    }
}

