/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.util.unittest.UnitTest;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DeviceReportExceptionParser {
    private String returnCode;
    private String exceptionReason;
    private String exception;
    private String doc;
    private XMLReader reader;
    private final String FINISHED = "FINISHED";
    public static final String sccs_id = "@(#)DeviceReportExceptionParser.java\t1.5 12/04/02 SMI";

    public DeviceReportExceptionParser() {
        this.init();
    }

    public DeviceReportExceptionParser(String string) {
        this.doc = string;
        this.init();
        this.parse(string);
    }

    private void init() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.reader = sAXParser.getXMLReader();
            this.reader.setContentHandler(new ReportParser());
            this.reader.setErrorHandler(new DRErrorHandler());
        }
        catch (Exception exception) {
            if (exception instanceof SAXException && "FINISHED".equals(exception.getMessage())) {
                return;
            }
            this.returnCode = "FAILURE";
            this.exception = exception.toString();
            this.exceptionReason = MFStatus.ERROR.getMappedValue();
        }
    }

    public void parse(String string) {
        try {
            this.reader.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            if (exception instanceof SAXException && "FINISHED".equals(exception.getMessage())) {
                return;
            }
            this.returnCode = "FAILURE";
            this.exception = exception.toString();
            this.exceptionReason = MFStatus.ERROR.getMappedValue();
        }
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getExceptionReason() {
        return this.exceptionReason;
    }

    public String getException() {
        return this.exception;
    }

    public static class Test
    extends UnitTest {
        String testDoc01 = "<report ReturnCode='FAILURE'><exception  Reason='COMM_LOST'>Network not reachable.</exception></report>";
        String testDoc02 = "<report ReturnCode='OK'><blah goo='stuff'/><moreblah>Stuff</moreblah></report>";

        public void test() {
            DeviceReportExceptionParser deviceReportExceptionParser = new DeviceReportExceptionParser(this.testDoc01);
            this.assertEquals("FAILURE", deviceReportExceptionParser.getReturnCode());
            this.assertEquals("COMM_LOST", deviceReportExceptionParser.getExceptionReason());
            this.assertEquals("Network not reachable.", deviceReportExceptionParser.getException());
            deviceReportExceptionParser = new DeviceReportExceptionParser(this.testDoc02);
            this.assertEquals("OK", deviceReportExceptionParser.getReturnCode());
        }
    }

    private static class DRErrorHandler
    implements ErrorHandler {
        private DRErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    }

    private class ReportParser
    implements ContentHandler {
        String currentElement;

        private ReportParser() {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if ("exception".equals(this.currentElement)) {
                DeviceReportExceptionParser.this.exception = new String(cArray, n, n2);
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("report".equals(string3) && "OK".equals(DeviceReportExceptionParser.this.returnCode)) {
                throw new SAXException("FINISHED");
            }
            if ("exception".equals(string3)) {
                throw new SAXException("FINISHED");
            }
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n;
            this.currentElement = string3;
            if ("report".equals(string3)) {
                n = 0;
                while (n < attributes.getLength()) {
                    if ("ReturnCode".equals(attributes.getQName(n))) {
                        DeviceReportExceptionParser.this.returnCode = attributes.getValue(n);
                        if ("OK".equals(DeviceReportExceptionParser.this.returnCode)) {
                            throw new SAXException("FINISHED");
                        }
                    }
                    ++n;
                }
            }
            if ("exception".equals(string3)) {
                n = 0;
                while (n < attributes.getLength()) {
                    if ("Reason".equals(attributes.getQName(n))) {
                        DeviceReportExceptionParser.this.exceptionReason = attributes.getValue(n);
                    }
                    ++n;
                }
            }
        }

        public void startPrefixMapping(String string, String string2) {
        }
    }
}

