/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.util.Config;
import com.sun.jade.util.ConfigProperty;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class DeviceConfig
extends Config {
    private Properties prop = new Properties();
    private List hostCfg = new ArrayList();
    private List deviceCfg = new ArrayList();
    private File fileCfg;
    private static DeviceConfig system;
    private static final String sccs_id = "@(#)DeviceConfig.java\t1.20 04/03/03 SMI";

    public DeviceConfig(File file) {
        this.fileCfg = file;
        if (file.exists() && file.length() == 0L) {
            this.init();
        } else {
            try {
                this.buildConfig(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8")));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Report.debug.log("New config file.");
                this.init();
            }
            catch (IOException iOException) {
                Report.error.log(iOException, (Object)"Error parsing discovery file.");
            }
        }
    }

    public String getProperty(String string) {
        return this.prop.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.prop.setProperty(string, string2);
    }

    public Iterator getHosts() {
        return this.hostCfg.iterator();
    }

    public void addHost(Properties properties) {
        this.addIfNew(properties, this.hostCfg);
    }

    public Iterator getDevices() {
        return this.deviceCfg.iterator();
    }

    public void addDevice(Properties properties) {
        this.addIfNew(properties, this.deviceCfg);
    }

    public boolean addDevice(Properties properties, String[] stringArray) {
        if (properties == null) {
            return false;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 0;
        while (n < this.deviceCfg.size()) {
            Properties properties2 = (Properties)this.deviceCfg.get(n);
            if (properties2 != null) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = properties2.getProperty(stringArray[n2]);
                    String string2 = properties.getProperty(stringArray[n2]);
                    if (string != null || string2 != null) {
                        if (string == null || string2 == null) {
                            bl = true;
                            break;
                        }
                        if (!string.equals(string2)) {
                            bl = true;
                            break;
                        }
                    }
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
            }
            ++n;
        }
        this.deviceCfg.add(properties);
        return true;
    }

    public void removeDevice(Properties properties) {
        this.removeIfExisted(properties, this.deviceCfg);
    }

    public void updateDevice(Properties properties) {
        this.updateIfExisted(properties, this.deviceCfg);
    }

    private void updateIfExisted(Properties properties, List list) {
        String string = properties.getProperty("logicalName");
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Properties properties2 = (Properties)list.get(n);
            if (properties2 != null && string.equals(properties2.getProperty("logicalName"))) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    properties2.setProperty(string2, string3);
                }
                break;
            }
            ++n;
        }
    }

    private void removeIfExisted(Properties properties, List list) {
        String string = properties.getProperty("logicalName");
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Properties properties2 = (Properties)list.get(n);
            if (properties2 != null && string.equals(properties2.getProperty("logicalName"))) {
                list.remove(n);
                break;
            }
            ++n;
        }
    }

    private void addIfNew(Properties properties, List list) {
        String string = properties.getProperty("wwn");
        int n = 0;
        while (n < list.size()) {
            String string2;
            Properties properties2 = (Properties)list.get(n);
            if (properties2 != null && string != null && (string2 = properties2.getProperty("wwn")) != null && string.equals(string2)) {
                return;
            }
            ++n;
        }
        list.add(properties);
    }

    private void init() {
        this.prop.setProperty("active", "Y");
        this.prop.setProperty("customer", "");
        this.prop.setProperty("site_address", "");
        this.prop.setProperty("site_city", "");
        this.prop.setProperty("site_contact", "");
        this.prop.setProperty("site_country", "");
        this.prop.setProperty("site_email", "");
        this.prop.setProperty("site_name", "");
        this.prop.setProperty("site_state", "");
        this.prop.setProperty("site_zip", "");
        this.prop.setProperty("ticker", "");
        this.prop.setProperty("version", StoradeEnvironment.getVersion());
    }

    private void buildConfig(BufferedReader bufferedReader) throws IOException {
        Properties properties = this.prop;
        List list = null;
        while (true) {
            String string;
            if ((string = bufferedReader.readLine()) == null) {
                if (list == null) break;
                list.add(properties);
                break;
            }
            if (string.length() == 0) {
                if (list != null) {
                    list.add(properties);
                }
                list = null;
                properties = null;
                continue;
            }
            char c = string.charAt(0);
            if (c == '\n') {
                if (list != null) {
                    list.add(properties);
                }
                list = null;
                properties = null;
                continue;
            }
            if (c == '[') {
                properties = new Properties();
                if (string.startsWith("[host")) {
                    list = this.hostCfg;
                    continue;
                }
                if (string.startsWith("[device")) {
                    list = this.deviceCfg;
                    continue;
                }
                list = null;
                properties = null;
                continue;
            }
            if (properties == null) continue;
            ConfigProperty configProperty = new ConfigProperty(string);
            String string2 = configProperty.getValue();
            if (string2 == null) {
                string2 = "";
            }
            properties.setProperty(configProperty.getName(), string2);
        }
    }

    public void store() {
        Report.debug.log("Store config " + this.fileCfg);
        if (this.fileCfg != null) {
            this.store(this.fileCfg);
        }
    }

    public void storeWithException(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        this.store(new PrintWriter(outputStreamWriter));
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    public void store(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            this.store(new PrintWriter(outputStreamWriter));
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            Report.error.log(iOException, (Object)"store failed");
        }
    }

    public void store(PrintWriter printWriter) {
        this.list(this.prop, printWriter);
        printWriter.println();
        int n = 0;
        while (n < this.hostCfg.size()) {
            printWriter.println();
            printWriter.println("[host" + (n + 1) + "]");
            this.list((Properties)this.hostCfg.get(n), printWriter);
            ++n;
        }
        n = 0;
        while (n < this.deviceCfg.size()) {
            printWriter.println();
            printWriter.println("[device" + (n + 1) + "]");
            this.list((Properties)this.deviceCfg.get(n), printWriter);
            ++n;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.store(printWriter);
        return stringWriter.toString();
    }

    private void list(Properties properties, PrintWriter printWriter) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            printWriter.println(object + "=" + object2);
        }
    }

    public Properties getTopLevelProperties() {
        return this.prop;
    }

    public void updateTopLevelProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.prop.setProperty(string, string2);
        }
    }

    public Collection getConfigProperties() {
        return this.deviceCfg;
    }

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.buildConfig(bufferedReader);
    }

    public void store(OutputStream outputStream) throws IOException {
        this.store(new PrintWriter(outputStream));
    }

    public void list(PrintWriter printWriter) {
        this.store(printWriter);
    }

    public static DeviceConfig getSystemConfig() {
        return system;
    }

    public void setAsSystemConfig() {
        system = this;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage DeviceConfig <file>");
            System.exit(-1);
        }
        DeviceConfig deviceConfig = new DeviceConfig(new File(stringArray[0]));
        System.out.println(deviceConfig.toString());
        System.exit(0);
    }
}

