/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.DeviceClassException;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.device.util.ReflectionException;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class DeviceClassSearch {
    private Vector v;
    private DeviceReport classTree;
    private DeviceClass rootNode;
    static /* synthetic */ Class class$java$util$Properties;

    public DeviceClassSearch(String string) {
        this.classTree = new DeviceReport(string);
        this.rootNode = this.classTree.getDeviceClass();
    }

    public DeviceClassSearch(DeviceReport deviceReport) {
        this.classTree = deviceReport;
        this.rootNode = this.classTree.getDeviceClass();
    }

    public ArrayList enumerateBeans(String string) throws Exception {
        Vector vector = this.enumerateClasses(string);
        ArrayList<CIMBean> arrayList = null;
        if (vector != null) {
            arrayList = new ArrayList<CIMBean>();
            int n = 0;
            while (n < vector.size()) {
                DeviceClass deviceClass = (DeviceClass)vector.get(n);
                String string2 = this.getCreationClassName(deviceClass);
                if (string2 == null) {
                    String string3 = string.substring(string.indexOf("_") + 1);
                    string2 = this.getPrefix() + "_" + string3;
                }
                arrayList.add(this.createBean(deviceClass, string2));
                ++n;
            }
        }
        return arrayList;
    }

    public Vector enumerateClasses(String string) {
        this.v = new Vector();
        String string2 = string.substring(string.indexOf("_") + 1);
        this.findClasses(this.rootNode, string2);
        if (this.v.size() == 0) {
            this.v = null;
        }
        return this.v;
    }

    private void findClasses(DeviceClass deviceClass, String string) {
        Iterator iterator;
        Object var3_3 = null;
        String string2 = string.substring(string.indexOf("_") + 1);
        if (string2.equals(deviceClass.getClassName())) {
            this.v.add(deviceClass);
        }
        if ((iterator = deviceClass.getChildren()) != null) {
            while (iterator.hasNext()) {
                this.findClasses((DeviceClass)iterator.next(), string2);
            }
        }
    }

    public CIMBean findBean(CIMObjectPath cIMObjectPath) throws Exception {
        DeviceClass deviceClass = this.findClass(cIMObjectPath);
        if (deviceClass == null) {
            throw new DeviceClassException("Could not find the specified instance in the report tree.");
        }
        String string = this.getCreationClassName(deviceClass);
        if (string == null) {
            String string2 = cIMObjectPath.getObjectName();
            String string3 = string2.substring(string2.indexOf("_") + 1);
            string = this.getPrefix() + "_" + string3;
        }
        return this.createBean(deviceClass, string);
    }

    private CIMBean createBean(DeviceClass deviceClass, String string) throws ReflectionException {
        String string2 = this.getPackage() + "." + string;
        Object var4_4 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var4_4 = clazz.newInstance();
            Class[] classArray = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = DeviceClassSearch.class$("java.util.Properties")) : class$java$util$Properties};
            Object[] objectArray = new Object[]{deviceClass.getProperties()};
            Method method = clazz.getMethod("fromProperties", classArray);
            method.invoke(var4_4, objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException("Error instantiating class " + string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Could not find method fromProperties in " + string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Could not access " + string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException("Error executing method " + invocationTargetException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException("Could not find class " + string2);
        }
        return var4_4;
    }

    public DeviceClass findClass(CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        String string2 = string.substring(string.indexOf("_") + 1);
        cIMObjectPath.setObjectName(string2);
        DeviceClass deviceClass = this.searchForMatch(this.rootNode, cIMObjectPath);
        cIMObjectPath.setObjectName(string);
        return deviceClass;
    }

    private DeviceClass searchForMatch(DeviceClass deviceClass, CIMObjectPath cIMObjectPath) {
        DeviceClass deviceClass2 = null;
        String string = cIMObjectPath.getObjectName();
        if (string.equals(deviceClass.getClassName()) && this.keysMatch(deviceClass, cIMObjectPath)) {
            return deviceClass;
        }
        Iterator iterator = deviceClass.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                deviceClass2 = this.searchForMatch((DeviceClass)iterator.next(), cIMObjectPath);
                if (deviceClass2 == null) continue;
                return deviceClass2;
            }
        }
        return deviceClass2;
    }

    private boolean keysMatch(DeviceClass deviceClass, CIMObjectPath cIMObjectPath) {
        boolean bl = true;
        Properties properties = deviceClass.getProperties();
        if (properties == null) {
            return false;
        }
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            String string = properties.getProperty(cIMProperty.getName());
            if (string != null) {
                bl = string.equalsIgnoreCase((String)cIMProperty.getValue().getValue());
                if (bl) continue;
                break;
            }
            bl = false;
            break;
        }
        return bl;
    }

    public String getPackage() {
        Properties properties = this.rootNode.getProperties();
        String string = properties.getProperty("package");
        return string;
    }

    public String getPrefix() {
        Properties properties = this.rootNode.getProperties();
        String string = properties.getProperty("prefix");
        return string;
    }

    public String getCreationClassName(DeviceClass deviceClass) {
        String string;
        try {
            Properties properties = deviceClass.getProperties();
            string = properties.getProperty("CreationClassName");
        }
        catch (NullPointerException nullPointerException) {
            string = null;
        }
        if (string == null) {
            string = this.getPrefix() + "_" + deviceClass.getClassName();
        }
        return string;
    }

    public Vector getChildrenBeans(CIMObjectPath cIMObjectPath) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        DeviceClass deviceClass = this.findClass(cIMObjectPath);
        if (deviceClass != null) {
            Object object;
            Iterator iterator = deviceClass.getChildren();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (DeviceClass)iterator.next();
                    String string = this.getCreationClassName((DeviceClass)object);
                    try {
                        vector.add(this.createBean((DeviceClass)object, string));
                    }
                    catch (ReflectionException reflectionException) {
                        // empty catch block
                    }
                }
            }
            object = this.createBean(deviceClass, this.getCreationClassName(deviceClass));
            vector.insertElementAt(object, 0);
        }
        if (vector.size() == 0) {
            throw new DeviceClassException("Specified instance has no children " + deviceClass.getClassName());
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = DeviceClassSearch.getReport(stringArray[0]);
        DeviceClassSearch deviceClassSearch = new DeviceClassSearch(string);
        ArrayList arrayList = null;
        try {
            arrayList = deviceClassSearch.enumerateBeans(stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(-1);
        }
        System.out.println("The number of beans returned is " + arrayList.size());
    }

    public static String getReport(String string) {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            FileReader fileReader = null;
            File file = new File(string);
            fileReader = new FileReader(file);
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray)) != -1) {
                String string2 = new String(cArray, 0, n);
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

