/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.device.util.ModelTag;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class DevInfo {
    public static final String TAG = "Agent";
    private static Properties devMap;
    private static HashMap tags;
    private static final String sccs_id = "@(#)DevInfo.java\t1.21 09/16/02 SMI";

    private DevInfo() {
    }

    public static Properties getDeviceProperties(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        try {
            return PropertiesPersister.restoreProperties("device" + File.separator + string + ".properties");
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(propertiesPersistenceException, (Object)("Couldn't load device " + string));
            return new Properties();
        }
    }

    public static String getDeviceProperty(String string, String string2) {
        Properties properties = DevInfo.getDeviceProperties(string);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(string2);
    }

    public static synchronized Properties getDevicePropertiesByClassName(String string) {
        String string2;
        if (string == null) {
            Report.warning.log("className is null, empty properties returned.");
            return new Properties();
        }
        if (devMap == null) {
            DevInfo.makeMap();
        }
        if ((string2 = devMap.getProperty(string)) == null) {
            Report.warning.log("No properties for device class " + string);
            return new Properties();
        }
        return DevInfo.getDeviceProperties(string2);
    }

    public static synchronized Properties getDeviceProperties(MF mF) {
        if (mF == null) {
            throw new IllegalArgumentException();
        }
        try {
            Properties properties = mF.getProperties();
            return DevInfo.getDeviceProperties(properties.getProperty("type"));
        }
        catch (RemoteException remoteException) {
            return new Properties();
        }
    }

    public static Collection getModelTags(String string, String string2) {
        Properties properties;
        String string3 = string + ":" + string2;
        Collection collection = (Collection)tags.get(string3);
        if (collection == null && (properties = DevInfo.getDevicePropertiesByClassName(string)) != null) {
            String string4 = properties.getProperty("Model." + string2);
            String string5 = ".properties";
            if (string4 != null) {
                ResourceBundle resourceBundle;
                if (string4.endsWith(string5)) {
                    string4 = string4.substring(0, string4.length() - string5.length());
                }
                try {
                    resourceBundle = ResourceBundle.getBundle(string4);
                }
                catch (MissingResourceException missingResourceException) {
                    return new ArrayList();
                }
                collection = ModelTag.createTags(resourceBundle);
                tags.put(string3, collection);
            }
        }
        return collection;
    }

    public static String[] getProbeableTypes() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator != null && iterator.hasNext()) {
            object = (Properties)iterator.next();
            String string = ((Properties)object).getProperty("TYPE");
            String string2 = ((Properties)object).getProperty("Probe.class");
            if (string2 == null || string == null || (string2 = string2.trim()).length() <= 0) continue;
            arrayList.add(string);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static Iterator getProbeableDevicesProperties() {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator != null && iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string = properties.getProperty("Probe.class");
            if (string == null || (string = string.trim()).length() <= 0) continue;
            arrayList.add(properties);
        }
        return arrayList.iterator();
    }

    public static Properties getMapForCategory() {
        Properties properties = new Properties();
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator != null && iterator.hasNext()) {
            Properties properties2 = (Properties)iterator.next();
            String string = properties2.getProperty("TYPE");
            String string2 = properties2.getProperty("CATEGORY");
            if (string2 == null || string == null || (string2 = string2.trim()).length() <= 0) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public static HashMap getMapForSnmpProbe() {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator != null && iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            Properties properties2 = new Properties();
            boolean bl = false;
            String string = properties.getProperty("TYPE");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("Probe.snmp.")) continue;
                properties2.setProperty(string2.substring(11), properties.getProperty(string2));
                bl = true;
            }
            if (!bl || string == null) continue;
            hashMap.put(string, properties2);
        }
        return hashMap;
    }

    public static Iterator getAllDeviceProperties() {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        String string = System.getProperty("storade.propsSaveDir") + File.separator + "device";
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf(".properties");
                if (n2 > 0) {
                    String string2 = stringArray[n].substring(0, n2);
                    Properties properties = DevInfo.getDeviceProperties(string2);
                    arrayList.add(properties);
                }
                ++n;
            }
        }
        return arrayList.iterator();
    }

    private static void makeMap() {
        String string = System.getProperty("storade.propsSaveDir") + File.separator + "device";
        devMap = new Properties();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2;
                String string3;
                Properties properties;
                int n2 = stringArray[n].indexOf(".properties");
                if (n2 > 0 && (properties = DevInfo.getDeviceProperties(string3 = stringArray[n].substring(0, n2))) != null && (string2 = properties.getProperty("CLASS_NAME")) != null) {
                    devMap.setProperty(string2, string3);
                }
                ++n;
            }
        }
    }

    static {
        tags = new HashMap();
    }

    public static class Test
    extends UnitTest {
        protected void init() {
            String string = System.getProperty("WORKSPACE");
            System.setProperty("storade.propsSaveDir", string + "/platform/properties");
        }

        public void test() {
            DevInfo.makeMap();
            this.assertNotNull(DevInfo.getDeviceProperties("fake"));
            this.assertEquals("CIM_System", DevInfo.getDeviceProperty("test", "CLASS_NAME"));
            Properties properties = DevInfo.getDevicePropertiesByClassName("CIM_System");
            this.assertEquals("com.sun.jade.device.test", properties.getProperty("BASE_PACKAGE"));
            DevInfo.getProbeableTypes();
            DevInfo.getMapForCategory();
            DevInfo.getMapForSnmpProbe();
            DevInfo.getAllDeviceProperties();
        }
    }

    public static interface Props {
        public static final String BASE_PACKAGE = "BASE_PACKAGE";
        public static final String CATEGORY = "CATEGORY";
        public static final String CAPTION = "CAPTION";
        public static final String CAPTION_LONG = "CAPTION_LONG";
        public static final String CLASS_NAME = "CLASS_NAME";
        public static final String RESOURCE_TYPE = "RESOURCE_TYPE";
        public static final String RESOURCE_MODEL = "RESOURCE_MODEL";
        public static final String TYPE = "TYPE";
        public static final String MF_CLASS = "MF.class";
        public static final String PROBE_CLASS = "Probe.class";
        public static final String MODEL_ASSET = "Model.Asset";
        public static final String MODEL_HEALTH = "Model.Health";
        public static final String POLICY_GROUP = "PolicyGroup.properties";
    }
}

