/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.util;

import com.sun.jade.util.unittest.UnitTest;

public final class Hex {
    private static final String sccs_id = "@(#)Hex.java\t1.2 10/10/01 SMI";

    private Hex() {
    }

    public static String toHexString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 1L;
        if (l > 0L) {
            long l3 = l2 << 60;
            while (l3 > l2) {
                if (l >= l3) break;
                stringBuffer.append('0');
                l3 >>= 4;
            }
        }
        stringBuffer.append(Long.toHexString(l));
        return stringBuffer.toString();
    }

    public static String toHexString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            int n2 = 0x10000000;
            while (n2 > 1) {
                if (n >= n2) break;
                stringBuffer.append('0');
                n2 >>= 4;
            }
        }
        stringBuffer.append(Integer.toHexString(n));
        return stringBuffer.toString();
    }

    public static String toHexString(short s) {
        int n = s & 0xFFFF;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 128;
        while (n2 > 1) {
            if (n < n2) {
                stringBuffer.append('0');
            }
            n2 >>= 1;
        }
        stringBuffer.append(Integer.toHexString(n));
        return stringBuffer.toString();
    }

    public static String toHexString(byte by) {
        int n = by & 0xFF;
        if (by < 16) {
            return "0" + Integer.toHexString(n);
        }
        return Integer.toHexString(n);
    }

    public static String dumpBlock(byte[] byArray, int n) {
        int n2 = 16;
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = (char)(byArray[n4] & 0xFF);
            if (c < '\u0010') {
                stringBuffer2.append('0');
            }
            stringBuffer2.append(Integer.toHexString(c));
            stringBuffer2.append(' ');
            if (c >= ' ' && c <= '\u007f' || Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer3.append(c);
            } else {
                stringBuffer3.append('.');
            }
            if (++n3 >= n2 || n4 == n - 1) {
                while (n3++ < n2) {
                    stringBuffer2.append("   ");
                }
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append(' ');
                stringBuffer.append(stringBuffer3.toString());
                stringBuffer.append('\n');
                stringBuffer2.setLength(0);
                stringBuffer3.setLength(0);
                n3 = 0;
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            String string = "210100e08b23f326";
            long l = Long.parseLong(string, 16);
            String string2 = "100000c0dd006fd7";
            long l2 = Long.parseLong(string2, 16);
            String string3 = "60020f2000003ee5";
            long l3 = Long.parseLong(string3, 16);
            String string4 = "000000c0dd006fd6";
            long l4 = Long.parseLong(string4, 16);
            this.assertEquals("210100e0", Hex.toHexString(553713888));
            this.assertEquals("87654321", Hex.toHexString(-2023406815));
            this.assertEquals("00123456", Hex.toHexString(1193046));
            this.assertEquals(string, Hex.toHexString(l));
            this.assertEquals(string2, Hex.toHexString(l2));
            this.assertEquals(string3, Hex.toHexString(l3));
            this.assertEquals(string4, Hex.toHexString(l4));
        }
    }
}

