/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.snmp;

import com.sun.jade.device.protocol.snmp.RFC1213_MIBOidTable;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpEventReportDispatcher;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;
import javax.management.snmp.manager.SnmpTrapListener;

public class TrapListener {
    private static int defaultListenPort = 8162;
    public static final String sccs_id = "@(#)TrapListener.java\t1.2 06/18/02 SMI";

    public static void main(String[] stringArray) {
        TrapListener trapListener = new TrapListener(stringArray[0], "61");
    }

    public TrapListener(String string, String string2) {
        try {
            this.init(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void init(String string, String string2) throws SnmpStatusException, UnknownHostException, SocketException {
        int n;
        RFC1213_MIBOidTable rFC1213_MIBOidTable = new RFC1213_MIBOidTable();
        SnmpOid.setSnmpOidTable((SnmpOidTable)rFC1213_MIBOidTable);
        SnmpPeer snmpPeer = new SnmpPeer(string);
        SnmpParameters snmpParameters = new SnmpParameters("public", "private");
        snmpPeer.setSnmpParam(snmpParameters);
        SnmpSession snmpSession = new SnmpSession("SyncManager session");
        snmpSession.setDefaultPeer(snmpPeer);
        SnmpEventReportDispatcher snmpEventReportDispatcher = new SnmpEventReportDispatcher(defaultListenPort);
        snmpEventReportDispatcher.addTrapListener((SnmpTrapListener)new TrapListenerImpl());
        new Thread((Runnable)snmpEventReportDispatcher).start();
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SyncManager varbind list");
        snmpVarBindList.addVarBind("sysDescr.0");
        SnmpRequest snmpRequest = snmpSession.snmpGetRequest(null, snmpVarBindList);
        boolean bl = snmpRequest.waitForCompletion(10000L);
        if (!bl) {
            System.out.println("Request timed out. Check reachability of agent");
            System.exit(0);
        }
        if ((n = snmpRequest.getErrorStatus()) != 0) {
            System.out.println("Error status = " + SnmpRequest.snmpErrorToString((int)n));
            System.out.println("Error index = " + snmpRequest.getErrorIndex());
            System.exit(0);
        }
        SnmpVarBindList snmpVarBindList2 = snmpRequest.getResponseVarBindList();
        System.out.println("Result: \n" + snmpVarBindList2);
    }

    public class TrapListenerImpl
    implements SnmpTrapListener {
        public void processSnmpTrapV1(SnmpPduTrap snmpPduTrap) {
            System.out.println("NOTE: TrapListenerImpl received trap :");
            System.out.println("\tGeneric " + snmpPduTrap.genericTrap);
            System.out.println("\tSpecific " + snmpPduTrap.specificTrap);
            System.out.println("\tTimeStamp " + snmpPduTrap.timeStamp);
            System.out.println("\tAgent address " + snmpPduTrap.agentAddr.stringValue());
        }

        public void processSnmpTrapV2(SnmpPduRequest snmpPduRequest) {
            System.out.println("NOTE: Trap V2 ignored");
        }
    }
}

