/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.snmp;

import com.sun.jade.apps.discovery.Probe;
import com.sun.jade.device.protocol.snmp.RFC1213_MIBOidTable;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.util.log.Report;
import com.sun.jdmk.snmp.SnmpOidTableSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class SNMP
implements Probe {
    private static int TIMEOUT = 60000;
    private static String snmpProbeType = "snmp";
    private static SnmpOidTableSupport oidTable = null;
    private static String[] varNames = new String[]{"sysDescr", "sysName", "sysObjectID", "sysContact", "sysLocation"};
    private int timeout;
    private static SnmpSession session = null;
    private static final String sccs_id = "@(#)SNMP.java\t1.12 01/30/03 SMI";

    public SNMP() {
        this.timeout = TIMEOUT;
        session = SingleSnmpSession.getSnmpSession();
    }

    public SNMP(int n) {
        this.timeout = n;
        session = SingleSnmpSession.getSnmpSession();
    }

    public Iterator probe(String string) {
        Object object;
        int n = string.indexOf(47);
        int n2 = 1;
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(0, n);
            object = string.substring(n + 1);
            n2 = Integer.parseInt((String)object);
        }
        object = null;
        try {
            object = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        byte[] byArray = ((InetAddress)object).getAddress();
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = this.getIpAddr(byArray);
            Properties properties = this.getBaseProperties(string3);
            if (properties != null) {
                arrayList.add(properties);
            }
            this.nextIpAddr(byArray);
            ++n3;
        }
        return arrayList.iterator();
    }

    private String getIpAddr(byte[] byArray) {
        return "" + (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private void nextIpAddr(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        if (n == 255) {
            byArray[3] = 0;
            int n2 = byArray[2] & 0xFF;
            byArray[2] = n2 == 255 ? (byte)0 : (byte)(++n2);
        } else {
            byArray[3] = (byte)(++n);
        }
    }

    public String[] getProbeProperties() {
        return varNames;
    }

    public String getProbeType() {
        return snmpProbeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getBaseProperties(String string) {
        SnmpRequest snmpRequest;
        SnmpPeer snmpPeer;
        InetAddress inetAddress;
        Properties properties;
        block25: {
            Properties properties2;
            block24: {
                properties = new Properties();
                inetAddress = null;
                if (oidTable == null) {
                    oidTable = new RFC1213_MIBOidTable();
                }
                SnmpOid.setSnmpOidTable((SnmpOidTable)oidTable);
                snmpPeer = null;
                snmpRequest = null;
                boolean bl = false;
                try {
                    snmpPeer = new SnmpPeer(string);
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    Report.error.log(unknownHostException, (Object)"host not found");
                    return null;
                }
                try {
                    try {
                        block23: {
                            Properties properties3;
                            SnmpParameters snmpParameters = new SnmpParameters("public", "private");
                            snmpPeer.setSnmpParam(snmpParameters);
                            session.setDefaultPeer(snmpPeer);
                            SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SNMP.BaseProperties");
                            int n = 0;
                            while (true) {
                                if (n >= varNames.length) {
                                    snmpRequest = session.snmpGetRequest(snmpPeer, null, snmpVarBindList);
                                    bl = snmpRequest.waitForCompletion((long)this.timeout);
                                    if (!bl) {
                                        Report.debug.log("Returning from Completed = false for IP " + string);
                                        properties3 = null;
                                        Object var16_15 = null;
                                        if (snmpRequest != null) {
                                            snmpRequest = null;
                                        }
                                        if (snmpPeer == null) break;
                                        return properties3;
                                    }
                                    break block23;
                                }
                                snmpVarBindList.addVarBind(varNames[n] + ".0");
                                ++n;
                            }
                            return properties3;
                        }
                        int n = snmpRequest.getErrorStatus();
                        if (n != 0) {
                            if (snmpRequest.getErrorIndex() != 0) {
                                Report.error.log("Error status = " + SnmpRequest.snmpErrorToString((int)n));
                                Report.error.log("Error index = " + snmpRequest.getErrorIndex());
                            }
                            Report.debug.log("Returning from errorStatus for IP " + string);
                            properties2 = null;
                            break block24;
                        }
                        SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
                        int n2 = snmpVarBindList.getVarBindCount();
                        int n3 = 0;
                        while (n3 < n2) {
                            SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n3);
                            if (snmpVarBind != null && snmpVarBind.isValidValue()) {
                                properties.setProperty(varNames[n3], snmpVarBind.getStringValue());
                            }
                            ++n3;
                        }
                        break block25;
                    }
                    catch (SnmpStatusException snmpStatusException) {
                        Report.error.log(snmpStatusException.getLocalizedMessage(), (Object)"SNMP error");
                        Properties properties4 = null;
                        Object var16_18 = null;
                        if (snmpRequest != null) {
                            snmpRequest = null;
                        }
                        if (snmpPeer != null) {
                            return properties4;
                        }
                        return properties4;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    if (snmpRequest != null) {
                        snmpRequest = null;
                    }
                    if (snmpPeer != null) {
                        snmpPeer = null;
                    }
                    throw throwable;
                }
            }
            Object var16_16 = null;
            if (snmpRequest != null) {
                snmpRequest = null;
            }
            if (snmpPeer != null) {
                return properties2;
            }
            return properties2;
        }
        Object var16_17 = null;
        if (snmpRequest != null) {
            snmpRequest = null;
        }
        if (snmpPeer != null) {
            snmpPeer = null;
        }
        properties.setProperty("ipno", inetAddress.getHostAddress());
        properties.setProperty("ip", inetAddress.getCanonicalHostName());
        return properties;
    }

    public static void main(String[] stringArray) {
        SNMP sNMP = new SNMP();
        Iterator iterator = sNMP.probe(stringArray[0]);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
    }
}

