/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.http;

import com.sun.jade.util.unittest.UnitTest;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;

public class HttpReply {
    private Properties p;
    private Reader in;
    private String version;
    private String responseCode;
    private String description;
    private static final String NEWLINE = "\r\n";
    public static final String sccs_id = "@(#)HttpReply.java\t1.2 11/05/02 SMI";

    public HttpReply(Reader reader) {
        this.in = reader;
    }

    public Properties readHeader() throws IOException {
        this.p = new Properties();
        this.parseHeader(this.getLine());
        String string;
        while ((string = this.getLine()).length() != 0) {
            int n = string.indexOf(58);
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 2);
                this.p.setProperty(string2, string3);
                continue;
            }
            this.p.setProperty(string, "");
        }
        return this.p;
    }

    public String getProperty(String string) {
        return this.p.getProperty(string);
    }

    public int getResponseCode() {
        try {
            return Integer.parseInt(this.responseCode);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void parseHeader(String string) {
        int n = string.indexOf(" ");
        if (n > 0) {
            this.version = string.substring(0, n);
            String string2 = string.substring(n + 1);
            int n2 = string2.indexOf(" ");
            if (n2 > 0) {
                this.description = string2.substring(n2 + 1);
                this.responseCode = string2.substring(0, n2);
            } else {
                this.responseCode = string2;
            }
        } else {
            this.version = string;
        }
    }

    private String getLine() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = this.in.read()) == 13) {
                    continue;
                }
                if (n != 10 && n != -1) {
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            String string = "HTTP/1.0 401 Unauthorized\r\nblah: ok\r\n\r\n";
            StringReader stringReader = new StringReader(string);
            HttpReply httpReply = new HttpReply(stringReader);
            httpReply.readHeader();
            this.assertEquals("ok", httpReply.getProperty("blah"));
            this.assertCondition(401 == httpReply.getResponseCode());
        }
    }
}

