/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.device.protocol.agent.AgentCommand;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import com.sun.jade.util.unittest.UnitTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class DiagnosticRunCommand
implements AgentCommand {
    private static final String NAME = "/rashttp?GO=Client::Diag::run";
    private ArrayList options;
    private String keyOption;
    private String testOption;
    public static final String sccs_id = "@(#)DiagnosticRunCommand.java\t1.3 09/05/02 SMI";

    public DiagnosticRunCommand(String string, String string2) {
        this.keyOption = "&key=" + string;
        this.testOption = "&test=" + string2;
    }

    public void addOption(String string, String string2) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        String string3 = string2;
        try {
            string3 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.options.add("&opt_" + string + "=" + string3);
    }

    public String getRequest() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NAME);
        if (this.keyOption != null) {
            stringBuffer.append(this.keyOption);
        }
        if (this.testOption != null) {
            stringBuffer.append(this.testOption);
        }
        if (this.options != null) {
            int n = 0;
            while (n < this.options.size()) {
                stringBuffer.append(this.options.get(n));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getType() {
        return "GET";
    }

    public static class Test
    extends UnitTest {
        public void test() {
            DiagnosticRunCommand diagnosticRunCommand = new DiagnosticRunCommand("dev", "tst");
            diagnosticRunCommand.addOption("a", "A");
            diagnosticRunCommand.addOption("b", "B B");
            this.assertEquals(diagnosticRunCommand.getType(), "GET");
            this.assertEquals(diagnosticRunCommand.getRequest(), "/rashttp?GO=Client::Diag::run&key=dev&test=tst&opt_a=A&opt_b=B+B");
        }

        public static void main(String[] stringArray) {
            int n = 7654;
            if (stringArray.length < 3) {
                System.out.println("Usage Test <host> <device> <test> [opt=value]");
                System.exit(1);
            }
            HTTPConnection hTTPConnection = new HTTPConnection(stringArray[0], n);
            DiagnosticRunCommand diagnosticRunCommand = new DiagnosticRunCommand(stringArray[1], stringArray[2]);
            int n2 = 3;
            while (n2 < stringArray.length) {
                int n3 = stringArray[n2].indexOf(61);
                String string = stringArray[n2].substring(0, n3);
                String string2 = stringArray[n2].substring(n3 + 1);
                diagnosticRunCommand.addOption(string, string2);
                ++n2;
            }
            System.out.println(hTTPConnection.sendCommand(diagnosticRunCommand));
        }
    }
}

