/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.EventsPersistence;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.protocol.agent.AgentEvent;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;

public abstract class AgentEventConverter {
    protected static void postStateChangeEvent(AgentEvent agentEvent, String string, CIMBean cIMBean, CIMBean cIMBean2) {
        String string2 = EventConstants.SOURCE_PREFIX + agentEvent.getEventHost() + "." + agentEvent.getStorAdeVersion();
        ModificationEventData modificationEventData = new ModificationEventData(agentEvent.getSeverity(), string2, cIMBean2.getCIMObjectPath().toString(), string, "StateChange", "device", cIMBean, cIMBean2);
        modificationEventData.setEventID(agentEvent.getEventID());
        modificationEventData.setSourceSequenceNumber(agentEvent.getSourceSequenceNumber());
        modificationEventData.setSubjectTime(agentEvent.getEventTime());
        modificationEventData.setDescription(agentEvent.getDescription());
        modificationEventData.setEventCode(agentEvent.getEventCode());
        EventGenerator.generateEvent(modificationEventData);
    }

    protected static void postStateChangeAlert(AgentEvent agentEvent, String string, String string2, MessageCode messageCode, String[] stringArray, String string3) {
        String string4 = EventConstants.SOURCE_PREFIX + agentEvent.getEventHost() + "." + agentEvent.getStorAdeVersion();
        AlertEventData alertEventData = new AlertEventData(agentEvent.getSeverity(), string4, string2, string, "StateChangeAlert", "other", null);
        alertEventData.setCorrelatedEvents(stringArray);
        alertEventData.setEventID(agentEvent.getEventID() + ".a");
        alertEventData.setSourceSequenceNumber(agentEvent.getSourceSequenceNumber());
        alertEventData.setSubjectTime(agentEvent.getEventTime());
        alertEventData.setDescription(agentEvent.getDescription());
        alertEventData.setEventCode(agentEvent.getEventCode());
        alertEventData.setSubjectEnclosureIP(string3);
        if (messageCode != null) {
            alertEventData.setDescription(messageCode.getLocalizedStringMessage());
            LocalizedString localizedString = messageCode.getLocalizedStringProperty("probableCause");
            LocalizedString localizedString2 = messageCode.getLocalizedStringProperty("recommendedAction");
            LocalizedString[] localizedStringArray = null;
            if (localizedString != null) {
                localizedStringArray = new LocalizedString[]{localizedString};
            }
            LocalizedString[] localizedStringArray2 = null;
            if (localizedString2 != null) {
                localizedStringArray2 = new LocalizedString[]{localizedString2};
            }
            AlertEventData.CauseInformation[] causeInformationArray = null;
            causeInformationArray = new AlertEventData.CauseInformation[]{new AlertEventData.CauseInformation(localizedStringArray, localizedStringArray2)};
            alertEventData.setCauseInformation(causeInformationArray);
        }
        EventGenerator.generateEvent(alertEventData);
    }

    protected static void postComponentAdditionEvent(AgentEvent agentEvent, String string, MessageCode messageCode, CIMBean[] cIMBeanArray) {
        String string2 = EventConstants.SOURCE_PREFIX + agentEvent.getEventHost() + "." + agentEvent.getStorAdeVersion();
        String string3 = null;
        int n = 0;
        while (n < cIMBeanArray.length) {
            if (cIMBeanArray[n] instanceof CIM_LogicalDevice) {
                string3 = cIMBeanArray[n].getCIMObjectPath().toString();
                break;
            }
            ++n;
        }
        if (string3 != null) {
            DefinitionEventData definitionEventData = new DefinitionEventData(2, string2, string3, string, "ComponentAddition", "device", cIMBeanArray);
            definitionEventData.setDescription(messageCode.getLocalizedStringMessage());
            EventGenerator.generateEvent(definitionEventData);
        } else {
            Report.error.log("No logical device in event payload. " + agentEvent.getDeepestCaption());
        }
    }

    protected static void postComponentRemovalEvent(AgentEvent agentEvent, String string, MessageCode messageCode, CIMBean[] cIMBeanArray) {
        String string2 = EventConstants.SOURCE_PREFIX + agentEvent.getEventHost() + "." + agentEvent.getStorAdeVersion();
        String string3 = null;
        int n = 0;
        while (n < cIMBeanArray.length) {
            if (cIMBeanArray[n] instanceof CIM_LogicalDevice) {
                string3 = cIMBeanArray[n].getCIMObjectPath().toString();
                break;
            }
            ++n;
        }
        if (string3 != null) {
            DeletionEventData deletionEventData = new DeletionEventData(2, string2, string3, string, "ComponentRemoval", "device", cIMBeanArray);
            deletionEventData.setDescription(messageCode.getLocalizedStringMessage());
            EventGenerator.generateEvent(deletionEventData);
        } else {
            Report.error.log("No logical device in event payload. " + agentEvent.getDeepestCaption());
        }
    }

    protected static void postCommunicationEvent(AgentEvent agentEvent, String string, CIMBean cIMBean, CIMBean cIMBean2) {
        String string2 = EventConstants.SOURCE_PREFIX + agentEvent.getEventHost() + "." + agentEvent.getStorAdeVersion();
        ModificationEventData modificationEventData = new ModificationEventData(agentEvent.getSeverity(), string2, cIMBean2.getCIMObjectPath().toString(), string, "CommunicationStateChange", "device", cIMBean, cIMBean2);
        modificationEventData.setEventID(agentEvent.getEventID());
        modificationEventData.setSourceSequenceNumber(agentEvent.getSourceSequenceNumber());
        modificationEventData.setSubjectTime(agentEvent.getEventTime());
        modificationEventData.setDescription(agentEvent.getDescription());
        modificationEventData.setEventCode(agentEvent.getEventCode());
        EventGenerator.generateEvent(modificationEventData);
    }

    protected static String clearAlert(String string) {
        Report.debug.log("ConvertSA22", (Object)("Clearing Alert, subject = " + string));
        String string2 = null;
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            EventsPersistence eventsPersistence = persistenceService.getEventsPersistence();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            Object object = eventsPersistence.retrieveLastEventBySubject(string, -1, 2, 3);
            if (object != null) {
                Report.debug.log("ConvertSA22", (Object)"Found an alarm in persistence....");
                Alarm alarm = (Alarm)object;
                NSMEvent nSMEvent = alarm.getEvent();
                string2 = nSMEvent.getEventID();
                Report.debug.log("ConvertSA22", (Object)("Attempting to clear an Alarm.  Event ID = " + string2));
                alarm.setIsCleared(true);
                alarm.setClearTime(System.currentTimeMillis());
                genericPersistence.updateAlarm(alarm);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Unable to clear the alarm");
        }
        return string2;
    }
}

