/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.device.protocol.agent.ConversionHelper;
import com.sun.jade.util.locale.LocalizedString;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class AgentEvent {
    private Properties properties;
    private AgentEvent originalEvent;
    public static final String ACTIONABLE = "Actionable";
    public static final String CAPTION = "Caption";
    public static final String COMPONENT = "Component";
    public static final String CURRENTSTATE = "CurrentState";
    public static final String CURRENTVALUE = "CurrentValue";
    public static final String DATATYPE = "DataType";
    public static final String DEBUGLEVEL = "DebugLevel";
    public static final String DESCRIPTION = "Description";
    public static final String EVENTGROUPID = "EventGroupId";
    public static final String EVENTID = "EventId";
    public static final String EVENTSOURCE = "EventSource";
    public static final String EVENTTIME = "EventTime";
    public static final String EVENTTYPE = "EventType";
    public static final String MGMTLEVEL = "MgmtLevel";
    public static final String PRIORSTATE = "PriorState";
    public static final String PRIORVALUE = "PriorValue";
    public static final String RUNID = "RunId";
    public static final String SEVERITY = "Severity";
    public static final String SOLUTIONID = "SolutionId";
    public static final String SOURCEIP = "SourceIP";
    public static final String TARGET = "Target";
    public static final String TARGETNAME = "TargetName";
    public static final String VERSION = "Version";
    public static final String CATEGORY = "category";
    public static final String GRID_ACTION = "grid_action";
    public static final String GRID_CAUSE = "grid_cause";
    public static final String GRID_CODE = "grid_code";
    public static final String GRID_INFO = "grid_info";
    public static final String RENV_VERSION = "renv_version";
    public static final String SOURCE = "source";
    public static final String PAYLOAD = "payload";
    public static final String ORIGINALEVENT = "OriginalEvent";
    public static final String sccs_id = "@(#)AgentEvent.java\t1.16 12/09/02 SMI";

    public AgentEvent(Properties properties) {
        this.properties = properties;
        this.originalEvent = ConversionHelper.getOriginalEvent(this.getProperty(ORIGINALEVENT));
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean isDerived() {
        boolean bl = false;
        if (this.originalEvent != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isActionable() {
        return this.isActionable(false);
    }

    public boolean isActionable(boolean bl) {
        boolean bl2 = "TRUE".equals(this.getProperty(ACTIONABLE));
        if (bl && this.originalEvent != null) {
            bl2 = this.originalEvent.isActionable();
        }
        return bl2;
    }

    public String getCaption() {
        return this.getProperty(CAPTION);
    }

    public String getDeepestCaption() {
        if (this.isDerived()) {
            return this.getOriginalEvent().getDeepestCaption();
        }
        return this.getProperty(CAPTION);
    }

    public String getComponent() {
        return this.getProperty(COMPONENT);
    }

    public String getEventDevice() {
        String string = this.getProperty(EVENTTYPE);
        String string2 = null;
        try {
            int n = string.indexOf(".");
            if (n > 0) {
                string2 = string.substring(0, n);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    public String getEventType() {
        String string;
        block22: {
            int n;
            String string2 = this.getProperty(EVENTTYPE);
            string = "unknown";
            if (string2 != null && (n = string2.indexOf(".")) > 0) {
                if ((string2 = string2.substring(n + 1)).equals("AlarmEvent")) {
                    string = "StateChange";
                } else if (string2.equals("StateChangeEvent")) {
                    string = "StateChange";
                } else if (string2.equals("CommunicationEstablishedEvent")) {
                    string = "CommunicationStateChange";
                } else if (string2.equals("CommunicationLostEvent")) {
                    string = "CommunicationStateChange";
                } else if (string2.equals("DiagnosticTest")) {
                    string = "DiagnosisStatus";
                } else if (string2.equals("LogEvent")) {
                    string = string2;
                } else if (string2.equals("ComponentInsertEvent")) {
                    string = "ComponentAddition";
                } else if (string2.equals("ComponentRemoveEvent")) {
                    string = "ComponentRemoval";
                } else if (string2.equals("TopologyEvent")) {
                    String string3 = this.getProperty(CAPTION);
                    try {
                        if (string3.startsWith("add")) {
                            string = "ComponentAddition";
                            break block22;
                        }
                        string = "ComponentRemoval";
                    }
                    catch (NullPointerException nullPointerException) {
                        string = string2;
                    }
                } else {
                    string = string2;
                }
            }
        }
        return string;
    }

    public int getSeverity() {
        String string = this.getProperty(SEVERITY);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case -2: 
            case 0: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    public String getEventID() {
        return this.getProperty(EVENTID);
    }

    public String getEventHost() {
        String string = this.getProperty(EVENTID);
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 3) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public long getEventTime() {
        String string = this.getProperty(EVENTTIME);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSSSSzzz");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        return date.getTime();
    }

    public String getSource() {
        return this.getProperty(SOURCE);
    }

    public String getTarget() {
        return this.getProperty(TARGET);
    }

    public String getTargetName() {
        return this.getProperty(TARGETNAME);
    }

    public long getSourceSequenceNumber() {
        String string = this.getProperty(EVENTID);
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 3) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken() + stringTokenizer.nextToken();
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public String getStorAdeVersion() {
        return this.getProperty(RENV_VERSION);
    }

    public String getEventCode() {
        String string;
        String string2 = this.getProperty(GRID_CODE);
        if (this.originalEvent != null && (string = this.originalEvent.getEventCode()) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getTopic() {
        String string = this.getProperty(GRID_CODE);
        String string2 = this.getEventType();
        String string3 = null;
        if (string2 == "StateChange") {
            string3 = ".state.update.device";
        } else if (string2 == "CommunicationStateChange") {
            string3 = ".state.update.topology.sanzonepath";
        } else if (string2 == "DiagnosisStatus") {
            string3 = "action.update.diagnosis";
        } else if (string2 == "ComponentAddition") {
            string3 = ".definition.create.fru";
        } else if (string2 == "ComponentRemoval") {
            string3 = ".definition.delete.fru";
        }
        return string3;
    }

    public AgentEvent getOriginalEvent() {
        return this.originalEvent;
    }

    public String getPayload() {
        String string = this.getProperty(PAYLOAD);
        return string;
    }

    public int getCurrentState() {
        String string = this.getProperty(CURRENTSTATE);
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int getPriorState() {
        String string = this.getProperty(PRIORSTATE);
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String getManagementLevel() {
        return this.getProperty(MGMTLEVEL);
    }

    public LocalizedString getDescription() {
        String string = this.getProperty(DESCRIPTION);
        LocalizedString localizedString = new LocalizedString(string);
        return localizedString;
    }
}

