/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.wbem;

import com.sun.jade.cim.bean.CIM_UnitaryComputerSystem;
import com.sun.jade.cim.exec.GenReport;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import java.util.Properties;

public class GenericMF
extends AbstractMF
implements ReportGenerator {
    String name;
    String ip;
    String className = "CIM_UnitaryComputerSystem";
    String description = "Generic Computer System";
    private CIM_UnitaryComputerSystem ucs;
    public static final String sccs_id = "@(#)GenericMF.java\t1.2 09/16/02 SMI";

    public GenericMF(Properties properties) {
        super(properties);
        this.ip = this.resolveIP(properties);
        this.name = properties.getProperty("name");
        this.description = properties.getProperty("description");
        if (this.name == null) {
            this.setKeys();
        }
        this.setDeviceReport(this);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        if (this.name == null) {
            this.setKeys();
        }
        return this.name;
    }

    private void setKeys() {
        if (this.ucs != null) {
            Properties properties = this.getProperties();
            this.name = this.ucs.getName();
            properties.setProperty("name", this.name);
            this.description = this.ucs.getDescription();
            properties.setProperty("description", this.description);
            this.updateDeviceConfig();
        }
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        if (this.description == null) {
            this.setKeys();
        }
        return new LocalizedString(this.description);
    }

    public synchronized String generateReport() {
        try {
            Properties properties = this.getProperties();
            GenReport genReport = new GenReport(this.ip, properties.getProperty("user"), properties.getProperty("password"));
            String string = genReport.toXML();
            this.ucs = genReport.getUCSystem();
            genReport.close();
            return string;
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error creating report.");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<report ReturnCode='FAILURE'>");
            stringBuffer.append("<exception>");
            stringBuffer.append(exception.toString());
            stringBuffer.append("</exception>");
            stringBuffer.append("</report>");
            return stringBuffer.toString();
        }
    }
}

