/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.service;

import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.topology.lib.TopologyHelper;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.host.diags.STTest;
import com.sun.jade.device.host.service.HostModel;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.ui.topology.tree.TreeNode;
import com.sun.jade.util.Config;
import com.sun.jade.util.ConfigProperties;
import com.sun.jade.util.locale.LocalizedMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class AgentHostMF
extends AbstractMF
implements HostModel,
ReportGenerator {
    private ServiceHelper[] helpers;
    private Properties hostProp;
    private String name;
    private String ip;
    private int portNum = 7655;
    private boolean diagsAdded;
    private static final String sccs_id = "@(#)AgentHostMF.java\t1.5 03/28/02 SMI";

    public AgentHostMF(Properties properties) {
        super(properties);
        String string;
        this.hostProp = properties;
        this.ip = properties.getProperty("ip");
        this.name = properties.getProperty("hostname");
        if (this.name == null) {
            this.name = this.ip;
        }
        if ((string = properties.getProperty("port")) != null) {
            try {
                this.portNum = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setDeviceReport(this);
        this.addDiagnostics();
    }

    public String getClassName() {
        return "CIM_UnitaryComputerSystem";
    }

    public String getName() {
        return this.name;
    }

    public LocalizedMessage getCaption() {
        return null;
    }

    public LocalizedMessage getDescription() {
        return null;
    }

    public String generateReport() {
        Properties properties = new Properties();
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            URL uRL = new URL("http", this.ip, this.portNum, "/Storade/getReport");
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                int n2 = 0;
                while (n2 < n) {
                    stringWriter.write(byArray[n2]);
                    ++n2;
                }
            }
            inputStream.close();
            if (!this.diagsAdded) {
                this.addDiagnostics();
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("<report ReturnCode='FAILURE'>");
            stringBuffer.append("<exception>");
            stringBuffer.append(iOException.toString());
            stringBuffer.append("</exception>");
            stringBuffer.append("</report>");
            return stringBuffer.toString();
        }
    }

    private void addDiagnostics() {
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            URL uRL = new URL("http", this.ip, this.portNum, "/Storade/getTestList");
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                int n2 = 0;
                while (n2 < n) {
                    stringWriter.write(byArray[n2]);
                    ++n2;
                }
            }
            StringReader stringReader = new StringReader(stringWriter.toString());
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            Config config = new Config();
            config.load(bufferedReader);
            Iterator iterator = config.getConfigProperties().iterator();
            while (iterator.hasNext()) {
                ConfigProperties configProperties = (ConfigProperties)iterator.next();
                STTest sTTest = new STTest(configProperties, this.ip, this.portNum);
                this.addDiagnosticTest(sTTest);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        this.diagsAdded = true;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            ReferenceForMSE referenceForMSE;
            DiagnosticTestInfo[] diagnosticTestInfoArray;
            Object object3;
            if (stringArray.length != 1) {
                System.out.println("Usage HostMF <host>");
                System.exit(1);
            }
            Properties properties = new Properties();
            properties.setProperty("ip", stringArray[0]);
            properties.setProperty("discovered", "now");
            AgentHostMF agentHostMF = new AgentHostMF(properties);
            System.out.println(agentHostMF.generateReport());
            TopologyHelper topologyHelper = (TopologyHelper)agentHostMF.getServiceHelper("com.sun.jade.apps.topology.lib.TopologyHelper");
            if (topologyHelper == null) {
                System.out.println("No topology");
            } else {
                object3 = topologyHelper.getTree();
                if (object3 != null && (diagnosticTestInfoArray = object3.getRoots()) != null) {
                    while (diagnosticTestInfoArray.hasNext()) {
                        TreeNode treeNode = (TreeNode)diagnosticTestInfoArray.next();
                        if (treeNode == null) continue;
                        referenceForMSE = (ReferenceForMSE)treeNode.getUserObject();
                        System.out.println(referenceForMSE.toString() + "\n");
                        object2 = treeNode.getChildren();
                        if (object2 == null) continue;
                        while (object2.hasNext()) {
                            object = (TreeNode)object2.next();
                            ReferenceForMSE referenceForMSE2 = (ReferenceForMSE)object.getUserObject();
                            System.out.println("\t" + referenceForMSE2.toString());
                        }
                    }
                }
            }
            object3 = (DiagnosableHelper)agentHostMF.getServiceHelper("com.sun.jade.apps.diags.lib.DiagnosableHelper");
            diagnosticTestInfoArray = null;
            if (object3 == null) {
                System.out.println("No DiagnosableHelper");
                return;
            }
            diagnosticTestInfoArray = object3.getDiagnosticTests();
            if (diagnosticTestInfoArray == null) {
                System.out.println("No dti");
                return;
            }
            int n = 0;
            while (n < diagnosticTestInfoArray.length) {
                referenceForMSE = new ReferenceForMSE(diagnosticTestInfoArray[n].getMSE());
                object2 = referenceForMSE.getCreationClassName();
                object = referenceForMSE.getKeyValue();
                System.out.println("Diagnostic Test = " + diagnosticTestInfoArray[n].getTestName() + "\n");
                System.out.println(" System=" + referenceForMSE.getSystemName() + " MSE=" + referenceForMSE.getKeyValue() + "\n");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

