/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.host.diags;

import com.sun.jade.apps.command.CommandClient;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.diag.param.HaltOnErrorParameter;
import com.sun.jade.cim.diag.param.PercentOfTestCoverageParameter;
import com.sun.jade.cim.diag.param.QuickModeParameter;
import com.sun.jade.cim.diag.param.ReportSoftErrorsParameter;
import com.sun.jade.cim.diag.param.ReportStatusMessagesParameter;
import com.sun.jade.cim.diag.param.TestWarningLevelParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.host.diags.STTest;
import com.sun.jade.util.locale.LocalizedString;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;

class STTestExecutable
implements TestExecutable {
    static final String RETURN_TAG = "@ReturnCode=";
    private String command;
    private DiagnosticResult result;
    private STTest test;
    private ReferenceForMSE mse;
    private DiagnosticSetting setting;
    private int warnLevel;
    private boolean reportStatus;
    private boolean reportErrors;
    private boolean haltOnError;
    private boolean isQuick;
    private int percentCover = 100;
    private static final String sccs_id = "@(#)STTestExecutable.java\t1.3 01/14/02 SMI";

    STTestExecutable(STTest sTTest, ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        this.test = sTTest;
        this.mse = referenceForMSE;
        this.setting = diagnosticSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        this.result = diagnosticResult;
        InputStream inputStream = null;
        this.parseSettings();
        Properties properties = new Properties();
        CommandClient commandClient = new CommandClient(this.test.getHost(), this.test.getPort());
        inputStream = commandClient.issueCommand("/Storade/testExec", this.command, properties);
        int n = -1;
        String string = null;
        while (true) {
            String string2;
            if ((string2 = this.getLine(inputStream)) == null) {
                if (n == 0) {
                    diagnosticResult.setFinalResults(TestState.PASSED);
                }
                if (string != null) break;
                diagnosticResult.setFinalResults(TestState.FAILED, "Communication lost with host.");
                break;
            }
            if (string2.startsWith(RETURN_TAG)) {
                string = string2.substring(RETURN_TAG.length());
                n = Integer.parseInt(string);
            }
            if (!this.reportStatus) continue;
            diagnosticResult.addTestResults(string2);
        }
        Object var9_10 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                LocalizedString localizedString = new LocalizedString(exception);
                diagnosticResult.setFinalResults(TestState.FAILED, localizedString.toString());
                Object var9_11 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        return false;
    }

    public DiagnosticSetting getDiagnosticSetting() {
        return this.setting;
    }

    public ReferenceForMSE getMSE() {
        return this.mse;
    }

    public ReferenceForMSE getExclusiveMSE() {
        return this.mse;
    }

    private void parseSettings() {
        this.warnLevel = this.setting.getTestWarningLevelValue();
        this.reportStatus = this.setting.getReportStatusMessagesValue();
        this.reportErrors = this.setting.getReportSoftErrorsValue();
        this.haltOnError = this.setting.getHaltOnErrorValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("test=");
        stringBuffer.append(this.test.getTestName());
        stringBuffer.append("\n");
        stringBuffer.append("options=");
        if (!this.haltOnError) {
            stringBuffer.append("-r ");
        }
        if (this.reportStatus) {
            stringBuffer.append("-v ");
        }
        stringBuffer.append(" -o \"dev=");
        stringBuffer.append(this.mse.getKeyValue());
        Vector vector = this.setting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            TestParameter testParameter = (TestParameter)vector.get(n);
            this.addParamToCmd(testParameter, stringBuffer);
            ++n;
        }
        stringBuffer.append("\"");
        this.command = stringBuffer.toString();
    }

    private void addParamToCmd(TestParameter testParameter, StringBuffer stringBuffer) {
        if (testParameter instanceof HaltOnErrorParameter) {
            return;
        }
        if (testParameter instanceof ReportSoftErrorsParameter) {
            return;
        }
        if (testParameter instanceof ReportStatusMessagesParameter) {
            return;
        }
        if (testParameter instanceof TestWarningLevelParameter) {
            return;
        }
        if (testParameter instanceof QuickModeParameter) {
            return;
        }
        if (testParameter instanceof PercentOfTestCoverageParameter) {
            return;
        }
        stringBuffer.append("|");
        stringBuffer.append(testParameter.getName());
        stringBuffer.append("=");
        stringBuffer.append(testParameter.getCurrentValue().toString());
    }

    private String getLine(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read()) == 13) {
                    continue;
                }
                if (n != 10 && n != -1) {
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

