/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.util;

import com.sun.jade.util.Util;
import com.sun.jade.util.log.Report;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CIMSchemaLocalizer {
    private static Hashtable cachedKeys = new Hashtable();
    private static Hashtable cachedValues = new Hashtable();
    private static final String NULL_FULLY_QUALIFIED_NAME = "-";
    private static final String ATTR_DELIMITER = "#";
    private static final String KV_DELIMITER = ",";
    private static final String VALUES_PROP = "values";
    private static final String KEYS_PROP = "keys";
    private static String TAG = "CIMSchemaLocalizer";
    public static final String sccs_id = "@(#)CIMSchemaLocalizer.java\t1.2 03/15/02 SMI";

    public static Object[][] localizeData(String[] stringArray, Object[][] objectArray, Locale locale) throws IllegalArgumentException {
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("data length is 0");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].length != stringArray.length) {
                throw new IllegalArgumentException("Length of data array (" + objectArray[n].length + ") and number of fullyQualifiedNames (" + stringArray.length + ") does not match.");
            }
            ++n;
        }
        Object[][] objectArray2 = new Object[objectArray.length][];
        CIMSchemaLocalizer.copyData(objectArray, objectArray2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            CIMSchemaLocalizer.validateFullyQualifiedName(stringArray[n2]);
            if (CIMSchemaLocalizer.hasLocalization(stringArray[n2], locale)) {
                Object[] objectArray3 = new Object[objectArray.length];
                int n3 = 0;
                while (n3 < objectArray.length) {
                    objectArray3[n3] = objectArray[n3][n2];
                    ++n3;
                }
                objectArray3 = CIMSchemaLocalizer.localizeData(stringArray[n2], objectArray3, locale);
                int n4 = 0;
                while (n4 < objectArray.length) {
                    objectArray2[n4][n2] = objectArray3[n4];
                    ++n4;
                }
            }
            ++n2;
        }
        return objectArray2;
    }

    public static boolean hasLocalization(String string, Locale locale) throws IllegalArgumentException {
        CIMSchemaLocalizer.validateFullyQualifiedName(string);
        Object v = cachedKeys.get(locale + string);
        if (v != null) {
            return v instanceof String[];
        }
        CIMSchemaLocalizer.buildLocalization(string, locale);
        v = cachedKeys.get(locale + string);
        if (v != null) {
            return v instanceof String[];
        }
        return false;
    }

    public static Object[] localizeData(String string, Object[] objectArray, Locale locale) throws IllegalArgumentException {
        Object[] objectArray2 = new Object[objectArray.length];
        if (!CIMSchemaLocalizer.hasLocalization(string, locale)) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        } else {
            String[] stringArray = (String[])cachedKeys.get(locale + string);
            String[] stringArray2 = (String[])cachedValues.get(locale + string);
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (objectArray[n].equals(stringArray[n2])) {
                        objectArray2[n] = stringArray2[n2];
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    objectArray2[n] = objectArray[n];
                    Report.warning.log("No localization found for " + objectArray[n] + " for fullyQualifiedName " + string);
                }
                ++n;
            }
        }
        return objectArray2;
    }

    private static void buildLocalization(String string, Locale locale) {
        String[] stringArray;
        if (string.equals(NULL_FULLY_QUALIFIED_NAME)) {
            cachedKeys.put(string, new Object());
            return;
        }
        String string2 = string.substring(0, string.indexOf(ATTR_DELIMITER));
        String string3 = string.substring(string.indexOf(ATTR_DELIMITER) + 1);
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string2, locale);
        }
        catch (MissingResourceException missingResourceException) {
            cachedKeys.put(string, new Object());
            return;
        }
        String string4 = null;
        String string5 = null;
        try {
            string4 = resourceBundle.getString(string3 + "." + VALUES_PROP);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            string5 = resourceBundle.getString(string3 + "." + KEYS_PROP);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string4 == null && string5 == null) {
            cachedKeys.put(locale + string, new Object());
            return;
        }
        if (string4 == null || string5 == null) {
            Report.error.log(TAG, (Object)("Property " + string3 + "." + VALUES_PROP + " or " + string3 + "." + KEYS_PROP + " not defined in resourcebundle " + string2));
            cachedKeys.put(locale + string, new Object());
            return;
        }
        String[] stringArray2 = Util.explode(string5, KV_DELIMITER);
        if (stringArray2.length != (stringArray = Util.explode(string4, KV_DELIMITER)).length) {
            Report.error.log(TAG, (Object)("keys.length != values.length for attribute " + string));
            cachedKeys.put(locale + string, new Object());
            return;
        }
        cachedKeys.put(locale + string, stringArray2);
        cachedValues.put(locale + string, stringArray);
    }

    private static void validateFullyQualifiedName(String string) throws IllegalArgumentException {
        if (string.equals(NULL_FULLY_QUALIFIED_NAME)) {
            return;
        }
        int n = string.indexOf(ATTR_DELIMITER);
        if (n == -1) {
            throw new IllegalArgumentException("fullyQualifiedName " + string + " is not a valid name.  " + "Syntax: fullyqualifiedclassname" + ATTR_DELIMITER + "attribute");
        }
    }

    private static Object[][] copyData(Object[][] objectArray, Object[][] objectArray2) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = new Object[objectArray[n].length];
            System.arraycopy(objectArray[n], 0, objectArray2[n], 0, objectArray[n].length);
            ++n;
        }
        return objectArray2;
    }
}

