/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.provider;

import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.TestException;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.wbem.cim.CIMDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class TestQueue {
    private static final String sccs_id = "@(#)TestQueue.java\t1.14 09/21/02 SMI";
    private static Map mseMap = new HashMap();
    private static LinkedList runList = new LinkedList();
    private String testName;
    public static TestQueue master = new TestQueue("NWS_DiagnosticTest");

    public TestQueue(String string) {
        this.testName = string;
    }

    public synchronized DiagnosticResult getResult(String string) {
        Iterator iterator = runList.iterator();
        while (iterator.hasNext()) {
            DiagnosticResult diagnosticResult = ((RunListItem)iterator.next()).getDiagnosticResult();
            if (!string.equals(diagnosticResult.getExecutionID())) continue;
            return diagnosticResult;
        }
        return null;
    }

    public synchronized boolean abortTest(DiagnosticResult diagnosticResult) {
        Iterator iterator = mseMap.values().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next();
            bl = this.doAbortTest(linkedList, diagnosticResult);
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    public synchronized boolean abortTest(ReferenceForMSE referenceForMSE, DiagnosticResult diagnosticResult) {
        LinkedList linkedList = (LinkedList)mseMap.get(referenceForMSE);
        if (linkedList == null) {
            return false;
        }
        return this.doAbortTest(linkedList, diagnosticResult);
    }

    private boolean doAbortTest(LinkedList linkedList, DiagnosticResult diagnosticResult) {
        Iterator iterator = linkedList.iterator();
        String string = diagnosticResult.getExecutionID();
        while (iterator.hasNext()) {
            boolean bl;
            RunListItem runListItem = (RunListItem)iterator.next();
            TestExecutable testExecutable = runListItem.getTestExecutable();
            DiagnosticResult diagnosticResult2 = runListItem.getDiagnosticResult();
            if (!string.equals(diagnosticResult2.getExecutionID())) continue;
            try {
                bl = testExecutable.abortTest();
            }
            catch (TestException testException) {
                diagnosticResult2.addTestResults(testException.getLocalizedMessage());
                return false;
            }
            int n = linkedList.indexOf(testExecutable);
            if (n > 0) {
                diagnosticResult2.setResultsToAborted();
                linkedList.remove(n);
            }
            return bl;
        }
        return false;
    }

    public synchronized void addTest(TestExecutable testExecutable, DiagnosticResult diagnosticResult) {
        LinkedList<RunListItem> linkedList;
        ReferenceForMSE referenceForMSE = testExecutable.getExclusiveMSE();
        if (referenceForMSE == null) {
            referenceForMSE = testExecutable.getMSE();
        }
        if ((linkedList = (LinkedList<RunListItem>)mseMap.get(referenceForMSE)) == null) {
            linkedList = new LinkedList<RunListItem>();
            mseMap.put(referenceForMSE, linkedList);
        }
        if (linkedList.isEmpty()) {
            linkedList.add(new RunListItem(testExecutable, diagnosticResult));
            this.runNextTest(referenceForMSE);
        } else {
            linkedList.add(new RunListItem(testExecutable, diagnosticResult));
        }
    }

    private synchronized RunListItem getNextRunListItem(ReferenceForMSE referenceForMSE) {
        LinkedList linkedList = (LinkedList)mseMap.get(referenceForMSE);
        if (linkedList == null || linkedList.isEmpty()) {
            return null;
        }
        return (RunListItem)linkedList.getFirst();
    }

    private synchronized boolean removeTest(ReferenceForMSE referenceForMSE) {
        LinkedList linkedList = (LinkedList)mseMap.get(referenceForMSE);
        if (linkedList == null || linkedList.isEmpty()) {
            return true;
        }
        linkedList.removeFirst();
        return false;
    }

    private void runNextTest(ReferenceForMSE referenceForMSE) {
        TestQueueRunner testQueueRunner = new TestQueueRunner(referenceForMSE, this);
        Thread thread = new Thread(testQueueRunner);
        thread.start();
    }

    private class TestQueueRunner
    implements Runnable {
        private ReferenceForMSE mse;
        private TestQueue tq;

        TestQueueRunner(ReferenceForMSE referenceForMSE, TestQueue testQueue2) {
            this.mse = referenceForMSE;
            this.tq = testQueue2;
        }

        public void run() {
            RunListItem runListItem;
            while ((runListItem = this.tq.getNextRunListItem(this.mse)) != null) {
                TestExecutable testExecutable = runListItem.getTestExecutable();
                DiagnosticResult diagnosticResult = runListItem.getDiagnosticResult();
                if (diagnosticResult == null) {
                    diagnosticResult = new DiagnosticResult();
                }
                diagnosticResult.setTestStartTime(new CIMDateTime());
                TestRunner testRunner = new TestRunner(testExecutable, diagnosticResult);
                testRunner.start();
                if (testExecutable.getExclusiveMSE() != null) {
                    boolean bl;
                    do {
                        try {
                            testRunner.join();
                            bl = false;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    } while (bl);
                }
                if (!this.tq.removeTest(this.mse)) continue;
                return;
            }
        }

        private class TestRunner
        extends Thread {
            TestExecutable test;
            DiagnosticResult result;

            TestRunner(TestExecutable testExecutable, DiagnosticResult diagnosticResult) {
                this.test = testExecutable;
                this.result = diagnosticResult;
            }

            public void run() {
                try {
                    this.result.setTestState(TestState.IN_PROGRESS);
                    this.test.runTest(this.result);
                }
                catch (TestException testException) {
                    this.result.setFinalResults(TestState.FAILED, testException.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    LocalizedString localizedString = new DiagnosticException().getLocalizedString();
                    this.result.addTestResults(localizedString.toString());
                    this.result.setFinalResults(TestState.FAILED);
                }
                if (this.result.getTestCompletionTime() == null) {
                    LocalizedString localizedString = new DiagnosticException().getLocalizedString();
                    this.result.addTestResults(localizedString.toString());
                    this.result.setFinalResults(TestState.FAILED);
                }
            }
        }
    }

    private class RunListItem {
        private TestExecutable testRun;
        private DiagnosticResult result;

        RunListItem(TestExecutable testExecutable, DiagnosticResult diagnosticResult) {
            this.testRun = testExecutable;
            this.result = diagnosticResult;
        }

        TestExecutable getTestExecutable() {
            return this.testRun;
        }

        DiagnosticResult getDiagnosticResult() {
            return this.result;
        }
    }
}

