/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.Messages;
import com.sun.jade.cim.util.ParameterType;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMValue;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class TestParameter
implements Serializable,
Cloneable {
    private static Localizer msgs = Messages.getLocalizer();
    public static final String DisplayName = "DisplayName";
    public static final String DescriptionName = "Description";
    public static final String UnitsName = "Units";
    public static final String MinValueName = "MinValue";
    public static final String MaxValueName = "MaxValue";
    public static final String ValueMapName = "ValueMap";
    public static final String ValuesName = "Values";
    public static final String TypeName = "SADE_Parameter";
    private Locale locale;
    private String name;
    private String displayName;
    private String description;
    private String units;
    private ParameterType type = ParameterType.UNKNOWN;
    private boolean isRequired = true;
    private boolean isSet = false;
    private boolean isDiscrete = false;
    private Object currentValue;
    private Object defaultValue;
    private Object[] validValues;
    private static final String sccs_id = "@(#)TestParameter.java\t1.20 02/20/03 SMI";

    public TestParameter() {
    }

    public TestParameter(Locale locale) {
        this.locale = locale;
    }

    public TestParameter(String string, ParameterType parameterType, Object object, String string2, String string3) {
        this.name = string;
        this.type = parameterType;
        this.defaultValue = object;
        this.displayName = string2;
        this.description = string3;
        if (object == null) {
            this.isRequired = true;
        }
    }

    public TestParameter(String string, String string2) {
        this.name = string;
        this.displayName = string2;
    }

    public TestParameter(String string, String string2, Object object, Object object2, boolean bl) {
        this.name = string;
        this.displayName = string2;
        this.currentValue = object;
        this.defaultValue = object2;
        this.isRequired = bl;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return object;
    }

    public ParameterType getParameterType() {
        return this.type;
    }

    public void setParameterType(ParameterType parameterType) {
        this.type = parameterType;
    }

    public void setParameterType(String string) {
        this.type = ParameterType.toParameterType(string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Object getCurrentValue() {
        if (this.currentValue == null) {
            return this.defaultValue;
        }
        return this.currentValue;
    }

    public Object setCurrentValueFromString(String string) {
        if (this.type.equals(ParameterType.STRING) || this.type.equals(ParameterType.PASSWORD)) {
            this.currentValue = string;
        } else if (this.type.equals(ParameterType.INTEGER) || this.type.equals(ParameterType.HEX_NUMBER) || this.type.equals(ParameterType.OCTAL_NUMBER) || this.type.equals(ParameterType.SLIDER)) {
            this.currentValue = Integer.valueOf(string);
        } else if (this.type.equals(ParameterType.BOOLEAN)) {
            if (string.equalsIgnoreCase("true")) {
                this.currentValue = Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                this.currentValue = Boolean.FALSE;
            }
        } else if (this.type.equals(ParameterType.CHOICE)) {
            boolean bl = false;
            int n = 0;
            while (n < this.validValues.length) {
                if (string.equals(this.validValues[n])) {
                    this.currentValue = this.validValues[n];
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 >= 0 && n2 < this.validValues.length) {
                        this.currentValue = this.validValues[n2];
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (this.type.equals(ParameterType.MULTI_CHOICE)) {
            // empty if block
        }
        return this.currentValue;
    }

    public void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
        this.isRequired = false;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public Object[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(Object[] objectArray, boolean bl) {
        this.validValues = objectArray;
        this.isDiscrete = bl;
        if (bl) {
            this.type = ParameterType.CHOICE;
        }
    }

    public boolean isValid() {
        return true;
    }

    public void setIntegerRange(int n, int n2) {
        Object[] objectArray = new Integer[]{new Integer(n), new Integer(n2)};
        this.setValidValues(objectArray, false);
        this.type = ParameterType.INTEGER;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        Localizer localizer = new Localizer("com.sun.jade.cim.diag.Messages");
        localizer.setLocale(locale);
        localizer.setDeferLocalization(false);
        String string = LocalizedString.localize(this.displayName, locale);
        return msgs.getFormattedString("param.value", string, this.currentValue);
    }

    public int choiceValue(int n) {
        if (this.validValues == null) {
            return n;
        }
        String string = (String)this.getCurrentValue();
        int n2 = 0;
        while (n2 < this.validValues.length) {
            if (string.equals(this.validValues[n2])) {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    public boolean booleanValue() {
        Object object = this.getCurrentValue();
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public int intValue(int n) {
        Object object = this.getCurrentValue();
        if (object != null && object instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public void readCIMProperty(CIMProperty cIMProperty) {
        CIMQualifier cIMQualifier;
        CIMValue cIMValue = cIMProperty.getValue();
        CIMDataType cIMDataType = cIMProperty.getType();
        this.name = cIMProperty.getName();
        Report.debug.log("TestParameter.readCIMProperty:" + cIMProperty);
        switch (cIMDataType.getType()) {
            case 9: {
                Boolean bl;
                if (cIMValue == null || (bl = (Boolean)cIMValue.getValue()) == null) {
                    bl = Boolean.FALSE;
                }
                this.setDefaultValue(bl);
                this.setCurrentValue(bl);
                break;
            }
            case 5: {
                Integer n;
                if (cIMValue == null || (n = (Integer)cIMValue.getValue()) == null) {
                    n = new Integer(0);
                }
                this.setDefaultValue(n);
                this.setCurrentValue(n);
                Integer n2 = null;
                Integer n3 = null;
                cIMQualifier = cIMProperty.getQualifier(MinValueName);
                if (cIMQualifier != null && (cIMValue = cIMQualifier.getValue()) != null) {
                    n2 = new Integer(((Number)cIMValue.getValue()).intValue());
                }
                if ((cIMQualifier = cIMProperty.getQualifier(MaxValueName)) != null && (cIMValue = cIMQualifier.getValue()) != null) {
                    n3 = new Integer(((Number)cIMValue.getValue()).intValue());
                }
                if (n2 == null) {
                    n2 = new Integer(Integer.MIN_VALUE);
                }
                if (n3 == null) {
                    n3 = new Integer(Integer.MAX_VALUE);
                }
                this.setValidValues(new Object[]{n2, n3}, false);
                break;
            }
            case 8: {
                String string;
                if (cIMValue == null || (string = (String)cIMValue.getValue()) == null) {
                    string = "";
                }
                this.setDefaultValue(string);
                this.setCurrentValue(string);
                cIMQualifier = cIMProperty.getQualifier(ValuesName);
                if (cIMQualifier == null || (cIMValue = cIMQualifier.getValue()) == null) break;
                Vector vector = (Vector)cIMValue.getValue();
                Object[] objectArray = new String[vector.size()];
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = (String)vector.get(n);
                    ++n;
                }
                this.setValidValues(objectArray, true);
                break;
            }
            default: {
                this.setDefaultValue(null);
                this.setCurrentValue(null);
            }
        }
        cIMQualifier = cIMProperty.getQualifier(DisplayName);
        if (cIMQualifier != null && (cIMValue = cIMQualifier.getValue()) != null) {
            this.setDisplayName((String)cIMValue.getValue());
        }
        if ((cIMQualifier = cIMProperty.getQualifier(UnitsName)) != null && (cIMValue = cIMQualifier.getValue()) != null) {
            this.setUnits((String)cIMValue.getValue());
        }
        if ((cIMQualifier = cIMProperty.getQualifier(DescriptionName)) != null && (cIMValue = cIMQualifier.getValue()) != null) {
            this.setDescription((String)cIMValue.getValue());
        }
        cIMQualifier = cIMProperty.getQualifier(TypeName);
        Report.debug.log("SADE_Qualifier = " + cIMQualifier);
        if (cIMQualifier != null && (cIMValue = cIMQualifier.getValue()) != null) {
            Report.debug.log("SADE_Qualifier Value = " + (String)cIMValue.getValue());
            this.setParameterType((String)cIMValue.getValue());
        }
        Report.debug.log("TestParameter.readCIMProperty: name=" + this.name + " value=" + this.getCurrentValue() + " displayName=" + this.displayName + " units=" + this.units);
    }

    protected String getResourceString(String string) {
        if (this.locale != null) {
            return msgs.getString(this.locale, string);
        }
        return msgs.getString(string);
    }

    protected void setCIMName(String string) {
        this.name = string;
    }

    public static class Test
    extends UnitTest {
        String testDescription = "Description for parameter";
        String testDisplayName = "Parameter";
        String testName = "p";

        public void test() {
            TestParameter testParameter = new TestParameter("name", ParameterType.UNKNOWN, null, "Name", "Name description");
            this.assertNull(testParameter.getCurrentValue());
        }

        public void testBoolean() {
            TestParameter testParameter = new TestParameter("Switch", ParameterType.BOOLEAN, (Object)Boolean.FALSE, "On/Off", "A Toggle Switch");
            testParameter.setCurrentValueFromString("true");
            this.assertEquals(testParameter.getCurrentValue(), Boolean.TRUE);
            this.assertCondition(testParameter.booleanValue());
            testParameter.setCurrentValueFromString("false");
            this.assertEquals(testParameter.getCurrentValue(), Boolean.FALSE);
        }

        public void testChoice() {
            Object[] objectArray = new String[]{"2000", "1500", "1000", "500", "250"};
            TestParameter testParameter = new TestParameter(this.testName, this.testDisplayName);
            testParameter.setValidValues(objectArray, true);
            testParameter.setDefaultValue(objectArray[0]);
            testParameter.setUnits("Bytes");
            testParameter.setDescription("Transfer some bytes");
            this.assertEquals(testParameter.getParameterType(), ParameterType.CHOICE);
            this.assertEquals(testParameter.getDisplayName(), this.testDisplayName);
            this.assertEquals(testParameter.getName(), this.testName);
            testParameter.setCurrentValueFromString("250");
            this.assertEquals("250", testParameter.getCurrentValue());
            testParameter.setCurrentValueFromString("1");
            this.assertEquals("1500", testParameter.getCurrentValue());
        }
    }
}

