/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.ui.diags.NotInRangeException;
import com.sun.jade.ui.diags.RendererUtilities;
import com.sun.jade.ui.diags.TestParameterRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class StandAloneTestDriver
extends JPanel
implements ActionListener {
    private boolean verbose = true;
    private static final String sccs_id = "@(#)StandAloneTestDriver.java\t1.14 02/20/03 SMI";
    protected ReferenceForMSE mse;
    protected TestTemplate test;
    protected DiagnosticSetting setting;
    protected boolean isTestRunning = false;
    protected TestExecutable testExec = null;
    protected JTextField mseField;
    protected JButton submitButton = new JButton("Submit");
    protected JButton cancelButton = new JButton("Exit");
    protected JButton defaultsButton = new JButton("Defaults");
    private TestParameterRenderer[] renderers;

    public StandAloneTestDriver(TestTemplate testTemplate, ReferenceForMSE referenceForMSE) {
        this.test = testTemplate;
        this.mse = referenceForMSE;
        this.setLayout(new BorderLayout());
        this.build();
        JFrame jFrame = new JFrame();
        jFrame.setTitle(testTemplate.getTestCaption(Locale.getDefault()));
        jFrame.getContentPane().add("Center", this);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block14: {
            block12: {
                block13: {
                    if (actionEvent.getSource() != this.submitButton) break block12;
                    if (!this.isTestRunning) break block13;
                    if (this.testExec != null) {
                        System.out.println("Aborting test...");
                        try {
                            this.testExec.abortTest();
                            this.testExec = null;
                        }
                        catch (Exception exception) {
                            System.out.println(exception.toString());
                        }
                    }
                    break block14;
                }
                this.setting = this.test.getDefaultSetting(Locale.getDefault());
                if (this.checkSettings(this.setting)) break block14;
                this.mse.setKeyValue(this.mseField.getText());
                try {
                    this.testExec = this.test.getTestExec(this.mse, this.setting);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    return;
                }
                TestRunner testRunner = new TestRunner(this.testExec, this.submitButton);
                this.isTestRunning = true;
                this.submitButton.setText("Abort");
                testRunner.start();
                break block14;
            }
            if (actionEvent.getSource() == this.cancelButton) {
                if (this.isTestRunning) {
                    try {
                        this.testExec.abortTest();
                    }
                    catch (Exception exception) {
                        System.out.println(exception.toString());
                    }
                }
                this.dispose();
                System.exit(0);
            } else if (actionEvent.getSource() == this.defaultsButton) {
                DiagnosticSetting diagnosticSetting = this.test.getDefaultSetting(Locale.getDefault());
                Object[] objectArray = new TestParameter[diagnosticSetting.getTestParameters().size()];
                diagnosticSetting.getTestParameters().copyInto(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    this.renderers[n].reset();
                    ++n;
                }
            }
        }
    }

    private boolean checkSettings(DiagnosticSetting diagnosticSetting) {
        boolean bl = false;
        Object[] objectArray = new TestParameter[diagnosticSetting.getTestParameters().size()];
        diagnosticSetting.getTestParameters().copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Object[] objectArray2;
            try {
                Object object = this.renderers[n].getValue();
                ((TestParameter)objectArray[n]).setCurrentValue(object);
                System.out.println(object);
            }
            catch (NotInRangeException notInRangeException) {
                bl = true;
                String string = "The parameter \"" + ((TestParameter)objectArray[n]).getDisplayName() + "\" is not within the specified range";
                objectArray2 = ((TestParameter)objectArray[n]).getValidValues();
                string = objectArray2.length == 2 ? string + ": " + objectArray2[0] + "..." + objectArray2[1] : string + ".";
                JOptionPane.showMessageDialog(null, string, "Error", 0);
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                objectArray2 = "The parameter \"" + ((TestParameter)objectArray[n]).getDisplayName() + "\" is not valid.";
                JOptionPane.showMessageDialog(null, objectArray2, "Error", 0);
            }
            ++n;
        }
        return bl;
    }

    private void build() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EtchedBorder());
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Device key");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        this.mseField = new JTextField(this.mse.getKeyValue());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(this.mseField, gridBagConstraints);
        jPanel.add(this.mseField);
        DiagnosticSetting diagnosticSetting = this.test.getDefaultSetting(Locale.getDefault());
        TestParameter[] testParameterArray = diagnosticSetting.getTestParametersArray();
        this.renderers = new TestParameterRenderer[testParameterArray.length];
        int n = 0;
        while (n < testParameterArray.length) {
            gridBagConstraints = new GridBagConstraints();
            jLabel = new JLabel(testParameterArray[n].getDisplayName());
            if (testParameterArray[n].getDescription() != null) {
                jLabel.setToolTipText(testParameterArray[n].getDescription());
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = insets;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints = new GridBagConstraints();
            this.renderers[n] = RendererUtilities.getRenderer(testParameterArray[n].getParameterType());
            Component component = this.renderers[n].getComponent(testParameterArray[n]);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n + 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = insets;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
            if (testParameterArray[n].getUnits() != null) {
                gridBagConstraints = new GridBagConstraints();
                JLabel jLabel2 = new JLabel(testParameterArray[n].getUnits());
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = n + 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = insets;
                gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
                jPanel.add(jLabel2);
            }
            ++n;
        }
        this.submitButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.defaultsButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.submitButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.defaultsButton);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
    }

    private void dispose() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Window) {
                ((Window)container).dispose();
            }
            container = container.getParent();
        }
    }

    private class TestRunner
    extends Thread {
        TestExecutable testExec;
        JButton submitButton;

        TestRunner(TestExecutable testExecutable, JButton jButton) {
            this.testExec = testExecutable;
            this.submitButton = jButton;
        }

        public void run() {
            System.out.println("Running test " + StandAloneTestDriver.this.mse);
            try {
                DiagnosticResult diagnosticResult = new DiagnosticResult();
                diagnosticResult.setTestState(4);
                diagnosticResult.update();
                ResultMonitor resultMonitor = new ResultMonitor(diagnosticResult);
                resultMonitor.start();
                this.testExec.runTest(diagnosticResult);
                System.out.println("========\n" + diagnosticResult + "========");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(exception);
            }
            StandAloneTestDriver.this.isTestRunning = false;
            this.submitButton.setText("Submit");
        }

        private class ResultMonitor
        extends Thread {
            private DiagnosticResult result;

            ResultMonitor(DiagnosticResult diagnosticResult) {
                this.result = diagnosticResult;
            }

            public void run() {
                do {
                    if (StandAloneTestDriver.this.verbose) {
                        System.out.println("========\n" + this.result + "========");
                    } else {
                        System.out.println(this.result.getPercentCompleteValue() + "%");
                    }
                    this.result.waitForUpdate();
                } while (this.result.getTestCompletionTime() == null);
            }
        }
    }
}

