/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.diag.DiagnosticClient;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticResultEvent;
import com.sun.jade.cim.diag.DiagnosticResultListener;
import com.sun.jade.cim.diag.DiagnosticTestInfo;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.util.log.Report;

class MonitorTest
implements Runnable {
    static final int pollQuantum = 5000;
    DiagnosticTestInfo testInfo;
    DiagnosticClient client;
    ElementKey testKey;
    DiagnosticResultListener listener;

    MonitorTest(DiagnosticTestInfo diagnosticTestInfo, DiagnosticClient diagnosticClient, ElementKey elementKey, DiagnosticResultListener diagnosticResultListener) {
        this.testInfo = diagnosticTestInfo;
        this.client = diagnosticClient;
        this.testKey = elementKey;
        this.listener = diagnosticResultListener;
    }

    public void run() {
        int n;
        Thread thread = Thread.currentThread();
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                DiagnosticResult diagnosticResult = this.client.getTestResults(this.testKey);
                diagnosticResult.setMse(this.client.getMse());
                DiagnosticResultEvent diagnosticResultEvent = new DiagnosticResultEvent(diagnosticResult);
                try {
                    this.listener.notify(diagnosticResultEvent);
                }
                catch (Exception exception) {
                    Report.debug.log("Error calling notify: " + exception);
                    Report.debug.log("\tListener = " + this.listener);
                    Report.debug.log("\tEvent    = " + diagnosticResultEvent);
                    exception.printStackTrace();
                }
                n = diagnosticResult.getTestStateValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n = 3;
            }
        } while (n == 4);
    }
}

