/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.cim.diag;

import com.sun.jade.cim.bean.CIM_DiagnosticTest;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.DiagnosticTest;
import com.sun.jade.cim.diag.TestCharactoristics;
import com.sun.jade.cim.diag.TestContext;
import com.sun.jade.cim.diag.TestResources;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.wbem.cim.UnsignedInt16;
import java.io.Serializable;
import java.util.Locale;

public class DiagnosticTestInfo
implements Serializable,
TestCharactoristics,
TestResources {
    private static final String sccs_id = "@(#)DiagnosticTestInfo.java\t1.16 02/26/03 SMI";
    private String testName;
    private String testClassName;
    private String mseClassName;
    private String testDescription;
    private int[] symptoms;
    private int[] testResources;
    private int[] testCharacteristics;
    private DiagnosticSetting settingsForTest;
    private TestableElement[] testableElements;
    private TestTemplate template;

    public DiagnosticTestInfo(TestTemplate testTemplate) {
        this.template = testTemplate;
        this.testClassName = testTemplate.getTestName();
        this.testableElements = testTemplate.getTestableElements();
        this.mseClassName = this.testableElements[0].getCreationClassName();
        this.testCharacteristics = testTemplate.getTestCharacteristics();
        this.symptoms = testTemplate.getSymptoms();
        this.settingsForTest = testTemplate.getDefaultSetting(Locale.getDefault());
    }

    public DiagnosticTestInfo(CIM_DiagnosticTest cIM_DiagnosticTest, String string, DiagnosticSetting diagnosticSetting) {
        int n;
        this.testName = cIM_DiagnosticTest.getName();
        this.testClassName = cIM_DiagnosticTest.getCreationClassName();
        this.testDescription = cIM_DiagnosticTest.getDescription();
        UnsignedInt16[] unsignedInt16Array = cIM_DiagnosticTest.getCharacteristics();
        if (unsignedInt16Array != null) {
            this.testCharacteristics = new int[unsignedInt16Array.length];
            n = 0;
            while (n < unsignedInt16Array.length) {
                this.testCharacteristics[n] = unsignedInt16Array[n].intValue();
                ++n;
            }
        }
        this.symptoms = new int[0];
        UnsignedInt16[] unsignedInt16Array2 = cIM_DiagnosticTest.getResourcesUsed();
        if (unsignedInt16Array2 != null) {
            this.testResources = new int[unsignedInt16Array2.length];
            n = 0;
            while (n < unsignedInt16Array2.length) {
                this.testResources[n] = unsignedInt16Array2[n].intValue();
                ++n;
            }
        }
        this.mseClassName = string;
        this.settingsForTest = diagnosticSetting;
    }

    public DiagnosticTestInfo(String string, String string2, String string3, DiagnosticSetting diagnosticSetting) {
        this.testName = string;
        this.testClassName = string2;
        this.mseClassName = string3;
        this.settingsForTest = diagnosticSetting;
    }

    public String getTestName() {
        return this.getTestName(Locale.getDefault());
    }

    public String getTestName(Locale locale) {
        if (this.template != null) {
            return this.template.getTestCaption(locale);
        }
        return this.testName;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getMSEClassName() {
        return this.mseClassName;
    }

    public DiagnosticSetting getSettingsForTest(Locale locale) {
        if (this.template != null) {
            this.settingsForTest = this.template.getDefaultSetting(locale);
            this.settingsForTest.pruneUnsupportedSettings(this.testCharacteristics);
        }
        return this.settingsForTest;
    }

    public DiagnosticSetting getSettingsForTest() {
        return this.settingsForTest;
    }

    public TestContext getTestContext() {
        return null;
    }

    public String toString() {
        return this.getTestName();
    }

    public String getTestDescription() {
        return this.getTestDescription(Locale.getDefault());
    }

    public String getTestDescription(Locale locale) {
        if (this.template != null) {
            return this.template.getTestDescription(locale);
        }
        return this.testDescription;
    }

    public int[] getTestCharacteristics() {
        return this.testCharacteristics;
    }

    public int[] getTestResources() {
        return this.testResources;
    }

    public int[] getSymptoms() {
        return this.symptoms;
    }

    public TestableElement[] getTestableElements() {
        return this.testableElements;
    }

    public DiagnosticTest createTest(DiagnosticSetting diagnosticSetting) throws DiagnosticException {
        DiagnosticTest diagnosticTest;
        Class<?> clazz;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            clazz = classLoader.loadClass(this.testClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new DiagnosticException(classNotFoundException, "DIAG_ERR_TEST_NOT_FOUND");
        }
        try {
            diagnosticTest = (DiagnosticTest)((Object)clazz.newInstance());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new DiagnosticException(illegalAccessException, "DIAG_ERR_FAILED");
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new DiagnosticException(instantiationException, "DIAG_ERR_FAILED");
        }
        diagnosticTest.setupTest(this, diagnosticSetting);
        return diagnosticTest;
    }
}

