/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.topology.lib;

import com.sun.jade.apps.discovery.InstallerException;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.topology.graph.model.Graph;
import com.sun.jade.apps.topology.lib.Connection;
import com.sun.jade.apps.topology.lib.TopologyHelperImpl;
import com.sun.jade.apps.topology.lib.Zone;
import com.sun.jade.cim.bean.CIM_HostedCollection;
import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.bean.CIM_ProtocolEndpoint;
import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.bean.CIM_SystemDevice;
import com.sun.jade.cim.bean.CIM_SystemSpecificCollection;
import com.sun.jade.cim.bean.CIM_Zone;
import com.sun.jade.cim.bean.CIM_ZoneMember;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.util.BeanHandler;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.ui.topology.tree.DefaultTree;
import com.sun.jade.ui.topology.tree.DefaultTreeNode;
import com.sun.jade.ui.topology.tree.Tree;
import com.sun.jade.ui.topology.tree.TreeNode;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.ArrayList;
import java.util.Iterator;

public class DeviceTopologyHelperImpl
extends TopologyHelperImpl {
    private AbstractMF mf;
    private static final String ZONE_LOG_TAG = "Zone";
    private MFStatus mfStatus = MFStatus.UNKNOWN;
    private BeanHandler handler;
    private ArrayList connections;
    private Tree tree;
    private ArrayList zones;
    private static final String sccs_id = "@(#)DeviceTopologyHelperImpl.java\t1.20 10/15/02 SMI";

    public DeviceTopologyHelperImpl(AbstractMF abstractMF) {
        super(abstractMF);
        this.mf = abstractMF;
        this.handler = new TopoBeanHandler();
    }

    public Iterator getConnections() {
        if (this.connections != null) {
            return this.connections.iterator();
        }
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Iterator getZones() {
        if (this.zones != null) {
            return this.zones.iterator();
        }
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public Graph getGraph() {
        throw new UnsupportedOperationException();
    }

    public Tree getTree() {
        if (this.tree == null) {
            TreeNode[] treeNodeArray = new TreeNode[]{};
            this.tree = new DefaultTree(treeNodeArray);
        }
        return this.tree;
    }

    public MFStatus getParsedMFStatus() {
        return this.mfStatus;
    }

    public BeanHandler getBeanHandler() {
        return this.handler;
    }

    private boolean treesAreEquals(Tree tree, Tree tree2) {
        ArrayList arrayList = DefaultTree.getNodes(tree);
        ArrayList arrayList2 = DefaultTree.getNodes(tree2);
        if (arrayList == null && arrayList2 == null) {
            return true;
        }
        if (arrayList == null || arrayList2 == null) {
            return false;
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        int n = 0;
        while (n < arrayList2.size()) {
            boolean bl = false;
            DefaultTreeNode defaultTreeNode = (DefaultTreeNode)arrayList2.get(n);
            ReferenceForMSE referenceForMSE = (ReferenceForMSE)defaultTreeNode.getUserObject();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                DefaultTreeNode defaultTreeNode2 = (DefaultTreeNode)arrayList.get(n2);
                ReferenceForMSE referenceForMSE2 = (ReferenceForMSE)defaultTreeNode2.getUserObject();
                if (referenceForMSE != null && referenceForMSE.equals(referenceForMSE2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean connectionsAreEquals(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null && arrayList2 == null) {
            return true;
        }
        if (arrayList == null || arrayList2 == null) {
            return false;
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        int n = 0;
        while (n < arrayList2.size()) {
            boolean bl = false;
            Connection connection = (Connection)arrayList2.get(n);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Connection connection2 = (Connection)arrayList.get(n2);
                if (connection != null && connection.equals(connection2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public class TopoBeanHandler
    implements BeanHandler {
        ArrayList clist;
        ArrayList dlist;
        String systemClassName;
        MFStatus status;
        ArrayList zoneList;

        TopoBeanHandler() {
            this.systemClassName = DeviceTopologyHelperImpl.this.mf.getClassName();
        }

        public void start() {
            this.clist = new ArrayList();
            this.dlist = new ArrayList();
            this.zoneList = new ArrayList();
            this.status = null;
        }

        public void handleBean(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
            this.scanDevices(cIMBeanBase, cIMBeanBase2, cIMBeanBase3);
            this.scanProtocolEndpoint(cIMBeanBase, cIMBeanBase2);
            this.scanZone(cIMBeanBase, cIMBeanBase2, cIMBeanBase3);
        }

        private void scanDevices(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
            Object object;
            CIM_System cIM_System;
            if (this.status == null && cIMBeanBase2 instanceof CIM_System) {
                cIM_System = (CIM_System)cIMBeanBase2;
                object = cIM_System.getStatus();
                if (object != null) {
                    try {
                        this.status = new MFStatus((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Report.warning.log("Bad status (" + (String)object + ") for device " + this.systemClassName + ":" + DeviceTopologyHelperImpl.this.mf.getName());
                        this.status = MFStatus.UNKNOWN;
                    }
                } else {
                    this.status = MFStatus.UNKNOWN;
                }
            }
            if (cIMBeanBase3 instanceof CIM_SystemDevice) {
                cIM_System = (CIM_LogicalDevice)cIMBeanBase2;
                object = new ReferenceForMSE(cIM_System.getCreationClassName(), cIM_System.getDeviceID(), this.systemClassName, DeviceTopologyHelperImpl.this.mf.getName());
                ((ReferenceForMSE)object).setBaseClassNameFromBean((CIMBean)cIM_System);
                this.dlist.add(new DefaultTreeNode(object));
            }
            if (cIMBeanBase3 instanceof CIM_HostedCollection) {
                cIM_System = (CIM_SystemSpecificCollection)cIMBeanBase2;
                object = cIM_System.getClass().getName();
                int n = ((String)object).lastIndexOf(".");
                object = ((String)object).substring(n + 1);
                ReferenceForMSE referenceForMSE = new ReferenceForMSE((String)object, cIM_System.getName(), cIM_System.getSystemCreationClassName(), cIM_System.getSystemName(), 4);
                referenceForMSE.setBaseClassNameFromBean((CIMBean)cIM_System);
                this.dlist.add(new DefaultTreeNode(referenceForMSE));
                Report.debug.log(DeviceTopologyHelperImpl.ZONE_LOG_TAG, (Object)("Zone=" + cIM_System.toBeanXML()));
                Report.debug.log(DeviceTopologyHelperImpl.ZONE_LOG_TAG, (Object)("MSE=" + referenceForMSE.toString()));
                Report.debug.log(DeviceTopologyHelperImpl.ZONE_LOG_TAG, (Object)("COP=" + referenceForMSE.getCIMObjectPath().toString()));
            }
        }

        private void scanProtocolEndpoint(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2) {
            if (cIMBeanBase instanceof CIM_ProtocolEndpoint && cIMBeanBase2 instanceof CIM_ProtocolEndpoint) {
                Connection connection;
                String string;
                CIM_ProtocolEndpoint cIM_ProtocolEndpoint = (CIM_ProtocolEndpoint)cIMBeanBase;
                String string2 = cIM_ProtocolEndpoint.getName();
                String string3 = cIM_ProtocolEndpoint.getProtocolType();
                String string4 = Connection.typeFromProtocolType(string3);
                cIM_ProtocolEndpoint = (CIM_ProtocolEndpoint)cIMBeanBase2;
                if (this.clist.size() > 0 && string2.equals(string = (connection = (Connection)this.clist.get(this.clist.size() - 1)).getInId())) {
                    connection.setOutId(cIM_ProtocolEndpoint.getName());
                }
                return;
            }
            if (cIMBeanBase2 instanceof CIM_ProtocolEndpoint && cIMBeanBase instanceof CIM_LogicalDevice) {
                CIM_ProtocolEndpoint cIM_ProtocolEndpoint = (CIM_ProtocolEndpoint)cIMBeanBase2;
                CIM_LogicalDevice cIM_LogicalDevice = (CIM_LogicalDevice)cIMBeanBase;
                ReferenceForMSE referenceForMSE = new ReferenceForMSE(cIM_LogicalDevice.getCreationClassName(), cIM_LogicalDevice.getDeviceID(), this.systemClassName, DeviceTopologyHelperImpl.this.mf.getName(), 5);
                String string = cIM_ProtocolEndpoint.getName();
                String string5 = cIM_ProtocolEndpoint.getProtocolType();
                String string6 = Connection.typeFromProtocolType(string5);
                this.clist.add(new Connection(referenceForMSE, string6, string, null));
            }
        }

        private void scanZone(CIMBeanBase cIMBeanBase, CIMBeanBase cIMBeanBase2, CIMBeanBase cIMBeanBase3) {
            CIM_ZoneMember cIM_ZoneMember;
            if (cIMBeanBase2 instanceof CIM_ZoneMember) {
                cIM_ZoneMember = (CIM_ZoneMember)cIMBeanBase2;
                this.addPortsToZone(cIM_ZoneMember);
            }
            if (cIMBeanBase2 instanceof CIM_Zone && cIMBeanBase instanceof CIM_System) {
                cIM_ZoneMember = (CIM_Zone)cIMBeanBase2;
                CIM_System cIM_System = (CIM_System)cIMBeanBase;
                this.zoneList.add(new Zone((CIM_Zone)cIM_ZoneMember, cIM_System));
            }
        }

        private void addPortsToZone(CIM_ZoneMember cIM_ZoneMember) {
            CIMObjectPath cIMObjectPath = cIM_ZoneMember.getCollection();
            CIMObjectPath cIMObjectPath2 = cIM_ZoneMember.getMember();
            int n = 0;
            while (n < this.zoneList.size()) {
                Zone zone = (Zone)this.zoneList.get(n);
                CIMObjectPath cIMObjectPath3 = zone.zone.getCIMObjectPath();
                if (cIMObjectPath3.equals((Object)cIMObjectPath)) {
                    zone.ports.add(cIMObjectPath2);
                }
                ++n;
            }
        }

        public void end() {
            if (this.status != null) {
                DeviceTopologyHelperImpl.this.mfStatus = this.status;
            }
            DeviceTopologyHelperImpl.this.zones = this.zoneList;
            TreeNode[] treeNodeArray = new TreeNode[this.dlist.size()];
            int n = 0;
            while (n < this.dlist.size()) {
                treeNodeArray[n] = (DefaultTreeNode)this.dlist.get(n);
                ++n;
            }
            DefaultTree defaultTree = new DefaultTree(treeNodeArray);
            boolean bl = DeviceTopologyHelperImpl.this.treesAreEquals(DeviceTopologyHelperImpl.this.tree, defaultTree);
            boolean bl2 = DeviceTopologyHelperImpl.this.connectionsAreEquals(DeviceTopologyHelperImpl.this.connections, this.clist);
            if (!bl || !bl2) {
                DeviceTopologyHelperImpl.this.tree = defaultTree;
                DeviceTopologyHelperImpl.this.connections = this.clist;
                InstallerService installerService = InstallerServiceFinder.getInstallerService();
                try {
                    installerService.updateDevice(DeviceTopologyHelperImpl.this.mf);
                }
                catch (InstallerException installerException) {
                    Report.error.log(installerException, (Object)"Error installing device");
                }
            }
        }
    }
}

