/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.topology.graph.model;

import com.sun.jade.apps.topology.graph.model.BasicNode;
import com.sun.jade.apps.topology.graph.model.IndexedGraph;
import com.sun.jade.apps.topology.graph.model.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class BasicGraph
implements Cloneable,
IndexedGraph,
Serializable {
    private Object userObject = null;
    private ArrayList nodes;

    public BasicGraph() {
        this.nodes = new ArrayList();
    }

    public BasicGraph(Object object) {
        this.setUserObject(object);
        this.nodes = new ArrayList();
    }

    public BasicGraph(int n) {
        this.nodes = new ArrayList(n);
    }

    public synchronized void add(BasicNode basicNode) {
        this.nodes.add(basicNode);
        basicNode.setParent(this);
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    public void clear() {
        while (this.getNodeCount() > 0) {
            BasicNode basicNode = (BasicNode)this.getNode(0);
            this.delete(basicNode);
        }
    }

    public synchronized void delete(BasicNode basicNode) {
        basicNode.getInEdgeSet().clear();
        basicNode.getOutEdgeSet().clear();
        this.remove(basicNode);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Node getNode(int n) {
        return (Node)this.nodes.get(n);
    }

    public int getIndex(Node node) {
        return this.nodes.indexOf(node);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Iterator nodes() {
        return this.nodes.iterator();
    }

    public void remove(BasicNode basicNode) {
        int n = this.nodes.indexOf(basicNode);
        this.nodes.remove(n);
    }

    public void removeAll() {
        this.nodes.clear();
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public String toString() {
        Object object = this.getUserObject();
        if (object != null) {
            return "BasicGraph[" + object.toString() + "]";
        }
        return super.toString();
    }

    public Object clone() {
        BasicGraph basicGraph = new BasicGraph();
        basicGraph.userObject = this.userObject;
        basicGraph.nodes = (ArrayList)this.nodes.clone();
        return basicGraph;
    }
}

