/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.topology;

import com.sun.jade.apps.discovery.InstallEvent;
import com.sun.jade.apps.discovery.InstallListener;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.persistence.service.EventsPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.topology.DeletedEdge;
import com.sun.jade.apps.topology.EdgePersistence;
import com.sun.jade.apps.topology.EdgeUserObject;
import com.sun.jade.apps.topology.EventBuilder;
import com.sun.jade.apps.topology.GraphComparator;
import com.sun.jade.apps.topology.NetworkEdge;
import com.sun.jade.apps.topology.NetworkGraph;
import com.sun.jade.apps.topology.NetworkNode;
import com.sun.jade.apps.topology.SimpleEdgeUserObject;
import com.sun.jade.apps.topology.TopologyEvent;
import com.sun.jade.apps.topology.TopologyListener;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.apps.topology.graph.model.BasicEdge;
import com.sun.jade.apps.topology.graph.model.BasicGraph;
import com.sun.jade.apps.topology.graph.model.BasicNode;
import com.sun.jade.apps.topology.graph.model.Graph;
import com.sun.jade.apps.topology.lib.Connection;
import com.sun.jade.apps.topology.lib.TopologyHelper;
import com.sun.jade.apps.topology.lib.Zone;
import com.sun.jade.cim.bean.CIM_ProtocolEndpoint;
import com.sun.jade.cim.bean.NWS_DirectLink;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlarmSummary;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.logic.asset.AssetItemImpl;
import com.sun.jade.logic.domain.DomainMF;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.topology.tree.DefaultTree;
import com.sun.jade.ui.topology.tree.Tree;
import com.sun.jade.ui.topology.tree.TreeNode;
import com.sun.jade.util.log.Report;
import java.io.Serializable;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TopologyServiceImpl
implements TopologyService,
InstallListener,
Serializable {
    static String className = "";
    private static final String TAG = "topo";
    private BasicGraph graph = new BasicGraph();
    private Vector listeners = new Vector();
    private InstallerService installerService;
    private String domain;
    private Vector edges = new Vector();
    private Vector oldBadEdges = new Vector();
    private Vector oldDeletedEdges = new Vector();
    private Vector deletedEdges = new Vector();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEdges() {
        Object object = this.lock;
        synchronized (object) {
            Report.trace.log(TAG, (Object)"To update edges");
            try {
                Object object2;
                Serializable serializable;
                BasicGraph basicGraph = new BasicGraph();
                Iterator iterator = this.graph.nodes();
                Vector vector = new Vector();
                while (iterator.hasNext()) {
                    serializable = (BasicNode)iterator.next();
                    object2 = ((TopologyNode)((BasicNode)serializable).getUserObject()).getMF();
                    this.updateGraph((MF)object2, basicGraph, vector, false);
                }
                serializable = new Vector();
                object2 = new Vector();
                boolean bl = GraphComparator.compareEdges(this.edges, vector, (Vector)serializable, (Vector)object2);
                int n = 0;
                while (n < ((Vector)object2).size()) {
                    this.remove((EdgeUserObject)((Vector)object2).get(n), this.graph, true);
                    ++n;
                }
                int n2 = 0;
                while (n2 < ((Vector)serializable).size()) {
                    this.insert((EdgeUserObject)((Vector)serializable).get(n2), this.graph, true);
                    ++n2;
                }
                boolean bl2 = GraphComparator.compareZones(this.graph, basicGraph);
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Unable to compare graph");
            }
            Report.trace.log(TAG, (Object)"Finish updating edges");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTree(MF mF) {
        Object object = this.lock;
        synchronized (object) {
            try {
                try {
                    Report.trace.log(TAG, (Object)("To update tree for " + mF.getName()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Iterator iterator = this.graph.nodes();
                while (iterator.hasNext()) {
                    Tree tree;
                    TopologyHelper topologyHelper;
                    BasicNode basicNode = (BasicNode)iterator.next();
                    MF mF2 = ((TopologyNode)basicNode.getUserObject()).getMF();
                    if (mF != mF2 || (topologyHelper = (TopologyHelper)mF.getServiceHelper("com.sun.jade.apps.topology.lib.TopologyHelper")) == null || (tree = topologyHelper.getTree()) == null) continue;
                    ((TopologyNode)basicNode.getUserObject()).setFRUs(tree);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                Report.trace.log(TAG, (Object)("Finish updating tree for " + mF.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public TopologyServiceImpl(Properties properties) {
        this.domain = InstallerServiceFinder.getCurrentDomain();
        this.init();
    }

    public TopologyServiceImpl() throws RemoteException {
        this.domain = InstallerServiceFinder.getCurrentDomain();
        this.init();
    }

    public TopologyServiceImpl(String string) throws RemoteException {
        this.domain = string;
        this.init();
    }

    private void init() {
        className = this.getClass().getName();
        this.oldBadEdges = EdgePersistence.fetchEdges("badEdges", false);
        this.oldDeletedEdges = EdgePersistence.fetchEdges("deletedEdges", true);
        this.installerService = InstallerServiceFinder.getLocalInstallerService();
        if (this.installerService != null) {
            this.installerService.addInstallListener(this);
        }
    }

    public String getServiceName() throws RemoteException {
        return "Topology Service";
    }

    public Graph getGraph() {
        return this.graph;
    }

    public synchronized void addTopologyListener(TopologyListener topologyListener) {
        this.listeners.add(topologyListener);
    }

    public synchronized void removeTopologyListener(TopologyListener topologyListener) {
        this.listeners.remove(topologyListener);
    }

    private synchronized void updateTopologyListener(int n) {
        TopologyEvent topologyEvent = new TopologyEvent(this.graph, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            TopologyListener topologyListener = (TopologyListener)this.listeners.get(n2);
            try {
                topologyListener.notify(topologyEvent);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public synchronized void notify(InstallEvent installEvent) throws RemoteException {
        try {
            switch (installEvent.getMode()) {
                case 1: 
                case 2: {
                    MF mF = (MF)installEvent.getSource();
                    Report.trace.log(TAG, (Object)("get event NEW_DEVICE: " + mF.getName()));
                    this.updateGraph(mF, this.graph, this.edges, true);
                    this.updateTopologyListener(0);
                    break;
                }
                case 4: {
                    MF mF = (MF)installEvent.getSource();
                    Report.trace.log(TAG, (Object)("get event REMOVE_DEVICE: " + mF.getName()));
                    this.deleteEdges(this.edges, mF, this.graph, true);
                    this.deleteNode(this.graph, mF);
                    this.deleteDeletedEdges(this.deletedEdges, mF);
                    this.updateTopologyListener(1);
                    break;
                }
                case 0: {
                    MF mF = (MF)installEvent.getSource();
                    Report.trace.log(TAG, (Object)("get event UPDATE_DEVICE: " + mF.getName()));
                    this.updateTree(mF);
                    this.updateEdges();
                    this.updateTopologyListener(2);
                }
            }
        }
        catch (ConnectionException connectionException) {
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error while updating topology");
            throw new RemoteException("Error while updating graph");
        }
    }

    private void report(Connection connection) {
        Report.info.log(TAG, (Object)("connection: " + connection.getType() + " " + connection.getMSE() + " " + connection.getInId() + " " + connection.getOutId()));
    }

    private void printEdges(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            EdgeUserObject edgeUserObject = (EdgeUserObject)vector.get(n);
            Report.debug.log(edgeUserObject.mf1 + " " + edgeUserObject.mf2 + " " + edgeUserObject.mse1 + " " + edgeUserObject.mse2 + " " + edgeUserObject.id1 + " " + edgeUserObject.id2 + " " + edgeUserObject.status);
            ++n;
        }
    }

    private void report(EdgeUserObject edgeUserObject) {
        Report.info.log(TAG, (Object)("new edge: " + edgeUserObject.mse1 + " " + edgeUserObject.id1 + " " + edgeUserObject.mse2 + " " + edgeUserObject.id2));
    }

    private boolean insert(EdgeUserObject edgeUserObject, BasicGraph basicGraph, boolean bl) {
        if (edgeUserObject.mf1 != null && edgeUserObject.mf2 != null) {
            Serializable serializable;
            Iterator iterator = basicGraph.nodes();
            Serializable serializable2 = null;
            Serializable serializable3 = null;
            while (iterator.hasNext()) {
                serializable = (BasicNode)iterator.next();
                MF mF = ((TopologyNode)serializable.getUserObject()).getMF();
                if (mF == edgeUserObject.mf1) {
                    serializable2 = serializable;
                }
                if (mF != edgeUserObject.mf2) continue;
                serializable3 = serializable;
            }
            if (serializable2 != null && serializable3 != null) {
                serializable = new BasicEdge(edgeUserObject, (BasicNode)serializable2, (BasicNode)serializable3);
                edgeUserObject.basicEdge = serializable;
                if (bl) {
                    if (edgeUserObject.status != EdgeUserObject.DEAD) {
                        EventBuilder.buildAndGenerate(edgeUserObject, this.getClass().getName(), "TopologyDiscovery");
                    } else {
                        EventBuilder.buildAndGenerate(edgeUserObject, this.getClass().getName(), "TopologyAddition");
                        this.persistEdges();
                    }
                }
                return true;
            }
        }
        return false;
    }

    public synchronized Vector getDeletedEdges() {
        Report.trace.log(TAG, (Object)"To get deleted edges");
        return (Vector)this.deletedEdges.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean purgeDeletedEdgesByUser(String[] stringArray) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            Report.trace.log(TAG, (Object)"To purge deleted edges");
            boolean bl2 = true;
            int n = 0;
            while (n < stringArray.length) {
                bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "^");
                int n2 = stringTokenizer.countTokens();
                if (n2 != 3) {
                    Report.error.log("wrong edgeID format: " + stringArray[n]);
                    bl2 = false;
                } else {
                    String string = URLDecoder.decode(stringTokenizer.nextToken());
                    String string2 = URLDecoder.decode(stringTokenizer.nextToken());
                    long l = new Long(stringTokenizer.nextToken());
                    int n3 = 0;
                    while (n3 < this.deletedEdges.size()) {
                        EdgeUserObject edgeUserObject = ((DeletedEdge)this.deletedEdges.get(n3)).getEdge();
                        long l2 = ((DeletedEdge)this.deletedEdges.get(n3)).getDate();
                        if (edgeUserObject.mse1 != null && edgeUserObject.mse2 != null) {
                            String string3 = edgeUserObject.mse1.getCIMObjectPath().toString();
                            String string4 = edgeUserObject.mse2.getCIMObjectPath().toString();
                            if (string.equals(string3) && string2.equals(string4) && l == l2) {
                                this.deletedEdges.remove(n3);
                                bl = true;
                                break;
                            }
                        }
                        ++n3;
                    }
                    if (!bl) {
                        bl2 = bl;
                    }
                }
                ++n;
            }
            this.persistEdges();
            bl = bl2;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean undeleteEdgesByUser(String[] stringArray) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            Report.trace.log(TAG, (Object)"To restore deleted edges");
            boolean bl2 = true;
            int n = 0;
            while (n < stringArray.length) {
                bl = false;
                boolean bl3 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "^");
                int n2 = stringTokenizer.countTokens();
                if (n2 != 3) {
                    Report.error.log("wrong edgeID format: " + stringArray[n]);
                    bl2 = false;
                } else {
                    Object object2;
                    String string = URLDecoder.decode(stringTokenizer.nextToken());
                    String string2 = URLDecoder.decode(stringTokenizer.nextToken());
                    long l = new Long(stringTokenizer.nextToken());
                    int n3 = 0;
                    while (n3 < this.edges.size()) {
                        EdgeUserObject edgeUserObject = (EdgeUserObject)this.edges.get(n3);
                        if (edgeUserObject.mse1 != null && (((String)(object2 = edgeUserObject.mse1.getCIMObjectPath().toString())).equals(string) || ((String)object2).equals(string2))) {
                            bl2 = false;
                            bl3 = false;
                            break;
                        }
                        if (edgeUserObject.mse2 != null && (((String)(object2 = edgeUserObject.mse2.getCIMObjectPath().toString())).equals(string) || ((String)object2).equals(string2))) {
                            bl2 = false;
                            bl3 = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl3) {
                        int n4 = 0;
                        while (n4 < this.deletedEdges.size()) {
                            object2 = ((DeletedEdge)this.deletedEdges.get(n4)).getEdge();
                            long l2 = ((DeletedEdge)this.deletedEdges.get(n4)).getDate();
                            if (((EdgeUserObject)object2).mse1 != null && ((EdgeUserObject)object2).mse2 != null) {
                                String string3 = ((EdgeUserObject)object2).mse1.getCIMObjectPath().toString();
                                String string4 = ((EdgeUserObject)object2).mse2.getCIMObjectPath().toString();
                                if (string.equals(string3) && string2.equals(string4) && l == l2) {
                                    this.edges.add(object2);
                                    this.deletedEdges.remove(n4);
                                    bl = this.insert((EdgeUserObject)object2, this.graph, true);
                                    break;
                                }
                            }
                            ++n4;
                        }
                        if (!bl) {
                            bl2 = bl;
                        }
                    }
                }
                ++n;
            }
            Report.trace.log(TAG, (Object)"Finish restoring deleted edges");
            bl = bl2;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteEdgesByUser(String[] stringArray, String string) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            Report.trace.log(TAG, (Object)"To delete edge by user action");
            boolean bl2 = true;
            int n = 0;
            while (n < stringArray.length) {
                bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "^");
                int n2 = stringTokenizer.countTokens();
                if (n2 != 2) {
                    Report.error.log("wrong edgeID format: " + stringArray[n]);
                    bl2 = false;
                } else {
                    String string2 = URLDecoder.decode(stringTokenizer.nextToken());
                    String string3 = URLDecoder.decode(stringTokenizer.nextToken());
                    int n3 = 0;
                    while (n3 < this.edges.size()) {
                        EdgeUserObject edgeUserObject = (EdgeUserObject)this.edges.get(n3);
                        if (edgeUserObject.mse1 != null && edgeUserObject.mse2 != null) {
                            String string4 = edgeUserObject.mse1.getCIMObjectPath().toString();
                            String string5 = edgeUserObject.mse2.getCIMObjectPath().toString();
                            if (string2.equals(string4) && string3.equals(string5) || string3.equals(string4) && string2.equals(string5)) {
                                this.edges.remove(n3);
                                this.deletedEdges.add(new DeletedEdge(string, System.currentTimeMillis(), edgeUserObject));
                                this.remove(edgeUserObject, this.graph, true);
                                bl = true;
                                break;
                            }
                        }
                        ++n3;
                    }
                    if (!bl) {
                        bl2 = bl;
                    }
                }
                ++n;
            }
            Report.trace.log(TAG, (Object)"Finish deleting edge by user action");
            bl = bl2;
            return bl;
        }
    }

    private void remove(EdgeUserObject edgeUserObject, BasicGraph basicGraph, boolean bl) {
        if (edgeUserObject.basicEdge != null) {
            BasicNode basicNode = (BasicNode)edgeUserObject.basicEdge.getTail();
            BasicNode basicNode2 = (BasicNode)edgeUserObject.basicEdge.getHead();
            if (basicNode != null) {
                basicNode.getOutEdgeSet().remove(edgeUserObject.basicEdge);
            }
            if (basicNode2 != null) {
                basicNode2.getInEdgeSet().remove(edgeUserObject.basicEdge);
            }
            edgeUserObject.basicEdge = null;
            if (bl && basicNode != null && basicNode2 != null) {
                EventBuilder.buildAndGenerate(edgeUserObject, this.getClass().getName(), "TopologyRemoval");
                this.persistEdges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEdges(MF mF, Iterator iterator, Vector vector, BasicGraph basicGraph, boolean bl) {
        String string = "unknown";
        try {
            string = mF.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Report.trace.log(TAG, (Object)("To add edges for " + string));
        if (iterator == null) {
            return;
        }
        Report.debug.log(TAG, (Object)("addEdges for " + string));
        Object object = this.lock;
        synchronized (object) {
            while (iterator.hasNext()) {
                EdgeUserObject edgeUserObject;
                Connection connection = (Connection)iterator.next();
                this.report(connection);
                if (!"WWN".equals(connection.getType())) continue;
                boolean bl2 = false;
                int n = 0;
                while (n < vector.size()) {
                    edgeUserObject = (EdgeUserObject)vector.get(n);
                    if (edgeUserObject.mf2 == null && edgeUserObject.mse2 == null && connection.getType().equalsIgnoreCase(edgeUserObject.type)) {
                        if (edgeUserObject.id2 != null && connection.getOutId() != null) {
                            if (edgeUserObject.id2.equalsIgnoreCase(connection.getInId()) && edgeUserObject.id1.equalsIgnoreCase(connection.getOutId())) {
                                edgeUserObject.mf2 = mF;
                                edgeUserObject.mse2 = connection.getMSE();
                                edgeUserObject.c2InId = connection.getInId();
                                edgeUserObject.c2OutId = connection.getOutId();
                                this.insert(edgeUserObject, basicGraph, bl);
                                this.report(edgeUserObject);
                                bl2 = true;
                                break;
                            }
                        } else {
                            if (edgeUserObject.id2 != null && edgeUserObject.id2.equalsIgnoreCase(connection.getInId())) {
                                edgeUserObject.mf2 = mF;
                                edgeUserObject.mse2 = connection.getMSE();
                                edgeUserObject.c2InId = connection.getInId();
                                edgeUserObject.c2OutId = connection.getOutId();
                                this.insert(edgeUserObject, basicGraph, bl);
                                this.report(edgeUserObject);
                                bl2 = true;
                                break;
                            }
                            if (connection.getOutId() != null && edgeUserObject.id1.equalsIgnoreCase(connection.getOutId())) {
                                edgeUserObject.mf2 = mF;
                                edgeUserObject.mse2 = connection.getMSE();
                                edgeUserObject.id2 = connection.getInId();
                                edgeUserObject.c2InId = connection.getInId();
                                edgeUserObject.c2OutId = connection.getOutId();
                                this.insert(edgeUserObject, basicGraph, bl);
                                this.report(edgeUserObject);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    ++n;
                }
                if (bl2) continue;
                edgeUserObject = new EdgeUserObject();
                edgeUserObject.type = connection.getType();
                edgeUserObject.mf1 = mF;
                edgeUserObject.mse1 = connection.getMSE();
                edgeUserObject.id1 = connection.getInId();
                edgeUserObject.id2 = connection.getOutId();
                edgeUserObject.c1InId = connection.getInId();
                edgeUserObject.c1OutId = connection.getOutId();
                if (edgeUserObject.id1 == null) {
                    Report.trace.log("Waring: Get edge Id1 == null for " + string + ". This edge will be ignore");
                    continue;
                }
                vector.add(edgeUserObject);
            }
        }
        Report.trace.log(TAG, (Object)("Finish adding edges for " + string));
    }

    private void addZonesToEdges(MF mF, Vector vector, ArrayList arrayList) {
        int n = 0;
        while (n < vector.size()) {
            String[] stringArray;
            EdgeUserObject edgeUserObject = (EdgeUserObject)vector.get(n);
            if (edgeUserObject.mf1 == mF) {
                stringArray = this.getZoneArray(arrayList, edgeUserObject.mse1);
                edgeUserObject.zones1 = stringArray;
            } else if (edgeUserObject.mf2 == mF) {
                stringArray = this.getZoneArray(arrayList, edgeUserObject.mse2);
                edgeUserObject.zones2 = stringArray;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void matchOldEdges(MF mF, Tree tree, Vector vector, Vector vector2, BasicGraph basicGraph, boolean bl) {
        if (bl) {
            Report.trace.log(TAG, (Object)"try finding a matched old deleted edges");
        } else {
            Report.trace.log(TAG, (Object)"try finding a matched old bad edges");
        }
        Vector<SimpleEdgeUserObject> vector3 = new Vector<SimpleEdgeUserObject>();
        try {
            int n = 0;
            while (n < vector2.size()) {
                SimpleEdgeUserObject simpleEdgeUserObject = (SimpleEdgeUserObject)vector2.get(n);
                if (simpleEdgeUserObject.mfName1.equals(mF.getName())) {
                    Report.trace.log(TAG, (Object)("mf1 matched: " + mF.getName()));
                    simpleEdgeUserObject.mf1 = mF;
                    simpleEdgeUserObject.mse1 = new ReferenceForMSE(simpleEdgeUserObject.creationClassName1, simpleEdgeUserObject.mseName1, simpleEdgeUserObject.systemCreationClassName1, simpleEdgeUserObject.mfName1);
                } else if (simpleEdgeUserObject.mfName2.equals(mF.getName())) {
                    Report.trace.log(TAG, (Object)("mf2 matched: " + mF.getName()));
                    simpleEdgeUserObject.mf2 = mF;
                    simpleEdgeUserObject.mse2 = new ReferenceForMSE(simpleEdgeUserObject.creationClassName2, simpleEdgeUserObject.mseName2, simpleEdgeUserObject.systemCreationClassName2, simpleEdgeUserObject.mfName2);
                }
                if (simpleEdgeUserObject.mf1 != null && simpleEdgeUserObject.mf2 != null) {
                    Object object;
                    if (!bl) {
                        Report.trace.log(TAG, (Object)"find a matched old bad edges");
                        object = this.lock;
                        synchronized (object) {
                            this.insert(simpleEdgeUserObject, basicGraph, false);
                            vector.add(simpleEdgeUserObject);
                        }
                    }
                    Report.trace.log(TAG, (Object)"find a matched old deleted edges");
                    object = this.lock;
                    synchronized (object) {
                        DeletedEdge deletedEdge = new DeletedEdge(simpleEdgeUserObject.user, simpleEdgeUserObject.date, simpleEdgeUserObject);
                        vector.add(deletedEdge);
                    }
                    vector3.add(simpleEdgeUserObject);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector2.remove(vector3.get(n2));
                ++n2;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"error in find old bad edges");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDeletedEdges(Vector vector, MF mF) {
        Object object = this.lock;
        synchronized (object) {
            Vector<DeletedEdge> vector2 = new Vector<DeletedEdge>();
            try {
                Report.trace.log(TAG, (Object)("To delete deleted edges for " + mF.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n = 0;
            while (n < vector.size()) {
                DeletedEdge deletedEdge = (DeletedEdge)vector.get(n);
                EdgeUserObject edgeUserObject = deletedEdge.getEdge();
                if (edgeUserObject.mf1 == mF || edgeUserObject.mf2 == mF) {
                    vector2.add(deletedEdge);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector.remove(vector2.get(n2));
                ++n2;
            }
            this.persistEdges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEdges(Vector vector, MF mF, BasicGraph basicGraph, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Report.trace.log(TAG, (Object)("To delete edges for " + mF.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ArrayList<EdgeUserObject> arrayList = new ArrayList<EdgeUserObject>();
            int n = 0;
            while (n < vector.size()) {
                EdgeUserObject edgeUserObject = (EdgeUserObject)vector.get(n);
                if (edgeUserObject.mf1 == mF && edgeUserObject.mf2 == mF) {
                    this.remove(edgeUserObject, basicGraph, bl);
                    arrayList.add(edgeUserObject);
                } else if (edgeUserObject.mf1 == mF) {
                    if (edgeUserObject.mf2 == null) {
                        arrayList.add(edgeUserObject);
                    } else {
                        this.remove(edgeUserObject, basicGraph, bl);
                        edgeUserObject.mf1 = edgeUserObject.mf2;
                        edgeUserObject.mse1 = edgeUserObject.mse2;
                        edgeUserObject.id1 = edgeUserObject.c2InId;
                        edgeUserObject.id2 = edgeUserObject.c2OutId;
                        edgeUserObject.mf2 = null;
                        edgeUserObject.mse2 = null;
                        edgeUserObject.status = EdgeUserObject.ACTIVE;
                    }
                } else if (edgeUserObject.mf2 == mF) {
                    this.remove(edgeUserObject, basicGraph, bl);
                    edgeUserObject.mf2 = null;
                    edgeUserObject.mse2 = null;
                    edgeUserObject.id2 = edgeUserObject.c1OutId;
                    edgeUserObject.status = EdgeUserObject.ACTIVE;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                vector.remove(arrayList.get(n2));
                ++n2;
            }
        }
        try {
            Report.trace.log(TAG, (Object)("Finish deleting edges for " + mF.getName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String[] getZoneArray(ArrayList arrayList, ReferenceForMSE referenceForMSE) {
        Object object;
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        while (n < arrayList.size()) {
            object = (Zone)arrayList.get(n);
            ArrayList arrayList3 = ((Zone)object).getPortsAsMSE();
            int n2 = 0;
            while (n2 < arrayList3.size()) {
                ReferenceForMSE referenceForMSE2 = (ReferenceForMSE)arrayList3.get(n2);
                if (referenceForMSE.getCreationClassName().equals(referenceForMSE2.getCreationClassName()) && referenceForMSE.getKeyValue().equals(referenceForMSE2.getKeyValue())) {
                    arrayList2.add(((Zone)object).getName());
                }
                ++n2;
            }
            ++n;
        }
        object = new String[arrayList2.size()];
        arrayList2.toArray((T[])object);
        return object;
    }

    private String[] getZoneArray(ArrayList arrayList) {
        Object object;
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        while (n < arrayList.size()) {
            object = (Zone)arrayList.get(n);
            arrayList2.add(((Zone)object).getName());
            ++n;
        }
        object = new String[arrayList2.size()];
        arrayList2.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistEdges() {
        Object object = this.lock;
        synchronized (object) {
            Vector<EdgeUserObject> vector = new Vector<EdgeUserObject>();
            int n = 0;
            while (n < this.edges.size()) {
                EdgeUserObject edgeUserObject = (EdgeUserObject)this.edges.get(n);
                if (edgeUserObject.status == EdgeUserObject.DEAD && edgeUserObject.mf1 != null && edgeUserObject.mf2 != null) {
                    vector.add(edgeUserObject);
                }
                ++n;
            }
            EdgePersistence.saveEdges(vector, "badEdges", false);
            EdgePersistence.saveEdges(this.deletedEdges, "deletedEdges", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(BasicGraph basicGraph, MF mF, String string, String string2, Tree tree, ArrayList arrayList) {
        Object object = this.lock;
        synchronized (object) {
            Report.trace.log(TAG, (Object)("To add Node for " + string));
            String[] stringArray = this.getZoneArray(arrayList);
            basicGraph.add(new BasicNode(new TopologyNode(mF, string, tree, stringArray)));
            Report.trace.log(TAG, (Object)("Finish adding Node for " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode(BasicGraph basicGraph, MF mF) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Report.trace.log(TAG, (Object)("To delete node for " + mF.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Iterator iterator = basicGraph.nodes();
            while (iterator.hasNext()) {
                BasicNode basicNode = (BasicNode)iterator.next();
                MF mF2 = ((TopologyNode)basicNode.getUserObject()).getMF();
                if (!mF2.equals(mF)) continue;
                basicGraph.delete(basicNode);
                break;
            }
        }
        try {
            Report.trace.log(TAG, (Object)("Finish deleting node for " + mF.getName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateGraph(MF mF, BasicGraph basicGraph, Vector vector, boolean bl) throws Exception {
        Object object;
        Object object2;
        Tree tree;
        Iterator iterator;
        TopologyHelper topologyHelper = (TopologyHelper)mF.getServiceHelper("com.sun.jade.apps.topology.lib.TopologyHelper");
        Report.trace.log(TAG, (Object)("To update graph for " + mF.getName()));
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        if (topologyHelper != null) {
            try {
                iterator = topologyHelper.getConnections();
                tree = topologyHelper.getTree();
                object2 = topologyHelper.getZones();
                while (object2.hasNext()) {
                    object = (Zone)object2.next();
                    arrayList.add((Zone)object);
                }
            }
            catch (Exception exception) {
                throw new ConnectionException();
            }
        } else {
            iterator = new ArrayList().iterator();
            object2 = new TreeNode[]{};
            tree = new DefaultTree((TreeNode[])object2);
            Report.error.log("Unable to access the Topology Helper");
        }
        this.addNode(basicGraph, mF, mF.getName(), mF.getClassName(), tree, arrayList);
        object2 = mF.getProperties();
        object = ((Properties)object2).getProperty("discovered");
        if (bl) {
            if (object != null && !"".equals(((String)object).trim())) {
                this.addEdges(mF, iterator, vector, basicGraph, false);
                this.matchOldEdges(mF, tree, vector, this.oldBadEdges, basicGraph, false);
                this.matchOldEdges(mF, tree, this.deletedEdges, this.oldDeletedEdges, basicGraph, true);
            } else {
                this.addEdges(mF, iterator, vector, basicGraph, bl);
            }
        } else {
            this.addEdges(mF, iterator, vector, basicGraph, bl);
        }
        this.addZonesToEdges(mF, vector, arrayList);
        Report.trace.log(TAG, (Object)("Finish updating graph for " + mF.getName()));
    }

    static NetworkGraph getNetworkGraph(BasicGraph basicGraph, Vector vector, boolean bl) {
        Alarm alarm;
        Object[] objectArray;
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String string2;
        Object object5;
        String[] stringArray;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        HashMap hashMap = null;
        try {
            int n = 0;
            object9 = PersistenceService.getService();
            object8 = object9.getGenericPersistence();
            object7 = object8.retrieveAlarmSummary();
            while (object7.hasNext()) {
                object6 = (AlarmSummary)object7.next();
                n += ((AlarmSummary)object6).getQuantity();
            }
            if (n != 0) {
                hashMap = object8.retrieveAlarmSummary(2, 2, true);
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error while getting alarm summary for topology");
        }
        Vector<Object> vector2 = new Vector<Object>();
        object9 = basicGraph.nodes();
        while (object9.hasNext()) {
            object8 = (BasicNode)object9.next();
            object7 = (TopologyNode)((BasicNode)object8).getUserObject();
            object6 = ((TopologyNode)object7).getMF();
            stringArray = ((TopologyNode)object7).getZones();
            object5 = null;
            string2 = null;
            object4 = ((TopologyNode)object7).getMSE();
            object3 = new ArrayList();
            if (!(object6 instanceof DomainMF)) {
                try {
                    string = object6.getCaption().getLocalizedMessage(Locale.ENGLISH);
                    object2 = object6.getProperties().getProperty("contact");
                    object = object6.getProperties().getProperty("location");
                    string2 = object6.getClassName();
                    object5 = object6.getName();
                    ((ArrayList)object3).add(new AssetItemImpl("caption", string == null ? "" : string));
                    ((ArrayList)object3).add(new AssetItemImpl("contact", object2 == null ? "" : object2));
                    ((ArrayList)object3).add(new AssetItemImpl("location", object == null ? "" : object));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            string = "0";
            object2 = null;
            if (hashMap != null && string2 != null && object5 != null && (object = (HashMap)hashMap.get(string2)) != null && (objectArray = (Object[])((HashMap)object).get(object5)) != null) {
                string = objectArray[2].toString();
                alarm = (Alarm)objectArray[0];
                if (alarm != null) {
                    object2 = alarm.getEvent();
                }
            }
            try {
                object = ((ArrayList)object3).size() == 0 ? new NetworkNode(0, object6.getName(), object6.getClassName(), (NSMEvent)object2, string) : new NetworkNode(0, object6.getName(), object6.getClassName(), (List)object3, (NSMEvent)object2, string);
                ((NetworkNode)object).setZones(stringArray);
                vector2.add(object);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        object8 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            object6 = (EdgeUserObject)vector.get(n);
            if (((EdgeUserObject)object6).mf2 != null) {
                try {
                    stringArray = ((EdgeUserObject)object6).type;
                    object5 = ((EdgeUserObject)object6).mf1.getName();
                    string2 = ((EdgeUserObject)object6).mse1.getKeyValue();
                    object4 = ((EdgeUserObject)object6).mf2.getName();
                    object3 = ((EdgeUserObject)object6).mse2.getKeyValue();
                    string = ((EdgeUserObject)object6).mse1.getCreationClassName();
                    object2 = ((EdgeUserObject)object6).mse2.getCreationClassName();
                    object = ((EdgeUserObject)object6).zones1;
                    objectArray = ((EdgeUserObject)object6).zones2;
                    alarm = TopologyServiceImpl.findAlarmForEdge((EdgeUserObject)object6, bl);
                    NSMEvent nSMEvent = null;
                    if (alarm != null) {
                        nSMEvent = alarm.getEvent();
                    }
                    NetworkEdge networkEdge = new NetworkEdge(((EdgeUserObject)object6).status, (String)stringArray, (String)object5, string2, string, (String)object4, (String)object3, (String)object2, nSMEvent);
                    networkEdge.setZones1((String[])object);
                    networkEdge.setZones2((String[])objectArray);
                    ((Vector)object8).add(networkEdge);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ++n;
        }
        stringArray = Long.toString(System.currentTimeMillis());
        object5 = new Date();
        object6 = new NetworkGraph((String)stringArray, (Date)object5, vector2, (List)object8);
        return object6;
    }

    private static Alarm findAlarmForEdge(EdgeUserObject edgeUserObject, boolean bl) {
        Alarm alarm = null;
        if (edgeUserObject.status != EdgeUserObject.DEAD) {
            return alarm;
        }
        try {
            String string = "";
            String string2 = "";
            if (edgeUserObject.mf1 == null || edgeUserObject.mf2 == null) {
                Report.error.log("Topology Service: A MF is null: " + edgeUserObject.mf1 + " " + edgeUserObject.mf2);
                return null;
            }
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            try {
                properties = DevInfo.getDevicePropertiesByClassName(edgeUserObject.mf1.getClassName());
                properties2 = DevInfo.getDevicePropertiesByClassName(edgeUserObject.mf2.getClassName());
                string = edgeUserObject.mf1.getName();
                string2 = edgeUserObject.mf2.getName();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            CIM_ProtocolEndpoint cIM_ProtocolEndpoint = new CIM_ProtocolEndpoint(edgeUserObject.mse1.getCIMObjectPath());
            cIM_ProtocolEndpoint.setCreationClassName(edgeUserObject.mse1.getCreationClassName());
            cIM_ProtocolEndpoint.setName(edgeUserObject.mse1.getKeyValue());
            cIM_ProtocolEndpoint.setSystemCreationClassName(properties.getProperty("CLASS_NAME"));
            cIM_ProtocolEndpoint.setSystemName(string);
            CIM_ProtocolEndpoint cIM_ProtocolEndpoint2 = new CIM_ProtocolEndpoint(edgeUserObject.mse2.getCIMObjectPath());
            cIM_ProtocolEndpoint2.setCreationClassName(edgeUserObject.mse2.getCreationClassName());
            cIM_ProtocolEndpoint2.setName(edgeUserObject.mse2.getKeyValue());
            cIM_ProtocolEndpoint2.setSystemCreationClassName(properties2.getProperty("CLASS_NAME"));
            cIM_ProtocolEndpoint2.setSystemName(string2);
            NWS_DirectLink nWS_DirectLink = new NWS_DirectLink();
            nWS_DirectLink.setType("FC");
            nWS_DirectLink.setState("Active");
            nWS_DirectLink.setAntecedent(cIM_ProtocolEndpoint.getCIMObjectPath());
            nWS_DirectLink.setDependent(cIM_ProtocolEndpoint2.getCIMObjectPath());
            String string3 = nWS_DirectLink.getCIMObjectPath().toString();
            PersistenceService persistenceService = PersistenceService.getService();
            EventsPersistence eventsPersistence = persistenceService.getEventsPersistence();
            alarm = (Alarm)eventsPersistence.retrieveSeverestEventBySubject(string3, 2, 2, 3);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Unable to get event for edge");
        }
        return alarm;
    }

    public synchronized NetworkGraph getNetworkGraph() throws RemoteException {
        return TopologyServiceImpl.getNetworkGraph(this.graph, this.edges, true);
    }

    public synchronized NetworkGraph getNetworkGraph(boolean bl) throws RemoteException {
        return TopologyServiceImpl.getNetworkGraph(this.graph, this.edges, bl);
    }

    public static void main(String[] stringArray) throws Exception {
        TopologyServiceImpl topologyServiceImpl = new TopologyServiceImpl(stringArray[0]);
    }

    private class ConnectionException
    extends Exception {
        private ConnectionException() {
        }
    }
}

