/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.diags.exec.TestRun;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.DatabaseTestTemplate;
import com.sun.jade.apps.persistence.service.GenericPersistenceImpl;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.TestPersistence;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.diag.TestableElement;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestPersistenceImpl
extends GenericPersistenceImpl
implements TestPersistence {
    protected TestPersistenceImpl() throws ConnectionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void storeTestRun(DiagnosticTestInfo diagnosticTestInfo, DiagnosticResult diagnosticResult, String string, String string2) throws ConnectionException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = diagnosticTestInfo.getTestName();
        String string4 = diagnosticTestInfo.getTestClassName();
        String string5 = diagnosticTestInfo.getTestDescription();
        ReferenceForMSE referenceForMSE = diagnosticResult.getMse();
        int n5 = referenceForMSE.getType();
        String string6 = referenceForMSE.getSystemClassName();
        String string7 = referenceForMSE.getSystemName();
        String string8 = referenceForMSE.getCreationClassName();
        String string9 = referenceForMSE.getKeyName();
        String string10 = referenceForMSE.getKeyValue();
        String string11 = diagnosticTestInfo.getTestCharacteristicsString();
        String string12 = diagnosticTestInfo.getTestResourcesString();
        String string13 = diagnosticTestInfo.getSettingsForTest().toString();
        Date date = diagnosticResult.getTestStartTime().getCalendar().getTime();
        Timestamp timestamp = new Timestamp(date.getTime());
        Report.debug.log("TestPersistence", (Object)("Test startTime = " + timestamp));
        Connection connection = null;
        try {
            try {
                AutoCloseable autoCloseable;
                ResultSet resultSet;
                Statement statement;
                n = GenericPersistenceImpl.getMseID(referenceForMSE);
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT testID from Test WHERE testName = ? AND testClassName = ? AND testDescription = ?");
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
                preparedStatement.setString(3, string5);
                ResultSet resultSet2 = preparedStatement.executeQuery();
                if (!resultSet2.next()) {
                    this.fillTest(n, diagnosticTestInfo);
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("CALL IDENTITY()");
                    resultSet.next();
                    n2 = resultSet.getInt(1);
                } else {
                    n2 = resultSet2.getInt(1);
                }
                statement = connection.prepareStatement("SELECT testRunID FROM TestRun where userID = ? AND startTime = ? ");
                statement.setString(1, string);
                statement.setTimestamp(2, timestamp);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) {
                    this.fillTestInfo(diagnosticTestInfo);
                    autoCloseable = connection.createStatement();
                    ResultSet resultSet3 = autoCloseable.executeQuery("CALL IDENTITY()");
                    resultSet3.next();
                    n3 = resultSet3.getInt(1);
                }
                if (diagnosticResult.getTestCompletionTime() == null) {
                    Report.debug.log("TestPersistence", (Object)"Storing interim test result.");
                    this.fillTestRunNoComp(n2, string, string2, n3, diagnosticTestInfo, diagnosticResult);
                } else {
                    statement.setString(1, string);
                    statement.setTimestamp(2, timestamp);
                    autoCloseable = statement.executeQuery();
                    if (!autoCloseable.next()) {
                        Report.debug.log("TestPersistence", (Object)"Storing final and only test result.");
                        this.fillTestRun(n2, string, string2, n3, diagnosticTestInfo, diagnosticResult);
                    } else {
                        Report.debug.log("TestPersistence", (Object)"Update interim testRun with final.");
                        n4 = autoCloseable.getInt(1);
                        this.updateTestRun(n4, diagnosticResult);
                    }
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                sQLException.printStackTrace();
                Object var32_34 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var32_33 = null;
        }
        catch (Throwable throwable) {
            Object var32_35 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TestRun[] retrieveUserTestRuns(String string) throws ConnectionException, NoDataFoundException {
        TestRun[] testRunArray = null;
        Vector<TestRun> vector = new Vector<TestRun>();
        TestRun testRun = null;
        Connection connection = null;
        try {
            Object var68_69;
            Object object;
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM TestRun where userID = ?");
                preparedStatement.setString(1, string);
                object = preparedStatement.executeQuery();
                if (!object.next()) {
                    throw new NoDataFoundException("No Test data found for this User.");
                }
                int n = 0;
                int n2 = 0;
                do {
                    Object object2;
                    int n3 = object.getInt(1);
                    int n4 = object.getInt(2);
                    String string2 = object.getString(3);
                    String string3 = object.getString(4);
                    int n5 = object.getInt(5);
                    boolean bl = object.getBoolean(6);
                    Timestamp timestamp = object.getTimestamp(7);
                    Timestamp timestamp2 = object.getTimestamp(8);
                    Timestamp timestamp3 = object.getTimestamp(9);
                    String string4 = object.getString(10);
                    String string5 = object.getString(11);
                    int n6 = object.getInt(12);
                    String string6 = object.getString(13);
                    int n7 = object.getInt(14);
                    int n8 = object.getInt(15);
                    PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT mseID, testName, testClassName, testDescription FROM Test WHERE testID = ?");
                    preparedStatement2.setInt(1, n4);
                    ResultSet resultSet = preparedStatement2.executeQuery();
                    if (!resultSet.next()) {
                        throw new NoDataFoundException("No Test data found for this TestRun.");
                    }
                    n = resultSet.getInt(1);
                    String string7 = resultSet.getString(2);
                    String string8 = resultSet.getString(3);
                    String string9 = resultSet.getString(4);
                    PreparedStatement preparedStatement3 = connection.prepareStatement("SELECT symptoms, testCharacteristics, testResources, diagnosticSetting, testableElements from testInfo WHERE testInfoID = ?");
                    preparedStatement3.setInt(1, n5);
                    ResultSet resultSet2 = preparedStatement3.executeQuery();
                    if (!resultSet2.next()) {
                        throw new NoDataFoundException("No TestInfo data found for this TestRun.");
                    }
                    String string10 = resultSet2.getString(1);
                    String string11 = resultSet2.getString(2);
                    String string12 = resultSet2.getString(3);
                    String string13 = resultSet2.getString(4);
                    String string14 = resultSet2.getString(5);
                    PreparedStatement preparedStatement4 = connection.prepareStatement("SELECT type, systemClassName, systemName, creationClassName, keyName, keyValue from ReferenceForMSE WHERE mseID = ?");
                    preparedStatement4.setInt(1, n);
                    ResultSet resultSet3 = preparedStatement4.executeQuery();
                    if (!resultSet3.next()) {
                        throw new NoDataFoundException("No ReferenceForMse data found for this TestRun.");
                    }
                    n2 = resultSet3.getInt(1);
                    String string15 = resultSet3.getString(2);
                    String string16 = resultSet3.getString(3);
                    String string17 = resultSet3.getString(4);
                    String string18 = resultSet3.getString(5);
                    String string19 = resultSet3.getString(6);
                    String string20 = "Null";
                    int n9 = 0;
                    boolean bl2 = false;
                    Vector<String> vector2 = new Vector<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string14, ",", false);
                    while (stringTokenizer.hasMoreTokens()) {
                        vector2.add(stringTokenizer.nextToken());
                    }
                    Enumeration enumeration = vector2.elements();
                    String string21 = (String)enumeration.nextElement();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string21, ":", false);
                    string20 = stringTokenizer2.nextToken();
                    bl2 = Boolean.getBoolean(stringTokenizer2.nextToken());
                    n9 = Integer.parseInt(stringTokenizer2.nextToken());
                    TestableElement testableElement = new TestableElement(string20, n9, bl2);
                    ReferenceForMSE referenceForMSE = new ReferenceForMSE(string17, string19, string15, string16, n2);
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string11, ",", false);
                    int[] nArray = new int[stringTokenizer3.countTokens()];
                    int n10 = 0;
                    while (n10 < stringTokenizer3.countTokens()) {
                        nArray[n10] = Integer.parseInt(stringTokenizer3.nextToken());
                        ++n10;
                    }
                    StringTokenizer stringTokenizer4 = new StringTokenizer(string10, ",", false);
                    int[] nArray2 = new int[stringTokenizer4.countTokens()];
                    int n11 = 0;
                    while (n11 < stringTokenizer4.countTokens()) {
                        nArray2[n11] = Integer.parseInt(stringTokenizer4.nextToken());
                        ++n11;
                    }
                    TestExecutable testExecutable = null;
                    DatabaseTestTemplate databaseTestTemplate = new DatabaseTestTemplate(string7, string8, string9, nArray, nArray2, testableElement, testExecutable, string13);
                    DiagnosticTestInfo diagnosticTestInfo = new DiagnosticTestInfo((TestTemplate)databaseTestTemplate, referenceForMSE);
                    DiagnosticResult diagnosticResult = new DiagnosticResult(string8, string7);
                    diagnosticResult.setIsPackage(bl);
                    CIMDateTime cIMDateTime = new CIMDateTime((Date)timestamp);
                    diagnosticResult.setTimeStamp(cIMDateTime);
                    cIMDateTime = new CIMDateTime((Date)timestamp2);
                    diagnosticResult.setTestStartTime(cIMDateTime);
                    if (timestamp3 != null) {
                        object2 = new CIMDateTime((Date)timestamp3);
                        diagnosticResult.setTestCompletionTime((CIMDateTime)object2);
                    }
                    object2 = new StringTokenizer(string4, ",", false);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        diagnosticResult.addTestResults(((StringTokenizer)object2).nextToken());
                    }
                    diagnosticResult.setExecutionID(string5);
                    diagnosticResult.setTestState(n6);
                    diagnosticResult.setOtherStateDescription(string6);
                    Integer n12 = new Integer(n7);
                    diagnosticResult.setPercentComplete(n12.shortValue());
                    diagnosticResult.setEstimatedTimeOfPerforming(n8);
                    testRun = new TestRun(diagnosticTestInfo, diagnosticResult);
                    vector.add(testRun);
                } while (object.next());
                var68_69 = null;
            }
            catch (SQLException sQLException) {
                object = "Unable to retrieve user test runs.";
                Report.error.log((String)object, (Object)sQLException);
                sQLException.printStackTrace();
                var68_69 = null;
                PersistenceService.returnConnection(connection);
            }
            PersistenceService.returnConnection(connection);
        }
        catch (Throwable throwable) {
            Object var68_70 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        testRunArray = new TestRun[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            testRunArray[n] = (TestRun)vector.elementAt(n);
            ++n;
        }
        return testRunArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeUserTestRuns(String string) throws ConnectionException, NoDataFoundException {
        if (string == null) {
            throw new IllegalArgumentException("Unable to remove TestRuns.  The userId parameter is null.");
        }
        Connection connection = null;
        try {
            try {
                PreparedStatement preparedStatement;
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT testInfoID FROM TestRun where userID = ?");
                preparedStatement2.setString(1, string);
                ResultSet resultSet = preparedStatement2.executeQuery();
                if (!resultSet.next()) {
                    throw new NoDataFoundException("No TestRuns found for this userID.");
                }
                do {
                    preparedStatement = connection.prepareStatement("DELETE FROM TestInfo WHERE testInfoID = ?");
                    int n = resultSet.getInt(1);
                    preparedStatement.setInt(1, n);
                    preparedStatement.executeUpdate();
                } while (resultSet.next());
                preparedStatement = connection.prepareStatement("DELETE FROM TestRun WHERE userID = ?");
                preparedStatement.setString(1, string);
                preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                String string2 = "Unable to remove user test runs.";
                Report.error.log(sQLException, (Object)string2);
                Object var8_11 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public TestRun[] retrieveAllTestRuns() throws ConnectionException, NoDataFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void storeUserTest(DiagnosticTestInfo diagnosticTestInfo, String string, String string2) throws ConnectionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public DiagnosticTestInfo[] retrieveUserTests(String string) throws ConnectionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void removeUserTest(String string, String string2) throws ConnectionException, NoDataFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTestRun(int n, DiagnosticResult diagnosticResult) throws ConnectionException {
        Report.debug.log("TestPersistence", (Object)"Start updateTestRun");
        Connection connection = null;
        try {
            try {
                Date date = diagnosticResult.getTestCompletionTime().getCalendar().getTime();
                Timestamp timestamp = new Timestamp(date.getTime());
                String string = diagnosticResult.getResultsString();
                String string2 = diagnosticResult.getExecutionID();
                int n2 = diagnosticResult.getTestStateValue();
                int n3 = diagnosticResult.getPercentCompleteValue();
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE testRun SET completionTime =?, results = ?, executionId = ?, testState = ?, percentComplete = ? WHERE testRunID = ?");
                preparedStatement.setTimestamp(1, timestamp);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setInt(4, n2);
                preparedStatement.setInt(5, n3);
                preparedStatement.setInt(6, n);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string = "TestPersistenceImpl method: updateTestRun failed.";
                Report.error.log(sQLException, (Object)string);
                sQLException.printStackTrace();
                Object var12_14 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTest(int n, DiagnosticTestInfo diagnosticTestInfo) throws ConnectionException {
        Connection connection = null;
        try {
            try {
                String string = diagnosticTestInfo.getTestName();
                String string2 = diagnosticTestInfo.getTestClassName();
                String string3 = diagnosticTestInfo.getTestDescription();
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO Test(mseID, testName, testClassName, testDescription) VALUES(?, ?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string = "TestPersistenceImpl method: fillTest failed.";
                Report.error.log(sQLException, (Object)string);
                sQLException.printStackTrace();
                Object var9_11 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTestInfo(DiagnosticTestInfo diagnosticTestInfo) throws ConnectionException {
        Connection connection = null;
        try {
            try {
                String string = diagnosticTestInfo.getSymptomsString();
                String string2 = diagnosticTestInfo.getTestCharacteristicsString();
                String string3 = diagnosticTestInfo.getTestResourcesString();
                String string4 = diagnosticTestInfo.getSettingsForTest().toString();
                String string5 = diagnosticTestInfo.getTestableElementsString();
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TestInfo(symptoms, testCharacteristics, testResources, diagnosticSetting, testableElements) VALUES(?, ?, ?, ?, ?)");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, string4);
                preparedStatement.setString(5, string5);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string = "TestPersistenceImpl method: fillTestInfo  failed.";
                Report.error.log(sQLException, (Object)string);
                sQLException.printStackTrace();
                Object var10_12 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTestRun(int n, String string, String string2, int n2, DiagnosticTestInfo diagnosticTestInfo, DiagnosticResult diagnosticResult) throws ConnectionException {
        Connection connection = null;
        Report.debug.log("TestPersistence", (Object)"method:fillTestRun");
        try {
            try {
                int n3 = diagnosticResult.getIsPackageInt();
                Date date = diagnosticResult.getTimeStamp().getCalendar().getTime();
                Timestamp timestamp = new Timestamp(date.getTime());
                Date date2 = diagnosticResult.getTestStartTime().getCalendar().getTime();
                Timestamp timestamp2 = new Timestamp(date2.getTime());
                Date date3 = diagnosticResult.getTestCompletionTime().getCalendar().getTime();
                Timestamp timestamp3 = new Timestamp(date3.getTime());
                String string3 = diagnosticResult.getResultsString();
                String string4 = diagnosticResult.getExecutionID();
                int n4 = diagnosticResult.getTestStateValue();
                String string5 = diagnosticResult.getOtherStateDescription();
                int n5 = diagnosticResult.getPercentCompleteValue();
                int n6 = diagnosticResult.getEstimatedTimeOfPerformingValue();
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TestRun(testID, userID, sessionID, testInfoID, isPackage, timeStamp, startTime, completionTime, results, executionID, testState, otherStateDescription, percentComplete, estimatedTimeOfPerform) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setInt(4, n2);
                preparedStatement.setInt(5, n3);
                preparedStatement.setTimestamp(6, timestamp);
                preparedStatement.setTimestamp(7, timestamp2);
                preparedStatement.setTimestamp(8, timestamp3);
                preparedStatement.setString(9, string3);
                preparedStatement.setString(10, string4);
                preparedStatement.setInt(11, n4);
                preparedStatement.setString(12, string5);
                preparedStatement.setInt(13, n5);
                preparedStatement.setInt(14, n6);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string6 = "TestPersistenceImpl method: fillTestRun failed.";
                Report.error.log(sQLException, (Object)string6);
                sQLException.printStackTrace();
                Object var23_25 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var23_24 = null;
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTestRunNoComp(int n, String string, String string2, int n2, DiagnosticTestInfo diagnosticTestInfo, DiagnosticResult diagnosticResult) throws ConnectionException {
        Connection connection = null;
        Report.debug.log("TestPersistence", (Object)"fillTestRunNoComp");
        try {
            try {
                int n3 = diagnosticResult.getIsPackageInt();
                Date date = diagnosticResult.getTimeStamp().getCalendar().getTime();
                Timestamp timestamp = new Timestamp(date.getTime());
                Date date2 = diagnosticResult.getTestStartTime().getCalendar().getTime();
                Timestamp timestamp2 = new Timestamp(date2.getTime());
                String string3 = diagnosticResult.getResultsString();
                String string4 = diagnosticResult.getExecutionID();
                int n4 = diagnosticResult.getTestStateValue();
                String string5 = diagnosticResult.getOtherStateDescription();
                int n5 = diagnosticResult.getPercentCompleteValue();
                int n6 = diagnosticResult.getEstimatedTimeOfPerformingValue();
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TestRun(testID, userID, sessionID, testInfoID, isPackage, timeStamp, startTime, results, executionID, testState, otherStateDescription, percentComplete, estimatedTimeOfPerform) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setInt(4, n2);
                preparedStatement.setInt(5, n3);
                preparedStatement.setTimestamp(6, timestamp);
                preparedStatement.setTimestamp(7, timestamp2);
                preparedStatement.setString(8, string3);
                preparedStatement.setString(9, string4);
                preparedStatement.setInt(10, n4);
                preparedStatement.setString(11, string5);
                preparedStatement.setInt(12, n5);
                preparedStatement.setInt(13, n6);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                String string6 = "TestPersistenceImpl method: fillTestRunNoComp failed.";
                Report.error.log(sQLException, (Object)string6);
                sQLException.printStackTrace();
                Object var21_23 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void retrieveTestRunUserId(String string) throws ConnectionException {
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM TestRun where userID = ?");
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    String string2 = resultSet.getString(3);
                    String string3 = resultSet.getString(4);
                    int n3 = resultSet.getInt(5);
                    boolean bl = resultSet.getBoolean(6);
                    Timestamp timestamp = resultSet.getTimestamp(7);
                    Timestamp timestamp2 = resultSet.getTimestamp(8);
                    Timestamp timestamp3 = resultSet.getTimestamp(9);
                    String string4 = resultSet.getString(10);
                    String string5 = resultSet.getString(11);
                    int n4 = resultSet.getInt(12);
                    String string6 = resultSet.getString(13);
                    int n5 = resultSet.getInt(14);
                    int n6 = resultSet.getInt(15);
                    Report.error.log("By UserId values: " + n + ", " + n2 + ", " + string2 + ", " + n3 + ", " + bl + ", " + timestamp + ", " + timestamp2 + ", " + timestamp3 + ", " + string4 + ", " + string5 + ", " + n4 + ", " + string6 + ", " + n5 + ", " + n6);
                }
            }
            catch (SQLException sQLException) {
                String string7 = "retrieveTestRunUserId failed.";
                Report.error.log(sQLException, (Object)string7);
                sQLException.printStackTrace();
                Object var21_23 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAllTestRun() throws ConnectionException {
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM TestRun");
                ResultSet resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                String string = "deleteAllTestRun";
                Report.error.log(sQLException, (Object)string);
                sQLException.printStackTrace();
                Object var5_7 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting TestServiceImpl Test...");
        String string = "User1";
        String string2 = "User2";
        ReferenceForMSE referenceForMSE = new ReferenceForMSE("CIM_TAPE", "DeviceID", "mse name");
        TestableElement testableElement = new TestableElement("CIM_Device", 0, false);
        String string3 = "MySetting=MaxFlips \n";
        DatabaseTestTemplate databaseTestTemplate = new DatabaseTestTemplate("TESTCLASSNAME", "TapeTESTNAME", "DESCRIPTION", null, null, testableElement, null, string3);
        DiagnosticTestInfo diagnosticTestInfo = new DiagnosticTestInfo((TestTemplate)databaseTestTemplate, referenceForMSE);
        DiagnosticResult diagnosticResult = new DiagnosticResult();
        diagnosticResult.setTimeStamp(new CIMDateTime());
        diagnosticResult.setTestStartTime(new CIMDateTime());
        ReferenceForMSE referenceForMSE2 = new ReferenceForMSE("TapeClass", "MyValue");
        diagnosticResult.setMse(referenceForMSE2);
        diagnosticResult.getMse().setSystemClassName("TapeSparc10");
        diagnosticResult.getMse().setSystemName("Walleye10");
        diagnosticResult.getMse().setCreationClassName("Sun");
        diagnosticResult.addTestResults("Test Started...");
        diagnosticResult.addTestResults("Test Passed!");
        try {
            DiagnosticResult diagnosticResult2;
            int n;
            TestPersistenceImpl testPersistenceImpl = new TestPersistenceImpl();
            testPersistenceImpl.storeTestRun(diagnosticTestInfo, diagnosticResult, string, "session1");
            testPersistenceImpl.retrieveTestRunUserId(string);
            TestRun[] testRunArray = testPersistenceImpl.retrieveUserTestRuns(string);
            if (testRunArray != null) {
                System.out.println("Results from main:");
                n = 0;
                while (n < testRunArray.length) {
                    diagnosticResult2 = testRunArray[n].getResult();
                    System.out.println("Result:" + n + " from DB: " + diagnosticResult2.toString());
                    ++n;
                }
            }
            diagnosticResult.setTestCompletionTime(new CIMDateTime());
            testPersistenceImpl.storeTestRun(diagnosticTestInfo, diagnosticResult, string, "session1");
            testPersistenceImpl.retrieveTestRunUserId(string);
            testRunArray = testPersistenceImpl.retrieveUserTestRuns(string);
            if (testRunArray != null) {
                System.out.println("Results from main:");
                n = 0;
                while (n < testRunArray.length) {
                    diagnosticResult2 = testRunArray[n].getResult();
                    System.out.println("Result:" + n + " from DB: " + diagnosticResult2.toString());
                    ++n;
                }
            }
            testPersistenceImpl.storeTestRun(diagnosticTestInfo, diagnosticResult, string2, "session2");
            testPersistenceImpl.removeUserTestRuns(string);
            TestRun[] testRunArray2 = testPersistenceImpl.retrieveUserTestRuns(string2);
            if (testRunArray2 != null) {
                System.out.println("User2 Results from main:");
                int n2 = 0;
                while (n2 < testRunArray2.length) {
                    DiagnosticResult diagnosticResult3 = testRunArray2[n2].getResult();
                    System.out.println("Result User2:" + n2 + " from DB: " + diagnosticResult3.toString());
                    ++n2;
                }
            }
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        System.exit(0);
    }
}

