/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.GenericPersistenceImpl;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.StatisticsPersistence;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.policy.StatisticInfo;
import com.sun.jade.util.TimerSingleton;
import com.sun.jade.util.log.Report;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public final class StatisticsPersistenceImpl
extends GenericPersistenceImpl
implements StatisticsPersistence {
    private static String selectString = "SELECT mseID, timestamp, type, oldValue, newValue, source, subject, eventTopic, eventType, attrname, attrType FROM Statistics WHERE mseID = ? AND ";
    private static Timer timer;
    private static final long DAY_MILLIS = 86400000L;
    private static final long TEN_DAYS = 864000000L;

    protected StatisticsPersistenceImpl() throws ConnectionException {
        this.initTimer();
    }

    private void initTimer() {
        if (timer == null) {
            timer = TimerSingleton.getTimer();
            DeleteStatisticsTask deleteStatisticsTask = new DeleteStatisticsTask();
            timer.schedule((TimerTask)deleteStatisticsTask, 0L, 86400000L);
        }
    }

    public synchronized void deleteStatistics() throws ConnectionException {
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                long l = System.currentTimeMillis() - 864000000L;
                PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM Statistics where timestamp < ?");
                preparedStatement.setTimestamp(1, new Timestamp(l));
                int n = preparedStatement.executeUpdate();
                connection.commit();
                Report.debug.log(n + " rows deleted");
            }
            catch (SQLException sQLException) {
                String string = "Unable to delete statistic.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public synchronized void storeStatistic(ReferenceForMSE referenceForMSE, StatisticInfo statisticInfo) throws ConnectionException {
        if (statisticInfo == null || referenceForMSE == null) {
            throw new IllegalArgumentException("ReferenceForMSE and StatisticsInfo params cannot be null.");
        }
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO Statistics(mseID, timestamp, type, oldValue, newValue, source, subject, eventTopic, eventType, attrName, attrType) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                int n = 0;
                n = GenericPersistenceImpl.getMseID(referenceForMSE);
                preparedStatement.setInt(1, n);
                if (statisticInfo.getTimeStamp() != null) {
                    preparedStatement.setTimestamp(2, new Timestamp(statisticInfo.getTimeStamp().getTime()));
                }
                preparedStatement.setInt(3, statisticInfo.getType());
                preparedStatement.setString(4, statisticInfo.getOldValue());
                preparedStatement.setString(5, statisticInfo.getNewValue());
                preparedStatement.setString(6, statisticInfo.getSource());
                preparedStatement.setString(7, statisticInfo.getSubject());
                preparedStatement.setString(8, statisticInfo.getEventTopic());
                preparedStatement.setString(9, statisticInfo.getEventType());
                preparedStatement.setString(10, statisticInfo.getAttrName());
                preparedStatement.setString(11, statisticInfo.getAttrType());
                preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                String string = "Unable to store statistic.  Error occurred during record insert.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    public Iterator getStatisticsByAttr(ReferenceForMSE referenceForMSE, Date date, Date date2, String string) throws ConnectionException {
        if (referenceForMSE == null || date == null || date2 == null || string == null) {
            throw new IllegalArgumentException("StatisticsPersistenceImpl:getStatisticsByAttr() Error - No parameters can be null.");
        }
        int n = 0;
        n = GenericPersistenceImpl.getMseID(referenceForMSE);
        ResultSet resultSet = null;
        Connection connection = null;
        Iterator iterator = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(selectString + "attrName = ? AND " + "timestamp > ? AND timestamp < ?");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, string);
                preparedStatement.setTimestamp(3, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(4, new Timestamp(date2.getTime()));
                resultSet = preparedStatement.executeQuery();
                iterator = this.constructStatisticsInfoObj(resultSet);
            }
            catch (SQLException sQLException) {
                String string2 = "Unable to retrieve statistics.  Error occurred during record retrieval.";
                Report.error.log(sQLException, (Object)string2);
                throw new ConnectionException(string2, sQLException);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    public Iterator getStatisticsByType(ReferenceForMSE referenceForMSE, Date date, Date date2, int n) throws ConnectionException {
        if (referenceForMSE == null || date == null || date2 == null) {
            throw new IllegalArgumentException("StatisticsPersistenceImpl:getStatisticsByAttr() Error - No parameters can be null.");
        }
        int n2 = 0;
        n2 = GenericPersistenceImpl.getMseID(referenceForMSE);
        ResultSet resultSet = null;
        Connection connection = null;
        Iterator iterator = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(selectString + "type = ? AND " + "timestamp > ? AND timestamp < ?");
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n);
                preparedStatement.setTimestamp(3, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(4, new Timestamp(date2.getTime()));
                resultSet = preparedStatement.executeQuery();
                iterator = this.constructStatisticsInfoObj(resultSet);
            }
            catch (SQLException sQLException) {
                String string = "Unable to retrieve statistics.  Error occurred during record retrieval.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    public Iterator getStatisticsByEvent(ReferenceForMSE referenceForMSE, Date date, Date date2, String string, String string2) throws ConnectionException {
        if (referenceForMSE == null || date == null || date2 == null || string == null || string2 == null) {
            throw new IllegalArgumentException("StatisticsPersistenceImpl:getStatisticsByAttr() Error - No parameters can be null.");
        }
        int n = 0;
        n = GenericPersistenceImpl.getMseID(referenceForMSE);
        ResultSet resultSet = null;
        Connection connection = null;
        Iterator iterator = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(selectString + "eventTopic = ? AND " + "eventType = ? AND timestamp > ? AND timestamp < ?");
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setTimestamp(4, new Timestamp(date.getTime()));
                preparedStatement.setTimestamp(5, new Timestamp(date2.getTime()));
                resultSet = preparedStatement.executeQuery();
                iterator = this.constructStatisticsInfoObj(resultSet);
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve statistics.  Error occurred during record retrieval.";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    private Iterator constructStatisticsInfoObj(ResultSet resultSet) throws ConnectionException {
        Vector<StatisticInfo> vector = new Vector<StatisticInfo>();
        try {
            while (resultSet.next()) {
                StatisticInfo statisticInfo = new StatisticInfo();
                statisticInfo.setTimeStamp(resultSet.getTimestamp("timestamp"));
                statisticInfo.setType(resultSet.getInt("type"));
                statisticInfo.setOldValue(resultSet.getString("oldValue"));
                statisticInfo.setNewValue(resultSet.getString("newValue"));
                statisticInfo.setSource(resultSet.getString("source"));
                statisticInfo.setSubject(resultSet.getString("subject"));
                statisticInfo.setEventTopic(resultSet.getString("eventTopic"));
                statisticInfo.setEventType(resultSet.getString("eventType"));
                statisticInfo.setAttrName(resultSet.getString("attrName"));
                statisticInfo.setAttrType(resultSet.getString("attrType"));
                vector.addElement(statisticInfo);
            }
        }
        catch (SQLException sQLException) {
            String string = "Unable to retrieve statistics.  Error occurred during record retrieval.";
            Report.error.log(sQLException, (Object)string);
            throw new ConnectionException(string, sQLException);
        }
        return vector.iterator();
    }

    class DeleteStatisticsTask
    extends TimerTask {
        DeleteStatisticsTask() {
        }

        public void run() {
            try {
                StatisticsPersistenceImpl.this.deleteStatistics();
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Error deleting old statistics");
            }
        }
    }
}

