/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.discovery.BaseServiceFinder;
import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.CIMBeanPersistenceImpl;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.DataAlreadyExistsException;
import com.sun.jade.apps.persistence.service.EventsPersistence;
import com.sun.jade.apps.persistence.service.EventsPersistenceImpl;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.Persistence;
import com.sun.jade.apps.persistence.service.StatisticsPersistence;
import com.sun.jade.apps.persistence.service.StatisticsPersistenceImpl;
import com.sun.jade.apps.persistence.service.TestPersistence;
import com.sun.jade.apps.persistence.service.TestPersistenceImpl;
import com.sun.jade.apps.persistence.service.TopologyPersistence;
import com.sun.jade.apps.persistence.service.TopologyPersistenceImpl;
import com.sun.jade.apps.persistence.service.ViewManager;
import com.sun.jade.apps.persistence.util.db.ConnectionPool;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.event.AbstractEventSubscriber;
import com.sun.jade.services.event.EventService;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.sql.Connection;
import java.sql.SQLException;

public final class PersistenceService
implements Persistence,
AbstractEventSubscriber {
    private static TestPersistenceImpl testPersistence = null;
    private static CIMBeanPersistenceImpl cimBeanPersistence = null;
    private static TopologyPersistenceImpl topologyPersistence = null;
    private static StatisticsPersistenceImpl statisticsPersistence = null;
    private static EventsPersistenceImpl eventsPersistence = null;
    private static PersistenceService persistenceService = null;
    private static ViewManager viewManager = null;
    static /* synthetic */ Class class$com$sun$jade$apps$persistence$service$PersistenceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceService() throws ConnectionException {
        Class clazz = class$com$sun$jade$apps$persistence$service$PersistenceService == null ? (class$com$sun$jade$apps$persistence$service$PersistenceService = PersistenceService.class$("com.sun.jade.apps.persistence.service.PersistenceService")) : class$com$sun$jade$apps$persistence$service$PersistenceService;
        synchronized (clazz) {
            if (persistenceService != null) {
                throw new IllegalStateException();
            }
            persistenceService = this;
            testPersistence = new TestPersistenceImpl();
            cimBeanPersistence = new CIMBeanPersistenceImpl();
            topologyPersistence = new TopologyPersistenceImpl();
            statisticsPersistence = new StatisticsPersistenceImpl();
            eventsPersistence = new EventsPersistenceImpl();
            viewManager = new ViewManager();
            EventService eventService = BaseServiceFinder.getEventService();
            eventService.subscribe(this, ".");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    ConnectionPool.closeConnections();
                }
            });
        }
    }

    public static PersistenceService getService() throws ConnectionException {
        if (persistenceService == null) {
            new PersistenceService();
        }
        return persistenceService;
    }

    public GenericPersistence getGenericPersistence() throws ConnectionException {
        if (testPersistence == null) {
            new PersistenceService();
        }
        return testPersistence;
    }

    public TestPersistence getTestPersistence() throws ConnectionException {
        if (testPersistence == null) {
            new PersistenceService();
        }
        return testPersistence;
    }

    public CIMBeanPersistence getCIMBeanPersistence() throws ConnectionException {
        if (cimBeanPersistence == null) {
            new PersistenceService();
        }
        return cimBeanPersistence;
    }

    public TopologyPersistence getTopologyPersistence() throws ConnectionException {
        if (topologyPersistence == null) {
            new PersistenceService();
        }
        return topologyPersistence;
    }

    public StatisticsPersistence getStatisticsPersistence() throws ConnectionException {
        if (statisticsPersistence == null) {
            new PersistenceService();
        }
        return statisticsPersistence;
    }

    public EventsPersistence getEventsPersistence() throws ConnectionException {
        if (eventsPersistence == null) {
            new PersistenceService();
        }
        return eventsPersistence;
    }

    public ViewManager getViewManager() {
        return viewManager;
    }

    static Connection getConnection() throws ConnectionException {
        Connection connection = null;
        String string = "CIMBeanPersistence: Unable to get database connection.";
        try {
            connection = ConnectionPool.getConnection();
        }
        catch (SQLException sQLException) {
            Report.error.log(sQLException, (Object)string);
            throw new ConnectionException(string, sQLException);
        }
        if (connection == null) {
            Report.error.log(string);
            throw new ConnectionException(string);
        }
        return connection;
    }

    static void returnConnection(Connection connection) {
        ConnectionPool.returnConnection(connection);
    }

    public void notify(AbstractEvent abstractEvent) {
        if (abstractEvent instanceof NSMEvent && !abstractEvent.getTopic().startsWith(".private.") && !abstractEvent.getTopic().startsWith(".alert.clear.")) {
            try {
                topologyPersistence.storeEvent((NSMEvent)abstractEvent);
            }
            catch (ConnectionException connectionException) {
                String string = "Unable to store subscribed to NSMEvent.";
                Report.error.log(connectionException, (Object)string);
            }
            catch (DataAlreadyExistsException dataAlreadyExistsException) {
                String string = "Unable to store subscribed to NSMEvent.";
                Report.error.log(dataAlreadyExistsException, (Object)string);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Start Persistence Test");
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            System.out.println("Start Test Test");
            TestPersistence testPersistence = persistenceService.getTestPersistence();
            System.out.println("Start Topo Test");
            TopologyPersistence topologyPersistence = persistenceService.getTopologyPersistence();
            System.out.println("Start Health Test");
            CIMBeanPersistence cIMBeanPersistence = persistenceService.getCIMBeanPersistence();
            System.exit(0);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

