/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.DataAlreadyExistsException;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.CIM_DiskDrive;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlarmSummary;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.jade.util.unittest.UnitTestError;
import com.sun.netstorage.mgmt.service.event.NWS_BaseEvent;
import com.sun.netstorage.mgmt.service.event.NWS_PublicEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class NSMEventHelper {
    public static final int ALL = -1;
    public static final int IS_ACK = 1;
    public static final int NOT_ACK = 2;
    public static final int IS_CLEARED = 1;
    public static final int NOT_CLEARED = 2;
    public static final int NON_ALARM_EVENTS = 2;
    public static final int ALARM_EVENTS = 3;
    protected static final String EVENT_TABLE = "NSMEvent";
    protected static final String ALARM_TABLE = "Alarm";
    protected static final String attrsClause = " mseID, eventID, source, sourceSequenceNumber, sourceTime, type, topic, severity, correlatedEvents, subject, subjectTime, payloadType, payload ";
    protected static final String attrsAlarmClause = " mseID, eventID, source, sourceSequenceNumber, sourceTime, type, topic, severity, correlatedEvents, subject, subjectTime, payloadType, payload , ackTime, ackBy, isAcked, note, isCleared, clearTime ";

    NSMEventHelper() {
    }

    private static void checkEventValidity(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            String string = "Unable to store event.  The NSMEvent attribute is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        String string = nSMEvent.getEventID();
        String string2 = nSMEvent.getSubject();
        if (string2 == null || string2.equals("")) {
            String string3 = "Unable to store event.  The NSMEvent.subject attribute is null or equals an empty string.";
            Report.error.log(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string.equals("")) {
            String string4 = "Unable to store event the NSMEvent.eventID attribute is null or equals an empty string";
            Report.error.log(string4);
            throw new IllegalArgumentException(string4);
        }
    }

    static synchronized void storeEvent(NSMEvent nSMEvent) throws DataAlreadyExistsException, ConnectionException {
        AutoCloseable autoCloseable;
        NSMEventHelper.checkEventValidity(nSMEvent);
        String string = nSMEvent.getEventID();
        String string2 = nSMEvent.getSubject();
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                PreparedStatement preparedStatement = nSMEvent.getTopic() != null && nSMEvent.getTopic().startsWith(".alert") ? connection.prepareStatement("SELECT COUNT(*) from Alarm WHERE eventID = ?") : connection.prepareStatement("SELECT COUNT(*) from NSMEvent WHERE eventID = ?");
                preparedStatement.setString(1, string);
                autoCloseable = preparedStatement.executeQuery();
                autoCloseable.next();
                int n = autoCloseable.getInt(1);
                if (n != 0) {
                    String string3 = "Unable to store event.  Data exists for eventID " + string + ".";
                    Report.error.log(string3);
                    throw new DataAlreadyExistsException(string3);
                }
                Object var9_16 = null;
            }
            catch (SQLException sQLException) {
                String string4 = "Unable to store event.  Unable to query to see if event already exists.";
                Report.error.log(sQLException, (Object)string4);
                throw new ConnectionException(string4, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        int n = 0;
        connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                autoCloseable = nSMEvent.getTopic() != null && nSMEvent.getTopic().startsWith(".alert") ? connection.prepareStatement("INSERT INTO Alarm ( mseID, eventID, source, sourceSequenceNumber, sourceTime, type, topic, severity, correlatedEvents, subject, subjectTime, payloadType, payload , ackTime, ackBy, isAcked, note, isCleared, clearTime ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?)") : connection.prepareStatement("INSERT INTO NSMEvent ( mseID, eventID, source, sourceSequenceNumber, sourceTime, type, topic, severity, correlatedEvents, subject, subjectTime, payloadType, payload ) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                autoCloseable.setInt(1, n);
                autoCloseable.setString(2, string);
                autoCloseable.setString(3, nSMEvent.getSource());
                autoCloseable.setLong(4, nSMEvent.getSourceSequenceNumber());
                autoCloseable.setTimestamp(5, new Timestamp(nSMEvent.getSourceTime()));
                autoCloseable.setString(6, nSMEvent.getType());
                autoCloseable.setString(7, nSMEvent.getTopic());
                autoCloseable.setInt(8, nSMEvent.getSeverity());
                autoCloseable.setObject(9, nSMEvent.getCorrelatedEvents());
                autoCloseable.setString(10, string2);
                autoCloseable.setLong(11, nSMEvent.getSubjectTime());
                autoCloseable.setString(12, nSMEvent.getPayloadType());
                Object object = nSMEvent.getPayload();
                if (object instanceof String) {
                    autoCloseable.setObject(13, object);
                }
                if (nSMEvent.getTopic() != null && nSMEvent.getTopic().startsWith(".alert")) {
                    Alarm alarm = new Alarm(nSMEvent);
                    autoCloseable.setLong(14, alarm.getAckTime());
                    autoCloseable.setString(15, alarm.getAckBy());
                    autoCloseable.setBoolean(16, alarm.getIsAcked());
                    autoCloseable.setString(17, alarm.getNote());
                    autoCloseable.setBoolean(18, alarm.getIsCleared());
                    autoCloseable.setLong(19, alarm.getClearTime());
                }
                autoCloseable.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    Report.error.log(sQLException2, (Object)"Error rolling back transaction.");
                }
                String string5 = "Unable to store event.  Unable to insert event.";
                Report.error.log(sQLException, (Object)string5);
                throw new ConnectionException(string5, sQLException);
            }
            Object var11_19 = null;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void updateEvent(NSMEvent nSMEvent) throws ConnectionException {
        NSMEventHelper.checkEventValidity(nSMEvent);
        String string = nSMEvent.getEventID();
        String string2 = nSMEvent.getSubject();
        int n = 0;
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                if (nSMEvent.getTopic() != null && nSMEvent.getTopic().startsWith(".alert")) {
                    String string3 = ALARM_TABLE;
                } else {
                    String string4 = EVENT_TABLE;
                }
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE Alarm SET  mseID = ?, source = ?, sourceSequenceNumber = ?, sourceTime = ?,  type = ?, topic = ?, severity = ?, correlatedEvents = ?,  subject = ?, subjectTime = ?, payloadtype = ?, payload = ?   WHERE eventID = ?");
                preparedStatement.setString(13, string);
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, nSMEvent.getSource());
                preparedStatement.setLong(3, nSMEvent.getSourceSequenceNumber());
                preparedStatement.setTimestamp(4, new Timestamp(nSMEvent.getSourceTime()));
                preparedStatement.setString(5, nSMEvent.getType());
                preparedStatement.setString(6, nSMEvent.getTopic());
                preparedStatement.setInt(7, nSMEvent.getSeverity());
                preparedStatement.setObject(8, nSMEvent.getCorrelatedEvents());
                preparedStatement.setString(9, string2);
                preparedStatement.setLong(10, nSMEvent.getSubjectTime());
                preparedStatement.setString(11, nSMEvent.getPayloadType());
                Object object = nSMEvent.getPayload();
                if (object instanceof String) {
                    preparedStatement.setObject(12, object);
                }
                preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                Object var9_11 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized void updateCorrelatedEvents(NSMEvent nSMEvent) throws ConnectionException {
        NSMEventHelper.checkEventValidity(nSMEvent);
        String string = nSMEvent.getEventID();
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                if (nSMEvent.getTopic() != null && nSMEvent.getTopic().startsWith(".alert")) {
                    String string2 = ALARM_TABLE;
                } else {
                    String string3 = EVENT_TABLE;
                }
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE Alarm SET  correlatedEvents = ?  WHERE eventID = ?");
                preparedStatement.setString(2, string);
                preparedStatement.setObject(1, nSMEvent.getCorrelatedEvents());
                preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException sQLException) {
                Object var6_8 = null;
                PersistenceService.returnConnection(connection);
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    private static void updateAlarm(Alarm alarm, Connection connection) throws SQLException {
        if (alarm != null) {
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE Alarm SET ackTime = ?, ackBy = ?, isAcked = ?, note = ?, isCleared = ?, clearTime = ? WHERE eventID = ?");
            preparedStatement.setString(7, alarm.getEvent().getEventID());
            preparedStatement.setLong(1, alarm.getAckTime());
            preparedStatement.setString(2, alarm.getAckBy());
            preparedStatement.setBoolean(3, alarm.getIsAcked());
            preparedStatement.setString(4, alarm.getNote());
            preparedStatement.setBoolean(5, alarm.getIsCleared());
            preparedStatement.setLong(6, alarm.getClearTime());
            preparedStatement.executeUpdate();
        }
    }

    static void updateAlarm(Alarm alarm) throws ConnectionException {
        String string = alarm.getEvent().getEventID();
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM Alarm  WHERE eventID = '" + string + "'");
                resultSet.next();
                int n = resultSet.getInt(1);
                if (n == 0) {
                    String string2 = "Unable to update Alarm information.  Records do not  exist for both the alarm and the event.";
                    Report.error.log(string2);
                    throw new ConnectionException(string2);
                }
                NSMEventHelper.updateAlarm(alarm, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to updateAlarm information.";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    private static String addAckAndCleared(String string, int n, int n2) {
        boolean bl = true;
        bl = string.indexOf("WHERE") <= 0;
        String string2 = string;
        String string3 = null;
        String string4 = null;
        String string5 = bl ? " WHERE " : " AND ";
        if (n == 1) {
            string3 = " ISACKED = TRUE ";
        } else if (n == 2) {
            string3 = " ISACKED != TRUE ";
        }
        if (n2 == 1) {
            string4 = " ISCLEARED = TRUE ";
        } else if (n2 == 2) {
            string4 = " ISCLEARED != TRUE ";
        }
        if (string3 != null) {
            string2 = string2 + string5 + string3;
            if (string4 != null) {
                string2 = string2 + " AND " + string4;
            }
        } else if (string4 != null) {
            string2 = string2 + string5 + string4;
        }
        return string2;
    }

    private static String addTopicAndSeverity(String string, String string2, int n, int n2) {
        boolean bl = true;
        bl = string.indexOf("WHERE") <= 0;
        String string3 = string;
        String string4 = null;
        String string5 = null;
        String string6 = bl ? " WHERE " : " AND ";
        if (string2 != null) {
            string4 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string4 + " TOPIC LIKE '" + stringTokenizer.nextToken() + "%' OR";
            }
            if ((string4 = string4.substring(0, string4.length() - 2)).indexOf("OR") > 0) {
                string4 = " (" + string4 + ") ";
            }
        }
        if (n >= 0 && n2 >= 0) {
            string5 = n == n2 ? " SEVERITY = " + n : " SEVERITY >= " + n + " AND SEVERITY <= " + n2;
        }
        if (string4 != null) {
            string3 = string3 + string6 + string4;
            if (string5 != null) {
                string3 = string3 + " AND " + string5;
            }
        } else if (string5 != null) {
            string3 = string3 + string6 + string5;
        }
        return string3;
    }

    static long countEvents(String string, int n, int n2, int n3, int n4, int n5) throws ConnectionException {
        long l = -1L;
        String string2 = null;
        Connection connection = null;
        Object var10_9 = null;
        Object var11_10 = null;
        if (n5 == 3) {
            string2 = "SELECT COUNT(*) FROM Alarm";
        } else if (n5 == 2) {
            string2 = "SELECT COUNT(*) FROM NSMEvent";
        }
        string2 = NSMEventHelper.addTopicAndSeverity(string2, string, n, n2);
        if (n5 == 3) {
            string2 = string2.indexOf("WHERE") > 0 ? NSMEventHelper.addAckAndCleared(string2, n3, n4) : NSMEventHelper.addAckAndCleared(string2, n3, n4);
        }
        try {
            block8: {
                try {
                    connection = PersistenceService.getConnection();
                    Statement statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(string2);
                    if (!resultSet.next()) break block8;
                    l = resultSet.getInt(1);
                }
                catch (SQLException sQLException) {
                    String string3 = "Unable to count events.";
                    Report.error.log(sQLException, (Object)string3);
                    throw new ConnectionException(string3, sQLException);
                }
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return l;
    }

    static long countEvents(String string, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEvents(string, -1, -1, n, n2, n3);
    }

    static long countEvents(int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEvents(null, n, n2, n3);
    }

    static Iterator retrieveEvents(String string, int n, int n2, int n3, int n4, int n5, long l, long l2) throws ConnectionException {
        Iterator iterator = null;
        String string2 = "SELECT ";
        if (l >= 0L && l2 >= 0L) {
            string2 = string2 + "LIMIT " + l + " " + l2;
        }
        string2 = string2 + " * ";
        if (n5 == 3) {
            string2 = string2 + "FROM " + ALARM_TABLE;
            string2 = NSMEventHelper.addTopicAndSeverity(string2, string, n, n2);
            string2 = NSMEventHelper.addAckAndCleared(string2, n3, n4);
            string2 = string2 + " ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(string2);
        } else if (n5 == 2) {
            string2 = string2 + "FROM " + EVENT_TABLE;
            string2 = NSMEventHelper.addTopicAndSeverity(string2, string, n, n2);
            string2 = string2 + " ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(string2);
        }
        return iterator;
    }

    static Iterator retrieveEvents(String string, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEvents(string, -1, -1, n, n2, n3, l, l2);
    }

    static Iterator retrieveEvents(String string, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEvents(string, n, n2, n3, -1L, -1L);
    }

    static Iterator retrieveEvents(int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEvents(null, n, n2, n3, -1L, -1L);
    }

    static Iterator retrieveEventsBySubject(String string, int n) throws ConnectionException {
        Iterator iterator = null;
        if (n == 3) {
            String string2 = "SELECT * FROM Alarm WHERE Alarm.subject = '" + string + "' " + "ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(string2);
        } else if (n == 2) {
            String string3 = "SELECT * FROM NSMEvent WHERE NSMEvent.subject = '" + string + "' " + "ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(string3);
        }
        return iterator;
    }

    static Object retrieveLastEventBySubject(String string, int n, int n2, int n3) throws ConnectionException {
        String string2 = " *, MAX SUBJECTTIME ";
        return NSMEventHelper.retrieveSpecificEventBySubject(string, string2, false, n, n2, n3);
    }

    static Object retrieveSeverestEventBySubject(String string, int n, int n2, int n3) throws ConnectionException {
        String string2 = " LIMIT 0 1 * ";
        return NSMEventHelper.retrieveSpecificEventBySubject(string, string2, true, n, n2, n3);
    }

    static Object retrieveSpecificEventBySubject(String string, String string2, boolean bl, int n, int n2, int n3) throws ConnectionException {
        Object var8_9;
        block6: {
            Iterator iterator = null;
            if (n3 == 3) {
                String string3 = "SELECT " + string2 + " " + "FROM " + ALARM_TABLE + " " + "WHERE " + ALARM_TABLE + ".subject = '" + string + "' ";
                string3 = NSMEventHelper.addAckAndCleared(string3, n, n2);
                if (bl) {
                    string3 = string3 + " ORDER BY severity DESC, subjectTime DESC";
                }
                iterator = NSMEventHelper.createAlarms(string3);
            } else if (n3 == 2) {
                String string4 = "SELECT " + string2 + " " + "FROM " + EVENT_TABLE + " " + "WHERE " + EVENT_TABLE + ".subject = '" + string + "' ";
                if (bl) {
                    string4 = string4 + " ORDER BY subjectTime DESC";
                }
                iterator = NSMEventHelper.createEvents(string4);
            }
            var8_9 = null;
            if (iterator == null) break block6;
            if (iterator.hasNext()) {
                var8_9 = iterator.next();
            }
        }
        return var8_9;
    }

    static Iterator retrieveEventsByTopic(String string, int n) throws ConnectionException {
        Iterator iterator = null;
        if (n == 3) {
            String string2 = "SELECT * FROM Alarm WHERE Alarm.topic = '" + string + "' " + "ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(string2);
        } else if (n == 2) {
            String string3 = "SELECT * FROM NSMEvent WHERE NSMEvent.topic = '" + string + "' " + "ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(string3);
        }
        return iterator;
    }

    static Iterator retrieveEvents(String string, String string2, int n, int n2) throws ConnectionException {
        Iterator iterator = null;
        if (n2 == 3) {
            String string3 = "SELECT * FROM Alarm WHERE Alarm.subject = '" + string + "' " + "AND   " + ALARM_TABLE + ".topic = '" + string2 + "' " + "AND   " + ALARM_TABLE + ".severity = " + n + " " + "ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(string3);
        } else if (n2 == 2) {
            String string4 = "SELECT * FROM NSMEvent WHERE NSMEvent.subject = '" + string + "' " + "AND   " + EVENT_TABLE + ".topic = '" + string2 + "' " + "AND   " + EVENT_TABLE + ".severity = " + n + " " + "ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(string4);
        }
        return iterator;
    }

    private static String buildSystemTypeString(String[] stringArray) {
        String string;
        if (stringArray.length == 1) {
            string = " = '" + stringArray[0] + "' ";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'" + stringArray[n] + "'");
                ++n;
            }
            string = " IN ( " + stringBuffer.toString() + " )";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long countEventsBySystemType(String string, int n, int n2, String[] stringArray, int n3, int n4, int n5) throws ConnectionException {
        Connection connection;
        long l;
        block10: {
            long string5;
            block9: {
                l = -1L;
                Object var10_8 = null;
                String string3 = NSMEventHelper.buildSystemTypeString(stringArray);
                String string4 = "SELECT subject FROM ManagedElementSubjectLookup l  WHERE l.creationClassName " + string3 + " OR l.systemCreationClassName " + string3;
                connection = null;
                try {
                    try {
                        connection = PersistenceService.getConnection();
                        Iterator iterator = NSMEventHelper.createSubjects(connection, string4);
                        String string2 = NSMEventHelper.buildSubjectString(iterator);
                        if (string2.length() == 0) {
                            string5 = 0L;
                            Object var19_19 = null;
                            break block9;
                        }
                        if (n5 == 3) {
                            String string6 = "SELECT COUNT(*) FROM Alarm n WHERE subject IN ( " + string2 + " ) ";
                            string6 = NSMEventHelper.addTopicAndSeverity(string6, string, n, n2);
                            string6 = NSMEventHelper.addAckAndCleared(string6, n3, n4);
                            Statement statement = connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string6);
                            if (resultSet.next()) {
                                l = resultSet.getLong(1);
                            }
                            break block10;
                        }
                        if (n5 != 2) break block10;
                        String string6 = "SELECT COUNT(*) FROM NSMEvent n WHERE subject IN ( " + string2 + " ) ";
                        string6 = NSMEventHelper.addTopicAndSeverity(string6, string, n, n2);
                        Statement statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(string6);
                        if (resultSet.next()) {
                            l = resultSet.getInt(1);
                        }
                        break block10;
                    }
                    catch (SQLException sQLException) {
                        String string7 = "Unable to count alarms/events";
                        Report.error.log(sQLException, (Object)string7);
                        throw new ConnectionException(string7, sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    PersistenceService.returnConnection(connection);
                    throw throwable;
                }
            }
            PersistenceService.returnConnection(connection);
            return string5;
        }
        Object var19_20 = null;
        PersistenceService.returnConnection(connection);
        return l;
    }

    static long countEventsBySystemType(String string, String[] stringArray, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemType(string, -1, -1, stringArray, n, n2, n3);
    }

    static long countEventsBySystemType(String[] stringArray, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemType(null, stringArray, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterator retrieveEventsBySystemType(String string, int n, int n2, String[] stringArray, int n3, int n4, int n5, long l, long l2) throws ConnectionException {
        String string2;
        Connection connection;
        Iterator iterator;
        block8: {
            Iterator iterator2;
            iterator = null;
            String string3 = NSMEventHelper.buildSystemTypeString(stringArray);
            String string4 = "SELECT subject FROM ManagedElementSubjectLookup l  WHERE l.creationClassName " + string3 + " OR l.systemCreationClassName " + string3;
            connection = null;
            try {
                connection = PersistenceService.getConnection();
                Iterator iterator3 = NSMEventHelper.createSubjects(connection, string4);
                string2 = NSMEventHelper.buildSubjectString(iterator3);
                if (string2.length() != 0) break block8;
                iterator2 = new ArrayList().iterator();
                Object var19_18 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                PersistenceService.returnConnection(connection);
                throw throwable;
            }
            PersistenceService.returnConnection(connection);
            return iterator2;
        }
        if (n5 == 3) {
            String string5 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string5 = string5 + "LIMIT " + l + " " + l2;
            }
            string5 = string5 + " * " + "FROM " + ALARM_TABLE + " n " + "WHERE subject IN " + "( " + string2 + " ) ";
            string5 = NSMEventHelper.addTopicAndSeverity(string5, string, n, n2);
            string5 = NSMEventHelper.addAckAndCleared(string5, n3, n4);
            string5 = string5 + " ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(connection, string5);
        } else if (n5 == 2) {
            String string6 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string6 = string6 + "LIMIT " + l + " " + l2;
            }
            string6 = string6 + " * " + "FROM " + EVENT_TABLE + " n " + "WHERE subject IN " + "( " + string2 + " ) ";
            string6 = NSMEventHelper.addTopicAndSeverity(string6, string, n, n2);
            string6 = string6 + " ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(connection, string6);
        }
        Object var19_19 = null;
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    static Iterator retrieveEventsBySystemType(String string, String[] stringArray, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, -1, -1, stringArray, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemType(String string, String[] stringArray, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, stringArray, n, n2, n3, -1L, -1L);
    }

    static Iterator retrieveEventsBySystemType(String[] stringArray, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(null, stringArray, n, n2, n3);
    }

    static Iterator retrieveEventsBySystemType(String[] stringArray, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(null, stringArray, n, n2, n3, l, l2);
    }

    static long countEventsBySystemType(String string, int n, int n2, String string2, int n3, int n4, int n5) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemType(string, n, n2, new String[]{string2}, n3, n4, n5);
    }

    static long countEventsBySystemType(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemType(string, new String[]{string2}, n, n2, n3);
    }

    static long countEventsBySystemType(String string, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemType(new String[]{string}, n, n2, n3);
    }

    static Iterator retrieveEventsBySystemType(String string, int n, int n2, String string2, int n3, int n4, int n5, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, n, n2, new String[]{string2}, n3, n4, n5, l, l2);
    }

    static Iterator retrieveEventsBySystemType(String string, String string2, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, new String[]{string2}, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemType(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, new String[]{string2}, n, n2, n3);
    }

    static Iterator retrieveEventsBySystemType(String string, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(new String[]{string}, n, n2, n3);
    }

    static Iterator retrieveEventsBySystemType(String string, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(new String[]{string}, n, n2, n3, l, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long countEventsBySystemName(String string, int n, int n2, String string2, String string3, int n3, int n4, int n5) throws ConnectionException {
        Connection connection;
        long l;
        block10: {
            long string6;
            block9: {
                l = -1L;
                String string5 = NSMEventHelper.buildSubjectForSystemName(string2, string3);
                connection = null;
                try {
                    try {
                        connection = PersistenceService.getConnection();
                        Iterator iterator = NSMEventHelper.createSubjects(connection, string5);
                        String string4 = NSMEventHelper.buildSubjectString(iterator);
                        if (string4.length() == 0) {
                            string6 = 0L;
                            Object var18_18 = null;
                            break block9;
                        }
                        if (n5 == 3) {
                            String string7 = "SELECT COUNT(*) FROM Alarm n WHERE subject IN ( " + string4 + " )";
                            string7 = NSMEventHelper.addTopicAndSeverity(string7, string, n, n2);
                            string7 = NSMEventHelper.addAckAndCleared(string7, n3, n4);
                            Statement statement = connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string7);
                            if (resultSet.next()) {
                                l = resultSet.getLong(1);
                            }
                            break block10;
                        }
                        if (n5 != 2) break block10;
                        String string7 = "SELECT COUNT(*) FROM NSMEvent n WHERE subject IN ( " + string4 + " )";
                        string7 = NSMEventHelper.addTopicAndSeverity(string7, string, n, n2);
                        Statement statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(string7);
                        if (resultSet.next()) {
                            l = resultSet.getLong(1);
                        }
                        break block10;
                    }
                    catch (SQLException sQLException) {
                        String string8 = "Unable to retrieve alarm quantity.";
                        Report.error.log(sQLException, (Object)string8);
                        throw new ConnectionException(string8, sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    PersistenceService.returnConnection(connection);
                    throw throwable;
                }
            }
            PersistenceService.returnConnection(connection);
            return string6;
        }
        Object var18_19 = null;
        PersistenceService.returnConnection(connection);
        return l;
    }

    static long countEventsBySystemName(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemName(string, -1, -1, string2, string3, n, n2, n3);
    }

    static long countEventsBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemName(null, string, string2, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterator retrieveEventsBySystemName(String string, int n, int n2, String string2, String string3, int n3, int n4, int n5, long l, long l2) throws ConnectionException {
        String string4;
        Connection connection;
        Iterator iterator;
        block8: {
            Iterator iterator2;
            iterator = null;
            String string5 = NSMEventHelper.buildSubjectForSystemName(string2, string3);
            connection = null;
            try {
                connection = PersistenceService.getConnection();
                Iterator iterator3 = NSMEventHelper.createSubjects(connection, string5);
                string4 = NSMEventHelper.buildSubjectString(iterator3);
                if (string4.length() != 0) break block8;
                iterator2 = new ArrayList().iterator();
                Object var19_18 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                PersistenceService.returnConnection(connection);
                throw throwable;
            }
            PersistenceService.returnConnection(connection);
            return iterator2;
        }
        if (n5 == 3) {
            String string6 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string6 = string6 + "LIMIT " + l + " " + l2;
            }
            string6 = string6 + " * " + "FROM " + ALARM_TABLE + " n " + "WHERE subject IN " + "( " + string4 + " ) ";
            string6 = NSMEventHelper.addTopicAndSeverity(string6, string, n, n2);
            string6 = NSMEventHelper.addAckAndCleared(string6, n3, n4);
            string6 = string6 + " ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(connection, string6);
        } else if (n5 == 2) {
            String string7 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string7 = string7 + "LIMIT " + l + " " + l2;
            }
            string7 = string7 + " * " + "FROM " + EVENT_TABLE + " n " + "WHERE subject IN " + "( " + string4 + " ) ";
            string7 = NSMEventHelper.addTopicAndSeverity(string7, string, n, n2);
            string7 = string7 + " ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(connection, string7);
        }
        Object var19_19 = null;
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    static Iterator retrieveEventsBySystemName(String string, String string2, String string3, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemName(string, -1, -1, string2, string3, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemName(String string, String string2, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemName(null, string, string2, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemName(string, string2, n, n2, n3, -1L, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long countEventsBySystemDevice(String string, int n, int n2, String string2, String string3, String string4, int n3, int n4, int n5) throws ConnectionException {
        Connection connection;
        long l;
        block10: {
            long string7;
            block9: {
                l = 0L;
                String string6 = NSMEventHelper.buildSubjectForSystemDevice(string2, string3, string4);
                connection = null;
                try {
                    try {
                        connection = PersistenceService.getConnection();
                        Iterator iterator = NSMEventHelper.createSubjects(connection, string6);
                        String string5 = NSMEventHelper.buildSubjectString(iterator);
                        if (string5.length() == 0) {
                            string7 = 0L;
                            Object var19_19 = null;
                            break block9;
                        }
                        if (n5 == 3) {
                            String string8 = "SELECT COUNT(*) FROM Alarm n WHERE subject IN ( " + string5 + " ) ";
                            string8 = NSMEventHelper.addTopicAndSeverity(string8, string, n, n2);
                            string8 = NSMEventHelper.addAckAndCleared(string8, n3, n4);
                            Statement statement = connection.createStatement();
                            ResultSet resultSet = statement.executeQuery(string8);
                            if (resultSet.next()) {
                                l = resultSet.getLong(1);
                            }
                            break block10;
                        }
                        if (n5 != 2) break block10;
                        String string8 = "SELECT COUNT(*) FROM NSMEvent n WHERE subject IN ( " + string5 + " ) ";
                        string8 = NSMEventHelper.addTopicAndSeverity(string8, string, n, n2);
                        Statement statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(string8);
                        if (resultSet.next()) {
                            l = resultSet.getInt(1);
                        }
                        break block10;
                    }
                    catch (SQLException sQLException) {
                        String string9 = "Unable to retrieve alarm quantity.";
                        Report.error.log(sQLException, (Object)string9);
                        throw new ConnectionException(string9, sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    PersistenceService.returnConnection(connection);
                    throw throwable;
                }
            }
            PersistenceService.returnConnection(connection);
            return string7;
        }
        Object var19_20 = null;
        PersistenceService.returnConnection(connection);
        return l;
    }

    static long countEventsBySystemDevice(String string, String string2, String string3, String string4, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemDevice(string, -1, -1, string2, string3, string4, n, n2, n3);
    }

    static long countEventsBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.countEventsBySystemDevice(null, string, string2, string3, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Iterator retrieveEventsBySystemDevice(String string, int n, int n2, String string2, String string3, String string4, int n3, int n4, int n5, long l, long l2) throws ConnectionException {
        String string5;
        Connection connection;
        Iterator iterator;
        block8: {
            Iterator iterator2;
            iterator = null;
            String string6 = NSMEventHelper.buildSubjectForSystemDevice(string2, string3, string4);
            connection = null;
            try {
                connection = PersistenceService.getConnection();
                Iterator iterator3 = NSMEventHelper.createSubjects(connection, string6);
                string5 = NSMEventHelper.buildSubjectString(iterator3);
                if (string5.length() != 0) break block8;
                iterator2 = new ArrayList().iterator();
                Object var20_19 = null;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                PersistenceService.returnConnection(connection);
                throw throwable;
            }
            PersistenceService.returnConnection(connection);
            return iterator2;
        }
        if (n5 == 3) {
            String string7 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string7 = string7 + "LIMIT " + l + " " + l2;
            }
            string7 = string7 + " * " + "FROM " + ALARM_TABLE + " n " + "WHERE subject IN " + "( " + string5 + " ) ";
            string7 = NSMEventHelper.addTopicAndSeverity(string7, string, n, n2);
            string7 = NSMEventHelper.addAckAndCleared(string7, n3, n4);
            string7 = string7 + " ORDER BY severity DESC, subjectTime DESC";
            iterator = NSMEventHelper.createAlarms(connection, string7);
        } else if (n5 == 2) {
            String string8 = "SELECT ";
            if (l >= 0L && l2 >= 0L) {
                string8 = string8 + "LIMIT " + l + " " + l2;
            }
            string8 = string8 + " * " + "FROM " + EVENT_TABLE + " n " + "WHERE subject IN " + "( " + string5 + " ) ";
            string8 = NSMEventHelper.addTopicAndSeverity(string8, string, n, n2);
            string8 = string8 + " ORDER BY subjectTime DESC";
            iterator = NSMEventHelper.createEvents(connection, string8);
        }
        Object var20_20 = null;
        PersistenceService.returnConnection(connection);
        return iterator;
    }

    static Iterator retrieveEventsBySystemDevice(String string, String string2, String string3, String string4, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemDevice(string, -1, -1, string2, string3, string4, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemDevice(String string, String string2, String string3, int n, int n2, int n3, long l, long l2) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemDevice(null, string, string2, string3, n, n2, n3, l, l2);
    }

    static Iterator retrieveEventsBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemDevice(string, string2, string3, n, n2, n3, -1L, -1L);
    }

    static NSMEvent retrieveEventByID(String string) throws NoDataFoundException, ConnectionException {
        String string2 = "SELECT  mseID, eventID, source, sourceSequenceNumber, sourceTime, type, topic, severity, correlatedEvents, subject, subjectTime, payloadType, payload  FROM NSMEvent WHERE eventID = '" + string + "'";
        Iterator iterator = NSMEventHelper.createEvents(string2);
        if (!iterator.hasNext()) {
            throw new NoDataFoundException("No event for Event ID, " + string + ", exists.");
        }
        NSMEvent nSMEvent = (NSMEvent)iterator.next();
        return nSMEvent;
    }

    static Alarm retrieveAlarmByID(String string) throws NoDataFoundException, ConnectionException {
        String string2 = "SELECT * FROM Alarm WHERE eventID = '" + string + "'";
        Iterator iterator = NSMEventHelper.createAlarms(string2);
        if (!iterator.hasNext()) {
            throw new NoDataFoundException("No alarm for Event ID, " + string + ", exists.");
        }
        Alarm alarm = (Alarm)iterator.next();
        return alarm;
    }

    static void removeEventByID(String string, int n) throws NoDataFoundException, ConnectionException {
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = null;
                if (n == 3) {
                    preparedStatement = connection.prepareStatement("SELECT COUNT(*) from Alarm WHERE eventID = ?");
                } else if (n == 2) {
                    preparedStatement = connection.prepareStatement("SELECT COUNT(*) from NSMEvent WHERE eventID = ?");
                }
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int n2 = resultSet.getInt(1);
                if (n2 == 0) {
                    String string2 = "Cannot remove event, " + string + ".  It doesn't exist " + "in the database.";
                    throw new NoDataFoundException(string2);
                }
                Statement statement = connection.createStatement();
                if (n == 3) {
                    statement.executeUpdate("DELETE FROM Alarm WHERE eventID = '" + string + "'");
                } else if (n == 2) {
                    statement.executeUpdate("DELETE FROM NSMEvent WHERE eventID = '" + string + "'");
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    Report.error.log(sQLException2, (Object)"Error rolling back transaction.");
                }
                String string3 = "Unable to remove event for event id " + string;
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    static void removeEvents(String[] stringArray, int n) throws ConnectionException {
        if (stringArray == null) {
            return;
        }
        Connection connection = null;
        try {
            block11: {
                try {
                    connection = PersistenceService.getConnection();
                    connection.setAutoCommit(false);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringArray.length <= 0) break block11;
                    stringBuffer.append("'" + stringArray[0] + "'");
                    int n2 = 1;
                    while (n2 < stringArray.length) {
                        stringBuffer.append(", ");
                        stringBuffer.append("'" + stringArray[n2] + "'");
                        ++n2;
                    }
                    Statement statement = connection.createStatement();
                    if (n == 3) {
                        statement.executeUpdate("DELETE FROM Alarm WHERE eventID IN (" + stringBuffer.toString() + ")");
                    } else if (n == 2) {
                        statement.executeUpdate("DELETE FROM NSMEvent WHERE eventID IN (" + stringBuffer.toString() + ")");
                    }
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        Report.error.log(sQLException2, (Object)"Error rolling back transaction.");
                    }
                    String string = "Unable to remove events.";
                    Report.error.log(sQLException, (Object)string);
                    throw new ConnectionException(string, sQLException);
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
    }

    static int removeEvents(Date date, int n, int n2, String[] stringArray, int n3) throws ConnectionException {
        int n4 = -1;
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                connection.setAutoCommit(false);
                long l = date.getTime();
                StringBuffer stringBuffer = new StringBuffer();
                if (stringArray != null) {
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        stringBuffer.append(" AND topic NOT LIKE '" + stringArray[n5] + "%'");
                        ++n5;
                    }
                }
                Statement statement = connection.createStatement();
                if (n3 == 3) {
                    String string = "DELETE FROM Alarm WHERE subjectTime < " + l;
                    string = NSMEventHelper.addAckAndCleared(string, n, n2);
                    string = string + stringBuffer.toString();
                    Report.trace.log("Delete Statement: " + string);
                    n4 = statement.executeUpdate(string);
                } else if (n3 == 2) {
                    String string = "DELETE FROM NSMEvent WHERE subjectTime < " + l;
                    string = string + stringBuffer.toString();
                    Report.trace.log("Delete Statement: " + string);
                    n4 = statement.executeUpdate(string);
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    Report.error.log(sQLException2, (Object)"Error rolling back transaction.");
                }
                String string = "Unable to remove events.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterator createEvents(Connection connection, String string) throws ConnectionException {
        Vector<NSMEvent> vector = new Vector<NSMEvent>();
        boolean bl = false;
        if (connection == null) {
            bl = true;
        }
        try {
            try {
                if (bl) {
                    connection = PersistenceService.getConnection();
                }
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    NSMEvent nSMEvent = new NSMEvent();
                    nSMEvent.setSource(resultSet.getString("source"));
                    nSMEvent.setSubject(resultSet.getString("subject"));
                    nSMEvent.setTopic(resultSet.getString("topic"));
                    nSMEvent.setSeverity(resultSet.getInt("severity"));
                    nSMEvent.setSourceSequenceNumber(resultSet.getLong("sourceSequenceNumber"));
                    nSMEvent.setSubjectTime(resultSet.getLong("subjectTime"));
                    nSMEvent.setType(resultSet.getString("type"));
                    nSMEvent.setEventID(resultSet.getString("eventID"));
                    nSMEvent.setSourceTime(resultSet.getTimestamp("sourceTime").getTime());
                    nSMEvent.setCorrelatedEvents((String[])resultSet.getObject("correlatedEvents"));
                    nSMEvent.setPayloadType(resultSet.getString("payloadType"));
                    nSMEvent.setPayload(resultSet.getObject("payload"));
                    vector.addElement(nSMEvent);
                }
            }
            catch (SQLException sQLException) {
                String string2 = "Unable to retrieve event(s).";
                Report.error.log(sQLException, (Object)string2);
                throw new ConnectionException(string2, sQLException);
            }
            Object var8_9 = null;
            if (!bl) return vector.iterator();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!bl) throw throwable;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector.iterator();
    }

    private static Iterator createEvents(String string) throws ConnectionException {
        return NSMEventHelper.createEvents(null, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterator createAlarms(Connection connection, String string) throws ConnectionException {
        Vector<Alarm> vector = new Vector<Alarm>();
        boolean bl = false;
        if (connection == null) {
            bl = true;
        }
        try {
            try {
                if (bl) {
                    connection = PersistenceService.getConnection();
                }
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    String string2 = resultSet.getString("eventID");
                    if (string2 == null) continue;
                    NSMEvent nSMEvent = new NSMEvent();
                    nSMEvent.setSource(resultSet.getString("source"));
                    nSMEvent.setSubject(resultSet.getString("subject"));
                    nSMEvent.setTopic(resultSet.getString("topic"));
                    nSMEvent.setSeverity(resultSet.getInt("severity"));
                    nSMEvent.setSourceSequenceNumber(resultSet.getLong("sourceSequenceNumber"));
                    nSMEvent.setSubjectTime(resultSet.getLong("subjectTime"));
                    nSMEvent.setType(resultSet.getString("type"));
                    nSMEvent.setEventID(resultSet.getString("eventID"));
                    nSMEvent.setSourceTime(resultSet.getTimestamp("sourceTime").getTime());
                    nSMEvent.setCorrelatedEvents((String[])resultSet.getObject("correlatedEvents"));
                    nSMEvent.setPayloadType(resultSet.getString("payloadType"));
                    nSMEvent.setPayload(resultSet.getObject("payload"));
                    Alarm alarm = new Alarm(nSMEvent);
                    alarm.setAckTime(resultSet.getLong("ackTime"));
                    alarm.setAckBy(resultSet.getString("ackBy"));
                    alarm.setIsAcked(resultSet.getBoolean("isAcked"));
                    alarm.setNote(resultSet.getString("note"));
                    alarm.setIsCleared(resultSet.getBoolean("isCleared"));
                    alarm.setClearTime(resultSet.getLong("clearTime"));
                    vector.addElement(alarm);
                }
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve alarm(s).";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var10_11 = null;
            if (!bl) return vector.iterator();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!bl) throw throwable;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector.iterator();
    }

    private static Iterator createAlarms(String string) throws ConnectionException {
        return NSMEventHelper.createAlarms(null, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterator createSubjects(Connection connection, String string) throws ConnectionException {
        boolean bl = false;
        if (connection == null) {
            bl = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                if (bl) {
                    connection = PersistenceService.getConnection();
                }
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    String string2 = resultSet.getString("subject");
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve subject(s).";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var8_9 = null;
            if (!bl) return arrayList.iterator();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!bl) throw throwable;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return arrayList.iterator();
    }

    private static String buildSubjectString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("'" + (String)iterator.next() + "'");
        }
        return stringBuffer.toString();
    }

    private static String buildSubjectForSystemName(String string, String string2) {
        return "SELECT subject FROM ManagedElementSubjectLookup l  WHERE (l.creationClassName = '" + string + "' " + " AND l.name = '" + string2 + "' ) " + " OR (l.systemCreationClassName = '" + string + "' " + " AND l.systemName = '" + string2 + "' ) ";
    }

    private static String buildSubjectForSystemDevice(String string, String string2, String string3) {
        return "SELECT subject FROM ManagedElementSubjectLookup l  WHERE l.systemCreationClassName = '" + string + "' " + " AND l.systemName = '" + string2 + "' " + " AND l.deviceID = '" + string3 + "' ";
    }

    static Iterator retrieveAlarmSummary() throws ConnectionException {
        String string = "SELECT SEVERITY, COUNT(*) FROM Alarm WHERE ISACKED != TRUE AND ISCLEARED != TRUE GROUP BY SEVERITY";
        Connection connection = null;
        Vector<AlarmSummary> vector = new Vector<AlarmSummary>();
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    AlarmSummary alarmSummary = new AlarmSummary();
                    alarmSummary.setSeverity(resultSet.getInt(1));
                    alarmSummary.setQuantity(resultSet.getInt(2));
                    vector.add(alarmSummary);
                }
            }
            catch (SQLException sQLException) {
                String string2 = "Unable to retrieve alarm summary.";
                Report.error.log(sQLException, (Object)string2);
                throw new ConnectionException(string2, sQLException);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector.iterator();
    }

    static Object retrieveLastEventBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        String string3 = " EVENTID, MAX SUBJECTTIME ";
        return NSMEventHelper.retrieveSpecificEventBySystemName(string, string2, string3, false, n, n2, n3);
    }

    static Object retrieveSeverestEventBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        String string3 = " LIMIT 0 1 EVENTID, SUBJECTTIME ";
        return NSMEventHelper.retrieveSpecificEventBySystemName(string, string2, string3, true, n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object retrieveSpecificEventBySystemName(String string, String string2, String string3, boolean bl, int n, int n2, int n3) throws ConnectionException {
        Iterator iterator;
        Connection connection;
        Iterator iterator2;
        block15: {
            Object string7;
            block14: {
                iterator2 = null;
                String string6 = NSMEventHelper.buildSubjectForSystemName(string, string2);
                connection = null;
                try {
                    try {
                        String string4;
                        connection = PersistenceService.getConnection();
                        iterator = NSMEventHelper.createSubjects(connection, string6);
                        String string42 = NSMEventHelper.buildSubjectString(iterator);
                        if (string42.length() == 0) {
                            string7 = null;
                            Object var19_16 = null;
                            break block14;
                        }
                        String string5 = null;
                        long l = -1L;
                        if (n3 == 3) {
                            Statement statement;
                            ResultSet resultSet;
                            string4 = "SELECT " + string3 + " " + "FROM " + ALARM_TABLE + " n ";
                            string4 = NSMEventHelper.addAckAndCleared(string4, n, n2);
                            string4 = string4 + " AND subject IN " + "( " + string42 + " ) ";
                            if (bl) {
                                string4 = string4 + "ORDER BY severity DESC, subjectTime DESC";
                            }
                            if ((resultSet = (statement = connection.createStatement()).executeQuery(string4)).next()) {
                                string5 = resultSet.getString(1);
                                l = resultSet.getLong(2);
                            }
                        } else if (n3 == 2) {
                            Statement statement;
                            ResultSet resultSet;
                            string4 = "SELECT " + string3 + " " + "FROM " + EVENT_TABLE + " n WHERE ";
                            string4 = string4 + " subject IN " + "( " + string42 + " ) ";
                            if (bl) {
                                string4 = string4 + "ORDER BY subjectTime DESC";
                            }
                            if ((resultSet = (statement = connection.createStatement()).executeQuery(string4)).next()) {
                                string5 = resultSet.getString(1);
                                l = resultSet.getLong(2);
                            }
                        }
                        if (string5 == null) break block15;
                        if (n3 == 3) {
                            string4 = "SELECT * FROM Alarm n WHERE eventID = '" + string5 + "' ";
                            iterator2 = NSMEventHelper.createAlarms(connection, string4);
                            break block15;
                        }
                        if (n3 == 2) {
                            string4 = "SELECT * FROM NSMEvent n WHERE eventID = '" + string5 + "' ";
                            iterator2 = NSMEventHelper.createEvents(connection, string4);
                        }
                        break block15;
                    }
                    catch (SQLException sQLException) {
                        String string8 = "Unable to retrieve last alarm.";
                        Report.error.log(sQLException, (Object)string8);
                        throw new ConnectionException(string8, sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_18 = null;
                    PersistenceService.returnConnection(connection);
                    throw throwable;
                }
            }
            PersistenceService.returnConnection(connection);
            return string7;
        }
        Object var19_17 = null;
        PersistenceService.returnConnection(connection);
        iterator = null;
        if (iterator2 == null) return iterator;
        if (!iterator2.hasNext()) return iterator;
        return iterator2.next();
    }

    static Object retrieveLastEventBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        String string4 = " EVENTID, MAX SUBJECTTIME ";
        return NSMEventHelper.retrieveSpecificEventBySystemDevice(string, string2, string3, string4, false, n, n2, n3);
    }

    static Object retrieveSeverestEventBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        String string4 = " LIMIT 0 1 EVENTID, SUBJECTTIME ";
        return NSMEventHelper.retrieveSpecificEventBySystemDevice(string, string2, string3, string4, true, n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object retrieveSpecificEventBySystemDevice(String string, String string2, String string3, String string4, boolean bl, int n, int n2, int n3) throws ConnectionException {
        Iterator iterator;
        Connection connection;
        Iterator iterator2;
        block15: {
            Object string8;
            block14: {
                iterator2 = null;
                String string7 = NSMEventHelper.buildSubjectForSystemDevice(string, string2, string3);
                connection = null;
                try {
                    try {
                        String string5;
                        connection = PersistenceService.getConnection();
                        iterator = NSMEventHelper.createSubjects(connection, string7);
                        String string52 = NSMEventHelper.buildSubjectString(iterator);
                        if (string52.length() == 0) {
                            string8 = null;
                            Object var20_17 = null;
                            break block14;
                        }
                        String string6 = null;
                        long l = -1L;
                        if (n3 == 3) {
                            Statement statement;
                            ResultSet resultSet;
                            string5 = "SELECT " + string4 + " " + "FROM " + ALARM_TABLE + " n ";
                            string5 = NSMEventHelper.addAckAndCleared(string5, n, n2);
                            string5 = string5 + " AND subject IN " + "( " + string52 + " ) ";
                            if (bl) {
                                string5 = string5 + "ORDER BY severity DESC, subjectTime DESC";
                            }
                            if ((resultSet = (statement = connection.createStatement()).executeQuery(string5)).next()) {
                                string6 = resultSet.getString(1);
                                l = resultSet.getLong(2);
                            }
                        } else if (n3 == 2) {
                            Statement statement;
                            ResultSet resultSet;
                            string5 = "SELECT " + string4 + " " + "FROM " + EVENT_TABLE + " n WHERE ";
                            string5 = string5 + " subject IN " + "( " + string52 + " ) ";
                            if (bl) {
                                string5 = string5 + "ORDER BY subjectTime DESC";
                            }
                            if ((resultSet = (statement = connection.createStatement()).executeQuery(string5)).next()) {
                                string6 = resultSet.getString(1);
                                l = resultSet.getLong(2);
                            }
                        }
                        if (string6 == null) break block15;
                        if (n3 == 3) {
                            string5 = "SELECT * FROM Alarm n WHERE eventID = '" + string6 + "' ";
                            iterator2 = NSMEventHelper.createAlarms(connection, string5);
                            break block15;
                        }
                        if (n3 == 2) {
                            string5 = "SELECT * FROM NSMEvent n WHERE eventID = '" + string6 + "' ";
                            iterator2 = NSMEventHelper.createEvents(connection, string5);
                        }
                        break block15;
                    }
                    catch (SQLException sQLException) {
                        String string9 = "Unable to retrieve last alarm.";
                        Report.error.log(sQLException, (Object)string9);
                        throw new ConnectionException(string9, sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var20_19 = null;
                    PersistenceService.returnConnection(connection);
                    throw throwable;
                }
            }
            PersistenceService.returnConnection(connection);
            return string8;
        }
        Object var20_18 = null;
        PersistenceService.returnConnection(connection);
        iterator = null;
        if (iterator2 == null) return iterator;
        if (!iterator2.hasNext()) return iterator;
        return iterator2.next();
    }

    public static HashMap retrieveAlarmSummary(int n, int n2, boolean bl) throws ConnectionException {
        HashMap hashMap = new HashMap();
        Connection connection = null;
        try {
            try {
                Object[] objectArray;
                ResultSet resultSet;
                Statement statement;
                String string;
                Alarm alarm;
                Object object;
                Object object2;
                connection = PersistenceService.getConnection();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string2 = "SELECT DISTINCT SUBJECT FROM Alarm ";
                string2 = NSMEventHelper.addAckAndCleared(string2, n, n2);
                Statement statement2 = connection.createStatement();
                ResultSet resultSet2 = statement2.executeQuery(string2);
                while (resultSet2.next()) {
                    object2 = resultSet2.getString(1);
                    arrayList.add(object2);
                }
                object2 = new ArrayList();
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    String string3 = "SELECT LIMIT 0 1 * FROM Alarm WHERE SUBJECT = '" + (String)arrayList.get(n3) + "'";
                    string3 = NSMEventHelper.addAckAndCleared(string3, n, n2);
                    string3 = string3 + " ORDER BY severity DESC, subjectTime DESC ";
                    object = NSMEventHelper.createAlarms(connection, string3);
                    alarm = null;
                    if (object.hasNext()) {
                        alarm = (Alarm)object.next();
                    }
                    if (bl) {
                        string = "SELECT COUNT(*) FROM Alarm WHERE SUBJECT = '" + (String)arrayList.get(n3) + "'";
                        string = NSMEventHelper.addAckAndCleared(string, n, n2);
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(string);
                        int n4 = -1;
                        while (resultSet.next()) {
                            n4 = resultSet.getInt(1);
                        }
                        objectArray = new Object[]{alarm, null, new Integer(n4)};
                    } else {
                        objectArray = new Object[]{alarm, null};
                    }
                    if (alarm != null) {
                        ((ArrayList)object2).add(objectArray);
                    }
                    ++n3;
                }
                int n5 = 0;
                while (n5 < ((ArrayList)object2).size()) {
                    object = (Object[])((ArrayList)object2).get(n5);
                    alarm = (Alarm)object[0];
                    objectArray = alarm.getEvent().getSubject();
                    string = "SELECT CREATIONCLASSNAME, NAME, SYSTEMCREATIONCLASSNAME, SYSTEMNAME, DEVICEID FROM MANAGEDELEMENTSUBJECTLOOKUP WHERE SUBJECT = '" + (String)objectArray + "'";
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("CREATIONCLASSNAME");
                        String string5 = resultSet.getString("NAME");
                        String string6 = resultSet.getString("SYSTEMCREATIONCLASSNAME");
                        String string7 = resultSet.getString("SYSTEMNAME");
                        String string8 = resultSet.getString("DEVICEID");
                        if (string6 != null && string7 != null) {
                            NSMEventHelper.updateMap(hashMap, string6, string7, string4, string5, string8, (Object[])object);
                            continue;
                        }
                        if (string4 != null && string5 != null) {
                            NSMEventHelper.updateMap(hashMap, string4, string5, null, null, null, (Object[])object);
                            continue;
                        }
                        Report.error.log("Cannot find creationClassName and name for this alarm");
                    }
                    ++n5;
                }
            }
            catch (SQLException sQLException) {
                String string = "Unable to retrieve last alarms.";
                Report.error.log(sQLException, (Object)string);
                throw new ConnectionException(string, sQLException);
            }
            Object var24_28 = null;
        }
        catch (Throwable throwable) {
            Object var24_29 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return hashMap;
    }

    private static void updateMap(HashMap hashMap, String string, String string2, String string3, String string4, String string5, Object[] objectArray) {
        HashMap hashMap2 = (HashMap)hashMap.get(string);
        if (hashMap2 != null) {
            Object[] objectArray2 = (Object[])hashMap2.get(string2);
            if (objectArray2 != null) {
                Alarm alarm = (Alarm)objectArray[0];
                Alarm alarm2 = (Alarm)objectArray2[0];
                if (alarm.getEvent().getSeverity() > alarm2.getEvent().getSeverity() || alarm.getEvent().getSeverity() >= alarm2.getEvent().getSeverity() && alarm.getEvent().getSubjectTime() > alarm2.getEvent().getSubjectTime()) {
                    hashMap2.remove(string2);
                    if (string3 != null && string4 != null) {
                        objectArray[1] = new ReferenceForMSE(string3, string4, string5);
                    }
                    if (objectArray.length >= 3) {
                        int n = (Integer)objectArray[2];
                        int n2 = (Integer)objectArray2[2];
                        objectArray[2] = new Integer(n + n2);
                    }
                    hashMap2.put(string2, objectArray);
                } else {
                    hashMap2.remove(string2);
                    if (objectArray.length >= 3) {
                        int n = (Integer)objectArray[2];
                        int n3 = (Integer)objectArray2[2];
                        objectArray2[2] = new Integer(n + n3);
                    }
                    hashMap2.put(string2, objectArray2);
                }
            } else {
                if (string3 != null && string4 != null) {
                    objectArray[1] = new ReferenceForMSE(string3, string4, string5);
                }
                hashMap2.put(string2, objectArray);
            }
        } else {
            HashMap<String, Object[]> hashMap3 = new HashMap<String, Object[]>();
            if (string3 != null && string4 != null) {
                objectArray[1] = new ReferenceForMSE(string3, string4, string5);
            }
            hashMap3.put(string2, objectArray);
            hashMap.put(string, hashMap3);
        }
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            UnitTest unitTest = new UnitTest();
            PersistenceService persistenceService = null;
            GenericPersistence genericPersistence = null;
            CIMBeanPersistence cIMBeanPersistence = null;
            NSMEvent nSMEvent = new NSMEvent();
            String string = "Event ID 123";
            nSMEvent.setSource("source");
            nSMEvent.setSourceSequenceNumber(6666666L);
            nSMEvent.setSeverity(2);
            nSMEvent.setSubject("subject");
            nSMEvent.setTopic(".alert.topic");
            nSMEvent.setSubjectTime(System.currentTimeMillis());
            nSMEvent.setType("type");
            String[] stringArray2 = new String[]{"event 2", "event 3"};
            nSMEvent.setCorrelatedEvents(stringArray2);
            nSMEvent.setPayloadType("ESM/Common/XML/1.0/StorADE");
            String string2 = new String("payload");
            nSMEvent.setPayload(string2);
            nSMEvent.setEventID(string);
            nSMEvent.setSourceTime(System.currentTimeMillis());
            NSMEvent nSMEvent2 = null;
            Alarm alarm = new Alarm(nSMEvent);
            alarm.setAckTime(System.currentTimeMillis());
            alarm.setAckBy("me");
            alarm.setIsAcked(true);
            alarm.setNote("ack ack note");
            alarm.setIsCleared(true);
            alarm.setClearTime(System.currentTimeMillis());
            Alarm alarm2 = null;
            try {
                persistenceService = PersistenceService.getService();
                genericPersistence = persistenceService.getGenericPersistence();
                genericPersistence.storeEvent(nSMEvent);
                nSMEvent2 = genericPersistence.retrieveAlarmByID(string).getEvent();
                try {
                    alarm2 = genericPersistence.retrieveAlarmByID(string);
                }
                catch (NoDataFoundException noDataFoundException) {
                    unitTest.fail("\nUnit Test Failed (Retrieving default alarm object)\n");
                    System.exit(1);
                }
                genericPersistence.updateAlarm(alarm);
                try {
                    alarm2 = genericPersistence.retrieveAlarmByID(string);
                }
                catch (NoDataFoundException noDataFoundException) {
                    unitTest.fail("\nUnit Test Failed (Retrieving updated alarm object)\n");
                    System.exit(1);
                }
            }
            catch (PersistenceException persistenceException) {
                System.err.println("\nUnit Test Failed (Event Storage Retrieval): \n" + persistenceException.getMessage() + "\n");
                persistenceException.printStackTrace();
                System.err.println("\n");
                System.exit(1);
            }
            try {
                int n;
                Object object;
                Object object2;
                unitTest.assertEquals(nSMEvent.getSource(), nSMEvent2.getSource());
                unitTest.assertEquals(new Long(nSMEvent.getSourceSequenceNumber()), new Long(nSMEvent2.getSourceSequenceNumber()));
                unitTest.assertEquals(new Integer(nSMEvent.getSeverity()), new Integer(nSMEvent2.getSeverity()));
                unitTest.assertEquals(nSMEvent.getSubject(), nSMEvent2.getSubject());
                unitTest.assertEquals(nSMEvent.getTopic(), nSMEvent2.getTopic());
                unitTest.assertEquals(new Long(nSMEvent.getSubjectTime()), new Long(nSMEvent2.getSubjectTime()));
                unitTest.assertEquals(nSMEvent.getType(), nSMEvent2.getType());
                if (nSMEvent.getCorrelatedEvents() != null) {
                    object2 = nSMEvent.getCorrelatedEvents();
                    object = nSMEvent2.getCorrelatedEvents();
                    int n2 = 0;
                    while (n2 < ((String[])object2).length) {
                        unitTest.assertEquals(object2[n2], object[n2]);
                        ++n2;
                    }
                } else {
                    unitTest.assertEquals(nSMEvent.getCorrelatedEvents(), nSMEvent2.getCorrelatedEvents());
                }
                unitTest.assertEquals(nSMEvent.getPayloadType(), nSMEvent2.getPayloadType());
                unitTest.assertEquals(nSMEvent.getPayload(), nSMEvent2.getPayload());
                unitTest.assertEquals(nSMEvent.getEventID(), nSMEvent2.getEventID());
                unitTest.assertEquals(new Long(nSMEvent.getSourceTime()), new Long(nSMEvent2.getSourceTime()));
                object2 = alarm2.getEvent();
                unitTest.assertEquals(nSMEvent.getSource(), ((NWS_BaseEvent)object2).getSource());
                unitTest.assertEquals(new Long(nSMEvent.getSourceSequenceNumber()), new Long(((NWS_BaseEvent)object2).getSourceSequenceNumber()));
                unitTest.assertEquals(new Integer(nSMEvent.getSeverity()), new Integer(((NWS_PublicEvent)object2).getSeverity()));
                unitTest.assertEquals(nSMEvent.getSubject(), ((NWS_PublicEvent)object2).getSubject());
                unitTest.assertEquals(nSMEvent.getTopic(), ((NWS_BaseEvent)object2).getTopic());
                unitTest.assertEquals(new Long(nSMEvent.getSubjectTime()), new Long(((NWS_PublicEvent)object2).getSubjectTime()));
                unitTest.assertEquals(nSMEvent.getType(), ((NWS_PublicEvent)object2).getType());
                if (nSMEvent.getCorrelatedEvents() != null) {
                    object = nSMEvent.getCorrelatedEvents();
                    String[] stringArray3 = ((NWS_PublicEvent)object2).getCorrelatedEvents();
                    n = 0;
                    while (n < ((String[])object).length) {
                        unitTest.assertEquals(object[n], stringArray3[n]);
                        ++n;
                    }
                } else {
                    unitTest.assertEquals(nSMEvent.getCorrelatedEvents(), ((NWS_PublicEvent)object2).getCorrelatedEvents());
                }
                unitTest.assertEquals(nSMEvent.getPayloadType(), ((NWS_BaseEvent)object2).getPayloadType());
                unitTest.assertEquals(nSMEvent.getPayload(), ((NWS_BaseEvent)object2).getPayload());
                unitTest.assertEquals(nSMEvent.getEventID(), ((NWS_BaseEvent)object2).getEventID());
                unitTest.assertEquals(new Long(nSMEvent.getSourceTime()), new Long(((NWS_BaseEvent)object2).getSourceTime()));
                unitTest.assertEquals(alarm.getAckBy(), alarm2.getAckBy());
                unitTest.assertEquals(new Long(alarm.getAckTime()), new Long(alarm2.getAckTime()));
                unitTest.assertEquals(new Boolean(alarm.getIsAcked()), new Boolean(alarm2.getIsAcked()));
                unitTest.assertEquals(alarm.getNote(), alarm2.getNote());
                unitTest.assertEquals(new Boolean(alarm.getIsCleared()), new Boolean(alarm2.getIsCleared()));
                unitTest.assertEquals(new Long(alarm.getClearTime()), new Long(alarm2.getClearTime()));
                String string3 = "subjectTest";
                n = 4;
                int n3 = 0;
                nSMEvent.setSubject("subjectTest");
                int n4 = 0;
                while (n4 < n) {
                    nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                    genericPersistence.storeEvent(nSMEvent);
                    ++n4;
                }
                long l = System.currentTimeMillis();
                object = genericPersistence.retrieveEventsBySubject(string3, 3);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (object == null || n3 != n) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by subject for ALARM_EVENTS)\n");
                    System.exit(1);
                }
                nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                nSMEvent.setTopic(".nonalert.topic");
                genericPersistence.storeEvent(nSMEvent);
                object = genericPersistence.retrieveEventsBySubject(string3, 2);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (n3 != 1) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by subject for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                String string4 = "topicTest";
                int n5 = 5;
                n3 = 0;
                nSMEvent.setTopic(string4);
                int n6 = 0;
                while (n6 < n5) {
                    nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                    genericPersistence.storeEvent(nSMEvent);
                    ++n6;
                }
                object = genericPersistence.retrieveEventsByTopic(string4, 2);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (object == null || n3 != n5) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by topic for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                nSMEvent.setTopic(".alert.alarm");
                genericPersistence.storeEvent(nSMEvent);
                object = genericPersistence.retrieveEventsByTopic(".alert.alarm", 3);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (n3 != 1) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by topic for ALARM_EVENTS)\n");
                    System.exit(1);
                }
                object = genericPersistence.retrieveEvents("subjectTest", "topicTest", 2, 2);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (object == null || n3 != n5) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by subject, topic, and severity for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                object = genericPersistence.retrieveEvents("subjectTest", ".alert.alarm", 2, 3);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (n3 != 1) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by subject, topic, and severity for ALARM_EVENTS)\n");
                    System.exit(1);
                }
                int n7 = 1 + n + 1;
                int n8 = 1 + n5;
                int n9 = n7 + n8;
                object = genericPersistence.retrieveEvents(2);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (n3 != n8) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events for only type criteria, NON_ALARM_EVENTS");
                    System.exit(1);
                }
                object = genericPersistence.retrieveEvents(3);
                n3 = 0;
                while (object.hasNext()) {
                    object.next();
                    ++n3;
                }
                if (n3 != n7) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events for only type criteria, ALARM_EVENTS");
                    System.exit(1);
                }
                genericPersistence.removeEventByID("Event ID 123", 3);
                boolean bl = false;
                try {
                    NSMEventHelper.retrieveEventByID("Event ID 123");
                }
                catch (NoDataFoundException noDataFoundException) {
                    bl = true;
                }
                if (!bl) {
                    unitTest.fail("\nUnit Test Failed (Removing event by ID\n");
                    System.exit(1);
                }
                cIMBeanPersistence = persistenceService.getCIMBeanPersistence();
                CIM_DiskDrive cIM_DiskDrive = new CIM_DiskDrive();
                cIM_DiskDrive.setName("Name");
                cIM_DiskDrive.setStatus("Status");
                cIM_DiskDrive.setSystemCreationClassName("CIM_UnitaryComputerSystem");
                cIM_DiskDrive.setSystemName("SystemID");
                cIM_DiskDrive.setCreationClassName("CIM_DiskDrive");
                cIM_DiskDrive.setDeviceID("DeviceID");
                cIMBeanPersistence.storeCIMBean((CIMBean)cIM_DiskDrive);
                nSMEvent.setTopic("nonalert");
                nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                nSMEvent.setSubject(cIM_DiskDrive.getCIMObjectPath().toString());
                genericPersistence.storeEvent(nSMEvent);
                object = NSMEventHelper.retrieveEventsBySystemType("CIM_UnitaryComputerSystem", -1, -1, 2);
                if (!object.hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Type  for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                if (!(object = NSMEventHelper.retrieveEventsBySystemName("CIM_UnitaryComputerSystem", "SystemID", -1, -1, 2)).hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Name  for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                if (!(object = NSMEventHelper.retrieveEventsBySystemDevice("CIM_UnitaryComputerSystem", "SystemID", "DeviceID", -1, -1, 2)).hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Device for NON_ALARM_EVENTS)\n");
                    System.exit(1);
                }
                nSMEvent.setTopic(".alert.alert");
                nSMEvent.setSubject(cIM_DiskDrive.getCIMObjectPath().toString());
                nSMEvent.setEventID(String.valueOf(System.currentTimeMillis()));
                genericPersistence.storeEvent(nSMEvent);
                object = NSMEventHelper.retrieveEventsBySystemType("CIM_UnitaryComputerSystem", -1, -1, 3);
                if (!object.hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Type  for ALARM_EVENTS)\n");
                    System.exit(1);
                }
                if (!(object = NSMEventHelper.retrieveEventsBySystemName("CIM_UnitaryComputerSystem", "SystemID", -1, -1, 3)).hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Name  for ALARM_EVENTS)\n");
                    System.exit(1);
                }
                if (!(object = NSMEventHelper.retrieveEventsBySystemDevice("CIM_UnitaryComputerSystem", "SystemID", "DeviceID", -1, -1, 3)).hasNext()) {
                    unitTest.fail("\nUnit Test Failed (Retrieving events by System Device for ALARM_EVENTS)\n");
                    System.exit(1);
                }
            }
            catch (UnitTestError unitTestError) {
                System.err.println("\nUnit Test Failed (Assertions): " + unitTestError.getMessage());
                unitTestError.printStackTrace(System.err);
                System.exit(1);
            }
            catch (Exception exception) {
                System.err.println("\nUnit Test Failed: ");
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            System.exit(0);
        }
    }
}

