/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.DataAlreadyExistsException;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.NSMEventHelper;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.util.db.ConnectionPool;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class GenericPersistenceImpl
implements GenericPersistence {
    protected GenericPersistenceImpl() throws ConnectionException {
    }

    public synchronized void storeEvent(NSMEvent nSMEvent) throws DataAlreadyExistsException, ConnectionException {
        NSMEventHelper.storeEvent(nSMEvent);
    }

    public void updateEvent(NSMEvent nSMEvent) throws ConnectionException {
        NSMEventHelper.updateEvent(nSMEvent);
    }

    public void updateCorrelatedEvents(NSMEvent nSMEvent) throws ConnectionException {
        NSMEventHelper.updateCorrelatedEvents(nSMEvent);
    }

    public Iterator retrieveEvents(int n) throws ConnectionException {
        return NSMEventHelper.retrieveEvents(-1, -1, n);
    }

    public Iterator retrieveEventsBySubject(String string, int n) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySubject(string, n);
    }

    public Iterator retrieveEvents(String string, String string2, int n, int n2) throws ConnectionException {
        return NSMEventHelper.retrieveEvents(string, string2, n, n2);
    }

    public Iterator retrieveEventsByTopic(String string, int n) throws ConnectionException {
        return NSMEventHelper.retrieveEventsByTopic(string, n);
    }

    public Iterator retrieveEventsBySystemType(String string, int n) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemType(string, -1, -1, n);
    }

    public Iterator retrieveEventsBySystemName(String string, String string2, int n) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemName(string, string2, -1, -1, n);
    }

    public Iterator retrieveEventsBySystemDevice(String string, String string2, String string3, int n) throws ConnectionException {
        return NSMEventHelper.retrieveEventsBySystemDevice(string, string2, string3, -1, -1, n);
    }

    public NSMEvent retrieveEventByID(String string) throws NoDataFoundException, ConnectionException {
        return NSMEventHelper.retrieveEventByID(string);
    }

    public Alarm retrieveAlarmByID(String string) throws NoDataFoundException, ConnectionException {
        return NSMEventHelper.retrieveAlarmByID(string);
    }

    public void removeEventByID(String string, int n) throws NoDataFoundException, ConnectionException {
        NSMEventHelper.removeEventByID(string, n);
    }

    public void updateAlarm(Alarm alarm) throws ConnectionException {
        NSMEventHelper.updateAlarm(alarm);
    }

    public Iterator retrieveAlarmSummary() throws ConnectionException {
        return NSMEventHelper.retrieveAlarmSummary();
    }

    public int retrieveNbrEventsBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return (int)NSMEventHelper.countEventsBySystemName(string, string2, n, n2, n3);
    }

    public int retrieveNbrEventsBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        return (int)NSMEventHelper.countEventsBySystemDevice(string, string2, string3, n, n2, n3);
    }

    public Object retrieveLastEventBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveLastEventBySystemName(string, string2, n, n2, n3);
    }

    public Object retrieveLastEventBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
        return NSMEventHelper.retrieveLastEventBySystemDevice(string, string2, string3, n, n2, n3);
    }

    public HashMap retrieveAlarmSummary(int n, int n2, boolean bl) throws ConnectionException {
        return NSMEventHelper.retrieveAlarmSummary(n, n2, bl);
    }

    static synchronized int getMseID(ReferenceForMSE referenceForMSE) throws ConnectionException {
        if (referenceForMSE == null) {
            String string = "Unable to get reference to managed system element unique identifier.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        Connection connection = PersistenceService.getConnection();
        try {
            block6: {
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT mseID FROM ReferenceForMSE WHERE type = ? AND systemClassName = ? AND systemName = ? AND creationClassName = ? AND keyName = ? AND keyValue = ?");
                    preparedStatement.setInt(1, referenceForMSE.getType());
                    preparedStatement.setString(2, referenceForMSE.getSystemClassName());
                    preparedStatement.setString(3, referenceForMSE.getSystemName());
                    preparedStatement.setString(4, referenceForMSE.getCreationClassName());
                    preparedStatement.setString(5, referenceForMSE.getKeyName());
                    preparedStatement.setString(6, referenceForMSE.getKeyValue());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                        break block6;
                    }
                    PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT INTO ReferenceForMSE(type, systemClassName, systemName, creationClassName, keyName, keyValue) VALUES(?, ?, ?, ?, ?, ?)");
                    preparedStatement2.setInt(1, referenceForMSE.getType());
                    preparedStatement2.setString(2, referenceForMSE.getSystemClassName());
                    preparedStatement2.setString(3, referenceForMSE.getSystemName());
                    preparedStatement2.setString(4, referenceForMSE.getCreationClassName());
                    preparedStatement2.setString(5, referenceForMSE.getKeyName());
                    preparedStatement2.setString(6, referenceForMSE.getKeyValue());
                    preparedStatement2.executeUpdate();
                    connection.commit();
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    n = resultSet.getInt(1);
                }
                catch (SQLException sQLException) {
                    String string = "Unable to retrieve managed system element unique identifier.";
                    Report.error.log(sQLException, (Object)string);
                    throw new ConnectionException(string, sQLException);
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            ConnectionPool.returnConnection(connection);
            throw throwable;
        }
        ConnectionPool.returnConnection(connection);
        return n;
    }

    public static CIMObjectPath parseToCIMObjectPath(String string) {
        try {
            int n = string.indexOf(58);
            int n2 = string.indexOf(46);
            String string2 = null;
            if (n > 0) {
                string2 = string.substring(n + 1, n2);
            }
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string2);
            String string3 = string.substring(n2 + 1, string.length() - 1);
            int n3 = string3.indexOf(",");
            int n4 = string3.indexOf("=");
            while (n4 != -1) {
                int n5;
                String string4 = null;
                if (n3 != -1) {
                    string4 = string3.substring(0, n3);
                } else {
                    string4 = string3;
                    n3 = string3.length() - 1;
                }
                while (string4.indexOf("=\\\"") != -1 && string4.indexOf("\\\"") == -1) {
                    String string5 = string3.substring(n3 + 1);
                    n5 = string5.indexOf(",");
                    if (n5 != -1) {
                        n3 = n3 + n5 + 1;
                        string4 = string3.substring(0, n3);
                        continue;
                    }
                    n3 = string3.length() - 1;
                    string4 = string3;
                }
                int n6 = string4.indexOf("\\\"");
                n5 = string4.lastIndexOf("\\\"");
                string4 = string4.substring(0, n6) + string4.substring(n6 + 2, n5);
                String string6 = string4.substring(0, string4.indexOf("="));
                String string7 = string4.substring(string4.indexOf("=") + 1);
                cIMObjectPath.addKey(string6, new CIMValue((Object)string7, new CIMDataType(8)));
                string3 = string3.substring(n3 + 1);
                n3 = string3.indexOf(",");
                n4 = string3.indexOf("=");
            }
            return cIMObjectPath;
        }
        catch (Exception exception) {
            String string8 = "Unable to determine CIMObjectPath/ReferenceForMSE given event subject string.";
            Report.error.log(exception, (Object)string8);
            throw new IllegalArgumentException(string8 + "\n" + exception.toString());
        }
    }
}

