/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.TableViewResult;
import com.sun.jade.apps.persistence.service.View;
import com.sun.jade.apps.persistence.service.ViewResult;
import com.sun.jade.apps.persistence.util.db.ConnectionPool;
import com.sun.jade.util.Util;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class DBQueryView
extends View {
    private static final String TAG = "DBQueryView";
    private static final String QUERY_PROP = "View.query";
    private static final String COLUMN_NAMES_PROP = "View.columnNames";
    private static final String RESOURCE_BUNDLE_NAME_PROP = "View.resourceBundleName";
    private static final String COLUMN_TO_SCHEMA_MAPPING_PROP = "View.columnToSchemaMapping";
    private String query;
    private String[] columnNames;
    private String resourceBundleName;
    private String[] columnToSchemaMapping;
    public static final String sccs_id = "@(#)DBQueryView.java\t1.7 04/01/02 SMI";

    public DBQueryView(String string, String string2, Properties properties) {
        super(string, string2, properties);
        this.query = properties.getProperty(QUERY_PROP);
        this.resourceBundleName = properties.getProperty(RESOURCE_BUNDLE_NAME_PROP);
        String string3 = properties.getProperty(COLUMN_NAMES_PROP);
        String string4 = properties.getProperty(COLUMN_TO_SCHEMA_MAPPING_PROP);
        if (this.query == null || string3 == null || this.resourceBundleName == null) {
            Report.error.log(TAG, (Object)"Failed to construct DBQueryView, property (View.columnNames or View.query or View.resourceBundleName) not defined.");
        }
        this.columnNames = Util.explode(string3, ",");
        if (string4 != null) {
            this.columnToSchemaMapping = Util.explode(string4, ",");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ViewResult retrieveView(Object[] objectArray, Locale locale) throws IllegalArgumentException {
        int n;
        Object[][] objectArray2;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ResultSetMetaData resultSetMetaData = null;
        TableViewResult tableViewResult = null;
        String string = this.getQueryAsString(this.query, objectArray);
        Report.trace.log(TAG, (Object)("QUERY=" + string));
        Vector<Object[][]> vector = new Vector<Object[][]>();
        connection = this.getConnection();
        preparedStatement = connection.prepareStatement(this.query);
        int n2 = 0;
        while (n2 < objectArray.length) {
            preparedStatement.setObject(n2 + 1, objectArray[n2]);
            ++n2;
        }
        resultSet = preparedStatement.executeQuery();
        resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next()) {
            objectArray2 = new Object[resultSetMetaData.getColumnCount()];
            n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = resultSet.getObject(n + 1);
                ++n;
            }
            vector.add(objectArray2);
        }
        objectArray2 = new Object[vector.size()][];
        vector.toArray((T[])objectArray2);
        if (this.columnToSchemaMapping != null && objectArray2.length != 0) {
            n = 0;
            while (n < this.columnToSchemaMapping.length) {
                if (!this.columnToSchemaMapping[n].equals("-")) {
                    int n3 = -1;
                    n3 = this.columnToSchemaMapping[n].indexOf("#");
                    if (n3 == -1) {
                        n3 = this.columnToSchemaMapping[n].indexOf(44);
                    }
                    if (n3 == -1) {
                        Report.error.log(TAG, (Object)("schemaMapping " + this.columnToSchemaMapping[n] + " is invalid, ignoring..."));
                    } else {
                        String string2 = this.columnToSchemaMapping[n].substring(0, n3);
                        String string3 = this.columnToSchemaMapping[n].substring(n3 + 1);
                        Localizer localizer = new Localizer(locale, string2, false);
                        int n4 = 0;
                        while (n4 < objectArray2.length) {
                            objectArray2[n4][n] = localizer.getString(string3 + "." + objectArray2[n4][n]);
                            ++n4;
                        }
                    }
                }
                ++n;
            }
        }
        TableViewResult tableViewResult2 = tableViewResult = new TableViewResult(locale, this.resourceBundleName, objectArray2, this.columnNames);
        Object var19_21 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                this.returnConnection(connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableViewResult2;
        catch (Exception exception) {
            Report.error.log(TAG, exception, "Error while retrieving view " + this.getName() + " query=" + this.getQueryAsString(this.query, objectArray));
            ViewResult viewResult = null;
            Object var19_22 = null;
            {
                catch (Throwable throwable) {
                    Object var19_23 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            this.returnConnection(connection);
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    this.returnConnection(connection);
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return viewResult;
        }
    }

    private String getQueryAsString(String string, Object[] objectArray) {
        String string2 = null;
        if (objectArray != null) {
            string2 = "";
            int n = 0;
            while (n < objectArray.length) {
                string2 = string2 + objectArray[n];
                if (n < objectArray.length - 1) {
                    string2 = string2 + ", ";
                }
                ++n;
            }
        }
        return string + "(" + string2 + ")";
    }

    private Connection getConnection() throws Exception {
        return ConnectionPool.getConnection();
    }

    private void returnConnection(Connection connection) {
        ConnectionPool.returnConnection(connection);
    }
}

