/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class CIMTableUtil {
    private CIMTableUtil() {
    }

    public static Boolean convertToBoolean(short s) {
        if (s == 1) {
            return new Boolean("true");
        }
        if (s == 0) {
            return new Boolean("false");
        }
        return null;
    }

    public static short convertFromBoolean(Boolean bl) {
        if (bl == null) {
            return -1;
        }
        if (bl.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static CIMDateTime convertToCIMDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new CIMDateTime((Date)timestamp);
    }

    public static Timestamp convertFromCIMDateTime(CIMDateTime cIMDateTime) {
        if (cIMDateTime == null) {
            return null;
        }
        return new Timestamp(cIMDateTime.getCalendar().getTime().getTime());
    }

    public static UnsignedInt8 convertToUnsignedInt8(short s) {
        return new UnsignedInt8(s);
    }

    public static short convertFromUnsignedInt8(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 == null) {
            return 0;
        }
        return unsignedInt8.shortValue();
    }

    public static UnsignedInt16 convertToUnsignedInt16(short s) {
        return new UnsignedInt16((int)s);
    }

    public static short convertFromUnsignedInt16(UnsignedInt16 unsignedInt16) {
        if (unsignedInt16 == null) {
            return 0;
        }
        return unsignedInt16.shortValue();
    }

    public static UnsignedInt32 convertToUnsignedInt32(int n) {
        return new UnsignedInt32((long)n);
    }

    public static int convertFromUnsignedInt32(UnsignedInt32 unsignedInt32) {
        if (unsignedInt32 == null) {
            return 0;
        }
        return unsignedInt32.intValue();
    }

    public static UnsignedInt64 convertToUnsignedInt64(long l) {
        return new UnsignedInt64(new BigInteger(String.valueOf(l)));
    }

    public static long convertFromUnsignedInt64(UnsignedInt64 unsignedInt64) {
        if (unsignedInt64 == null) {
            return 0L;
        }
        return unsignedInt64.longValue();
    }

    public static String getExistsSelectStmt(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("SELECT id FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" WHERE ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n] + " = ? AND ");
            ++n;
        }
        stringBuffer.delete(stringBuffer.length() - 4, stringBuffer.length());
        return stringBuffer.toString();
    }

    public static String getUpdateStmt(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("UPDATE ");
        stringBuffer.append(string);
        stringBuffer.append(" SET ");
        stringBuffer.append("modifiedTS = ?, ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" = ?, ");
            ++n;
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(" WHERE id = ?");
        return stringBuffer.toString();
    }

    public static String getInsertStmt(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append("(id, modifiedTS, ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuffer.append(", ");
            } else {
                stringBuffer.append(")");
            }
            ++n;
        }
        stringBuffer.append(" VALUES(getUniqueID(), ");
        int n2 = 0;
        while (n2 < stringArray.length + 1) {
            stringBuffer.append("?, ");
            ++n2;
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getSelectStmt(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(", ");
            ++n;
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" WHERE ");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringBuffer.append(stringArray2[n2]);
            stringBuffer.append(" = ? AND ");
            ++n2;
        }
        stringBuffer.delete(stringBuffer.length() - 4, stringBuffer.length());
        return stringBuffer.toString();
    }
}

