/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.persistence.service;

import com.sun.jade.apps.persistence.service.CIMBeanHelper;
import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.CIM_DeviceStatisticalInformation;
import com.sun.jade.cim.bean.CIM_DeviceStatistics;
import com.sun.jade.cim.bean.CIM_DiskDrive;
import com.sun.jade.cim.bean.CIM_Indication;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.jade.util.unittest.UnitTestError;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;

public final class CIMBeanPersistenceImpl
implements CIMBeanPersistence {
    protected CIMBeanPersistenceImpl() throws ConnectionException {
    }

    public synchronized void storeCIMBean(CIMBean cIMBean) throws ConnectionException {
        if (cIMBean == null) {
            String string = "Unable to store CIM Bean.  The CIMBean parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(cIMBean.getClass());
        if (cIMBean instanceof CIM_Indication) {
            cIMBeanHelper.insert(cIMBean);
        } else {
            long l = cIMBeanHelper.getBeanID(cIMBean);
            if (l != -1L) {
                cIMBeanHelper.update(cIMBean, l);
            } else {
                cIMBeanHelper.insert(cIMBean);
            }
        }
    }

    public void storeCIMBeans(CIMBean[] cIMBeanArray) throws ConnectionException {
        if (cIMBeanArray == null) {
            String string = "Unable to store CIM Bean.  The cimBeans parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        while (n < cIMBeanArray.length) {
            CIMBean cIMBean = cIMBeanArray[n];
            if (cIMBean != null) {
                this.storeCIMBean(cIMBean);
            }
            ++n;
        }
    }

    public Collection retrieveBeans(Class clazz, CIMObjectPath cIMObjectPath) throws ConnectionException {
        if (cIMObjectPath == null) {
            String string = "Unable to retrieve CIM Beans.  The CIMObjectPath parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        CIMBean cIMBean = CIMBeanUtil.createBean(cIMObjectPath);
        return this.retrieveBeans(clazz, cIMBean);
    }

    public Collection retrieveBeans(Class clazz, CIMBean cIMBean) throws ConnectionException {
        if (clazz == null) {
            String string = "Unable to retrieve CIM Beans.  The relatedCIMClass parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        if (cIMBean == null) {
            String string = "Unable to retrieve CIM Beans.  The cimBean parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        Connection connection = null;
        String string = cIMBean.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        String string2 = clazz.getName();
        string2 = string2.substring(string2.lastIndexOf(".") + 1);
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(cIMBean.getClass());
        long l = cIMBeanHelper.getBeanID(cIMBean);
        Vector<CIMBean> vector = new Vector<CIMBean>();
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT beanID1 FROM CIMAssociationLookup WHERE beanType1 = '" + string2 + "'" + " AND beanID2 = " + l + " AND beanType2 = '" + string + "'" + " UNION " + "SELECT beanID2 FROM CIMAssociationLookup" + " WHERE beanType2 = '" + string2 + "'" + " AND beanID1 = " + l + " AND beanType1 = '" + string + "'");
                CIMBeanHelper cIMBeanHelper2 = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz);
                while (resultSet.next()) {
                    try {
                        vector.addElement(cIMBeanHelper2.select(resultSet.getLong(1)));
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        Report.error.log(noDataFoundException);
                    }
                }
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve CIM Bean(s).";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector;
    }

    public Collection retrieveBeans(CIMBean cIMBean) throws ConnectionException {
        if (cIMBean == null) {
            String string = "Unable to retrieve CIM Beans.  The cimBean parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        Connection connection = null;
        String string = cIMBean.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(cIMBean.getClass());
        long l = cIMBeanHelper.getBeanID(cIMBean);
        Vector<CIMBean> vector = new Vector<CIMBean>();
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT beanID1, beanType1 FROM CIMAssociationLookup WHERE beanID2 = " + l + " AND beanType2 = '" + string + "'" + " UNION " + "SELECT beanID2, beanType2 FROM CIMAssociationLookup" + " WHERE beanID1 = " + l + " AND beanType1 = '" + string + "'");
                while (resultSet.next()) {
                    String string2 = resultSet.getString(2);
                    try {
                        CIMBeanHelper cIMBeanHelper2 = CIMBeanPersistenceImpl.getCIMBeanHelper(Class.forName("com.sun.jade.cim.bean." + string2));
                        vector.addElement(cIMBeanHelper2.select(resultSet.getLong(1)));
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        Report.error.log(noDataFoundException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String string3 = "Unable to retrieve CIM Beans(s) for class " + string2;
                        Report.error.log(classNotFoundException, (Object)string3);
                        throw new ConnectionException(string3, classNotFoundException);
                    }
                }
            }
            catch (SQLException sQLException) {
                String string4 = "Unable to retrieve CIM Bean(s).";
                Report.error.log(sQLException, (Object)string4);
                throw new ConnectionException(string4, sQLException);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long countBeans(String string, String string2) throws ConnectionException {
        long l;
        Object object;
        long l2 = 0L;
        Connection connection = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        CIMBeanHelper cIMBeanHelper = null;
        try {
            object = Class.forName("com.sun.jade.persistence.cim.bean." + string + "Helper");
            cIMBeanHelper = (CIMBeanHelper)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.error.log(classNotFoundException, (Object)"no Helper");
            throw new IllegalArgumentException(string);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Bean helper not available.");
            return l2;
        }
        try {
            try {
                connection = PersistenceService.getConnection();
                object = connection.createStatement();
                ResultSet resultSet = object.executeQuery(string2);
                if (resultSet.next()) {
                    l2 = resultSet.getLong(1);
                }
                l = l2;
                Object var12_13 = null;
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve Number of CIM Beans.";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection retrieveBeans(String string, String string2) throws ConnectionException {
        Vector vector;
        Object object;
        Connection connection = null;
        Vector vector2 = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        CIMBeanHelper cIMBeanHelper = null;
        try {
            object = Class.forName("com.sun.jade.persistence.cim.bean." + string + "Helper");
            cIMBeanHelper = (CIMBeanHelper)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.error.log(classNotFoundException, (Object)"no Helper");
            throw new IllegalArgumentException(string);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Bean helper not available.");
            return new Vector();
        }
        try {
            try {
                connection = PersistenceService.getConnection();
                object = connection.createStatement();
                ResultSet resultSet = object.executeQuery(string2);
                vector = vector2 = cIMBeanHelper.createBeansFromRS(resultSet);
                Object var10_13 = null;
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to retrieve CIM Bean(s).";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector;
    }

    public Collection retrieveBeans(String string) throws ConnectionException {
        return this.retrieveBeans(string, "SELECT * FROM " + string);
    }

    public CIMBean retrieveBean(CIMBean cIMBean) throws NoDataFoundException, ConnectionException {
        Class<?> clazz = null;
        if (cIMBean == null) {
            String string = "Unable to retrieve CIM Bean data.  There is no ReferenceForMSE.creationClassName or ReferenceForMSE.systemClassName in the mse parameter.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        clazz = cIMBean.getClass();
        CIMBean cIMBean2 = CIMBeanPersistenceImpl.retrieveBean(clazz, cIMBean);
        return cIMBean2;
    }

    public void removeBean(CIMBean cIMBean) throws NoDataFoundException, ConnectionException {
        Class<?> clazz = null;
        if (cIMBean == null) {
            String string = "Unable to remove CIM Bean.  The CIMBean parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        clazz = cIMBean.getClass();
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz);
        cIMBeanHelper.delete(cIMBean);
    }

    public void removeBean(CIMObjectPath cIMObjectPath) throws NoDataFoundException, ConnectionException {
        this.removeBean(CIMBeanUtil.createBean(cIMObjectPath));
    }

    public int removeBeans(String string, String string2) throws ConnectionException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = -1;
        Connection connection = null;
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                n = statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                String string3 = "Unable to delete CIM Bean(s).";
                Report.error.log(sQLException, (Object)string3);
                throw new ConnectionException(string3, sQLException);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return n;
    }

    public Collection retrieveAssocBeans(CIMBean cIMBean) throws ConnectionException {
        if (cIMBean == null) {
            String string = "Unable to retrieve Association CIM Beans.  The cimBean parameter is null.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        Connection connection = null;
        String string = cIMBean.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1);
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(cIMBean.getClass());
        long l = cIMBeanHelper.getBeanID(cIMBean);
        Vector<CIMBean> vector = new Vector<CIMBean>();
        try {
            try {
                connection = PersistenceService.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT assocID, assocType FROM CIMAssociationLookup WHERE beanID2 = " + l + " AND beanType2 = '" + string + "'" + " UNION " + "SELECT assocID, assocType FROM CIMAssociationLookup" + " WHERE beanID1 = " + l + " AND beanType1 = '" + string + "'");
                while (resultSet.next()) {
                    try {
                        long l2 = resultSet.getLong("assocID");
                        String string2 = resultSet.getString("assocType");
                        String string3 = "com.sun.jade.cim.bean." + string2;
                        CIMBeanHelper cIMBeanHelper2 = CIMBeanPersistenceImpl.getCIMBeanHelper(Class.forName(string3));
                        vector.addElement(cIMBeanHelper2.select(l2));
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        Report.error.log(noDataFoundException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Report.error.log(classNotFoundException);
                    }
                }
            }
            catch (SQLException sQLException) {
                String string4 = "Unable to retrieve CIM Bean(s).";
                Report.error.log(sQLException, (Object)string4);
                throw new ConnectionException(string4, sQLException);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            PersistenceService.returnConnection(connection);
            throw throwable;
        }
        PersistenceService.returnConnection(connection);
        return vector;
    }

    public Collection retrieveAssocBeans(CIMObjectPath cIMObjectPath) throws ConnectionException {
        return this.retrieveAssocBeans(CIMBeanUtil.createBean(cIMObjectPath));
    }

    private static CIMBean retrieveBean(Class clazz, CIMBean cIMBean) throws NoDataFoundException, ConnectionException {
        CIMBeanHelper cIMBeanHelper = CIMBeanPersistenceImpl.getCIMBeanHelper(clazz);
        CIMBean cIMBean2 = cIMBeanHelper.select(cIMBean);
        return cIMBean2;
    }

    static CIMBeanHelper getCIMBeanHelper(Class clazz) {
        CIMBeanHelper cIMBeanHelper = null;
        if ("com.sun.jade.util.CIMBeanBase".equals(clazz.getName())) {
            String string = "Unable to store CIM Bean.  Unable to create persistence helper.";
            throw new IllegalArgumentException(string);
        }
        try {
            String string = clazz.getName();
            string = string.substring(string.lastIndexOf(".") + 1);
            String string2 = "com.sun.jade.persistence.cim.bean." + string + "Helper";
            Class<?> clazz2 = Class.forName(string2);
            cIMBeanHelper = (CIMBeanHelper)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return CIMBeanPersistenceImpl.getCIMBeanHelper(clazz.getSuperclass());
        }
        catch (InstantiationException instantiationException) {
            String string = "Unable to store CIM Bean.  Unable to create persistence helper.";
            Report.error.log(instantiationException, (Object)string);
            throw new IllegalArgumentException(string + "\n" + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Unable to store CIM Bean.  Unable to create persistence helper.";
            Report.error.log(illegalAccessException, (Object)string);
            throw new IllegalArgumentException(string + "\n" + illegalAccessException.toString());
        }
        return cIMBeanHelper;
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            UnitTest unitTest = new UnitTest();
            PersistenceService persistenceService = null;
            CIMBeanPersistence cIMBeanPersistence = null;
            try {
                long l = System.currentTimeMillis();
                persistenceService = PersistenceService.getService();
                cIMBeanPersistence = persistenceService.getCIMBeanPersistence();
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
            }
            catch (Exception exception) {
                // empty catch block
            }
            CIM_DiskDrive cIM_DiskDrive = null;
            CIM_DiskDrive cIM_DiskDrive2 = null;
            int n = 0;
            while (n < 1) {
                Date date = new Date(System.currentTimeMillis());
                cIM_DiskDrive = new CIM_DiskDrive();
                cIM_DiskDrive.setCaption("Caption");
                cIM_DiskDrive.setDescription("Description");
                cIM_DiskDrive.setInstallDate(new CIMDateTime(date));
                cIM_DiskDrive.setName("Name");
                cIM_DiskDrive.setStatus("Status");
                cIM_DiskDrive.setSystemCreationClassName("SystemCreationClassName");
                cIM_DiskDrive.setSystemName("SystemName");
                cIM_DiskDrive.setCreationClassName("CIM_DiskDrive");
                cIM_DiskDrive.setDeviceID("DeviceID" + n);
                cIM_DiskDrive.setPowerManagementSupported(new Boolean(true));
                cIM_DiskDrive.parsePowerManagementCapabilities("1,2,3");
                cIM_DiskDrive.setAvailability(new UnsignedInt16((int)Short.parseShort("12")));
                cIM_DiskDrive.setStatusInfo(new UnsignedInt16((int)Short.parseShort("12")));
                cIM_DiskDrive.setLastErrorCode(new UnsignedInt32(123L));
                cIM_DiskDrive.setErrorDescription("ErrorDescription");
                cIM_DiskDrive.setErrorCleared(new Boolean(false));
                String[] stringArray2 = new String[]{"other", "Identifying", "Info"};
                cIM_DiskDrive.setOtherIdentifyingInfo(stringArray2);
                cIM_DiskDrive.setPowerOnHours(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setTotalPowerOnHours(new UnsignedInt64(new BigInteger("1234")));
                String[] stringArray3 = new String[]{"identifyingDescriptions"};
                cIM_DiskDrive.setIdentifyingDescriptions(stringArray3);
                cIM_DiskDrive.setMaxQuiesceTime(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.parseCapabilities("1,2,3");
                String[] stringArray4 = new String[]{"capability", "Descriptions"};
                cIM_DiskDrive.setCapabilityDescriptions(null);
                cIM_DiskDrive.setErrorMethodology("ErrorMethodology");
                cIM_DiskDrive.setCompressionMethod("CompressionMethod");
                cIM_DiskDrive.setNumberOfMediaSupported(new UnsignedInt32(123L));
                cIM_DiskDrive.setMaxMediaSize(null);
                cIM_DiskDrive.setDefaultBlockSize(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setMaxBlockSize(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setMinBlockSize(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setNeedsCleaning(null);
                cIM_DiskDrive.setMediaIsLocked(new Boolean(false));
                cIM_DiskDrive.setSecurity(null);
                cIM_DiskDrive.setLastCleaned(null);
                cIM_DiskDrive.setMaxAccessTime(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setUncompressedDataRate(null);
                cIM_DiskDrive.setLoadTime(new UnsignedInt64(new BigInteger("1234")));
                cIM_DiskDrive.setUnloadTime(new UnsignedInt64(new BigInteger("1234")));
                try {
                    try {
                        cIMBeanPersistence.retrieveBean((CIMBean)cIM_DiskDrive);
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        cIMBeanPersistence.storeCIMBean((CIMBean)cIM_DiskDrive);
                    }
                    cIMBeanPersistence.storeCIMBean((CIMBean)cIM_DiskDrive);
                    cIM_DiskDrive2 = (CIM_DiskDrive)cIMBeanPersistence.retrieveBean((CIMBean)cIM_DiskDrive);
                    CIM_DeviceStatisticalInformation cIM_DeviceStatisticalInformation = new CIM_DeviceStatisticalInformation();
                    cIM_DeviceStatisticalInformation.setCreationClassName("CIM_DeviceStatisticalInformation");
                    cIM_DeviceStatisticalInformation.setDeviceCreationClassName("CIM_DiskDrive");
                    cIM_DeviceStatisticalInformation.setDeviceID("unique dev id");
                    cIM_DeviceStatisticalInformation.setSystemCreationClassName("ugh");
                    cIM_DeviceStatisticalInformation.setSystemName("system name");
                    cIM_DeviceStatisticalInformation.setName("name");
                    CIM_DeviceStatistics cIM_DeviceStatistics = new CIM_DeviceStatistics();
                    cIM_DeviceStatistics.setElement(cIM_DiskDrive.getCIMObjectPath());
                    cIM_DeviceStatistics.setStats(cIM_DeviceStatisticalInformation.getCIMObjectPath());
                    cIMBeanPersistence.storeCIMBean((CIMBean)cIM_DeviceStatisticalInformation);
                    try {
                        cIMBeanPersistence.retrieveBean((CIMBean)cIM_DeviceStatisticalInformation);
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        unitTest.fail("Unable to retrieve statistics bean after insert");
                        System.exit(1);
                    }
                    cIMBeanPersistence.storeCIMBean((CIMBean)cIM_DeviceStatistics);
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName("com.sun.jade.cim.bean.CIM_DeviceStatisticalInformation");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        unitTest.fail("Unable to retrieve related CIM Beans. Cannot create classinstance.");
                        System.exit(1);
                    }
                    Collection collection = cIMBeanPersistence.retrieveBeans(clazz, (CIMBean)cIM_DiskDrive);
                    if (collection.size() != 1) {
                        unitTest.fail("Did not retrieve associated CIM Beans correctly.");
                        System.exit(1);
                    }
                    CIM_DeviceStatisticalInformation cIM_DeviceStatisticalInformation2 = (CIM_DeviceStatisticalInformation)collection.iterator().next();
                    unitTest.assertEquals(cIM_DeviceStatisticalInformation.getDeviceID(), cIM_DeviceStatisticalInformation2.getDeviceID());
                    collection = cIMBeanPersistence.retrieveBeans(clazz, cIM_DiskDrive.getCIMObjectPath());
                    if (collection.size() != 1) {
                        unitTest.fail("Did not retrieve associated CIM Beans correctly.");
                        System.exit(1);
                    }
                    cIM_DeviceStatisticalInformation2 = (CIM_DeviceStatisticalInformation)collection.iterator().next();
                    unitTest.assertEquals(cIM_DeviceStatisticalInformation.getDeviceID(), cIM_DeviceStatisticalInformation2.getDeviceID());
                    Collection collection2 = cIMBeanPersistence.retrieveAssocBeans((CIMBean)cIM_DiskDrive);
                    if (collection2.size() != 1) {
                        unitTest.fail("Did not retrieve association beans correctly.");
                        System.exit(1);
                    }
                    cIMBeanPersistence.removeBean((CIMBean)cIM_DiskDrive);
                    boolean bl = false;
                    try {
                        cIMBeanPersistence.retrieveBean((CIMBean)cIM_DiskDrive);
                    }
                    catch (NoDataFoundException noDataFoundException) {
                        bl = true;
                    }
                    if (!bl) {
                        unitTest.fail("Did not remove CIM Bean correctly.");
                        System.exit(1);
                    }
                }
                catch (PersistenceException persistenceException) {
                    System.err.println("\nUnit Test Failed (Bean Storage Retrieval): \n" + persistenceException.getMessage() + "\n");
                    persistenceException.printStackTrace();
                    System.err.println("\n");
                    System.exit(1);
                }
                ++n;
            }
            try {
                unitTest.assertEquals(cIM_DiskDrive.getCaption(), cIM_DiskDrive2.getCaption());
                unitTest.assertEquals(cIM_DiskDrive.getDescription(), cIM_DiskDrive2.getDescription());
                unitTest.assertEquals(cIM_DiskDrive.getInstallDate(), cIM_DiskDrive2.getInstallDate());
                unitTest.assertEquals(cIM_DiskDrive.getName(), cIM_DiskDrive2.getName());
                unitTest.assertEquals(cIM_DiskDrive.getStatus(), cIM_DiskDrive2.getStatus());
                unitTest.assertEquals(cIM_DiskDrive.getSystemCreationClassName(), cIM_DiskDrive2.getSystemCreationClassName());
                unitTest.assertEquals(cIM_DiskDrive.getCreationClassName(), cIM_DiskDrive2.getCreationClassName());
                unitTest.assertEquals(cIM_DiskDrive.getSystemName(), cIM_DiskDrive2.getSystemName());
                unitTest.assertEquals(cIM_DiskDrive.getDeviceID(), cIM_DiskDrive2.getDeviceID());
                unitTest.assertEquals(cIM_DiskDrive.getPowerManagementSupported(), cIM_DiskDrive2.getPowerManagementSupported());
                unitTest.assertEquals(CIMBeanUtil.toStringValue(cIM_DiskDrive.getPowerManagementCapabilities()), CIMBeanUtil.toStringValue(cIM_DiskDrive2.getPowerManagementCapabilities()));
                unitTest.assertEquals(cIM_DiskDrive.getAvailability(), cIM_DiskDrive2.getAvailability());
                unitTest.assertEquals(cIM_DiskDrive.getStatusInfo(), cIM_DiskDrive2.getStatusInfo());
                unitTest.assertEquals(cIM_DiskDrive.getLastErrorCode(), cIM_DiskDrive2.getLastErrorCode());
                unitTest.assertEquals(CIMBeanUtil.toStringValue(cIM_DiskDrive.getOtherIdentifyingInfo()), CIMBeanUtil.toStringValue(cIM_DiskDrive2.getOtherIdentifyingInfo()));
                unitTest.assertEquals(cIM_DiskDrive.getPowerOnHours(), cIM_DiskDrive2.getPowerOnHours());
                unitTest.assertEquals(cIM_DiskDrive.getTotalPowerOnHours(), cIM_DiskDrive2.getTotalPowerOnHours());
                unitTest.assertEquals(cIM_DiskDrive.getMaxQuiesceTime(), cIM_DiskDrive2.getMaxQuiesceTime());
                unitTest.assertEquals(CIMBeanUtil.toStringValue(cIM_DiskDrive.getCapabilities()), CIMBeanUtil.toStringValue(cIM_DiskDrive2.getCapabilities()));
                unitTest.assertEquals(CIMBeanUtil.toStringValue(cIM_DiskDrive.getCapabilityDescriptions()), CIMBeanUtil.toStringValue(cIM_DiskDrive2.getCapabilityDescriptions()));
                unitTest.assertEquals(cIM_DiskDrive.getErrorMethodology(), cIM_DiskDrive2.getErrorMethodology());
                unitTest.assertEquals(cIM_DiskDrive.getCompressionMethod(), cIM_DiskDrive2.getCompressionMethod());
                unitTest.assertEquals(cIM_DiskDrive.getNumberOfMediaSupported(), cIM_DiskDrive2.getNumberOfMediaSupported());
                unitTest.assertEquals(cIM_DiskDrive.getMaxMediaSize(), cIM_DiskDrive2.getMaxMediaSize());
                unitTest.assertEquals(cIM_DiskDrive.getDefaultBlockSize(), cIM_DiskDrive2.getDefaultBlockSize());
                unitTest.assertEquals(cIM_DiskDrive.getMaxBlockSize(), cIM_DiskDrive2.getMaxBlockSize());
                unitTest.assertEquals(cIM_DiskDrive.getMinBlockSize(), cIM_DiskDrive2.getMinBlockSize());
                unitTest.assertEquals(cIM_DiskDrive.getNeedsCleaning(), cIM_DiskDrive2.getNeedsCleaning());
                unitTest.assertEquals(cIM_DiskDrive.getMediaIsLocked(), cIM_DiskDrive2.getMediaIsLocked());
                unitTest.assertEquals(cIM_DiskDrive.getSecurity(), cIM_DiskDrive2.getSecurity());
                unitTest.assertEquals(cIM_DiskDrive.getLastCleaned(), cIM_DiskDrive2.getLastCleaned());
                unitTest.assertEquals(cIM_DiskDrive.getMaxAccessTime(), cIM_DiskDrive2.getMaxAccessTime());
                unitTest.assertEquals(cIM_DiskDrive.getUncompressedDataRate(), cIM_DiskDrive2.getUncompressedDataRate());
                unitTest.assertEquals(cIM_DiskDrive.getLoadTime(), cIM_DiskDrive2.getLoadTime());
                unitTest.assertEquals(cIM_DiskDrive.getUnloadTime(), cIM_DiskDrive2.getUnloadTime());
            }
            catch (UnitTestError unitTestError) {
                System.err.println("\nUnit Test Failed (Assertions): " + unitTestError.getMessage());
                unitTestError.printStackTrace();
                System.exit(1);
            }
            System.exit(0);
        }
    }
}

