/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.apps.discovery;

import com.sun.jade.apps.discovery.AgentInstallEvent;
import com.sun.jade.apps.discovery.InstallEvent;
import com.sun.jade.apps.discovery.InstallListener;
import com.sun.jade.apps.discovery.InstallerException;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.device.util.DeviceHandler;
import com.sun.jade.event.DefinitionEventGenerator;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.MFAdmin;
import com.sun.jade.logic.mf.ServiceException;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.logic.service.StorAdeService;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.locale.LocalizableMessage;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class InstallerServiceImpl
implements InstallerService {
    String domain;
    static InstallerServiceImpl is = null;
    static final String SERVICE_NAME = "Installer";
    private static final String PROPERTIES = "InstallerService.properties";
    private Properties serviceProperties;
    private Vector listeners = new Vector();
    private Vector mf = new Vector();
    private Vector service = new Vector();
    private static final String sccs_id = "@(#)InstallerServiceImpl.java\t1.44 09/27/02 SMI";
    static /* synthetic */ Class class$com$sun$jade$apps$discovery$InstallerServiceImpl;
    static /* synthetic */ Class class$java$util$Properties;

    private InstallerServiceImpl() {
    }

    public InstallerServiceImpl(String string, String string2) throws InstallerException {
        try {
            this.serviceProperties = PropertiesPersister.restoreProperties(PROPERTIES);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(propertiesPersistenceException, (Object)"Installer failed to load config.");
            System.exit(-1);
        }
        this.domain = string;
        if (is == null) {
            is = this;
            this.initialize(string2);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void shutdown() {
        System.exit(0);
    }

    public String getName() {
        return StoradeEnvironment.getHostID();
    }

    public String getClassName() {
        return "com.sun.jade.apps.discovery.InstallerService";
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage(class$com$sun$jade$apps$discovery$InstallerServiceImpl == null ? (class$com$sun$jade$apps$discovery$InstallerServiceImpl = InstallerServiceImpl.class$("com.sun.jade.apps.discovery.InstallerServiceImpl")) : class$com$sun$jade$apps$discovery$InstallerServiceImpl, "description", null, null);
    }

    public LocalizableMessage getCaption() {
        return new LocalizableMessage(class$com$sun$jade$apps$discovery$InstallerServiceImpl == null ? (class$com$sun$jade$apps$discovery$InstallerServiceImpl = InstallerServiceImpl.class$("com.sun.jade.apps.discovery.InstallerServiceImpl")) : class$com$sun$jade$apps$discovery$InstallerServiceImpl, "description", null, null);
    }

    public MF[] getInstalledSystems() {
        MF[] mFArray = new MF[this.mf.size()];
        return this.mf.toArray(mFArray);
    }

    public Object[] getInstalledServices() {
        Object[] objectArray = new Object[this.service.size()];
        return this.service.toArray(objectArray);
    }

    public MF installDevice(Properties properties) throws InstallerException {
        return this.doAddDevice(properties);
    }

    public void removeDevice(MF mF) throws InstallerException {
        this.mf.remove(mF);
        this.notifyListeners(new InstallEvent(mF, 4));
        MFAdmin mFAdmin = mF.getAdmin();
        if (mFAdmin != null) {
            try {
                mFAdmin.stopService();
            }
            catch (ServiceException serviceException) {
                throw new InstallerException(serviceException);
            }
        }
        try {
            String string = mF.getProperties().getProperty("discovered");
            if (string != null && !"".equals(string.trim())) {
                Properties properties = DevInfo.getDeviceProperties(mF.getProperties().getProperty("type"));
                String string2 = properties.getProperty("RESOURCE_TYPE");
                if ("host".equals(string2)) {
                    DefinitionEventGenerator.generateHostEvent(mF, 7);
                } else {
                    DefinitionEventGenerator.generateDeviceEvent(mF, 2);
                }
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"cannot sent out device/host removal event");
        }
    }

    public void removeService(Object object) throws InstallerException {
        this.service.remove(object);
        this.notifyListeners(new InstallEvent(object, 5));
        if (object instanceof StorAdeService) {
            try {
                ((StorAdeService)object).stopService();
            }
            catch (StorAdeException storAdeException) {
                throw new InstallerException(storAdeException);
            }
        }
    }

    public void addInstallListener(InstallListener installListener) {
        this.listeners.add(installListener);
    }

    public void removeInstallListener(InstallListener installListener) {
        this.listeners.remove(installListener);
    }

    public synchronized void addService(Object object) {
        this.service.add(object);
        int n = 0;
        while (n < this.listeners.size()) {
            InstallListener installListener = (InstallListener)this.listeners.get(n);
            try {
                installListener.notify(new InstallEvent(object, 3));
            }
            catch (RemoteException remoteException) {
                Report.error.log(remoteException, (Object)"Error notifing remote listener");
            }
            ++n;
        }
    }

    private Collection parseServiceProperties() {
        String string;
        Object object;
        Object object2;
        TreeMap<String, Properties> treeMap = new TreeMap<String, Properties>();
        TreeMap<Object, Object> treeMap2 = new TreeMap<Object, Object>(this.serviceProperties);
        Set<Map.Entry<Object, Object>> set = treeMap2.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            object2 = iterator.next();
            object = (String)object2.getKey();
            string = (String)object2.getValue();
            int n = ((String)object).indexOf(46);
            if (n <= 0 || "InstallerService".equals(string2 = ((String)object).substring(0, n))) continue;
            Properties properties = (Properties)treeMap.get(string2);
            if (properties == null) {
                properties = new Properties();
                treeMap.put(string2, properties);
            }
            properties.setProperty(((String)object).substring(n + 1), string);
        }
        treeMap2 = new TreeMap(treeMap);
        set = treeMap2.entrySet();
        iterator = set.iterator();
        object2 = new TreeMap();
        while (iterator.hasNext()) {
            object = iterator.next();
            string = (String)object.getKey();
            Properties properties = (Properties)object.getValue();
            ((TreeMap)object2).put(string, properties);
            int n = string.indexOf("_");
            if (n > 0) {
                string = string.substring(n + 1);
            }
            properties.setProperty("name", string);
        }
        return ((TreeMap)object2).values();
    }

    private Object startService(Properties properties) throws InstallerException {
        Class[] classArray = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = InstallerServiceImpl.class$("java.util.Properties")) : class$java$util$Properties};
        Object[] objectArray = new Object[]{properties};
        String string = properties.getProperty("name");
        String string2 = properties.getProperty("class");
        Class<?> clazz = null;
        Report.debug.log(SERVICE_NAME, (Object)("Loading service " + string2));
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.error.log(classNotFoundException, (Object)"Class not found");
        }
        Method method = null;
        boolean bl = false;
        try {
            method = clazz.getDeclaredMethod("getService", classArray);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod("getService", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method != null) {
            try {
                if (bl) {
                    return method.invoke(null, objectArray);
                }
                return method.invoke(null, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                Report.error.log(illegalAccessException, (Object)"Illegal Access Exception");
                throw new InstallerException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Report.error.log(invocationTargetException.getCause(), (Object)"Invocation Exception");
                throw new InstallerException(invocationTargetException);
            }
        }
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                constructor = null;
            }
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                throw new InstallerException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InstallerException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new InstallerException(invocationTargetException);
            }
        }
        return null;
    }

    private void initialize(String string) throws InstallerException {
        Object object;
        DeviceConfig deviceConfig = new DeviceConfig(new File(string));
        deviceConfig.setAsSystemConfig();
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        Collection collection = this.parseServiceProperties();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Properties)iterator.next();
            try {
                this.addService(this.startService((Properties)object));
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)("Failed to start service " + ((Properties)object).getProperty("name")));
            }
        }
        AgentInstallEvent.initStorADEHeartbeat(this.serviceProperties);
        AgentInstallEvent.initStorADEAuditEvents(this.serviceProperties);
        object = deviceConfig.getConfigProperties();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            this.doAddDevice((Properties)iterator2.next());
        }
        DeviceHandler.getDeviceHandler().startPolling();
        AgentInstallEvent.postStorADEInstalledEvent();
    }

    private MF doAddDevice(Properties properties) throws InstallerException {
        String string = properties.getProperty("active");
        String string2 = properties.getProperty("type");
        String string3 = properties.getProperty("ip");
        String string4 = properties.getProperty("hostname");
        MF mF = null;
        if (string2 != null) {
            Properties properties2 = DevInfo.getDeviceProperties(string2);
            String string5 = properties2.getProperty("MF.class");
            Class[] classArray = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = InstallerServiceImpl.class$("java.util.Properties")) : class$java$util$Properties};
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Report.error.log(classNotFoundException, (Object)("Couldn't find device class for " + string2));
                return null;
            }
            Constructor<?> constructor = null;
            Object[] objectArray = new Object[]{properties};
            try {
                constructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                    objectArray = new Object[]{};
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Report.error.log(noSuchMethodException2, (Object)("Couldn't load device constructor for " + string2));
                    return null;
                }
            }
            Report.info.log(SERVICE_NAME, (Object)("Loading device " + string2));
            Object var13_15 = null;
            try {
                var13_15 = constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
                Report.error.log(instantiationException, (Object)("Couldn't create device " + string2));
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                Report.error.log(illegalAccessException, (Object)("Couldn't create device " + string2));
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                Report.error.log(invocationTargetException, (Object)("Couldn't create device " + string2));
                return null;
            }
            if (var13_15 != null && var13_15 instanceof MF) {
                mF = var13_15;
            } else {
                Report.error.log("Couldn't create device " + string2);
                return null;
            }
        }
        this.addMF(mF);
        return mF;
    }

    public void addDevice(MF mF) {
        this.addMF(mF);
    }

    public void updateDevice(MF mF) {
        int n = 0;
        while (n < this.listeners.size()) {
            InstallListener installListener = (InstallListener)this.listeners.get(n);
            try {
                installListener.notify(new InstallEvent(mF, 0));
            }
            catch (RemoteException remoteException) {
                Report.error.log(remoteException, (Object)"Error notifing remote listener");
            }
            ++n;
        }
    }

    private synchronized void addMF(MF mF) {
        this.mf.add(mF);
        int n = 0;
        while (n < this.listeners.size()) {
            InstallListener installListener = (InstallListener)this.listeners.get(n);
            try {
                installListener.notify(new InstallEvent(mF, 2));
            }
            catch (RemoteException remoteException) {
                Report.error.log(remoteException, (Object)"Error notifing remote listener");
            }
            ++n;
        }
    }

    private void notifyListeners(InstallEvent installEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            InstallListener installListener = (InstallListener)this.listeners.get(n);
            try {
                installListener.notify(installEvent);
            }
            catch (RemoteException remoteException) {
                Report.error.log(remoteException, (Object)"Error notifing remote listener");
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            InstallerServiceImpl installerServiceImpl = new InstallerServiceImpl();
            installerServiceImpl.addInstallListener(null);
            installerServiceImpl.removeInstallListener(null);
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            StoradeEnvironment.setState(2);
        }
    }
}

